/*
 * Copyright © 2018-2020 Peter M. Stahl pemistahl@gmail.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either expressed or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.github.pemistahl.lingua.api

/**
 * The ISO 639-3 code representations for the supported languages.
 *
 * ISO 639 is a standardized nomenclature used to classify languages.
 */
enum class IsoCode639_3 {

    /**
     * The ISO 639-3 code for [Afrikaans][Language.AFRIKAANS].
     */
    AFR,

    /**
     * The ISO 639-3 code for [Arabic][Language.ARABIC].
     */
    ARA,

    /**
     * The ISO 639-3 code for [Azerbaijani][Language.AZERBAIJANI].
     */
    AZE,

    /**
     * The ISO 639-3 code for [Belarusian][Language.BELARUSIAN].
     */
    BEL,

    /**
     * The ISO 639-3 code for [Bengali][Language.BENGALI].
     */
    BEN,

    /**
     * The ISO 639-3 code for [Bosnian][Language.BOSNIAN].
     */
    BOS,

    /**
     * The ISO 639-3 code for [Bulgarian][Language.BULGARIAN].
     */
    BUL,

    /**
     * The ISO 639-3 code for [Catalan][Language.CATALAN].
     */
    CAT,

    /**
     * The ISO 639-3 code for [Czech][Language.CZECH].
     */
    CES,

    /**
     * The ISO 639-3 code for [Welsh][Language.WELSH].
     */
    CYM,

    /**
     * The ISO 639-3 code for [Danish][Language.DANISH].
     */
    DAN,

    /**
     * The ISO 639-3 code for [German][Language.GERMAN].
     */
    DEU,

    /**
     * The ISO 639-3 code for [Greek][Language.GREEK].
     */
    ELL,

    /**
     * The ISO 639-3 code for [English][Language.ENGLISH].
     */
    ENG,

    /**
     * The ISO 639-3 code for [Esperanto][Language.ESPERANTO].
     */
    EPO,

    /**
     * The ISO 639-3 code for [Estonian][Language.ESTONIAN].
     */
    EST,

    /**
     * The ISO 639-3 code for [Basque][Language.BASQUE].
     */
    EUS,

    /**
     * The ISO 639-3 code for [Persian][Language.PERSIAN].
     */
    FAS,

    /**
     * The ISO 639-3 code for [Finnish][Language.FINNISH].
     */
    FIN,

    /**
     * The ISO 639-3 code for [French][Language.FRENCH].
     */
    FRA,

    /**
     * The ISO 639-3 code for [Irish][Language.IRISH].
     */
    GLE,

    /**
     * The ISO 639-3 code for [Gujarati][Language.GUJARATI].
     */
    GUJ,

    /**
     * The ISO 639-3 code for [Hebrew][Language.HEBREW].
     */
    HEB,

    /**
     * The ISO 639-3 code for [Hindi][Language.HINDI].
     */
    HIN,

    /**
     * The ISO 639-3 code for [Croatian][Language.CROATIAN].
     */
    HRV,

    /**
     * The ISO 639-3 code for [Hungarian][Language.HUNGARIAN].
     */
    HUN,

    /**
     * The ISO 639-3 code for [Armenian][Language.ARMENIAN].
     */
    HYE,

    /**
     * The ISO 639-3 code for [Indonesian][Language.INDONESIAN].
     */
    IND,

    /**
     * The ISO 639-3 code for [Icelandic][Language.ICELANDIC].
     */
    ISL,

    /**
     * The ISO 639-3 code for [Italian][Language.ITALIAN].
     */
    ITA,

    /**
     * The ISO 639-3 code for [Japanese][Language.JAPANESE].
     */
    JPN,

    /**
     * The ISO 639-3 code for [Georgian][Language.GEORGIAN].
     */
    KAT,

    /**
     * The ISO 639-3 code for [Kazakh][Language.KAZAKH].
     */
    KAZ,

    /**
     * The ISO 639-3 code for [Korean][Language.KOREAN].
     */
    KOR,

    /**
     * The ISO 639-3 code for [Latin][Language.LATIN].
     */
    LAT,

    /**
     * The ISO 639-3 code for [Latvian][Language.LATVIAN].
     */
    LAV,

    /**
     * The ISO 639-3 code for [Lithuanian][Language.LITHUANIAN].
     */
    LIT,

    /**
     * The ISO 639-3 code for [Ganda][Language.GANDA].
     */
    LUG,

    /**
     * The ISO 639-3 code for [Marathi][Language.MARATHI].
     */
    MAR,

    /**
     * The ISO 639-3 code for [Macedonian][Language.MACEDONIAN].
     */
    MKD,

    /**
     * The ISO 639-3 code for [Mongolian][Language.MONGOLIAN].
     */
    MON,

    /**
     * The ISO 639-3 code for [Malay][Language.MALAY].
     */
    MSA,

    /**
     * The ISO 639-3 code for [Dutch][Language.DUTCH].
     */
    NLD,

    /**
     * The ISO 639-3 code for [Norwegian Nynorsk][Language.NYNORSK].
     */
    NNO,

    /**
     * The ISO 639-3 code for [Norwegian Bokmal][Language.BOKMAL].
     */
    NOB,

    /**
     * The ISO 639-3 code for [Punjabi][Language.PUNJABI].
     */
    PAN,

    /**
     * The ISO 639-3 code for [Polish][Language.POLISH].
     */
    POL,

    /**
     * The ISO 639-3 code for [Portuguese][Language.PORTUGUESE].
     */
    POR,

    /**
     * The ISO 639-3 code for [Romanian][Language.ROMANIAN].
     */
    RON,

    /**
     * The ISO 639-3 code for [Russian][Language.RUSSIAN].
     */
    RUS,

    /**
     * The ISO 639-3 code for [Slovak][Language.SLOVAK].
     */
    SLK,

    /**
     * The ISO 639-3 code for [Slovene][Language.SLOVENE].
     */
    SLV,

    /**
     * The ISO 639-3 code for [Shona][Language.SHONA].
     */
    SNA,

    /**
     * The ISO 639-3 code for [Somali][Language.SOMALI].
     */
    SOM,

    /**
     * The ISO 639-3 code for [Southern Sotho][Language.SOTHO].
     */
    SOT,

    /**
     * The ISO 639-3 code for [Spanish][Language.SPANISH].
     */
    SPA,

    /**
     * The ISO 639-3 code for [Albanian][Language.ALBANIAN].
     */
    SQI,

    /**
     * The ISO 639-3 code for [Serbian][Language.SERBIAN].
     */
    SRP,

    /**
     * The ISO 639-3 code for [Swahili][Language.SWAHILI].
     */
    SWA,

    /**
     * The ISO 639-3 code for [Swedish][Language.SWEDISH].
     */
    SWE,

    /**
     * The ISO 639-3 code for [Tamil][Language.TAMIL].
     */
    TAM,

    /**
     * The ISO 639-3 code for [Telugu][Language.TELUGU].
     */
    TEL,

    /**
     * The ISO 639-3 code for [Tagalog][Language.TAGALOG].
     */
    TGL,

    /**
     * The ISO 639-3 code for [Thai][Language.THAI].
     */
    THA,

    /**
     * The ISO 639-3 code for [Tswana][Language.TSWANA].
     */
    TSN,

    /**
     * The ISO 639-3 code for [Tsonga][Language.TSONGA].
     */
    TSO,

    /**
     * The ISO 639-3 code for [Turkish][Language.TURKISH].
     */
    TUR,

    /**
     * The ISO 639-3 code for [Ukrainian][Language.UKRAINIAN].
     */
    UKR,

    /**
     * The ISO 639-3 code for [Urdu][Language.URDU].
     */
    URD,

    /**
     * The ISO 639-3 code for [Vietnamese][Language.VIETNAMESE].
     */
    VIE,

    /**
     * The ISO 639-3 code for [Xhosa][Language.XHOSA].
     */
    XHO,

    /**
     * The ISO 639-3 code for [Yoruba][Language.YORUBA].
     */
    YOR,

    /**
     * The ISO 639-3 code for [Chinese][Language.CHINESE].
     */
    ZHO,

    /**
     * The ISO 639-3 code for [Zulu][Language.ZULU].
     */
    ZUL,

    /**
     * The ISO 639-3 code for [the imaginary unknown language][Language.UNKNOWN].
     */
    NONE;

    override fun toString() = this.name.toLowerCase()
}
