/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.api;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.api.LanguageDetectorKt;
import com.github.pemistahl.lingua.internal.Alphabet;
import com.github.pemistahl.lingua.internal.Constant;
import com.github.pemistahl.lingua.internal.Ngram;
import com.github.pemistahl.lingua.internal.TestDataLanguageModel;
import com.github.pemistahl.lingua.internal.TrainingDataLanguageModel;
import com.github.pemistahl.lingua.internal.util.extension.CharExtensionsKt;
import com.github.pemistahl.lingua.internal.util.extension.MapExtensionsKt;
import com.github.pemistahl.lingua.internal.util.extension.StringExtensionsKt;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0015\u0018\u00002\u00020\u0001B\u009d\u0001\b\u0000\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\u0014\b\u0002\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f\u0012\u0014\b\u0002\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f\u0012\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f\u0012\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0000\u00a2\u0006\u0002\b+J\u001a\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060-2\u0006\u0010*\u001a\u00020)J/\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u001f2\u0006\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000402H\u0000\u00a2\u0006\u0002\b3J#\u00104\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00042\f\u00106\u001a\b\u0012\u0004\u0012\u00020702H\u0000\u00a2\u0006\u0002\b8J/\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u001f2\u0006\u0010:\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000402H\u0000\u00a2\u0006\u0002\b;J\b\u0010<\u001a\u00020#H\u0002J\u0006\u0010=\u001a\u00020>J\u000e\u0010?\u001a\u00020\u00042\u0006\u0010*\u001a\u00020)J\u001b\u0010@\u001a\u00020\u00042\f\u0010A\u001a\b\u0012\u0004\u0012\u00020)0BH\u0000\u00a2\u0006\u0002\bCJ\u0013\u0010D\u001a\u00020\b2\b\u0010E\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J!\u0010F\u001a\b\u0012\u0004\u0012\u00020\u0004022\f\u0010A\u001a\b\u0012\u0004\u0012\u00020)0BH\u0000\u00a2\u0006\u0002\bGJ\b\u0010H\u001a\u00020\nH\u0016J\u0018\u0010I\u001a\u00020\r2\u0006\u00105\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\nH\u0002J,\u0010K\u001a\u00020\r2\u0012\u0010L\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\f2\u0006\u00105\u001a\u00020\u00042\u0006\u0010J\u001a\u00020\nH\u0002J\u001d\u0010M\u001a\u00020\u00062\u0006\u00105\u001a\u00020\u00042\u0006\u0010N\u001a\u000207H\u0000\u00a2\u0006\u0002\bOJ\b\u0010P\u001a\u00020>H\u0002J\u001b\u0010Q\u001a\b\u0012\u0004\u0012\u00020)0B2\u0006\u0010*\u001a\u00020)H\u0000\u00a2\u0006\u0002\bRJU\u0010S\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u001f2\u0018\u0010T\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\u001f0B2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\n0\u001f2\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u000402H\u0000\u00a2\u0006\u0002\bVR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u001a\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020\u00040\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0014R\u0014\u0010\"\u001a\u00020#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0014R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0014\u00a8\u0006W"}, d2={"Lcom/github/pemistahl/lingua/api/LanguageDetector;", "", "languages", "", "Lcom/github/pemistahl/lingua/api/Language;", "minimumRelativeDistance", "", "isEveryLanguageModelPreloaded", "", "numberOfLoadedLanguages", "", "unigramLanguageModels", "", "Lcom/github/pemistahl/lingua/internal/TrainingDataLanguageModel;", "bigramLanguageModels", "trigramLanguageModels", "quadrigramLanguageModels", "fivegramLanguageModels", "(Ljava/util/Set;DZILjava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;Ljava/util/Map;)V", "getBigramLanguageModels$lingua", "()Ljava/util/Map;", "getFivegramLanguageModels$lingua", "getLanguages$lingua", "()Ljava/util/Set;", "languagesWithUniqueCharacters", "Lkotlin/sequences/Sequence;", "getMinimumRelativeDistance$lingua", "()D", "getNumberOfLoadedLanguages$lingua", "()I", "oneLanguageAlphabets", "", "Lcom/github/pemistahl/lingua/internal/Alphabet;", "getQuadrigramLanguageModels$lingua", "threadPool", "Ljava/util/concurrent/ExecutorService;", "getThreadPool$lingua", "()Ljava/util/concurrent/ExecutorService;", "getTrigramLanguageModels$lingua", "getUnigramLanguageModels$lingua", "cleanUpInputText", "", "text", "cleanUpInputText$lingua", "computeLanguageConfidenceValues", "Ljava/util/SortedMap;", "computeLanguageProbabilities", "testDataModel", "Lcom/github/pemistahl/lingua/internal/TestDataLanguageModel;", "filteredLanguages", "", "computeLanguageProbabilities$lingua", "computeSumOfNgramProbabilities", "language", "ngrams", "Lcom/github/pemistahl/lingua/internal/Ngram;", "computeSumOfNgramProbabilities$lingua", "countUnigramsOfInputText", "unigramLanguageModel", "countUnigramsOfInputText$lingua", "createThreadPool", "destroy", "", "detectLanguageOf", "detectLanguageWithRules", "words", "", "detectLanguageWithRules$lingua", "equals", "other", "filterLanguagesByRules", "filterLanguagesByRules$lingua", "hashCode", "loadLanguageModel", "ngramLength", "loadLanguageModels", "languageModels", "lookUpNgramProbability", "ngram", "lookUpNgramProbability$lingua", "preloadLanguageModels", "splitTextIntoWords", "splitTextIntoWords$lingua", "sumUpProbabilities", "probabilities", "unigramCountsOfInputText", "sumUpProbabilities$lingua", "lingua"})
public final class LanguageDetector {
    @NotNull
    private final Set<Language> languages;
    private final double minimumRelativeDistance;
    private final int numberOfLoadedLanguages;
    @NotNull
    private final Map<Language, TrainingDataLanguageModel> unigramLanguageModels;
    @NotNull
    private final Map<Language, TrainingDataLanguageModel> bigramLanguageModels;
    @NotNull
    private final Map<Language, TrainingDataLanguageModel> trigramLanguageModels;
    @NotNull
    private final Map<Language, TrainingDataLanguageModel> quadrigramLanguageModels;
    @NotNull
    private final Map<Language, TrainingDataLanguageModel> fivegramLanguageModels;
    @NotNull
    private final ExecutorService threadPool;
    @NotNull
    private final Sequence<Language> languagesWithUniqueCharacters;
    @NotNull
    private final Map<Alphabet, Language> oneLanguageAlphabets;

    /*
     * WARNING - void declaration
     */
    public LanguageDetector(@NotNull Set<Language> languages, double minimumRelativeDistance, boolean isEveryLanguageModelPreloaded, int numberOfLoadedLanguages, @NotNull Map<Language, TrainingDataLanguageModel> unigramLanguageModels, @NotNull Map<Language, TrainingDataLanguageModel> bigramLanguageModels, @NotNull Map<Language, TrainingDataLanguageModel> trigramLanguageModels, @NotNull Map<Language, TrainingDataLanguageModel> quadrigramLanguageModels, @NotNull Map<Language, TrainingDataLanguageModel> fivegramLanguageModels) {
        void $this$filterValues$iv;
        void $this$filterNotTo$iv$iv;
        Map<Alphabet, Language> $this$filterNot$iv;
        Intrinsics.checkNotNullParameter(languages, (String)"languages");
        Intrinsics.checkNotNullParameter(unigramLanguageModels, (String)"unigramLanguageModels");
        Intrinsics.checkNotNullParameter(bigramLanguageModels, (String)"bigramLanguageModels");
        Intrinsics.checkNotNullParameter(trigramLanguageModels, (String)"trigramLanguageModels");
        Intrinsics.checkNotNullParameter(quadrigramLanguageModels, (String)"quadrigramLanguageModels");
        Intrinsics.checkNotNullParameter(fivegramLanguageModels, (String)"fivegramLanguageModels");
        this.languages = languages;
        this.minimumRelativeDistance = minimumRelativeDistance;
        this.numberOfLoadedLanguages = numberOfLoadedLanguages;
        this.unigramLanguageModels = unigramLanguageModels;
        this.bigramLanguageModels = bigramLanguageModels;
        this.trigramLanguageModels = trigramLanguageModels;
        this.quadrigramLanguageModels = quadrigramLanguageModels;
        this.fivegramLanguageModels = fivegramLanguageModels;
        this.threadPool = this.createThreadPool();
        Iterable iterable = this.languages;
        LanguageDetector languageDetector = this;
        boolean $i$f$filterNot = false;
        void var13_13 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            Language it = (Language)((Object)element$iv$iv);
            boolean bl = false;
            CharSequence charSequence = it.getUniqueCharacters$lingua();
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        languageDetector.languagesWithUniqueCharacters = CollectionsKt.asSequence((Iterable)((List)destination$iv$iv));
        $this$filterNot$iv = Alphabet.Companion.allSupportingExactlyOneLanguage();
        languageDetector = this;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            Language it = (Language)((Object)entry$iv.getValue());
            boolean bl = false;
            if (!this.getLanguages$lingua().contains((Object)it)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        languageDetector.oneLanguageAlphabets = result$iv;
        if (isEveryLanguageModelPreloaded) {
            this.preloadLanguageModels();
        }
    }

    public /* synthetic */ LanguageDetector(Set set, double d, boolean bl, int n, Map map, Map map2, Map map3, Map map4, Map map5, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = set.size();
        }
        if ((n2 & 0x10) != 0) {
            map = LanguageDetectorKt.access$getUNIGRAM_MODELS$p();
        }
        if ((n2 & 0x20) != 0) {
            map2 = LanguageDetectorKt.access$getBIGRAM_MODELS$p();
        }
        if ((n2 & 0x40) != 0) {
            map3 = LanguageDetectorKt.access$getTRIGRAM_MODELS$p();
        }
        if ((n2 & 0x80) != 0) {
            map4 = LanguageDetectorKt.access$getQUADRIGRAM_MODELS$p();
        }
        if ((n2 & 0x100) != 0) {
            map5 = LanguageDetectorKt.access$getFIVEGRAM_MODELS$p();
        }
        this(set, d, bl, n, map, map2, map3, map4, map5);
    }

    @NotNull
    public final Set<Language> getLanguages$lingua() {
        return this.languages;
    }

    public final double getMinimumRelativeDistance$lingua() {
        return this.minimumRelativeDistance;
    }

    public final int getNumberOfLoadedLanguages$lingua() {
        return this.numberOfLoadedLanguages;
    }

    @NotNull
    public final Map<Language, TrainingDataLanguageModel> getUnigramLanguageModels$lingua() {
        return this.unigramLanguageModels;
    }

    @NotNull
    public final Map<Language, TrainingDataLanguageModel> getBigramLanguageModels$lingua() {
        return this.bigramLanguageModels;
    }

    @NotNull
    public final Map<Language, TrainingDataLanguageModel> getTrigramLanguageModels$lingua() {
        return this.trigramLanguageModels;
    }

    @NotNull
    public final Map<Language, TrainingDataLanguageModel> getQuadrigramLanguageModels$lingua() {
        return this.quadrigramLanguageModels;
    }

    @NotNull
    public final Map<Language, TrainingDataLanguageModel> getFivegramLanguageModels$lingua() {
        return this.fivegramLanguageModels;
    }

    @NotNull
    public final ExecutorService getThreadPool$lingua() {
        return this.threadPool;
    }

    @NotNull
    public final Language detectLanguageOf(@NotNull String text) {
        Language language;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        SortedMap<Language, Double> confidenceValues = this.computeLanguageConfidenceValues(text);
        if (confidenceValues.isEmpty()) {
            return Language.UNKNOWN;
        }
        Language mostLikelyLanguage = confidenceValues.firstKey();
        if (confidenceValues.size() == 1) {
            Intrinsics.checkNotNullExpressionValue((Object)((Object)mostLikelyLanguage), (String)"mostLikelyLanguage");
            return mostLikelyLanguage;
        }
        Double mostLikelyLanguageProbability = (Double)MapsKt.getValue((Map)confidenceValues, (Object)((Object)mostLikelyLanguage));
        Collection<Double> collection = confidenceValues.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"confidenceValues.values");
        Double secondMostLikelyLanguageProbability = (Double)CollectionsKt.elementAt((Iterable)collection, (int)1);
        if (Intrinsics.areEqual((Double)mostLikelyLanguageProbability, (Double)secondMostLikelyLanguageProbability)) {
            language = Language.UNKNOWN;
        } else {
            double d = mostLikelyLanguageProbability;
            Intrinsics.checkNotNullExpressionValue((Object)secondMostLikelyLanguageProbability, (String)"secondMostLikelyLanguageProbability");
            if (d - secondMostLikelyLanguageProbability < this.minimumRelativeDistance) {
                language = Language.UNKNOWN;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)((Object)mostLikelyLanguage), (String)"mostLikelyLanguage");
                language = mostLikelyLanguage;
            }
        }
        return language;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final SortedMap<Language, Double> computeLanguageConfidenceValues(@NotNull String text) {
        Comparator sortedByConfidenceValue;
        void $this$mapValuesTo$iv$iv;
        Map map;
        Map unigramCounts2;
        Map<Language, Double> summedUpProbabilities;
        Iterator iterator2;
        Map probabilities;
        void $this$mapTo$iv$iv;
        void $this$mapTo$iv$iv2;
        Object object;
        void $this$mapTo$iv$iv3;
        void $this$map$iv;
        int i;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (this.threadPool.isShutdown()) {
            throw new IllegalStateException("This LanguageDetector instance has been destroyed and cannot be reused");
        }
        TreeMap values = new TreeMap();
        String cleanedUpText = this.cleanUpInputText$lingua(text);
        if (((CharSequence)cleanedUpText).length() == 0 || Constant.INSTANCE.getNO_LETTER().matches((CharSequence)cleanedUpText)) {
            return values;
        }
        List<String> words = this.splitTextIntoWords$lingua(cleanedUpText);
        Language languageDetectedByRules = this.detectLanguageWithRules$lingua(words);
        if (languageDetectedByRules != Language.UNKNOWN) {
            Map map2 = values;
            Double d = 1.0;
            map2.put(languageDetectedByRules, d);
            return values;
        }
        Set<Language> filteredLanguages = this.filterLanguagesByRules$lingua(words);
        if (filteredLanguages.size() == 1) {
            Language filteredLanguage = filteredLanguages.iterator().next();
            Map map3 = values;
            Double d = 1.0;
            map3.put(filteredLanguage, d);
            return values;
        }
        IntRange ngramSizeRange = cleanedUpText.length() >= 120 ? new IntRange(3, 3) : new IntRange(1, 5);
        Iterable $this$filter$iv = (Iterable)ngramSizeRange;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            i = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (!(cleanedUpText.length() >= i)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            i = ((Number)item$iv$iv).intValue();
            object = destination$iv$iv;
            boolean bl = false;
            object.add(() -> LanguageDetector.computeLanguageConfidenceValues$lambda-4$lambda-3(cleanedUpText, i, this, filteredLanguages));
        }
        List tasks2 = (List)destination$iv$iv;
        List $i$f$map22 = this.threadPool.invokeAll(tasks2);
        Intrinsics.checkNotNullExpressionValue($i$f$map22, (String)"threadPool.invokeAll(tasks)");
        Iterable $this$map$iv2 = $i$f$map22;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Future bl = (Future)item$iv$iv;
            object = destination$iv$iv2;
            boolean bl2 = false;
            object.add((Pair)it.get());
        }
        List allProbabilitiesAndUnigramCounts = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = allProbabilitiesAndUnigramCounts;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $dstr$probabilities$_u24__u24;
            Pair bl2 = (Pair)item$iv$iv;
            object = destination$iv$iv3;
            boolean iterator2 = false;
            probabilities = (Map)$dstr$probabilities$_u24__u24.component1();
            object.add(probabilities);
        }
        List allProbabilities = (List)destination$iv$iv3;
        Map map4 = (Map)((Pair)allProbabilitiesAndUnigramCounts.get(0)).getSecond();
        if (map4 == null) {
            map4 = MapsKt.emptyMap();
        }
        if (!(iterator2 = ((Iterable)(summedUpProbabilities = this.sumUpProbabilities$lingua(allProbabilities, unigramCounts2 = map4, filteredLanguages)).entrySet()).iterator()).hasNext()) {
            map = null;
        } else {
            probabilities = iterator2.next();
            if (!iterator2.hasNext()) {
                map = probabilities;
            } else {
                Map.Entry it22 = (Map.Entry)((Object)probabilities);
                boolean bl3 = false;
                double it22 = ((Number)it22.getValue()).doubleValue();
                do {
                    Object bl3 = iterator2.next();
                    Map.Entry it = (Map.Entry)bl3;
                    boolean $i$a$-maxByOrNull-LanguageDetector$computeLanguageConfidenceValues$highestProbability$2 = false;
                    double d = ((Number)it.getValue()).doubleValue();
                    if (Double.compare(it22, d) >= 0) continue;
                    probabilities = bl3;
                    it22 = d;
                } while (iterator2.hasNext());
                map = probabilities;
            }
        }
        Map.Entry entry = (Map.Entry)((Object)map);
        Double d = entry == null ? null : (Double)entry.getValue();
        if (d == null) {
            return MapsKt.sortedMapOf((Pair[])new Pair[0]);
        }
        double highestProbability = d;
        Map<Language, Double> $this$mapValues$iv = summedUpProbabilities;
        boolean $i$f$mapValues = false;
        Map<Language, Double> $dstr$probabilities$_u24__u24 = $this$mapValues$iv;
        Map destination$iv$iv4 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Map map5 = destination$iv$iv4;
            boolean bl = false;
            Map.Entry entry3 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            object = map5;
            boolean bl4 = false;
            Double d2 = highestProbability / ((Number)it.getValue()).doubleValue();
            object.put(k, d2);
        }
        Map confidenceValues = destination$iv$iv4;
        Comparator comparator = sortedByConfidenceValue = (Comparator)new Comparator(confidenceValues){
            final /* synthetic */ Map $confidenceValues$inlined;
            {
                this.$confidenceValues$inlined = map;
            }

            public final int compare(T a, T b) {
                Language language = (Language)((Object)b);
                boolean bl = false;
                Comparable comparable = (Comparable)this.$confidenceValues$inlined.get((Object)((Object)language));
                language = (Language)((Object)a);
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)this.$confidenceValues$inlined.get((Object)((Object)language))));
            }
        };
        Comparator sortedByConfidenceValueThenByLanguage = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Language language = (Language)((Object)a);
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)language);
                    language = (Language)((Object)b);
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)language)));
                }
                return n;
            }
        };
        return MapsKt.toSortedMap((Map)confidenceValues, (Comparator)sortedByConfidenceValueThenByLanguage);
    }

    public final void destroy() {
        this.threadPool.shutdown();
        if (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
            this.threadPool.shutdownNow();
        }
        for (Language language : this.languages) {
            this.unigramLanguageModels.remove((Object)language);
            this.bigramLanguageModels.remove((Object)language);
            this.trigramLanguageModels.remove((Object)language);
            this.quadrigramLanguageModels.remove((Object)language);
            this.fivegramLanguageModels.remove((Object)language);
        }
    }

    @NotNull
    public final String cleanUpInputText$lingua(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String string = ((Object)StringsKt.trim((CharSequence)text)).toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        CharSequence charSequence = string;
        string = Constant.INSTANCE.getPUNCTUATION();
        String string2 = "";
        charSequence = string.replace(charSequence, string2);
        string = Constant.INSTANCE.getNUMBERS();
        string2 = "";
        charSequence = string.replace(charSequence, string2);
        string = Constant.INSTANCE.getMULTIPLE_WHITESPACE();
        string2 = " ";
        return string.replace(charSequence, string2);
    }

    @NotNull
    public final List<String> splitTextIntoWords$lingua(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        List words = new ArrayList();
        int nextWordStart = 0;
        int n = 0;
        int n2 = text.length();
        while (n < n2) {
            String string;
            int i;
            char c;
            if ((c = text.charAt(i = n++)) == ' ') {
                if (nextWordStart != i) {
                    string = text.substring(nextWordStart, i);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    words.add(string);
                }
                nextWordStart = i + 1;
                continue;
            }
            if (!CharExtensionsKt.isLogogram(c)) continue;
            if (nextWordStart != i) {
                string = text.substring(nextWordStart, i);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                words.add(string);
            }
            words.add(String.valueOf(text.charAt(i)));
            nextWordStart = i + 1;
        }
        if (nextWordStart != text.length()) {
            String string = text;
            n2 = text.length();
            String string2 = string.substring(nextWordStart, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            words.add(string2);
        }
        return words;
    }

    @NotNull
    public final Map<Language, Integer> countUnigramsOfInputText$lingua(@NotNull TestDataLanguageModel unigramLanguageModel, @NotNull Set<? extends Language> filteredLanguages) {
        Intrinsics.checkNotNullParameter((Object)unigramLanguageModel, (String)"unigramLanguageModel");
        Intrinsics.checkNotNullParameter(filteredLanguages, (String)"filteredLanguages");
        Map unigramCounts2 = new LinkedHashMap();
        for (Language language : filteredLanguages) {
            for (Ngram unigram : unigramLanguageModel.getNgrams()) {
                double probability = this.lookUpNgramProbability$lingua(language, unigram);
                if (!(probability > 0.0)) continue;
                MapExtensionsKt.incrementCounter(unigramCounts2, language);
            }
        }
        return unigramCounts2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Language, Double> sumUpProbabilities$lingua(@NotNull List<? extends Map<Language, Double>> probabilities, @NotNull Map<Language, Integer> unigramCountsOfInputText, @NotNull Set<? extends Language> filteredLanguages) {
        void $this$filterTo$iv$iv;
        Map map;
        Intrinsics.checkNotNullParameter(probabilities, (String)"probabilities");
        Intrinsics.checkNotNullParameter(unigramCountsOfInputText, (String)"unigramCountsOfInputText");
        Intrinsics.checkNotNullParameter(filteredLanguages, (String)"filteredLanguages");
        Map summedUpProbabilities = new LinkedHashMap();
        for (Language language : filteredLanguages) {
            map = summedUpProbabilities;
            Object object = probabilities;
            double d = 0.0;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                void it;
                Object t = iterator.next();
                Map map2 = (Map)t;
                double d2 = d;
                boolean bl = false;
                Double d3 = (Double)it.get((Object)language);
                double d4 = d3 == null ? 0.0 : d3;
                d = d2 + d4;
            }
            object = d;
            map.put(language, object);
            if (!unigramCountsOfInputText.containsKey((Object)language)) continue;
            map = summedUpProbabilities;
            object = ((Number)MapsKt.getValue((Map)summedUpProbabilities, (Object)((Object)language))).doubleValue() / ((Number)MapsKt.getValue(unigramCountsOfInputText, (Object)((Object)language))).doubleValue();
            map.put(language, object);
        }
        Map $this$filter$iv = summedUpProbabilities;
        boolean bl = false;
        map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(!(((Number)it.getValue()).doubleValue() == 0.0))) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Language detectLanguageWithRules$lingua(@NotNull List<String> words) {
        int unknownLanguageCount;
        Intrinsics.checkNotNullParameter(words, (String)"words");
        Map totalLanguageCounts = new LinkedHashMap();
        for (String word : words) {
            int secondCharCount;
            Map wordLanguageCounts = new LinkedHashMap();
            int n = 0;
            int n2 = word.length();
            while (n < n2) {
                void $this$forEach$iv;
                char character = word.charAt(n);
                ++n;
                boolean isMatch = false;
                for (Map.Entry<Alphabet, Language> entry : this.oneLanguageAlphabets.entrySet()) {
                    Alphabet alphabet = entry.getKey();
                    Language language = entry.getValue();
                    if (!alphabet.matches(character)) continue;
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, language);
                    isMatch = true;
                    break;
                }
                if (isMatch) continue;
                if (Alphabet.HAN.matches(character)) {
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, Language.CHINESE);
                    continue;
                }
                if (Constant.INSTANCE.isJapaneseAlphabet(character)) {
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, Language.JAPANESE);
                    continue;
                }
                if (!Alphabet.LATIN.matches(character) && !Alphabet.CYRILLIC.matches(character) && !Alphabet.DEVANAGARI.matches(character)) continue;
                Sequence sequence = SequencesKt.filter(this.languagesWithUniqueCharacters, (Function1)((Function1)new Function1<Language, Boolean>(character){
                    final /* synthetic */ char $character;
                    {
                        this.$character = $character;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Language it) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                        String string = it.getUniqueCharacters$lingua();
                        return string == null ? false : (bl = StringsKt.contains$default((CharSequence)string, (char)this.$character, (boolean)false, (int)2, null));
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Language it = (Language)((Object)element$iv);
                    boolean bl = false;
                    MapExtensionsKt.incrementCounter(wordLanguageCounts, it);
                }
            }
            if (wordLanguageCounts.isEmpty()) {
                MapExtensionsKt.incrementCounter(totalLanguageCounts, Language.UNKNOWN);
                continue;
            }
            if (wordLanguageCounts.size() == 1) {
                Language language = (Language)((Object)CollectionsKt.first((Iterable)wordLanguageCounts.keySet()));
                if (this.languages.contains((Object)language)) {
                    MapExtensionsKt.incrementCounter(totalLanguageCounts, language);
                    continue;
                }
                MapExtensionsKt.incrementCounter(totalLanguageCounts, Language.UNKNOWN);
                continue;
            }
            Iterable $this$sortedByDescending$iv = MapsKt.toList((Map)wordLanguageCounts);
            boolean $i$f$sortedByDescending = false;
            List sortedWordLanguageCounts = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Pair it = (Pair)b;
                    boolean bl = false;
                    Comparable comparable = (Integer)it.getSecond();
                    it = (Pair)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
                }
            });
            $this$sortedByDescending$iv = (Pair)sortedWordLanguageCounts.get(0);
            Language mostFrequentLanguage = (Language)((Object)$this$sortedByDescending$iv.component1());
            int firstCharCount = ((Number)$this$sortedByDescending$iv.component2()).intValue();
            if (firstCharCount > (secondCharCount = ((Number)((Pair)sortedWordLanguageCounts.get(1)).component2()).intValue()) && this.languages.contains((Object)mostFrequentLanguage)) {
                MapExtensionsKt.incrementCounter(totalLanguageCounts, mostFrequentLanguage);
                continue;
            }
            MapExtensionsKt.incrementCounter(totalLanguageCounts, Language.UNKNOWN);
        }
        Integer n = (Integer)totalLanguageCounts.get((Object)Language.UNKNOWN);
        int n3 = unknownLanguageCount = n == null ? 0 : n;
        if ((double)unknownLanguageCount < 0.5 * (double)words.size()) {
            totalLanguageCounts.remove((Object)Language.UNKNOWN);
        }
        if (totalLanguageCounts.isEmpty()) {
            return Language.UNKNOWN;
        }
        if (totalLanguageCounts.size() == 1) {
            return (Language)((Object)CollectionsKt.first((Iterable)totalLanguageCounts.keySet()));
        }
        if (totalLanguageCounts.size() == 2 && totalLanguageCounts.containsKey((Object)Language.CHINESE) && totalLanguageCounts.containsKey((Object)Language.JAPANESE)) {
            return Language.JAPANESE;
        }
        Iterable $this$sortedByDescending$iv = MapsKt.toList((Map)totalLanguageCounts);
        boolean $i$f$sortedByDescending = false;
        List sortedTotalLanguageCounts = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = (Integer)it.getSecond();
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)it.getSecond()));
            }
        });
        Pair pair = (Pair)sortedTotalLanguageCounts.get(0);
        Language mostFrequentLanguage = (Language)((Object)pair.component1());
        int firstCharCount = ((Number)pair.component2()).intValue();
        int secondCharCount = ((Number)((Pair)sortedTotalLanguageCounts.get(1)).component2()).intValue();
        return firstCharCount == secondCharCount ? Language.UNKNOWN : mostFrequentLanguage;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Language> filterLanguagesByRules$lingua(@NotNull List<String> words) {
        Set set;
        void $this$filterTo$iv$iv;
        Object v0;
        Intrinsics.checkNotNullParameter(words, (String)"words");
        Map detectedAlphabets = new LinkedHashMap();
        block0: for (String string : words) {
            for (Alphabet alphabet : Alphabet.values()) {
                if (!alphabet.matches(string)) continue;
                MapExtensionsKt.incrementCounter(detectedAlphabets, alphabet);
                continue block0;
            }
        }
        if (detectedAlphabets.isEmpty()) {
            return this.languages;
        }
        if (detectedAlphabets.size() > 1) {
            Set distinctAlphabets = new LinkedHashSet();
            Iterator iterator = detectedAlphabets.values().iterator();
            while (iterator.hasNext()) {
                int count = ((Number)iterator.next()).intValue();
                distinctAlphabets.add(count);
            }
            if (distinctAlphabets.size() == 1) {
                return this.languages;
            }
        }
        Iterable iterable = detectedAlphabets.entrySet();
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = iterable.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                Map.Entry it = (Map.Entry)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = ((Number)it.getValue()).intValue();
                do {
                    Object t = iterator$iv.next();
                    Map.Entry it2 = (Map.Entry)t;
                    boolean bl2 = false;
                    int v$iv = ((Number)it2.getValue()).intValue();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = t;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        Intrinsics.checkNotNull(v0);
        Alphabet mostFrequentAlphabet = (Alphabet)((Object)((Map.Entry)v0).getKey());
        Iterable $this$filter$iv = this.languages;
        boolean $i$f$filter = false;
        Iterable maxElem$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean bl = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Language it = (Language)((Object)element$iv$iv);
            boolean bl3 = false;
            if (!it.getAlphabets$lingua().contains((Object)mostFrequentAlphabet)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list = (List)destination$iv$iv;
        Map languageCounts = new LinkedHashMap();
        block5: for (String word : words) {
            for (Map.Entry entry : Constant.INSTANCE.getCHARS_TO_LANGUAGES_MAPPING().entrySet()) {
                String characters = (String)entry.getKey();
                Set languages = (Set)entry.getValue();
                if (!StringExtensionsKt.containsAnyOf(word, characters)) continue;
                for (Language language : languages) {
                    MapExtensionsKt.incrementCounter(languageCounts, language);
                }
                continue block5;
            }
        }
        Map $this$filterValues$iv = languageCounts;
        boolean $i$f$filterValues = false;
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            int it = ((Number)entry$iv.getValue()).intValue();
            boolean bl4 = false;
            if (!((double)it >= (double)words.size() / 2.0)) continue;
            linkedHashMap.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set languagesSubset = ((Map)linkedHashMap).keySet();
        if (!((Collection)languagesSubset).isEmpty()) {
            Iterable $this$filter$iv2 = list;
            boolean $i$f$filter2 = false;
            Iterable iterable2 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo3 = false;
            for (Object element$iv$iv : iterable2) {
                Language it = (Language)((Object)element$iv$iv);
                boolean bl5 = false;
                if (!languagesSubset.contains((Object)it)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        } else {
            set = CollectionsKt.toSet((Iterable)list);
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<Language, Double> computeLanguageProbabilities$lingua(@NotNull TestDataLanguageModel testDataModel, @NotNull Set<? extends Language> filteredLanguages) {
        void $this$filterTo$iv$iv;
        Map map;
        Intrinsics.checkNotNullParameter((Object)testDataModel, (String)"testDataModel");
        Intrinsics.checkNotNullParameter(filteredLanguages, (String)"filteredLanguages");
        Map probabilities = new LinkedHashMap();
        for (Language language : filteredLanguages) {
            map = probabilities;
            Double d = this.computeSumOfNgramProbabilities$lingua(language, testDataModel.getNgrams());
            map.put(language, d);
        }
        Map $this$filter$iv = probabilities;
        boolean bl = false;
        map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl2 = false;
            if (!(((Number)it.getValue()).doubleValue() < 0.0)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return destination$iv$iv;
    }

    public final double computeSumOfNgramProbabilities$lingua(@NotNull Language language, @NotNull Set<Ngram> ngrams) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter(ngrams, (String)"ngrams");
        double probabilitiesSum = 0.0;
        block0: for (Ngram ngram : ngrams) {
            for (Ngram elem : ngram.rangeOfLowerOrderNgrams()) {
                double probability = this.lookUpNgramProbability$lingua(language, elem);
                if (!(probability > 0.0)) continue;
                probabilitiesSum += Math.log(probability);
                continue block0;
            }
        }
        return probabilitiesSum;
    }

    public final double lookUpNgramProbability$lingua(@NotNull Language language, @NotNull Ngram ngram) {
        Map<Language, TrainingDataLanguageModel> map;
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)ngram, (String)"ngram");
        int ngramLength = ngram.getValue().length();
        switch (ngramLength) {
            case 5: {
                map = this.fivegramLanguageModels;
                break;
            }
            case 4: {
                map = this.quadrigramLanguageModels;
                break;
            }
            case 3: {
                map = this.trigramLanguageModels;
                break;
            }
            case 2: {
                map = this.bigramLanguageModels;
                break;
            }
            case 1: {
                map = this.unigramLanguageModels;
                break;
            }
            case 0: {
                throw new IllegalArgumentException("Zerogram detected");
            }
            default: {
                throw new IllegalArgumentException(Intrinsics.stringPlus((String)"unsupported ngram length detected: ", (Object)ngram.getValue().length()));
            }
        }
        Map<Language, TrainingDataLanguageModel> languageModels = map;
        TrainingDataLanguageModel model = this.loadLanguageModels(languageModels, language, ngramLength);
        return model.getRelativeFrequency(ngram);
    }

    private final TrainingDataLanguageModel loadLanguageModels(Map<Language, TrainingDataLanguageModel> languageModels, Language language, int ngramLength) {
        if (languageModels.containsKey((Object)language)) {
            return (TrainingDataLanguageModel)MapsKt.getValue(languageModels, (Object)((Object)language));
        }
        TrainingDataLanguageModel model = this.loadLanguageModel(language, ngramLength);
        languageModels.put(language, model);
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final TrainingDataLanguageModel loadLanguageModel(Language language, int ngramLength) {
        String fileName = Intrinsics.stringPlus((String)Ngram.Companion.getNgramNameByLength(ngramLength), (Object)"s.json");
        String filePath = "/language-models/" + (Object)((Object)language.getIsoCode639_1()) + '/' + fileName;
        InputStream inputStream = Language.class.getResourceAsStream(filePath);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
        Object object = inputStream;
        object = new InputStreamReader((InputStream)object, Charsets.UTF_8);
        int n = 8192;
        Closeable closeable = object instanceof BufferedReader ? (BufferedReader)object : new BufferedReader((Reader)object, n);
        Throwable throwable = null;
        try {
            BufferedReader it = (BufferedReader)closeable;
            boolean bl = false;
            object = TextStreamsKt.readText((Reader)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object jsonContent = object;
        return TrainingDataLanguageModel.Companion.fromJson((String)jsonContent);
    }

    private final void preloadLanguageModels() {
        List tasks2 = new ArrayList();
        for (Language language : this.languages) {
            tasks2.add(() -> LanguageDetector.preloadLanguageModels$lambda-22(this, language));
            tasks2.add(() -> LanguageDetector.preloadLanguageModels$lambda-23(this, language));
            tasks2.add(() -> LanguageDetector.preloadLanguageModels$lambda-24(this, language));
            tasks2.add(() -> LanguageDetector.preloadLanguageModels$lambda-25(this, language));
            tasks2.add(() -> LanguageDetector.preloadLanguageModels$lambda-26(this, language));
        }
        this.threadPool.invokeAll(tasks2);
    }

    private final ExecutorService createThreadPool() {
        int cpus = Runtime.getRuntime().availableProcessors();
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(cpus, cpus, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue());
        threadPool.allowCoreThreadTimeOut(true);
        return threadPool;
    }

    public boolean equals(@Nullable Object other) {
        return this == other ? true : (!(other instanceof LanguageDetector) ? false : (!Intrinsics.areEqual(this.languages, ((LanguageDetector)other).languages) ? false : this.minimumRelativeDistance == ((LanguageDetector)other).minimumRelativeDistance));
    }

    public int hashCode() {
        return 31 * ((Object)this.languages).hashCode() + Double.hashCode(this.minimumRelativeDistance);
    }

    private static final Pair computeLanguageConfidenceValues$lambda-4$lambda-3(String $cleanedUpText, int $i, LanguageDetector this$0, Set $filteredLanguages) {
        Map<Language, Integer> map;
        Intrinsics.checkNotNullParameter((Object)$cleanedUpText, (String)"$cleanedUpText");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$filteredLanguages, (String)"$filteredLanguages");
        TestDataLanguageModel testDataModel = TestDataLanguageModel.Companion.fromText($cleanedUpText, $i);
        Map<Language, Double> probabilities = this$0.computeLanguageProbabilities$lingua(testDataModel, $filteredLanguages);
        if ($i == 1) {
            Set<Language> languages = probabilities.keySet();
            Set unigramFilteredLanguages2 = !((Collection)languages).isEmpty() ? SequencesKt.toSet((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)$filteredLanguages), (Function1)((Function1)new Function1<Language, Boolean>(languages){
                final /* synthetic */ Set<Language> $languages;
                {
                    this.$languages = $languages;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(@NotNull Language it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return this.$languages.contains((Object)((Object)it));
                }
            }))) : $filteredLanguages;
            map = this$0.countUnigramsOfInputText$lingua(testDataModel, unigramFilteredLanguages2);
        } else {
            map = null;
        }
        Map<Language, Integer> unigramCounts2 = map;
        return new Pair(probabilities, (Object)unigramCounts2);
    }

    private static final TrainingDataLanguageModel preloadLanguageModels$lambda-22(LanguageDetector this$0, Language $language) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$language), (String)"$language");
        return this$0.loadLanguageModels(this$0.unigramLanguageModels, $language, 1);
    }

    private static final TrainingDataLanguageModel preloadLanguageModels$lambda-23(LanguageDetector this$0, Language $language) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$language), (String)"$language");
        return this$0.loadLanguageModels(this$0.bigramLanguageModels, $language, 2);
    }

    private static final TrainingDataLanguageModel preloadLanguageModels$lambda-24(LanguageDetector this$0, Language $language) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$language), (String)"$language");
        return this$0.loadLanguageModels(this$0.trigramLanguageModels, $language, 3);
    }

    private static final TrainingDataLanguageModel preloadLanguageModels$lambda-25(LanguageDetector this$0, Language $language) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$language), (String)"$language");
        return this$0.loadLanguageModels(this$0.quadrigramLanguageModels, $language, 4);
    }

    private static final TrainingDataLanguageModel preloadLanguageModels$lambda-26(LanguageDetector this$0, Language $language) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$language), (String)"$language");
        return this$0.loadLanguageModels(this$0.fivegramLanguageModels, $language, 5);
    }
}

