/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.api.io;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.internal.Ngram;
import com.github.pemistahl.lingua.internal.TrainingDataLanguageModel;
import com.github.pemistahl.lingua.internal.io.FilesWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007JD\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u0013H\u0002J \u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\rH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/github/pemistahl/lingua/api/io/LanguageModelFilesWriter;", "Lcom/github/pemistahl/lingua/internal/io/FilesWriter;", "()V", "createAndWriteLanguageModelFiles", "", "inputFilePath", "Ljava/nio/file/Path;", "inputFileCharset", "Ljava/nio/charset/Charset;", "outputDirectoryPath", "language", "Lcom/github/pemistahl/lingua/api/Language;", "charClass", "", "createLanguageModel", "Lcom/github/pemistahl/lingua/internal/TrainingDataLanguageModel;", "ngramLength", "", "lowerNgramAbsoluteFrequencies", "", "Lcom/github/pemistahl/lingua/internal/Ngram;", "writeLanguageModel", "model", "fileName", "lingua"})
public final class LanguageModelFilesWriter
extends FilesWriter {
    @NotNull
    public static final LanguageModelFilesWriter INSTANCE = new LanguageModelFilesWriter();

    private LanguageModelFilesWriter() {
    }

    @JvmStatic
    public static final void createAndWriteLanguageModelFiles(@NotNull Path inputFilePath, @NotNull Charset inputFileCharset, @NotNull Path outputDirectoryPath, @NotNull Language language, @NotNull String charClass) {
        Intrinsics.checkNotNullParameter((Object)inputFilePath, (String)"inputFilePath");
        Intrinsics.checkNotNullParameter((Object)inputFileCharset, (String)"inputFileCharset");
        Intrinsics.checkNotNullParameter((Object)outputDirectoryPath, (String)"outputDirectoryPath");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)charClass, (String)"charClass");
        INSTANCE.checkInputFilePath(inputFilePath);
        INSTANCE.checkOutputDirectoryPath(outputDirectoryPath);
        TrainingDataLanguageModel unigramModel = INSTANCE.createLanguageModel(inputFilePath, inputFileCharset, language, 1, charClass, MapsKt.emptyMap());
        TrainingDataLanguageModel bigramModel = INSTANCE.createLanguageModel(inputFilePath, inputFileCharset, language, 2, charClass, unigramModel.getAbsoluteFrequencies());
        TrainingDataLanguageModel trigramModel = INSTANCE.createLanguageModel(inputFilePath, inputFileCharset, language, 3, charClass, bigramModel.getAbsoluteFrequencies());
        TrainingDataLanguageModel quadrigramModel = INSTANCE.createLanguageModel(inputFilePath, inputFileCharset, language, 4, charClass, trigramModel.getAbsoluteFrequencies());
        TrainingDataLanguageModel fivegramModel = INSTANCE.createLanguageModel(inputFilePath, inputFileCharset, language, 5, charClass, quadrigramModel.getAbsoluteFrequencies());
        INSTANCE.writeLanguageModel(unigramModel, outputDirectoryPath, "unigrams.json");
        INSTANCE.writeLanguageModel(bigramModel, outputDirectoryPath, "bigrams.json");
        INSTANCE.writeLanguageModel(trigramModel, outputDirectoryPath, "trigrams.json");
        INSTANCE.writeLanguageModel(quadrigramModel, outputDirectoryPath, "quadrigrams.json");
        INSTANCE.writeLanguageModel(fivegramModel, outputDirectoryPath, "fivegrams.json");
    }

    public static /* synthetic */ void createAndWriteLanguageModelFiles$default(Path path, Charset charset, Path path2, Language language, String string, int n, Object object) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n & 0x10) != 0) {
            string = "\\p{L}";
        }
        LanguageModelFilesWriter.createAndWriteLanguageModelFiles(path, charset, path2, language, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final TrainingDataLanguageModel createLanguageModel(Path inputFilePath, Charset inputFileCharset, Language language, int ngramLength, String charClass, Map<Ngram, Integer> lowerNgramAbsoluteFrequencies) {
        void $this$useLines$iv;
        TrainingDataLanguageModel model = null;
        Object object = inputFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inputFilePath.toFile()");
        int n = 8192;
        Object object2 = object;
        object2 = new FileInputStream((File)object2);
        Closeable closeable = new InputStreamReader((InputStream)object2, inputFileCharset);
        object = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        boolean $i$f$useLines = false;
        closeable = $this$useLines$iv;
        int n2 = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            model = TrainingDataLanguageModel.Companion.fromText((Sequence<String>)lines, language, ngramLength, charClass, lowerNgramAbsoluteFrequencies);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        TrainingDataLanguageModel trainingDataLanguageModel = model;
        if (trainingDataLanguageModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"model");
            trainingDataLanguageModel = null;
        }
        return trainingDataLanguageModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeLanguageModel(TrainingDataLanguageModel model, Path outputDirectoryPath, String fileName) {
        Path modelFilePath = outputDirectoryPath.resolve(fileName);
        if (Files.isRegularFile(modelFilePath, new LinkOption[0])) {
            Files.delete(modelFilePath);
        }
        Object object = modelFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"modelFilePath.toFile()");
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        Object object3 = object;
        object3 = new FileOutputStream((File)object3);
        Writer writer = new OutputStreamWriter((OutputStream)object3, (Charset)object2);
        object = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object2 = null;
        try {
            BufferedWriter writer2 = (BufferedWriter)object;
            boolean bl = false;
            writer2.write(model.toJson());
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }
}

