/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.api.io;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.internal.Constant;
import com.github.pemistahl.lingua.internal.io.FilesWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J>\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J<\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0007J.\u0010\u0013\u001a\u00020\u00042\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/github/pemistahl/lingua/api/io/TestDataFilesWriter;", "Lcom/github/pemistahl/lingua/internal/io/FilesWriter;", "()V", "createAndWriteSentencesFile", "", "inputFilePath", "Ljava/nio/file/Path;", "inputFileCharset", "Ljava/nio/charset/Charset;", "outputDirectoryPath", "language", "Lcom/github/pemistahl/lingua/api/Language;", "maximumLines", "", "createAndWriteSingleWordsFile", "", "", "charClass", "createAndWriteTestDataFiles", "createAndWriteWordPairsFile", "words", "lingua"})
public final class TestDataFilesWriter
extends FilesWriter {
    @NotNull
    public static final TestDataFilesWriter INSTANCE = new TestDataFilesWriter();

    private TestDataFilesWriter() {
    }

    @JvmStatic
    public static final void createAndWriteTestDataFiles(@NotNull Path inputFilePath, @NotNull Charset inputFileCharset, @NotNull Path outputDirectoryPath, @NotNull Language language, @NotNull String charClass, int maximumLines) {
        Intrinsics.checkNotNullParameter((Object)inputFilePath, (String)"inputFilePath");
        Intrinsics.checkNotNullParameter((Object)inputFileCharset, (String)"inputFileCharset");
        Intrinsics.checkNotNullParameter((Object)outputDirectoryPath, (String)"outputDirectoryPath");
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter((Object)charClass, (String)"charClass");
        INSTANCE.checkInputFilePath(inputFilePath);
        INSTANCE.checkOutputDirectoryPath(outputDirectoryPath);
        INSTANCE.createAndWriteSentencesFile(inputFilePath, inputFileCharset, outputDirectoryPath, language, maximumLines);
        List<String> singleWords = INSTANCE.createAndWriteSingleWordsFile(inputFilePath, inputFileCharset, outputDirectoryPath, language, charClass, maximumLines);
        INSTANCE.createAndWriteWordPairsFile(singleWords, outputDirectoryPath, language, maximumLines);
    }

    public static /* synthetic */ void createAndWriteTestDataFiles$default(Path path, Charset charset, Path path2, Language language, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        if ((n2 & 0x10) != 0) {
            string = "\\p{L}";
        }
        TestDataFilesWriter.createAndWriteTestDataFiles(path, charset, path2, language, string, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void createAndWriteSentencesFile(Path inputFilePath, Charset inputFileCharset, Path outputDirectoryPath, Language language, int maximumLines) {
        void $this$useLines$iv;
        String fileName = (Object)((Object)language.getIsoCode639_1()) + ".txt";
        Path sentencesDirectoryPath = outputDirectoryPath.resolve("sentences");
        Path sentencesFilePath = sentencesDirectoryPath.resolve(fileName);
        int lineCounter = 0;
        if (!Files.isDirectory(sentencesDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(sentencesDirectoryPath, new FileAttribute[0]);
        }
        if (Files.isRegularFile(sentencesFilePath, new LinkOption[0])) {
            Files.delete(sentencesFilePath);
        }
        Object object = inputFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"inputFilePath.toFile()");
        int n = 8192;
        Object object2 = object;
        object2 = new FileInputStream((File)object2);
        Closeable closeable = new InputStreamReader((InputStream)object2, inputFileCharset);
        object = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        boolean $i$f$useLines = false;
        closeable = $this$useLines$iv;
        int n2 = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            Object object3 = sentencesFilePath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"sentencesFilePath.toFile()");
            Object object4 = Charsets.UTF_8;
            int n3 = 8192;
            Object object5 = object3;
            object5 = new FileOutputStream((File)object5);
            Writer writer = new OutputStreamWriter((OutputStream)object5, (Charset)object4);
            object3 = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n3);
            object4 = null;
            try {
                BufferedWriter writer2 = (BufferedWriter)object3;
                boolean bl3 = false;
                for (String line : lines) {
                    if (lineCounter >= maximumLines) continue;
                    CharSequence charSequence = line;
                    Regex regex = Constant.INSTANCE.getMULTIPLE_WHITESPACE();
                    String string = " ";
                    writer2.write(StringsKt.replace$default((String)regex.replace(charSequence, string), (String)"\"", (String)"", (boolean)false, (int)4, null));
                    writer2.newLine();
                    int n4 = lineCounter;
                    lineCounter = n4 + 1;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                object4 = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object3, (Throwable)object4);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final List<String> createAndWriteSingleWordsFile(Path inputFilePath, Charset inputFileCharset, Path outputDirectoryPath, Language language, String charClass, int maximumLines) {
        Object object;
        void $this$useLines$iv;
        String fileName = (Object)((Object)language.getIsoCode639_1()) + ".txt";
        Path singleWordsDirectoryPath = outputDirectoryPath.resolve("single-words");
        Path singleWordsFilePath = singleWordsDirectoryPath.resolve(fileName);
        Regex wordRegex = new Regex('[' + charClass + "]{5,}");
        List words = new ArrayList();
        int lineCounter = 0;
        if (!Files.isDirectory(singleWordsDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(singleWordsDirectoryPath, new FileAttribute[0]);
        }
        if (Files.isRegularFile(singleWordsFilePath, new LinkOption[0])) {
            Files.delete(singleWordsFilePath);
        }
        Object object2 = inputFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"inputFilePath.toFile()");
        int n = 8192;
        Object object3 = object2;
        object3 = new FileInputStream((File)object3);
        Closeable closeable = new InputStreamReader((InputStream)object3, inputFileCharset);
        object2 = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        boolean $i$f$useLines = false;
        closeable = $this$useLines$iv;
        int n2 = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n2);
        Object object4 = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence lines = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            for (String line : lines) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                String it;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Object object5 = line;
                Regex regex = Constant.INSTANCE.getPUNCTUATION();
                String string = "";
                object5 = regex.replace((CharSequence)object5, string);
                regex = Constant.INSTANCE.getNUMBERS();
                string = "";
                object5 = regex.replace((CharSequence)object5, string);
                regex = Constant.INSTANCE.getMULTIPLE_WHITESPACE();
                string = " ";
                CharSequence charSequence = StringsKt.replace$default((String)regex.replace((CharSequence)object5, string), (String)"\"", (String)"", (boolean)false, (int)4, null);
                object5 = new char[1];
                object5[0] = 32;
                object5 = StringsKt.split$default((CharSequence)charSequence, (char[])object5, (boolean)false, (int)0, (int)6, null);
                boolean $i$f$map = false;
                string = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    String string3 = ((Object)StringsKt.trim((CharSequence)it)).toString().toLowerCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    collection.add(string3);
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl4 = false;
                    if (!wordRegex.matches((CharSequence)it)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List singleWords = (List)destination$iv$iv;
                words.addAll(singleWords);
            }
            object = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object4 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object4);
        }
        object2 = singleWordsFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"singleWordsFilePath.toFile()");
        Object object6 = Charsets.UTF_8;
        int n3 = 8192;
        object = object2;
        object = new FileOutputStream((File)object);
        object4 = new OutputStreamWriter((OutputStream)object, (Charset)object6);
        object2 = object4 instanceof BufferedWriter ? (BufferedWriter)object4 : new BufferedWriter((Writer)object4, n3);
        object6 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object2;
            boolean bl = false;
            for (String word : words) {
                if (lineCounter >= maximumLines) break;
                writer.write(word);
                writer.newLine();
                int n4 = lineCounter;
                lineCounter = n4 + 1;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object6 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object6);
        }
        return words;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void createAndWriteWordPairsFile(List<String> words, Path outputDirectoryPath, Language language, int maximumLines) {
        int n;
        int n2;
        int n3;
        String fileName = (Object)((Object)language.getIsoCode639_1()) + ".txt";
        Path wordPairsDirectoryPath = outputDirectoryPath.resolve("word-pairs");
        Path wordPairsFilePath = wordPairsDirectoryPath.resolve(fileName);
        Set wordPairs = new LinkedHashSet();
        int lineCounter = 0;
        if (!Files.isDirectory(wordPairsDirectoryPath, new LinkOption[0])) {
            Files.createDirectory(wordPairsDirectoryPath, new FileAttribute[0]);
        }
        if (Files.isRegularFile(wordPairsFilePath, new LinkOption[0])) {
            Files.delete(wordPairsFilePath);
        }
        if ((n3 = 0) <= (n2 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)(n = words.size() - 2), (int)2))) {
            int i;
            do {
                i = n3;
                n3 += 2;
                wordPairs.add(CollectionsKt.joinToString$default((Iterable)CollectionsKt.slice(words, (IntRange)new IntRange(i, i + 1)), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
            } while (i != n2);
        }
        Object object = wordPairsFilePath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"wordPairsFilePath.toFile()");
        Object object2 = Charsets.UTF_8;
        n2 = 8192;
        Iterator iterator = object;
        iterator = new FileOutputStream((File)((Object)iterator));
        Writer i = new OutputStreamWriter((OutputStream)((Object)iterator), (Charset)object2);
        object = i instanceof BufferedWriter ? (BufferedWriter)i : new BufferedWriter(i, n2);
        object2 = null;
        try {
            BufferedWriter writer = (BufferedWriter)object;
            boolean bl = false;
            for (String wordPair : wordPairs) {
                if (lineCounter >= maximumLines) break;
                writer.write(wordPair);
                writer.newLine();
                int n4 = lineCounter;
                lineCounter = n4 + 1;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }
}

