/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.internal;

import com.github.pemistahl.lingua.api.Language;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aR#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0011\u0010\u0015\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/github/pemistahl/lingua/internal/Constant;", "", "()V", "CHARS_TO_LANGUAGES_MAPPING", "", "", "", "Lcom/github/pemistahl/lingua/api/Language;", "getCHARS_TO_LANGUAGES_MAPPING", "()Ljava/util/Map;", "LANGUAGES_SUPPORTING_LOGOGRAMS", "getLANGUAGES_SUPPORTING_LOGOGRAMS", "()Ljava/util/Set;", "MULTIPLE_WHITESPACE", "Lkotlin/text/Regex;", "getMULTIPLE_WHITESPACE", "()Lkotlin/text/Regex;", "NO_LETTER", "getNO_LETTER", "NUMBERS", "getNUMBERS", "PUNCTUATION", "getPUNCTUATION", "isJapaneseAlphabet", "", "char", "", "lingua"})
public final class Constant {
    @NotNull
    public static final Constant INSTANCE = new Constant();
    @NotNull
    private static final Map<String, Set<Language>> CHARS_TO_LANGUAGES_MAPPING;
    @NotNull
    private static final Set<Language> LANGUAGES_SUPPORTING_LOGOGRAMS;
    @NotNull
    private static final Regex MULTIPLE_WHITESPACE;
    @NotNull
    private static final Regex NO_LETTER;
    @NotNull
    private static final Regex NUMBERS;
    @NotNull
    private static final Regex PUNCTUATION;

    private Constant() {
    }

    @NotNull
    public final Map<String, Set<Language>> getCHARS_TO_LANGUAGES_MAPPING() {
        return CHARS_TO_LANGUAGES_MAPPING;
    }

    public final boolean isJapaneseAlphabet(char c) {
        Character.UnicodeScript script = Character.UnicodeScript.of(c);
        return script == Character.UnicodeScript.HIRAGANA || script == Character.UnicodeScript.KATAKANA || script == Character.UnicodeScript.HAN;
    }

    @NotNull
    public final Set<Language> getLANGUAGES_SUPPORTING_LOGOGRAMS() {
        return LANGUAGES_SUPPORTING_LOGOGRAMS;
    }

    @NotNull
    public final Regex getMULTIPLE_WHITESPACE() {
        return MULTIPLE_WHITESPACE;
    }

    @NotNull
    public final Regex getNO_LETTER() {
        return NO_LETTER;
    }

    @NotNull
    public final Regex getNUMBERS() {
        return NUMBERS;
    }

    @NotNull
    public final Regex getPUNCTUATION() {
        return PUNCTUATION;
    }

    static {
        Object[] objectArray = new Pair[43];
        Language[] languageArray = new Language[]{Language.PORTUGUESE, Language.VIETNAMESE};
        objectArray[0] = TuplesKt.to((Object)"\u00c3\u00e3", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.LITHUANIAN, Language.POLISH};
        objectArray[1] = TuplesKt.to((Object)"\u0104\u0105\u0118\u0119", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.POLISH, Language.ROMANIAN};
        objectArray[2] = TuplesKt.to((Object)"\u017b\u017c", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.FRENCH, Language.ROMANIAN};
        objectArray[3] = TuplesKt.to((Object)"\u00ce\u00ee", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.BASQUE, Language.SPANISH};
        objectArray[4] = TuplesKt.to((Object)"\u00d1\u00f1", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.CZECH, Language.SLOVAK};
        objectArray[5] = TuplesKt.to((Object)"\u0147\u0148\u0164\u0165", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.ROMANIAN, Language.VIETNAMESE};
        objectArray[6] = TuplesKt.to((Object)"\u0102\u0103", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.AZERBAIJANI, Language.TURKISH};
        objectArray[7] = TuplesKt.to((Object)"\u0130\u0131\u011e\u011f", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.MACEDONIAN, Language.SERBIAN};
        objectArray[8] = TuplesKt.to((Object)"\u0408\u0458\u0409\u0459\u040a\u045a", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.VIETNAMESE, Language.YORUBA};
        objectArray[9] = TuplesKt.to((Object)"\u1eb8\u1eb9\u1ecc\u1ecd", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.ICELANDIC, Language.TURKISH};
        objectArray[10] = TuplesKt.to((Object)"\u00d0\u00f0\u00de\u00fe", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.FRENCH, Language.HUNGARIAN};
        objectArray[11] = TuplesKt.to((Object)"\u00db\u00fb", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.MAORI, Language.YORUBA};
        objectArray[12] = TuplesKt.to((Object)"\u014c\u014d", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.LATVIAN, Language.MAORI, Language.YORUBA};
        objectArray[13] = TuplesKt.to((Object)"\u0100\u0101\u0112\u0113\u012a\u012b", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.AZERBAIJANI, Language.ROMANIAN, Language.TURKISH};
        objectArray[14] = TuplesKt.to((Object)"\u015e\u015f", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.CZECH, Language.ROMANIAN, Language.SLOVAK};
        objectArray[15] = TuplesKt.to((Object)"\u010e\u010f", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.BOSNIAN, Language.CROATIAN, Language.POLISH};
        objectArray[16] = TuplesKt.to((Object)"\u0106\u0107", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.BOSNIAN, Language.CROATIAN, Language.VIETNAMESE};
        objectArray[17] = TuplesKt.to((Object)"\u0110\u0111", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.BELARUSIAN, Language.KAZAKH, Language.UKRAINIAN};
        objectArray[18] = TuplesKt.to((Object)"\u0406\u0456", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.ITALIAN, Language.VIETNAMESE, Language.YORUBA};
        objectArray[19] = TuplesKt.to((Object)"\u00cc\u00ec", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.BOKMAL, Language.DANISH, Language.NYNORSK};
        objectArray[20] = TuplesKt.to((Object)"\u00d8\u00f8", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.LATVIAN, Language.LITHUANIAN, Language.MAORI, Language.YORUBA};
        objectArray[21] = TuplesKt.to((Object)"\u016a\u016b", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.AFRIKAANS, Language.ALBANIAN, Language.DUTCH, Language.FRENCH};
        objectArray[22] = TuplesKt.to((Object)"\u00cb\u00eb", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.FRENCH, Language.ITALIAN, Language.VIETNAMESE, Language.YORUBA};
        objectArray[23] = TuplesKt.to((Object)"\u00c8\u00e8\u00d9\u00f9", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.AFRIKAANS, Language.FRENCH, Language.PORTUGUESE, Language.VIETNAMESE};
        objectArray[24] = TuplesKt.to((Object)"\u00ca\u00ea", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.ESTONIAN, Language.HUNGARIAN, Language.PORTUGUESE, Language.VIETNAMESE};
        objectArray[25] = TuplesKt.to((Object)"\u00d5\u00f5", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.FRENCH, Language.PORTUGUESE, Language.SLOVAK, Language.VIETNAMESE};
        objectArray[26] = TuplesKt.to((Object)"\u00d4\u00f4", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.BELARUSIAN, Language.KAZAKH, Language.MONGOLIAN, Language.RUSSIAN};
        objectArray[27] = TuplesKt.to((Object)"\u0401\u0451\u042b\u044b\u042d\u044d", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.BULGARIAN, Language.KAZAKH, Language.MONGOLIAN, Language.RUSSIAN};
        objectArray[28] = TuplesKt.to((Object)"\u0429\u0449\u042a\u044a", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.CATALAN, Language.ITALIAN, Language.VIETNAMESE, Language.YORUBA};
        objectArray[29] = TuplesKt.to((Object)"\u00d2\u00f2", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.BOKMAL, Language.DANISH, Language.ICELANDIC, Language.NYNORSK};
        objectArray[30] = TuplesKt.to((Object)"\u00c6\u00e6", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.BOKMAL, Language.DANISH, Language.NYNORSK, Language.SWEDISH};
        objectArray[31] = TuplesKt.to((Object)"\u00c5\u00e5", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.CZECH, Language.ICELANDIC, Language.SLOVAK, Language.TURKISH, Language.VIETNAMESE};
        objectArray[32] = TuplesKt.to((Object)"\u00dd\u00fd", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.ESTONIAN, Language.FINNISH, Language.GERMAN, Language.SLOVAK, Language.SWEDISH};
        objectArray[33] = TuplesKt.to((Object)"\u00c4\u00e4", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.CATALAN, Language.FRENCH, Language.ITALIAN, Language.PORTUGUESE, Language.VIETNAMESE};
        objectArray[34] = TuplesKt.to((Object)"\u00c0\u00e0", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.FRENCH, Language.PORTUGUESE, Language.ROMANIAN, Language.TURKISH, Language.VIETNAMESE};
        objectArray[35] = TuplesKt.to((Object)"\u00c2\u00e2", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.AZERBAIJANI, Language.CATALAN, Language.ESTONIAN, Language.GERMAN, Language.HUNGARIAN, Language.SPANISH, Language.TURKISH};
        objectArray[36] = TuplesKt.to((Object)"\u00dc\u00fc", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.BOSNIAN, Language.CZECH, Language.CROATIAN, Language.LATVIAN, Language.LITHUANIAN, Language.SLOVAK, Language.SLOVENE};
        objectArray[37] = TuplesKt.to((Object)"\u010c\u010d\u0160\u0161\u017d\u017e", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.ALBANIAN, Language.AZERBAIJANI, Language.BASQUE, Language.CATALAN, Language.FRENCH, Language.PORTUGUESE, Language.TURKISH};
        objectArray[38] = TuplesKt.to((Object)"\u00c7\u00e7", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.AZERBAIJANI, Language.ESTONIAN, Language.FINNISH, Language.GERMAN, Language.HUNGARIAN, Language.ICELANDIC, Language.SWEDISH, Language.TURKISH};
        objectArray[39] = TuplesKt.to((Object)"\u00d6\u00f6", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.CATALAN, Language.HUNGARIAN, Language.ICELANDIC, Language.IRISH, Language.POLISH, Language.PORTUGUESE, Language.SLOVAK, Language.SPANISH, Language.VIETNAMESE, Language.YORUBA};
        objectArray[40] = TuplesKt.to((Object)"\u00d3\u00f3", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.CATALAN, Language.CZECH, Language.ICELANDIC, Language.IRISH, Language.HUNGARIAN, Language.PORTUGUESE, Language.SLOVAK, Language.SPANISH, Language.VIETNAMESE, Language.YORUBA};
        objectArray[41] = TuplesKt.to((Object)"\u00c1\u00e1\u00cd\u00ed\u00da\u00fa", (Object)SetsKt.setOf((Object[])languageArray));
        languageArray = new Language[]{Language.CATALAN, Language.CZECH, Language.FRENCH, Language.HUNGARIAN, Language.ICELANDIC, Language.IRISH, Language.ITALIAN, Language.PORTUGUESE, Language.SLOVAK, Language.SPANISH, Language.VIETNAMESE, Language.YORUBA};
        objectArray[42] = TuplesKt.to((Object)"\u00c9\u00e9", (Object)SetsKt.setOf((Object[])languageArray));
        CHARS_TO_LANGUAGES_MAPPING = MapsKt.mapOf((Pair[])objectArray);
        objectArray = new Language[]{Language.CHINESE, Language.JAPANESE, Language.KOREAN};
        LANGUAGES_SUPPORTING_LOGOGRAMS = SetsKt.setOf((Object[])objectArray);
        MULTIPLE_WHITESPACE = new Regex("\\s+");
        NO_LETTER = new Regex("^[^\\p{L}]+$");
        NUMBERS = new Regex("\\p{N}");
        PUNCTUATION = new Regex("\\p{P}");
    }
}

