/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.internal;

import com.github.pemistahl.lingua.internal.NgramRange;
import com.github.pemistahl.lingua.internal.NgramSerializer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=NgramSerializer.class)
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0081\b\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0000H\u0096\u0002J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\t\u0010\f\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\t\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\bH\u00d6\u0001J\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/github/pemistahl/lingua/internal/Ngram;", "", "value", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/String;", "compareTo", "", "other", "component1", "copy", "dec", "equals", "", "", "hashCode", "rangeOfLowerOrderNgrams", "Lcom/github/pemistahl/lingua/internal/NgramRange;", "toString", "Companion", "lingua"})
public final class Ngram
implements Comparable<Ngram> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String value;

    public Ngram(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
        int n = this.value.length();
        if (!(0 <= n ? n < 6 : false)) {
            boolean bl = false;
            String string = "length of ngram '" + this.getValue() + "' is not in range 0..5";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getValue() {
        return this.value;
    }

    @NotNull
    public String toString() {
        return this.value;
    }

    @Override
    public int compareTo(@NotNull Ngram other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.length() > other.value.length() ? 1 : (this.value.length() < other.value.length() ? -1 : 0);
    }

    @NotNull
    public final NgramRange rangeOfLowerOrderNgrams() {
        return new NgramRange(this, new Ngram(String.valueOf(this.value.charAt(0))));
    }

    @NotNull
    public final Ngram dec() {
        Ngram ngram;
        if (this.value.length() > 1) {
            String string = this.value.substring(0, this.value.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Ngram ngram2 = new Ngram(string);
            ngram = ngram2;
        } else if (this.value.length() == 1) {
            ngram = new Ngram("");
        } else {
            throw new IllegalStateException("Zerogram is ngram type of lowest order and can not be decremented");
        }
        return ngram;
    }

    @NotNull
    public final String component1() {
        return this.value;
    }

    @NotNull
    public final Ngram copy(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return new Ngram(value);
    }

    public static /* synthetic */ Ngram copy$default(Ngram ngram, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = ngram.value;
        }
        return ngram.copy(string);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Ngram)) {
            return false;
        }
        Ngram ngram = (Ngram)other;
        return Intrinsics.areEqual((Object)this.value, (Object)ngram.value);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u00c6\u0001\u00a8\u0006\n"}, d2={"Lcom/github/pemistahl/lingua/internal/Ngram$Companion;", "", "()V", "getNgramNameByLength", "", "ngramLength", "", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/github/pemistahl/lingua/internal/Ngram;", "lingua"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getNgramNameByLength(int ngramLength) {
            String string;
            switch (ngramLength) {
                case 1: {
                    string = "unigram";
                    break;
                }
                case 2: {
                    string = "bigram";
                    break;
                }
                case 3: {
                    string = "trigram";
                    break;
                }
                case 4: {
                    string = "quadrigram";
                    break;
                }
                case 5: {
                    string = "fivegram";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("ngram length " + ngramLength + " is not in range 1..5");
                }
            }
            return string;
        }

        @NotNull
        public final KSerializer<Ngram> serializer() {
            return NgramSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

