/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.internal;

import com.github.pemistahl.lingua.internal.Ngram;
import com.github.pemistahl.lingua.internal.NgramIterator;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.ClosedRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\t\u0010\n\u001a\u00020\u0002H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0002H\u00c6\u0003J\u0011\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0096\u0002J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u0002H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\r2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u000f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0016H\u0096\u0002J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/github/pemistahl/lingua/internal/NgramRange;", "Lkotlin/ranges/ClosedRange;", "Lcom/github/pemistahl/lingua/internal/Ngram;", "", "start", "endInclusive", "(Lcom/github/pemistahl/lingua/internal/Ngram;Lcom/github/pemistahl/lingua/internal/Ngram;)V", "getEndInclusive", "()Lcom/github/pemistahl/lingua/internal/Ngram;", "getStart", "component1", "component2", "contains", "", "value", "copy", "equals", "other", "", "hashCode", "", "iterator", "", "toString", "", "lingua"})
public final class NgramRange
implements ClosedRange<Ngram>,
Iterable<Ngram>,
KMappedMarker {
    @NotNull
    private final Ngram start;
    @NotNull
    private final Ngram endInclusive;

    public NgramRange(@NotNull Ngram start, @NotNull Ngram endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        this.start = start;
        this.endInclusive = endInclusive;
        if (!(this.getStart().compareTo(this.getEndInclusive()) >= 0)) {
            boolean bl = false;
            String string = "" + '\'' + this.getStart() + "' must be of higher order than '" + this.getEndInclusive() + '\'';
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public Ngram getStart() {
        return this.start;
    }

    @NotNull
    public Ngram getEndInclusive() {
        return this.endInclusive;
    }

    public boolean contains(@NotNull Ngram value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Ngram ngram = this.getEndInclusive();
        return value.compareTo((Object)this.getStart()) <= 0 ? 0 <= value.compareTo((Object)ngram) : false;
    }

    @Override
    @NotNull
    public Iterator<Ngram> iterator() {
        return new NgramIterator(this.getStart());
    }

    public boolean isEmpty() {
        return ClosedRange.DefaultImpls.isEmpty((ClosedRange)this);
    }

    @NotNull
    public final Ngram component1() {
        return this.getStart();
    }

    @NotNull
    public final Ngram component2() {
        return this.getEndInclusive();
    }

    @NotNull
    public final NgramRange copy(@NotNull Ngram start, @NotNull Ngram endInclusive) {
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        return new NgramRange(start, endInclusive);
    }

    public static /* synthetic */ NgramRange copy$default(NgramRange ngramRange, Ngram ngram, Ngram ngram2, int n, Object object) {
        if ((n & 1) != 0) {
            ngram = ngramRange.getStart();
        }
        if ((n & 2) != 0) {
            ngram2 = ngramRange.getEndInclusive();
        }
        return ngramRange.copy(ngram, ngram2);
    }

    @NotNull
    public String toString() {
        return "NgramRange(start=" + this.getStart() + ", endInclusive=" + this.getEndInclusive() + ')';
    }

    public int hashCode() {
        int result = this.getStart().hashCode();
        result = result * 31 + this.getEndInclusive().hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NgramRange)) {
            return false;
        }
        NgramRange ngramRange = (NgramRange)other;
        if (!Intrinsics.areEqual((Object)this.getStart(), (Object)ngramRange.getStart())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getEndInclusive(), (Object)ngramRange.getEndInclusive());
    }
}

