/*
 * Decompiled with CFR 0.152.
 */
package com.github.pemistahl.lingua.internal;

import com.github.pemistahl.lingua.api.Language;
import com.github.pemistahl.lingua.internal.Fraction;
import com.github.pemistahl.lingua.internal.JsonLanguageModel;
import com.github.pemistahl.lingua.internal.Ngram;
import com.github.pemistahl.lingua.internal.util.extension.MapExtensionsKt;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KType;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0080\b\u0018\u0000 #2\u00020\u0001:\u0001#BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J\u0015\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0003JO\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u00052\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006J\t\u0010 \u001a\u00020\u0007H\u00d6\u0001J\u0006\u0010!\u001a\u00020\fJ\t\u0010\"\u001a\u00020\fH\u00d6\u0001R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000f\u00a8\u0006$"}, d2={"Lcom/github/pemistahl/lingua/internal/TrainingDataLanguageModel;", "", "language", "Lcom/github/pemistahl/lingua/api/Language;", "absoluteFrequencies", "", "Lcom/github/pemistahl/lingua/internal/Ngram;", "", "relativeFrequencies", "Lcom/github/pemistahl/lingua/internal/Fraction;", "jsonRelativeFrequencies", "Lit/unimi/dsi/fastutil/objects/Object2DoubleMap;", "", "(Lcom/github/pemistahl/lingua/api/Language;Ljava/util/Map;Ljava/util/Map;Lit/unimi/dsi/fastutil/objects/Object2DoubleMap;)V", "getAbsoluteFrequencies", "()Ljava/util/Map;", "getJsonRelativeFrequencies", "()Lit/unimi/dsi/fastutil/objects/Object2DoubleMap;", "getLanguage", "()Lcom/github/pemistahl/lingua/api/Language;", "getRelativeFrequencies", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getRelativeFrequency", "", "ngram", "hashCode", "toJson", "toString", "Companion", "lingua"})
public final class TrainingDataLanguageModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Language language;
    @NotNull
    private final Map<Ngram, Integer> absoluteFrequencies;
    @NotNull
    private final Map<Ngram, Fraction> relativeFrequencies;
    @NotNull
    private final Object2DoubleMap<String> jsonRelativeFrequencies;

    public TrainingDataLanguageModel(@NotNull Language language, @NotNull Map<Ngram, Integer> absoluteFrequencies, @NotNull Map<Ngram, Fraction> relativeFrequencies, @NotNull Object2DoubleMap<String> jsonRelativeFrequencies) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter(absoluteFrequencies, (String)"absoluteFrequencies");
        Intrinsics.checkNotNullParameter(relativeFrequencies, (String)"relativeFrequencies");
        Intrinsics.checkNotNullParameter(jsonRelativeFrequencies, (String)"jsonRelativeFrequencies");
        this.language = language;
        this.absoluteFrequencies = absoluteFrequencies;
        this.relativeFrequencies = relativeFrequencies;
        this.jsonRelativeFrequencies = jsonRelativeFrequencies;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final Map<Ngram, Integer> getAbsoluteFrequencies() {
        return this.absoluteFrequencies;
    }

    @NotNull
    public final Map<Ngram, Fraction> getRelativeFrequencies() {
        return this.relativeFrequencies;
    }

    @NotNull
    public final Object2DoubleMap<String> getJsonRelativeFrequencies() {
        return this.jsonRelativeFrequencies;
    }

    public final double getRelativeFrequency(@NotNull Ngram ngram) {
        Intrinsics.checkNotNullParameter((Object)ngram, (String)"ngram");
        return this.jsonRelativeFrequencies.getDouble((Object)ngram.getValue());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String toJson() {
        void $this$mapValuesTo$iv$iv;
        Object fraction;
        Map ngrams = new LinkedHashMap();
        for (Map.Entry<Ngram, Fraction> object2 : this.relativeFrequencies.entrySet()) {
            Ngram ngram = object2.getKey();
            fraction = object2.getValue();
            ngrams.computeIfAbsent(fraction, TrainingDataLanguageModel::toJson$lambda-0).add(ngram);
        }
        Map map = ngrams;
        Language language = this.language;
        boolean $i$f$mapValues = false;
        fraction = map;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)map.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            String string = CollectionsKt.joinToString$default((Iterable)((Iterable)it.getValue()), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            map3.put(k, string);
        }
        Map map4 = destination$iv$iv;
        Language language2 = language;
        JsonLanguageModel jsonLanguageModel = new JsonLanguageModel(language2, map4);
        StringFormat stringFormat = (StringFormat)Json.Default;
        boolean $i$f$encodeToString = false;
        SerializersModule $this$serializer$iv$iv = stringFormat.getSerializersModule();
        boolean $i$f$serializer = false;
        KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonLanguageModel.class));
        boolean $i$f$cast = false;
        return stringFormat.encodeToString((SerializationStrategy)$this$cast$iv$iv$iv, (Object)jsonLanguageModel);
    }

    @NotNull
    public final Language component1() {
        return this.language;
    }

    @NotNull
    public final Map<Ngram, Integer> component2() {
        return this.absoluteFrequencies;
    }

    @NotNull
    public final Map<Ngram, Fraction> component3() {
        return this.relativeFrequencies;
    }

    @NotNull
    public final Object2DoubleMap<String> component4() {
        return this.jsonRelativeFrequencies;
    }

    @NotNull
    public final TrainingDataLanguageModel copy(@NotNull Language language, @NotNull Map<Ngram, Integer> absoluteFrequencies, @NotNull Map<Ngram, Fraction> relativeFrequencies, @NotNull Object2DoubleMap<String> jsonRelativeFrequencies) {
        Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
        Intrinsics.checkNotNullParameter(absoluteFrequencies, (String)"absoluteFrequencies");
        Intrinsics.checkNotNullParameter(relativeFrequencies, (String)"relativeFrequencies");
        Intrinsics.checkNotNullParameter(jsonRelativeFrequencies, (String)"jsonRelativeFrequencies");
        return new TrainingDataLanguageModel(language, absoluteFrequencies, relativeFrequencies, jsonRelativeFrequencies);
    }

    public static /* synthetic */ TrainingDataLanguageModel copy$default(TrainingDataLanguageModel trainingDataLanguageModel, Language language, Map map, Map map2, Object2DoubleMap object2DoubleMap, int n, Object object) {
        if ((n & 1) != 0) {
            language = trainingDataLanguageModel.language;
        }
        if ((n & 2) != 0) {
            map = trainingDataLanguageModel.absoluteFrequencies;
        }
        if ((n & 4) != 0) {
            map2 = trainingDataLanguageModel.relativeFrequencies;
        }
        if ((n & 8) != 0) {
            object2DoubleMap = trainingDataLanguageModel.jsonRelativeFrequencies;
        }
        return trainingDataLanguageModel.copy(language, map, map2, object2DoubleMap);
    }

    @NotNull
    public String toString() {
        return "TrainingDataLanguageModel(language=" + (Object)((Object)this.language) + ", absoluteFrequencies=" + this.absoluteFrequencies + ", relativeFrequencies=" + this.relativeFrequencies + ", jsonRelativeFrequencies=" + this.jsonRelativeFrequencies + ')';
    }

    public int hashCode() {
        int result = this.language.hashCode();
        result = result * 31 + ((Object)this.absoluteFrequencies).hashCode();
        result = result * 31 + ((Object)this.relativeFrequencies).hashCode();
        result = result * 31 + this.jsonRelativeFrequencies.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TrainingDataLanguageModel)) {
            return false;
        }
        TrainingDataLanguageModel trainingDataLanguageModel = (TrainingDataLanguageModel)other;
        if (this.language != trainingDataLanguageModel.language) {
            return false;
        }
        if (!Intrinsics.areEqual(this.absoluteFrequencies, trainingDataLanguageModel.absoluteFrequencies)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.relativeFrequencies, trainingDataLanguageModel.relativeFrequencies)) {
            return false;
        }
        return Intrinsics.areEqual(this.jsonRelativeFrequencies, trainingDataLanguageModel.jsonRelativeFrequencies);
    }

    private static final List toJson$lambda-0(Fraction it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new ArrayList();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\tH\u0002JD\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\r0\u00042\u0006\u0010\n\u001a\u00020\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ@\u0010\u0013\u001a\u00020\u00112\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a8\u0006\u0016"}, d2={"Lcom/github/pemistahl/lingua/internal/TrainingDataLanguageModel$Companion;", "", "()V", "computeAbsoluteFrequencies", "", "Lcom/github/pemistahl/lingua/internal/Ngram;", "", "text", "Lkotlin/sequences/Sequence;", "", "ngramLength", "charClass", "computeRelativeFrequencies", "Lcom/github/pemistahl/lingua/internal/Fraction;", "absoluteFrequencies", "lowerNgramAbsoluteFrequencies", "fromJson", "Lcom/github/pemistahl/lingua/internal/TrainingDataLanguageModel;", "json", "fromText", "language", "Lcom/github/pemistahl/lingua/api/Language;", "lingua"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TrainingDataLanguageModel fromText(@NotNull Sequence<String> text, @NotNull Language language, int ngramLength, @NotNull String charClass, @NotNull Map<Ngram, Integer> lowerNgramAbsoluteFrequencies) {
            Intrinsics.checkNotNullParameter(text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)((Object)language), (String)"language");
            Intrinsics.checkNotNullParameter((Object)charClass, (String)"charClass");
            Intrinsics.checkNotNullParameter(lowerNgramAbsoluteFrequencies, (String)"lowerNgramAbsoluteFrequencies");
            if (!(1 <= ngramLength ? ngramLength < 6 : false)) {
                boolean $i$a$-require-TrainingDataLanguageModel$Companion$fromText$22 = false;
                String $i$a$-require-TrainingDataLanguageModel$Companion$fromText$22 = "ngram length " + ngramLength + " is not in range 1..5";
                throw new IllegalArgumentException($i$a$-require-TrainingDataLanguageModel$Companion$fromText$22.toString());
            }
            Map<Ngram, Integer> absoluteFrequencies = this.computeAbsoluteFrequencies(text, ngramLength, charClass);
            Map<Ngram, Fraction> relativeFrequencies = this.computeRelativeFrequencies(ngramLength, absoluteFrequencies, lowerNgramAbsoluteFrequencies);
            return new TrainingDataLanguageModel(language, absoluteFrequencies, relativeFrequencies, (Object2DoubleMap<String>)((Object2DoubleMap)new Object2DoubleOpenHashMap()));
        }

        @NotNull
        public final TrainingDataLanguageModel fromJson(@NotNull String json) {
            Intrinsics.checkNotNullParameter((Object)json, (String)"json");
            StringFormat $this$decodeFromString$iv = (StringFormat)Json.Default;
            boolean $i$f$decodeFromString = false;
            SerializersModule $this$serializer$iv$iv = $this$decodeFromString$iv.getSerializersModule();
            boolean $i$f$serializer = false;
            KSerializer $this$cast$iv$iv$iv = SerializersKt.serializer((SerializersModule)$this$serializer$iv$iv, (KType)Reflection.typeOf(JsonLanguageModel.class));
            boolean $i$f$cast = false;
            JsonLanguageModel jsonLanguageModel = (JsonLanguageModel)$this$decodeFromString$iv.decodeFromString((DeserializationStrategy)$this$cast$iv$iv$iv, json);
            Object2DoubleOpenHashMap jsonRelativeFrequencies = new Object2DoubleOpenHashMap();
            for (Map.Entry<Fraction, String> entry : jsonLanguageModel.getNgrams().entrySet()) {
                Fraction fraction = entry.getKey();
                String ngrams = entry.getValue();
                double fractionAsDouble = fraction.doubleValue();
                char[] cArray = new char[]{' '};
                for (String ngram : StringsKt.split$default((CharSequence)ngrams, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                    jsonRelativeFrequencies.put((Object)ngram, fractionAsDouble);
                }
            }
            jsonRelativeFrequencies.trim();
            return new TrainingDataLanguageModel(jsonLanguageModel.getLanguage(), MapsKt.emptyMap(), MapsKt.emptyMap(), (Object2DoubleMap<String>)((Object2DoubleMap)jsonRelativeFrequencies));
        }

        private final Map<Ngram, Integer> computeAbsoluteFrequencies(Sequence<String> text, int ngramLength, String charClass) {
            Map absoluteFrequencies = new LinkedHashMap();
            Regex regex = new Regex('[' + charClass + "]+");
            for (String line : text) {
                int i;
                String string = line.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                int n = 0;
                String lowerCasedLine = string;
                int n2 = lowerCasedLine.length() - ngramLength;
                if (n > n2) continue;
                do {
                    i = n++;
                    String string2 = lowerCasedLine;
                    int n3 = i + ngramLength;
                    String string3 = string2.substring(i, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    String textSlice = string3;
                    if (!regex.matches((CharSequence)textSlice)) continue;
                    Ngram ngram = new Ngram(textSlice);
                    MapExtensionsKt.incrementCounter(absoluteFrequencies, ngram);
                } while (i != n2);
            }
            return absoluteFrequencies;
        }

        private final Map<Ngram, Fraction> computeRelativeFrequencies(int ngramLength, Map<Ngram, Integer> absoluteFrequencies, Map<Ngram, Integer> lowerNgramAbsoluteFrequencies) {
            Map ngramProbabilities = new LinkedHashMap();
            int totalNgramFrequency = CollectionsKt.sumOfInt((Iterable)absoluteFrequencies.values());
            for (Map.Entry<Ngram, Integer> entry : absoluteFrequencies.entrySet()) {
                Object object;
                int n;
                Ngram ngram = entry.getKey();
                int frequency = ((Number)entry.getValue()).intValue();
                if (ngramLength == 1 || lowerNgramAbsoluteFrequencies.isEmpty()) {
                    n = totalNgramFrequency;
                } else {
                    object = ngram.getValue();
                    int n2 = 0;
                    int n3 = ngramLength - 1;
                    String string = ((String)object).substring(n2, n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    n = ((Number)MapsKt.getValue(lowerNgramAbsoluteFrequencies, (Object)new Ngram(string))).intValue();
                }
                int denominator = n;
                object = ngramProbabilities;
                Fraction fraction = new Fraction(frequency, denominator);
                object.put(ngram, fraction);
            }
            return ngramProbabilities;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

