/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.decode;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.github.penfeizhou.animation.decode.Frame;
import com.github.penfeizhou.animation.executor.FrameDecoderExecutor;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.io.Writer;
import com.github.penfeizhou.animation.loader.Loader;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

public abstract class FrameSeqDecoder<R extends Reader, W extends Writer> {
    private static final String TAG = FrameSeqDecoder.class.getSimpleName();
    private final int taskId;
    private final Loader mLoader;
    private final Handler workerHandler;
    protected List<Frame<R, W>> frames = new ArrayList<Frame<R, W>>();
    protected int frameIndex = -1;
    protected static final double MB = 1048576.0;
    private int playCount;
    private Integer loopLimit = null;
    private final Set<RenderListener> renderListeners = new HashSet<RenderListener>();
    private final AtomicBoolean paused = new AtomicBoolean(true);
    private static final Rect RECT_EMPTY = new Rect();
    private final Runnable renderTask = new Runnable(){

        @Override
        public void run() {
            if (FrameSeqDecoder.this.paused.get()) {
                return;
            }
            if (FrameSeqDecoder.this.canStep()) {
                long start = System.currentTimeMillis();
                long delay = FrameSeqDecoder.this.step();
                long cost = System.currentTimeMillis() - start;
                FrameSeqDecoder.this.workerHandler.removeCallbacks(FrameSeqDecoder.this.renderTask);
                FrameSeqDecoder.this.workerHandler.postDelayed((Runnable)this, Math.max(0L, delay - cost));
                for (RenderListener renderListener : FrameSeqDecoder.this.renderListeners) {
                    if (FrameSeqDecoder.this.frameBuffer == null) continue;
                    renderListener.onRender(FrameSeqDecoder.this.frameBuffer);
                }
            } else {
                FrameSeqDecoder.this.stop();
            }
        }
    };
    protected int sampleSize = 1;
    private final Set<Bitmap> cacheBitmaps = new HashSet<Bitmap>();
    private final Object cacheBitmapsLock = new Object();
    protected Map<Bitmap, Canvas> cachedCanvas = new WeakHashMap<Bitmap, Canvas>();
    protected ByteBuffer frameBuffer;
    protected volatile Rect fullRect;
    private W mWriter = this.getWriter();
    private R mReader = null;
    public static final boolean DEBUG = false;
    private boolean finished = false;
    private volatile State mState = State.IDLE;

    protected abstract W getWriter();

    protected abstract R getReader(Reader var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Bitmap obtainBitmap(int width, int height) {
        Object object = this.cacheBitmapsLock;
        synchronized (object) {
            Bitmap ret = null;
            Iterator<Bitmap> iterator = this.cacheBitmaps.iterator();
            while (iterator.hasNext()) {
                int reuseSize = width * height * 4;
                ret = iterator.next();
                if (Build.VERSION.SDK_INT >= 19) {
                    if (ret == null || ret.getAllocationByteCount() < reuseSize) continue;
                    iterator.remove();
                    if ((ret.getWidth() != width || ret.getHeight() != height) && width > 0 && height > 0) {
                        ret.reconfigure(width, height, Bitmap.Config.ARGB_8888);
                    }
                    ret.eraseColor(0);
                    return ret;
                }
                if (ret == null || ret.getByteCount() < reuseSize) continue;
                if (ret.getWidth() == width && ret.getHeight() == height) {
                    iterator.remove();
                    ret.eraseColor(0);
                }
                return ret;
            }
            if (width <= 0 || height <= 0) {
                return null;
            }
            try {
                Bitmap.Config config = Bitmap.Config.ARGB_8888;
                ret = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recycleBitmap(Bitmap bitmap) {
        Object object = this.cacheBitmapsLock;
        synchronized (object) {
            if (bitmap != null) {
                this.cacheBitmaps.add(bitmap);
            }
        }
    }

    public FrameSeqDecoder(Loader loader, @Nullable RenderListener renderListener) {
        this.mLoader = loader;
        if (renderListener != null) {
            this.renderListeners.add(renderListener);
        }
        this.taskId = FrameDecoderExecutor.getInstance().generateTaskId();
        this.workerHandler = new Handler(FrameDecoderExecutor.getInstance().getLooper(this.taskId));
    }

    public void addRenderListener(final RenderListener renderListener) {
        this.workerHandler.post(new Runnable(){

            @Override
            public void run() {
                FrameSeqDecoder.this.renderListeners.add(renderListener);
            }
        });
    }

    public void removeRenderListener(final RenderListener renderListener) {
        this.workerHandler.post(new Runnable(){

            @Override
            public void run() {
                FrameSeqDecoder.this.renderListeners.remove(renderListener);
            }
        });
    }

    public void stopIfNeeded() {
        this.workerHandler.post(new Runnable(){

            @Override
            public void run() {
                if (FrameSeqDecoder.this.renderListeners.size() == 0) {
                    FrameSeqDecoder.this.stop();
                }
            }
        });
    }

    public Rect getBounds() {
        if (this.fullRect == null) {
            if (this.mState == State.FINISHING) {
                Log.e((String)TAG, (String)"In finishing,do not interrupt");
            }
            final Thread thread = Thread.currentThread();
            this.workerHandler.post(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (FrameSeqDecoder.this.fullRect == null) {
                            if (FrameSeqDecoder.this.mReader == null) {
                                FrameSeqDecoder.this.mReader = FrameSeqDecoder.this.getReader(FrameSeqDecoder.this.mLoader.obtain());
                            } else {
                                FrameSeqDecoder.this.mReader.reset();
                            }
                            FrameSeqDecoder.this.initCanvasBounds(FrameSeqDecoder.this.read(FrameSeqDecoder.this.mReader));
                        }
                    }
                    catch (Exception | OutOfMemoryError e) {
                        e.printStackTrace();
                        FrameSeqDecoder.this.fullRect = RECT_EMPTY;
                    }
                    finally {
                        LockSupport.unpark(thread);
                    }
                }
            });
            LockSupport.park(thread);
        }
        return this.fullRect == null ? RECT_EMPTY : this.fullRect;
    }

    private void initCanvasBounds(Rect rect) {
        this.fullRect = rect;
        long bufferSize = ((long)rect.width() * (long)rect.height() / ((long)this.sampleSize * (long)this.sampleSize) + 1L) * 4L;
        try {
            this.frameBuffer = ByteBuffer.allocate((int)bufferSize);
            if (this.mWriter == null) {
                this.mWriter = this.getWriter();
            }
        }
        catch (OutOfMemoryError error) {
            Log.e((String)TAG, (String)String.format("OutOfMemoryError in FrameSeqDecoder: Buffer needed: %.2fMB (%,d bytes)", (double)bufferSize / 1048576.0, bufferSize));
            this.frameBuffer = null;
            this.fullRect = RECT_EMPTY;
            throw error;
        }
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public int getFrameIndex() {
        return this.frameIndex;
    }

    protected abstract int getLoopCount();

    public void start() {
        if (this.fullRect == RECT_EMPTY) {
            return;
        }
        if (this.mState == State.RUNNING || this.mState == State.INITIALIZING) {
            Log.i((String)TAG, (String)(this.debugInfo() + " Already started"));
            return;
        }
        if (this.mState == State.FINISHING) {
            Log.e((String)TAG, (String)(this.debugInfo() + " Processing,wait for finish at " + (Object)((Object)this.mState)));
        }
        this.mState = State.INITIALIZING;
        if (Looper.myLooper() == this.workerHandler.getLooper()) {
            this.innerStart();
        } else {
            this.workerHandler.post(new Runnable(){

                @Override
                public void run() {
                    FrameSeqDecoder.this.innerStart();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void innerStart() {
        this.paused.compareAndSet(true, false);
        long start = System.currentTimeMillis();
        try {
            if (this.getFrameCount() == 0) {
                try {
                    if (this.mReader == null) {
                        this.mReader = this.getReader(this.mLoader.obtain());
                    } else {
                        this.mReader.reset();
                    }
                    this.initCanvasBounds(this.read(this.mReader));
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            Log.i((String)TAG, (String)(this.debugInfo() + " Set state to RUNNING,cost " + (System.currentTimeMillis() - start)));
            this.mState = State.RUNNING;
        }
        if (this.getNumPlays() == 0 || !this.finished) {
            this.frameIndex = -1;
            this.workerHandler.removeCallbacks(this.renderTask);
            this.renderTask.run();
            for (RenderListener renderListener : this.renderListeners) {
                renderListener.onStart();
            }
        } else {
            Log.i((String)TAG, (String)(this.debugInfo() + " No need to started"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void innerStop() {
        this.workerHandler.removeCallbacks(this.renderTask);
        this.frames.clear();
        Iterator<RenderListener> iterator = this.cacheBitmapsLock;
        synchronized (iterator) {
            for (Bitmap bitmap : this.cacheBitmaps) {
                if (bitmap == null || bitmap.isRecycled()) continue;
                bitmap.recycle();
            }
            this.cacheBitmaps.clear();
        }
        if (this.frameBuffer != null) {
            this.frameBuffer = null;
        }
        this.cachedCanvas.clear();
        try {
            if (this.mReader != null) {
                this.mReader.close();
                this.mReader = null;
            }
            if (this.mWriter != null) {
                this.mWriter.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.release();
        this.mState = State.IDLE;
        for (RenderListener renderListener : this.renderListeners) {
            renderListener.onEnd();
        }
    }

    public void stop() {
        if (this.fullRect == RECT_EMPTY) {
            return;
        }
        if (this.mState == State.FINISHING || this.mState == State.IDLE) {
            Log.i((String)TAG, (String)(this.debugInfo() + "No need to stop"));
            return;
        }
        if (this.mState == State.INITIALIZING) {
            Log.e((String)TAG, (String)(this.debugInfo() + "Processing,wait for finish at " + (Object)((Object)this.mState)));
        }
        this.mState = State.FINISHING;
        if (Looper.myLooper() == this.workerHandler.getLooper()) {
            this.innerStop();
        } else {
            this.workerHandler.post(new Runnable(){

                @Override
                public void run() {
                    FrameSeqDecoder.this.innerStop();
                }
            });
        }
    }

    private String debugInfo() {
        return "";
    }

    protected abstract void release();

    public boolean isRunning() {
        return this.mState == State.RUNNING || this.mState == State.INITIALIZING;
    }

    public boolean isPaused() {
        return this.paused.get();
    }

    public void setLoopLimit(int limit) {
        this.loopLimit = limit;
    }

    public void reset() {
        this.workerHandler.post(new Runnable(){

            @Override
            public void run() {
                FrameSeqDecoder.this.playCount = 0;
                FrameSeqDecoder.this.frameIndex = -1;
                FrameSeqDecoder.this.finished = false;
            }
        });
    }

    public void pause() {
        this.workerHandler.removeCallbacks(this.renderTask);
        this.paused.compareAndSet(false, true);
    }

    public void resume() {
        this.paused.compareAndSet(true, false);
        this.workerHandler.removeCallbacks(this.renderTask);
        this.workerHandler.post(this.renderTask);
    }

    public int getSampleSize() {
        return this.sampleSize;
    }

    public int setDesiredSize(int width, int height) {
        final int sample = this.getDesiredSample(width, height);
        if (sample != this.getSampleSize()) {
            final boolean tempRunning = this.isRunning();
            this.workerHandler.removeCallbacks(this.renderTask);
            this.workerHandler.post(new Runnable(){

                @Override
                public void run() {
                    FrameSeqDecoder.this.innerStop();
                    try {
                        FrameSeqDecoder.this.sampleSize = sample;
                        FrameSeqDecoder.this.initCanvasBounds(FrameSeqDecoder.this.read(FrameSeqDecoder.this.getReader(FrameSeqDecoder.this.mLoader.obtain())));
                        if (tempRunning) {
                            FrameSeqDecoder.this.innerStart();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return sample;
    }

    protected int getDesiredSample(int desiredWidth, int desiredHeight) {
        if (desiredWidth == 0 || desiredHeight == 0) {
            return 1;
        }
        int radio = Math.min(this.getBounds().width() / desiredWidth, this.getBounds().height() / desiredHeight);
        int sample = 1;
        while (sample * 2 <= radio) {
            sample *= 2;
        }
        return sample;
    }

    protected abstract Rect read(R var1) throws IOException;

    private int getNumPlays() {
        return this.loopLimit != null ? this.loopLimit.intValue() : this.getLoopCount();
    }

    private boolean canStep() {
        if (!this.isRunning()) {
            return false;
        }
        if (this.getFrameCount() == 0) {
            return false;
        }
        if (this.getNumPlays() <= 0) {
            return true;
        }
        if (this.playCount < this.getNumPlays() - 1) {
            return true;
        }
        if (this.playCount == this.getNumPlays() - 1 && this.frameIndex < this.getFrameCount() - 1) {
            return true;
        }
        this.finished = true;
        return false;
    }

    @WorkerThread
    private long step() {
        Frame<R, W> frame;
        ++this.frameIndex;
        if (this.frameIndex >= this.getFrameCount()) {
            this.frameIndex = 0;
            ++this.playCount;
        }
        if ((frame = this.getFrame(this.frameIndex)) == null) {
            return 0L;
        }
        this.renderFrame(frame);
        return frame.frameDuration;
    }

    protected abstract void renderFrame(Frame<R, W> var1);

    public Frame<R, W> getFrame(int index) {
        if (index < 0 || index >= this.frames.size()) {
            return null;
        }
        return this.frames.get(index);
    }

    public Bitmap getFrameBitmap(int index) throws IOException {
        if (this.mState != State.IDLE) {
            Log.e((String)TAG, (String)(this.debugInfo() + ",stop first"));
            return null;
        }
        this.mState = State.RUNNING;
        this.paused.compareAndSet(true, false);
        if (this.frames.size() == 0) {
            if (this.mReader == null) {
                this.mReader = this.getReader(this.mLoader.obtain());
            } else {
                this.mReader.reset();
            }
            this.initCanvasBounds(this.read(this.mReader));
        }
        if (index < 0) {
            index += this.frames.size();
        }
        if (index < 0) {
            index = 0;
        }
        this.frameIndex = -1;
        while (this.frameIndex < index && this.canStep()) {
            this.step();
        }
        this.frameBuffer.rewind();
        Bitmap bitmap = Bitmap.createBitmap((int)(this.getBounds().width() / this.getSampleSize()), (int)(this.getBounds().height() / this.getSampleSize()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.copyPixelsFromBuffer((Buffer)this.frameBuffer);
        this.innerStop();
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMemorySize() {
        Object object = this.cacheBitmapsLock;
        synchronized (object) {
            int size = 0;
            for (Bitmap bitmap : this.cacheBitmaps) {
                if (bitmap.isRecycled()) continue;
                if (Build.VERSION.SDK_INT >= 19) {
                    size += bitmap.getAllocationByteCount();
                    continue;
                }
                size += bitmap.getByteCount();
            }
            if (this.frameBuffer != null) {
                size += this.frameBuffer.capacity();
            }
            return size;
        }
    }

    private static enum State {
        IDLE,
        RUNNING,
        INITIALIZING,
        FINISHING;

    }

    public static interface RenderListener {
        public void onStart();

        public void onRender(ByteBuffer var1);

        public void onEnd();
    }
}

