/*
 * Decompiled with CFR 0.152.
 */
package permissions.dispatcher.ktx;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import java.util.Arrays;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import permissions.dispatcher.PermissionUtils;
import permissions.dispatcher.ktx.PermissionRequestViewModel;
import permissions.dispatcher.ktx.PermissionResult;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0013\u0014B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0004\u00a2\u0006\u0002\u0010\u000eJ\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "Landroidx/fragment/app/Fragment;", "()V", "requestCode", "", "getRequestCode", "()I", "viewModel", "Lpermissions/dispatcher/ktx/PermissionRequestViewModel;", "getViewModel", "()Lpermissions/dispatcher/ktx/PermissionRequestViewModel;", "setViewModel", "(Lpermissions/dispatcher/ktx/PermissionRequestViewModel;)V", "dismiss", "()Ljava/lang/Integer;", "onAttach", "", "context", "Landroid/content/Context;", "NormalRequestPermissionFragment", "SpecialRequestPermissionFragment", "Lpermissions/dispatcher/ktx/PermissionRequestFragment$NormalRequestPermissionFragment;", "Lpermissions/dispatcher/ktx/PermissionRequestFragment$SpecialRequestPermissionFragment;", "ktx_release"})
public abstract class PermissionRequestFragment
extends Fragment {
    private final int requestCode = new Random().nextInt(1000);
    protected PermissionRequestViewModel viewModel;

    private PermissionRequestFragment() {
    }

    protected final int getRequestCode() {
        return this.requestCode;
    }

    @NotNull
    protected final PermissionRequestViewModel getViewModel() {
        PermissionRequestViewModel permissionRequestViewModel = this.viewModel;
        if (permissionRequestViewModel != null) {
            return permissionRequestViewModel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        throw null;
    }

    protected final void setViewModel(@NotNull PermissionRequestViewModel permissionRequestViewModel) {
        Intrinsics.checkNotNullParameter((Object)((Object)permissionRequestViewModel), (String)"<set-?>");
        this.viewModel = permissionRequestViewModel;
    }

    public void onAttach(@Nullable Context context) {
        super.onAttach(context);
        this.setRetainInstance(true);
        ViewModel viewModel = new ViewModelProvider((ViewModelStoreOwner)this.requireActivity()).get(PermissionRequestViewModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)viewModel, (String)"ViewModelProvider(requireActivity()).get(PermissionRequestViewModel::class.java)");
        this.setViewModel((PermissionRequestViewModel)viewModel);
    }

    @Nullable
    protected final Integer dismiss() {
        FragmentTransaction fragmentTransaction;
        FragmentTransaction fragmentTransaction2;
        FragmentManager fragmentManager = this.getFragmentManager();
        return fragmentManager == null ? null : ((fragmentTransaction2 = fragmentManager.beginTransaction()) == null ? null : ((fragmentTransaction = fragmentTransaction2.remove((Fragment)this)) == null ? null : Integer.valueOf(fragmentTransaction.commitAllowingStateLoss())));
    }

    public /* synthetic */ PermissionRequestFragment(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J+\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lpermissions/dispatcher/ktx/PermissionRequestFragment$NormalRequestPermissionFragment;", "Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "()V", "onCreate", "", "savedInstanceState", "Landroid/os/Bundle;", "onRequestPermissionsResult", "requestCode", "", "permissions", "", "", "grantResults", "", "(I[Ljava/lang/String;[I)V", "Companion", "ktx_release"})
    public static final class NormalRequestPermissionFragment
    extends PermissionRequestFragment {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String BUNDLE_PERMISSIONS_KEY = "key:permissions";

        public NormalRequestPermissionFragment() {
            super(null);
        }

        public void onCreate(@Nullable Bundle savedInstanceState) {
            String[] stringArray;
            String[] stringArray2;
            super.onCreate(savedInstanceState);
            Bundle bundle = this.getArguments();
            String[] stringArray3 = stringArray2 = bundle == null ? null : bundle.getStringArray(BUNDLE_PERMISSIONS_KEY);
            if (stringArray2 == null) {
                return;
            }
            String[] permissions = stringArray = stringArray2;
            this.requestPermissions(permissions, this.getRequestCode());
        }

        public void onRequestPermissionsResult(int requestCode, @NotNull String[] permissions, @NotNull int[] grantResults) {
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            Intrinsics.checkNotNullParameter((Object)grantResults, (String)"grantResults");
            super.onRequestPermissionsResult(requestCode, permissions, grantResults);
            if (requestCode == this.getRequestCode()) {
                Object[] objectArray = ArraysKt.sortedArray((Comparable[])((Comparable[])permissions));
                boolean bl = false;
                String string = Arrays.toString(objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.util.Arrays.toString(this)");
                String key = string;
                if (PermissionUtils.verifyPermissions((int[])Arrays.copyOf(grantResults, grantResults.length))) {
                    this.getViewModel().postPermissionRequestResult(key, PermissionResult.GRANTED);
                } else if (!PermissionUtils.shouldShowRequestPermissionRationale((Fragment)this, (String[])Arrays.copyOf(permissions, permissions.length))) {
                    this.getViewModel().postPermissionRequestResult(key, PermissionResult.DENIED_AND_DISABLED);
                } else {
                    this.getViewModel().postPermissionRequestResult(key, PermissionResult.DENIED);
                }
            }
            this.dismiss();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lpermissions/dispatcher/ktx/PermissionRequestFragment$NormalRequestPermissionFragment$Companion;", "", "()V", "BUNDLE_PERMISSIONS_KEY", "", "newInstance", "Lpermissions/dispatcher/ktx/PermissionRequestFragment$NormalRequestPermissionFragment;", "permissions", "", "([Ljava/lang/String;)Lpermissions/dispatcher/ktx/PermissionRequestFragment$NormalRequestPermissionFragment;", "ktx_release"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final NormalRequestPermissionFragment newInstance(@NotNull String[] permissions) {
                void $this$newInstance_u24lambda_u2d1_u24lambda_u2d0;
                Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
                NormalRequestPermissionFragment normalRequestPermissionFragment = new NormalRequestPermissionFragment();
                boolean bl = false;
                boolean bl2 = false;
                NormalRequestPermissionFragment $this$newInstance_u24lambda_u2d1 = normalRequestPermissionFragment;
                boolean bl3 = false;
                Bundle bundle = new Bundle();
                boolean bl4 = false;
                boolean bl5 = false;
                Bundle bundle2 = bundle;
                NormalRequestPermissionFragment normalRequestPermissionFragment2 = $this$newInstance_u24lambda_u2d1;
                boolean bl6 = false;
                $this$newInstance_u24lambda_u2d1_u24lambda_u2d0.putStringArray(NormalRequestPermissionFragment.BUNDLE_PERMISSIONS_KEY, permissions);
                Unit unit = Unit.INSTANCE;
                normalRequestPermissionFragment2.setArguments(bundle);
                return normalRequestPermissionFragment;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lpermissions/dispatcher/ktx/PermissionRequestFragment$SpecialRequestPermissionFragment;", "Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "()V", "action", "", "onActivityResult", "", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "Companion", "ktx_release"})
    public static final class SpecialRequestPermissionFragment
    extends PermissionRequestFragment {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private String action;
        @NotNull
        public static final String BUNDLE_ACTION_KEY = "key:action";

        public SpecialRequestPermissionFragment() {
            super(null);
        }

        public void onCreate(@Nullable Bundle savedInstanceState) {
            String string;
            super.onCreate(savedInstanceState);
            Object object = this.getArguments();
            String string2 = string = object == null ? null : object.getString(BUNDLE_ACTION_KEY);
            if (string == null) {
                return;
            }
            this.action = string;
            Object object2 = this.getContext();
            String string3 = object = object2 == null ? null : object2.getPackageName();
            if (object == null) {
                return;
            }
            Object packageName = object;
            Uri uri = Uri.parse((String)Intrinsics.stringPlus((String)"package:", (Object)packageName));
            object2 = this.action;
            if (object2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"action");
                throw null;
            }
            this.startActivityForResult(new Intent((String)object2, uri), this.getRequestCode());
        }

        public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
            if (requestCode == this.getRequestCode()) {
                if (Build.VERSION.SDK_INT >= 23 && Settings.canDrawOverlays((Context)((Context)this.getActivity()))) {
                    String string = this.action;
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"action");
                        throw null;
                    }
                    this.getViewModel().postPermissionRequestResult(string, PermissionResult.GRANTED);
                } else {
                    String string = this.action;
                    if (string == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"action");
                        throw null;
                    }
                    this.getViewModel().postPermissionRequestResult(string, PermissionResult.DENIED);
                }
            }
            this.dismiss();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lpermissions/dispatcher/ktx/PermissionRequestFragment$SpecialRequestPermissionFragment$Companion;", "", "()V", "BUNDLE_ACTION_KEY", "", "newInstance", "Lpermissions/dispatcher/ktx/PermissionRequestFragment$SpecialRequestPermissionFragment;", "action", "ktx_release"})
        public static final class Companion {
            private Companion() {
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final SpecialRequestPermissionFragment newInstance(@NotNull String action) {
                void $this$newInstance_u24lambda_u2d1_u24lambda_u2d0;
                Intrinsics.checkNotNullParameter((Object)action, (String)"action");
                SpecialRequestPermissionFragment specialRequestPermissionFragment = new SpecialRequestPermissionFragment();
                boolean bl = false;
                boolean bl2 = false;
                SpecialRequestPermissionFragment $this$newInstance_u24lambda_u2d1 = specialRequestPermissionFragment;
                boolean bl3 = false;
                Bundle bundle = new Bundle();
                boolean bl4 = false;
                boolean bl5 = false;
                Bundle bundle2 = bundle;
                SpecialRequestPermissionFragment specialRequestPermissionFragment2 = $this$newInstance_u24lambda_u2d1;
                boolean bl6 = false;
                $this$newInstance_u24lambda_u2d1_u24lambda_u2d0.putString(SpecialRequestPermissionFragment.BUNDLE_ACTION_KEY, action);
                Unit unit = Unit.INSTANCE;
                specialRequestPermissionFragment2.setArguments(bundle);
                return specialRequestPermissionFragment;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

