/*
 * Decompiled with CFR 0.152.
 */
package permissions.dispatcher.ktx;

import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.RequiresApi;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import permissions.dispatcher.PermissionUtils;
import permissions.dispatcher.ktx.PermissionRequestFragment;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0003\u000e\u000f\u0010B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH&\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH&\u00a2\u0006\u0002\u0010\r\u0082\u0001\u0003\u0011\u0012\u0013\u00a8\u0006\u0014"}, d2={"Lpermissions/dispatcher/ktx/PermissionRequestType;", "", "()V", "checkPermissions", "", "context", "Landroid/content/Context;", "permissions", "", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "fragment", "Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "([Ljava/lang/String;)Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "Normal", "SystemAlertWindow", "WriteSettings", "Lpermissions/dispatcher/ktx/PermissionRequestType$Normal;", "Lpermissions/dispatcher/ktx/PermissionRequestType$SystemAlertWindow;", "Lpermissions/dispatcher/ktx/PermissionRequestType$WriteSettings;", "ktx_release"})
public abstract class PermissionRequestType {
    private PermissionRequestType() {
    }

    public abstract boolean checkPermissions(@NotNull Context var1, @NotNull String[] var2);

    @NotNull
    public abstract PermissionRequestFragment fragment(@NotNull String[] var1);

    public /* synthetic */ PermissionRequestType(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lpermissions/dispatcher/ktx/PermissionRequestType$Normal;", "Lpermissions/dispatcher/ktx/PermissionRequestType;", "()V", "checkPermissions", "", "context", "Landroid/content/Context;", "permissions", "", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "fragment", "Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "([Ljava/lang/String;)Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "ktx_release"})
    public static final class Normal
    extends PermissionRequestType {
        @NotNull
        public static final Normal INSTANCE = new Normal();

        private Normal() {
            super(null);
        }

        @Override
        public boolean checkPermissions(@NotNull Context context, @NotNull String[] permissions) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            return PermissionUtils.hasSelfPermissions((Context)context, (String[])Arrays.copyOf(permissions, permissions.length));
        }

        @Override
        @NotNull
        public PermissionRequestFragment fragment(@NotNull String[] permissions) {
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            return PermissionRequestFragment.NormalRequestPermissionFragment.Companion.newInstance(permissions);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0017\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lpermissions/dispatcher/ktx/PermissionRequestType$SystemAlertWindow;", "Lpermissions/dispatcher/ktx/PermissionRequestType;", "()V", "checkPermissions", "", "context", "Landroid/content/Context;", "permissions", "", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "fragment", "Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "([Ljava/lang/String;)Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "ktx_release"})
    public static final class SystemAlertWindow
    extends PermissionRequestType {
        @NotNull
        public static final SystemAlertWindow INSTANCE = new SystemAlertWindow();

        private SystemAlertWindow() {
            super(null);
        }

        @Override
        public boolean checkPermissions(@NotNull Context context, @NotNull String[] permissions) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            return Build.VERSION.SDK_INT < 23 || Settings.canDrawOverlays((Context)context);
        }

        @Override
        @RequiresApi(value=23)
        @NotNull
        public PermissionRequestFragment fragment(@NotNull String[] permissions) {
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            return PermissionRequestFragment.SpecialRequestPermissionFragment.Companion.newInstance("android.settings.action.MANAGE_OVERLAY_PERMISSION");
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0016\u00a2\u0006\u0002\u0010\nJ\u001d\u0010\u000b\u001a\u00020\f2\u000e\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\bH\u0017\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lpermissions/dispatcher/ktx/PermissionRequestType$WriteSettings;", "Lpermissions/dispatcher/ktx/PermissionRequestType;", "()V", "checkPermissions", "", "context", "Landroid/content/Context;", "permissions", "", "", "(Landroid/content/Context;[Ljava/lang/String;)Z", "fragment", "Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "([Ljava/lang/String;)Lpermissions/dispatcher/ktx/PermissionRequestFragment;", "ktx_release"})
    public static final class WriteSettings
    extends PermissionRequestType {
        @NotNull
        public static final WriteSettings INSTANCE = new WriteSettings();

        private WriteSettings() {
            super(null);
        }

        @Override
        public boolean checkPermissions(@NotNull Context context, @NotNull String[] permissions) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            return Build.VERSION.SDK_INT < 23 || Settings.System.canWrite((Context)context);
        }

        @Override
        @RequiresApi(value=23)
        @NotNull
        public PermissionRequestFragment fragment(@NotNull String[] permissions) {
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            return PermissionRequestFragment.SpecialRequestPermissionFragment.Companion.newInstance("android.settings.action.MANAGE_WRITE_SETTINGS");
        }
    }
}

