/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.DigitShiftAccumulator;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.ExtendedOrSimpleRadixMath;
import com.upokecenter.numbers.Extras;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.FastIntegerFixed;
import com.upokecenter.numbers.IRadixMath;
import com.upokecenter.numbers.IRadixMathHelper;
import com.upokecenter.numbers.IShiftAccumulator;
import com.upokecenter.numbers.NumberUtility;
import com.upokecenter.numbers.RadixMath;
import com.upokecenter.numbers.TrappableRadixMath;

public final class EDecimal
implements Comparable<EDecimal> {
    private static final int RepeatDivideThreshold = 10000;
    private static final int MaxSafeInt = 0xCCCCCCB;
    public static final EDecimal NaN = EDecimal.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 4);
    public static final EDecimal NegativeInfinity = EDecimal.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 3);
    public static final EDecimal NegativeZero = EDecimal.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 1);
    public static final EDecimal One = new EDecimal(FastIntegerFixed.FromInt32(1), FastIntegerFixed.Zero, 0);
    public static final EDecimal PositiveInfinity = EDecimal.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 2);
    public static final EDecimal SignalingNaN = EDecimal.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 8);
    public static final EDecimal Ten = new EDecimal(FastIntegerFixed.FromInt32(10), FastIntegerFixed.Zero, 0);
    public static final EDecimal Zero = new EDecimal(FastIntegerFixed.Zero, FastIntegerFixed.Zero, 0);
    private static final int CacheFirst = -24;
    private static final int CacheLast = 128;
    private static final EDecimal[] Cache = EDecimal.EDecimalCache(-24, 128);
    private static final DecimalMathHelper HelperValue = new DecimalMathHelper();
    private static final IRadixMath<EDecimal> ExtendedMathValue = new RadixMath<EDecimal>(HelperValue);
    private static final IRadixMath<EDecimal> MathValue = new TrappableRadixMath<EDecimal>(new ExtendedOrSimpleRadixMath<EDecimal>(HelperValue));
    private static final int[] ValueTenPowers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private final FastIntegerFixed unsignedMantissa;
    private final FastIntegerFixed exponent;
    private final byte flags;

    private static EDecimal[] EDecimalCache(int first, int last) {
        EDecimal[] cache = new EDecimal[last - first + 1];
        for (int i = first; i <= last; ++i) {
            cache[i - first] = i == 0 ? Zero : (i == 1 ? One : (i == 10 ? Ten : new EDecimal(FastIntegerFixed.FromInt32(Math.abs(i)), FastIntegerFixed.Zero, (byte)(i < 0 ? 1 : 0))));
        }
        return cache;
    }

    private EDecimal(FastIntegerFixed unsignedMantissa, FastIntegerFixed exponent, byte flags) {
        this.unsignedMantissa = unsignedMantissa;
        this.exponent = exponent;
        this.flags = flags;
    }

    public EDecimal Copy() {
        return new EDecimal(this.unsignedMantissa.Copy(), this.exponent.Copy(), this.flags);
    }

    public final EInteger getExponent() {
        return this.exponent.ToEInteger();
    }

    public final boolean isFinite() {
        return (this.flags & 0xE) == 0;
    }

    public final boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    public final boolean isZero() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.isValueZero();
    }

    public boolean IsInteger() {
        if (!this.isFinite()) {
            return false;
        }
        if (this.isZero() || this.exponent.CompareToInt(0) >= 0) {
            return true;
        }
        EDecimal r = this.Reduce(null);
        return r.exponent.CompareToInt(0) >= 0;
    }

    public final EInteger getMantissa() {
        return this.isNegative() ? this.unsignedMantissa.ToEInteger().Negate() : this.unsignedMantissa.ToEInteger();
    }

    public final int signum() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.isValueZero() ? 0 : ((this.flags & 1) != 0 ? -1 : 1);
    }

    public final EInteger getUnsignedMantissa() {
        return this.unsignedMantissa.ToEInteger();
    }

    public static EDecimal Create(int mantissaSmall, int exponentSmall) {
        if (exponentSmall == 0 && mantissaSmall >= -24 && mantissaSmall <= 128) {
            return Cache[mantissaSmall - -24];
        }
        if (mantissaSmall < 0) {
            if (mantissaSmall == Integer.MIN_VALUE) {
                FastIntegerFixed fi = FastIntegerFixed.FromInt64(Integer.MIN_VALUE);
                return new EDecimal(fi.Negate(), FastIntegerFixed.FromInt32(exponentSmall), 1);
            }
            return new EDecimal(FastIntegerFixed.FromInt32(-mantissaSmall), FastIntegerFixed.FromInt32(exponentSmall), 1);
        }
        if (mantissaSmall == 0) {
            return new EDecimal(FastIntegerFixed.Zero, FastIntegerFixed.FromInt32(exponentSmall), 0);
        }
        return new EDecimal(FastIntegerFixed.FromInt32(mantissaSmall), FastIntegerFixed.FromInt32(exponentSmall), 0);
    }

    public static EDecimal Create(EInteger mantissa, int exponentSmall) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (mantissa.CanFitInInt32()) {
            int mantissaSmall = mantissa.ToInt32Checked();
            return EDecimal.Create(mantissaSmall, exponentSmall);
        }
        FastIntegerFixed fi = FastIntegerFixed.FromBig(mantissa);
        int sign = fi.signum();
        return new EDecimal(sign < 0 ? fi.Negate() : fi, FastIntegerFixed.FromInt32(exponentSmall), (byte)(sign < 0 ? 1 : 0));
    }

    public static EDecimal Create(EInteger mantissa, long exponentLong) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (mantissa.CanFitInInt64()) {
            long mantissaLong = mantissa.ToInt64Checked();
            return EDecimal.Create(mantissaLong, exponentLong);
        }
        FastIntegerFixed fi = FastIntegerFixed.FromBig(mantissa);
        int sign = fi.signum();
        return new EDecimal(sign < 0 ? fi.Negate() : fi, FastIntegerFixed.FromInt64(exponentLong), (byte)(sign < 0 ? 1 : 0));
    }

    public static EDecimal Create(EInteger mantissa, EInteger exponent) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        if (mantissa.CanFitInInt32() && exponent.isZero()) {
            int mantissaSmall = mantissa.ToInt32Checked();
            return EDecimal.Create(mantissaSmall, 0);
        }
        FastIntegerFixed fi = FastIntegerFixed.FromBig(mantissa);
        int sign = fi.signum();
        return new EDecimal(sign < 0 ? fi.Negate() : fi, FastIntegerFixed.FromBig(exponent), (byte)(sign < 0 ? 1 : 0));
    }

    public static EDecimal Create(long mantissaLong, int exponentSmall) {
        return EDecimal.Create(mantissaLong, (long)exponentSmall);
    }

    public static EDecimal Create(long mantissaLong, long exponentLong) {
        if (mantissaLong >= Integer.MIN_VALUE && mantissaLong <= Integer.MAX_VALUE && exponentLong >= Integer.MIN_VALUE && exponentLong <= Integer.MAX_VALUE) {
            return EDecimal.Create((int)mantissaLong, (int)exponentLong);
        }
        if (mantissaLong == Long.MIN_VALUE) {
            FastIntegerFixed fi = FastIntegerFixed.FromInt64(mantissaLong);
            return new EDecimal(fi.Negate(), FastIntegerFixed.FromInt64(exponentLong), (byte)(mantissaLong < 0L ? 1 : 0));
        }
        FastIntegerFixed fi = FastIntegerFixed.FromInt64(Math.abs(mantissaLong));
        return new EDecimal(fi, FastIntegerFixed.FromInt64(exponentLong), (byte)(mantissaLong < 0L ? 1 : 0));
    }

    public static EDecimal CreateNaN(EInteger diag) {
        return EDecimal.CreateNaN(diag, false, false, null);
    }

    public static EDecimal CreateNaN(EInteger diag, boolean signaling, boolean negative, EContext ctx) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        if (diag.signum() < 0) {
            throw new IllegalArgumentException("Diagnostic information must be 0 or greater,  was: " + diag);
        }
        if (diag.isZero() && !negative) {
            return signaling ? SignalingNaN : NaN;
        }
        int flags = 0;
        if (negative) {
            flags |= 1;
        }
        if (ctx != null && ctx.getHasMaxPrecision()) {
            EDecimal ef = new EDecimal(FastIntegerFixed.FromBig(diag), FastIntegerFixed.Zero, (byte)(flags |= 4)).RoundToPrecision(ctx);
            int newFlags = ef.flags;
            newFlags &= 0xFFFFFFFB;
            return new EDecimal(ef.unsignedMantissa, ef.exponent, (byte)(newFlags |= signaling ? 8 : 4));
        }
        return new EDecimal(FastIntegerFixed.FromBig(diag), FastIntegerFixed.Zero, (byte)(flags |= signaling ? 8 : 4));
    }

    public static EDecimal FromDouble(double dbl) {
        boolean neg;
        int[] value = Extras.DoubleToIntegers(dbl);
        int floatExponent = value[1] >> 20 & 0x7FF;
        boolean bl = neg = value[1] >> 31 != 0;
        if (floatExponent == 2047) {
            if ((value[1] & 0xFFFFF) == 0 && value[0] == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (value[1] & 0x80000) != 0;
            value[1] = value[1] & 0x7FFFF;
            long lvalue = (long)value[0] & 0xFFFFFFFFL | (long)value[1] << 32;
            int flags = (neg ? 1 : 0) | (quiet ? 4 : 8);
            return lvalue == 0L ? (quiet ? NaN : SignalingNaN) : new EDecimal(FastIntegerFixed.FromInt64(lvalue), FastIntegerFixed.Zero, (byte)flags);
        }
        value[1] = value[1] & 0xFFFFF;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            value[1] = value[1] | 0x100000;
        }
        if ((value[1] | value[0]) != 0) {
            floatExponent += NumberUtility.ShiftAwayTrailingZerosTwoElements(value);
        } else {
            return neg ? NegativeZero : Zero;
        }
        long lvalue = (long)value[0] & 0xFFFFFFFFL | (long)value[1] << 32;
        if ((floatExponent -= 1075) == 0) {
            if (neg) {
                lvalue = -lvalue;
            }
            return EDecimal.FromInt64(lvalue);
        }
        if (floatExponent > 0) {
            EInteger bigmantissa = EInteger.FromInt64(lvalue);
            bigmantissa = bigmantissa.ShiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return EDecimal.FromEInteger(bigmantissa);
        }
        EInteger bigmantissa = EInteger.FromInt64(lvalue);
        EInteger bigexp = NumberUtility.FindPowerOfFive(-floatExponent);
        bigmantissa = bigmantissa.Multiply(bigexp);
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        return EDecimal.Create(bigmantissa, EInteger.FromInt32(floatExponent));
    }

    public static EDecimal FromEInteger(EInteger bigint) {
        return EDecimal.Create(bigint, EInteger.FromInt32(0));
    }

    @Deprecated
    public static EDecimal FromExtendedFloat(EFloat ef) {
        return EDecimal.FromEFloat(ef);
    }

    public static EDecimal FromEFloat(EFloat bigfloat) {
        if (bigfloat == null) {
            throw new NullPointerException("bigfloat");
        }
        if (bigfloat.IsNaN() || bigfloat.IsInfinity()) {
            int flags = (bigfloat.isNegative() ? 1 : 0) | (bigfloat.IsInfinity() ? 2 : 0) | (bigfloat.IsQuietNaN() ? 4 : 0) | (bigfloat.IsSignalingNaN() ? 8 : 0);
            return EDecimal.CreateWithFlags(bigfloat.getUnsignedMantissa(), bigfloat.getExponent(), flags);
        }
        EInteger bigintExp = bigfloat.getExponent();
        EInteger bigSignedMantissa = bigfloat.getMantissa();
        if (bigSignedMantissa.isZero()) {
            return bigfloat.isNegative() ? NegativeZero : Zero;
        }
        if (bigintExp.isZero()) {
            return EDecimal.FromEInteger(bigSignedMantissa);
        }
        if (bigintExp.signum() > 0) {
            boolean neg;
            FastInteger intcurexp = FastInteger.FromBig(bigintExp);
            EInteger bigmantissa = bigSignedMantissa;
            boolean bl = neg = bigmantissa.signum() < 0;
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            while (intcurexp.signum() > 0) {
                int shift = 1000000;
                if (intcurexp.CompareToInt(1000000) < 0) {
                    shift = intcurexp.ToInt32();
                }
                bigmantissa = bigmantissa.ShiftLeft(shift);
                intcurexp.AddInt(-shift);
            }
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return EDecimal.FromEInteger(bigmantissa);
        }
        EInteger bigmantissa = bigSignedMantissa;
        EInteger negbigintExp = bigintExp.Negate();
        negbigintExp = NumberUtility.FindPowerOfFiveFromBig(negbigintExp);
        bigmantissa = bigmantissa.Multiply(negbigintExp);
        return EDecimal.Create(bigmantissa, bigintExp);
    }

    public static EDecimal FromBoolean(boolean boolValue) {
        return boolValue ? One : Zero;
    }

    public static EDecimal FromInt32(int valueSmaller) {
        if (valueSmaller >= -24 && valueSmaller <= 128) {
            return Cache[valueSmaller - -24];
        }
        if (valueSmaller == Integer.MIN_VALUE) {
            return EDecimal.Create(EInteger.FromInt32(valueSmaller), EInteger.FromInt32(0));
        }
        if (valueSmaller < 0) {
            return new EDecimal(FastIntegerFixed.FromInt32(valueSmaller).Negate(), FastIntegerFixed.Zero, 1);
        }
        return new EDecimal(FastIntegerFixed.FromInt32(valueSmaller), FastIntegerFixed.Zero, 0);
    }

    public static EDecimal FromInt64(long valueSmall) {
        if (valueSmall >= -24L && valueSmall <= 128L) {
            return Cache[(int)(valueSmall - -24L)];
        }
        if (valueSmall > Integer.MIN_VALUE && valueSmall <= Integer.MAX_VALUE) {
            if (valueSmall < 0L) {
                return new EDecimal(FastIntegerFixed.FromInt32((int)valueSmall).Negate(), FastIntegerFixed.Zero, 1);
            }
            return new EDecimal(FastIntegerFixed.FromInt32((int)valueSmall), FastIntegerFixed.Zero, 0);
        }
        EInteger bigint = EInteger.FromInt64(valueSmall);
        return EDecimal.Create(bigint, EInteger.FromInt32(0));
    }

    public static EDecimal FromSingle(float flt) {
        int value = Float.floatToRawIntBits(flt);
        boolean neg = value >> 31 != 0;
        int floatExponent = value >> 23 & 0xFF;
        int valueFpMantissa = value & 0x7FFFFF;
        if (floatExponent == 255) {
            if (valueFpMantissa == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (valueFpMantissa & 0x400000) != 0;
            value = (neg ? 1 : 0) | (quiet ? 4 : 8);
            return (valueFpMantissa &= 0x3FFFFF) == 0 ? (quiet ? NaN : SignalingNaN) : new EDecimal(FastIntegerFixed.FromInt32(valueFpMantissa), FastIntegerFixed.Zero, (byte)value);
        }
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            valueFpMantissa |= 0x800000;
        }
        if (valueFpMantissa == 0) {
            return neg ? NegativeZero : Zero;
        }
        floatExponent -= 150;
        while ((valueFpMantissa & 1) == 0) {
            ++floatExponent;
            valueFpMantissa >>= 1;
        }
        if (floatExponent == 0) {
            if (neg) {
                valueFpMantissa = -valueFpMantissa;
            }
            return EDecimal.FromInt64(valueFpMantissa);
        }
        if (floatExponent > 0) {
            EInteger bigmantissa = EInteger.FromInt32(valueFpMantissa);
            bigmantissa = bigmantissa.ShiftLeft(floatExponent);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return EDecimal.FromEInteger(bigmantissa);
        }
        EInteger bigmantissa = EInteger.FromInt32(valueFpMantissa);
        EInteger bigexponent = NumberUtility.FindPowerOfFive(-floatExponent);
        bigmantissa = bigmantissa.Multiply(bigexponent);
        if (neg) {
            bigmantissa = bigmantissa.Negate();
        }
        return EDecimal.Create(bigmantissa, EInteger.FromInt32(floatExponent));
    }

    public static EDecimal FromString(String str) {
        return EDecimal.FromString(str, 0, str == null ? 0 : str.length(), null);
    }

    public static EDecimal FromString(String str, EContext ctx) {
        return EDecimal.FromString(str, 0, str == null ? 0 : str.length(), ctx);
    }

    public static EDecimal FromString(String str, int offset, int length) {
        return EDecimal.FromString(str, offset, length, null);
    }

    public static EDecimal FromString(String str, int offset, int length, EContext ctx) {
        EDecimal ed;
        int tmpoffset = offset;
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (tmpoffset < 0) {
            throw new NumberFormatException("offset(" + tmpoffset + ") is less than 0");
        }
        if (tmpoffset > str.length()) {
            throw new NumberFormatException("offset(" + tmpoffset + ") is more than " + str.length());
        }
        if (length <= 0) {
            if (length == 0) {
                throw new NumberFormatException("length is 0");
            }
            throw new NumberFormatException("length(" + length + ") is less than 0");
        }
        if (length > str.length()) {
            throw new NumberFormatException("length(" + length + ") is more than " + str.length());
        }
        if (str.length() - tmpoffset < length) {
            throw new NumberFormatException("str's length minus " + tmpoffset + "(" + (str.length() - tmpoffset) + ") is less than " + length);
        }
        boolean negative = false;
        int endStr = tmpoffset + length;
        char c = str.charAt(tmpoffset);
        if (c == '-') {
            negative = true;
            if (++tmpoffset >= endStr) {
                throw new NumberFormatException();
            }
            c = str.charAt(tmpoffset);
        } else if (str.charAt(tmpoffset) == '+') {
            if (++tmpoffset >= endStr) {
                throw new NumberFormatException();
            }
            c = str.charAt(tmpoffset);
        }
        int i = tmpoffset;
        if ((c < '0' || c > '9') && (ed = EDecimal.ParseSpecialValue(str, i, endStr, negative, ctx)) != null) {
            return ed;
        }
        if (ctx != null && ctx.getHasMaxPrecision() && ctx.getHasExponentRange() && !ctx.isSimplified()) {
            return EDecimal.ParseOrdinaryNumberLimitedPrecision(str, i, endStr, negative, ctx);
        }
        return EDecimal.ParseOrdinaryNumber(str, i, endStr, negative, ctx);
    }

    private static EDecimal ParseSpecialValue(String str, int i, int endStr, boolean negative, EContext ctx) {
        int mantInt = 0;
        EInteger mant = null;
        boolean haveDigits = false;
        int digitStart = 0;
        if (!(i + 8 != endStr || str.charAt(i) != 'I' && str.charAt(i) != 'i' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'F' && str.charAt(i + 2) != 'f' || str.charAt(i + 3) != 'I' && str.charAt(i + 3) != 'i' || str.charAt(i + 4) != 'N' && str.charAt(i + 4) != 'n' || str.charAt(i + 5) != 'I' && str.charAt(i + 5) != 'i' || str.charAt(i + 6) != 'T' && str.charAt(i + 6) != 't' || str.charAt(i + 7) != 'Y' && str.charAt(i + 7) != 'y')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("Infinity not allowed");
            }
            return negative ? NegativeInfinity : PositiveInfinity;
        }
        if (!(i + 3 != endStr || str.charAt(i) != 'I' && str.charAt(i) != 'i' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'F' && str.charAt(i + 2) != 'f')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("Infinity not allowed");
            }
            return negative ? NegativeInfinity : PositiveInfinity;
        }
        if (!(i + 3 > endStr || str.charAt(i) != 'N' && str.charAt(i) != 'n' || str.charAt(i + 1) != 'A' && str.charAt(i + 1) != 'a' || str.charAt(i + 2) != 'N' && str.charAt(i + 2) != 'n')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("NaN not allowed");
            }
            int flags2 = (negative ? 1 : 0) | 4;
            if (i + 3 == endStr) {
                return !negative ? NaN : new EDecimal(FastIntegerFixed.Zero, FastIntegerFixed.Zero, (byte)flags2);
            }
            i += 3;
            FastInteger digitCount = new FastInteger(0);
            FastInteger maxDigits = null;
            haveDigits = false;
            if (ctx != null && ctx.getHasMaxPrecision()) {
                maxDigits = FastInteger.FromBig(ctx.getPrecision());
                if (ctx.getClampNormalExponents()) {
                    maxDigits.Decrement();
                }
            }
            digitStart = i;
            while (i < endStr) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    int thisdigit = str.charAt(i) - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (mantInt <= 0xCCCCCCB) {
                        mantInt *= 10;
                        mantInt += thisdigit;
                    }
                    if (haveDigits && maxDigits != null) {
                        digitCount.Increment();
                        if (digitCount.compareTo(maxDigits) > 0) {
                            throw new NumberFormatException();
                        }
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (mantInt > 0xCCCCCCB) {
                mant = EInteger.FromSubstring(str, digitStart, endStr);
            }
            EInteger bigmant = mant == null ? EInteger.FromInt32(mantInt) : mant;
            flags2 = (negative ? 1 : 0) | 4;
            return EDecimal.CreateWithFlags(FastIntegerFixed.FromBig(bigmant), FastIntegerFixed.Zero, flags2);
        }
        if (!(i + 4 > endStr || str.charAt(i) != 'S' && str.charAt(i) != 's' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'A' && str.charAt(i + 2) != 'a' || str.charAt(i + 3) != 'N' && str.charAt(i + 3) != 'n')) {
            if (ctx != null && ctx.isSimplified() && i < endStr) {
                throw new NumberFormatException("NaN not allowed");
            }
            if (i + 4 == endStr) {
                int flags2 = (negative ? 1 : 0) | 8;
                return !negative ? SignalingNaN : new EDecimal(FastIntegerFixed.Zero, FastIntegerFixed.Zero, (byte)flags2);
            }
            i += 4;
            FastInteger digitCount = new FastInteger(0);
            FastInteger maxDigits = null;
            haveDigits = false;
            if (ctx != null && ctx.getHasMaxPrecision()) {
                maxDigits = FastInteger.FromBig(ctx.getPrecision());
                if (ctx.getClampNormalExponents()) {
                    maxDigits.Decrement();
                }
            }
            digitStart = i;
            while (i < endStr) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    int thisdigit = str.charAt(i) - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (mantInt <= 0xCCCCCCB) {
                        mantInt *= 10;
                        mantInt += thisdigit;
                    }
                    if (haveDigits && maxDigits != null) {
                        digitCount.Increment();
                        if (digitCount.compareTo(maxDigits) > 0) {
                            throw new NumberFormatException();
                        }
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (mantInt > 0xCCCCCCB) {
                mant = EInteger.FromSubstring(str, digitStart, endStr);
            }
            int flags3 = (negative ? 1 : 0) | 8;
            EInteger bigmant = mant == null ? EInteger.FromInt32(mantInt) : mant;
            return EDecimal.CreateWithFlags(bigmant, EInteger.FromInt32(0), flags3);
        }
        return null;
    }

    private static EDecimal SignalUnderflow(EContext ec, boolean negative, boolean zeroSignificand) {
        EInteger eTiny = ec.getEMin().Subtract(ec.getPrecision().Subtract(1));
        eTiny = eTiny.Subtract(2);
        EDecimal ret = EDecimal.Create(zeroSignificand ? EInteger.FromInt32(0) : EInteger.FromInt32(1), eTiny);
        if (negative) {
            ret = ret.Negate();
        }
        return ret.RoundToPrecision(ec);
    }

    private static EDecimal SignalOverflow(EContext ec, boolean negative, boolean zeroSignificand) {
        if (zeroSignificand) {
            EDecimal ret = EDecimal.Create(EInteger.FromInt32(0), ec.getEMax());
            if (negative) {
                ret = ret.Negate();
            }
            return ret.RoundToPrecision(ec);
        }
        return EDecimal.GetMathValue(ec).SignalOverflow(ec, negative);
    }

    private static EDecimal ParseOrdinaryNumberLimitedPrecision(String str, int offset, int endStr, boolean negative, EContext ctx) {
        EInteger exp;
        int i;
        int tmpoffset = offset;
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (ctx == null || !ctx.getHasMaxPrecision()) {
            throw new IllegalStateException();
        }
        boolean haveDecimalPoint = false;
        boolean haveDigits = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        long mantissaLong = 0L;
        int digitStart = i;
        int digitEnd = i;
        int decimalDigitStart = i;
        boolean haveNonzeroDigit = false;
        int decimalPrec = 0;
        int decimalDigitEnd = i;
        boolean nonzeroBeyondMax = false;
        boolean beyondMax = false;
        int lastdigit = -1;
        EInteger precisionPlusTwo = ctx.getPrecision().Add(2);
        for (i = tmpoffset; i < endStr; ++i) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                int thisdigit = ch - 48;
                haveDigits = true;
                haveNonzeroDigit |= thisdigit != 0;
                if (beyondMax || precisionPlusTwo.compareTo(decimalPrec) < 0 && mantissaLong == Long.MAX_VALUE) {
                    beyondMax = true;
                    if (thisdigit != 0) {
                        nonzeroBeyondMax = true;
                    }
                    if (haveDecimalPoint) continue;
                    ++newScaleInt;
                    continue;
                }
                lastdigit = thisdigit;
                if (haveNonzeroDigit) {
                    ++decimalPrec;
                }
                if (haveDecimalPoint) {
                    decimalDigitEnd = i + 1;
                } else {
                    digitEnd = i + 1;
                }
                if (mantissaLong <= 0xCCCCCCCCCCCCCCCL) {
                    mantissaLong *= 10L;
                    mantissaLong += (long)thisdigit;
                } else {
                    mantissaLong = Long.MAX_VALUE;
                }
                if (!haveDecimalPoint) continue;
                --newScaleInt;
                continue;
            }
            if (ch == '.') {
                if (haveDecimalPoint) {
                    throw new NumberFormatException();
                }
                haveDecimalPoint = true;
                decimalDigitStart = i + 1;
                decimalDigitEnd = i + 1;
                continue;
            }
            if (ch == 'E' || ch == 'e') {
                haveExponent = true;
                ++i;
                break;
            }
            throw new NumberFormatException();
        }
        if (!haveDigits) {
            throw new NumberFormatException();
        }
        int expInt = 0;
        int expoffset = 1;
        int expDigitStart = -1;
        int expPrec = 0;
        boolean zeroMantissa = !haveNonzeroDigit;
        haveNonzeroDigit = false;
        if (haveExponent) {
            haveDigits = false;
            if (i == endStr) {
                throw new NumberFormatException();
            }
            if (str.charAt(i) == '+' || str.charAt(i) == '-') {
                if (str.charAt(i) == '-') {
                    expoffset = -1;
                }
                ++i;
            }
            expDigitStart = i;
            while (i < endStr) {
                char ch = str.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    haveDigits = true;
                    int thisdigit = ch - 48;
                    if (haveNonzeroDigit |= thisdigit != 0) {
                        ++expPrec;
                    }
                    if (expInt <= 0xCCCCCCC) {
                        expInt *= 10;
                        expInt += thisdigit;
                    } else {
                        expInt = Integer.MAX_VALUE;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                throw new NumberFormatException();
            }
            expInt *= expoffset;
            if (expPrec > 12) {
                if (expoffset < 0) {
                    return EDecimal.SignalUnderflow(ctx, negative, zeroMantissa);
                }
                return EDecimal.SignalOverflow(ctx, negative, zeroMantissa);
            }
        }
        if (i != endStr) {
            throw new NumberFormatException();
        }
        if (expInt != Integer.MAX_VALUE && expInt > -2147483647 && mantissaLong != Long.MAX_VALUE) {
            long finalexp = (long)expInt + (long)newScaleInt;
            if (negative) {
                mantissaLong = -mantissaLong;
            }
            EDecimal eret = EDecimal.Create(mantissaLong, finalexp);
            if (negative && zeroMantissa) {
                eret = eret.Negate();
            }
            return eret.RoundToPrecision(ctx);
        }
        EInteger mant = null;
        EInteger eInteger = exp = !haveExponent ? EInteger.FromInt32(0) : EInteger.FromSubstring(str, expDigitStart, endStr);
        if (expoffset < 0) {
            exp = exp.Negate();
        }
        exp = exp.Add(newScaleInt);
        if (nonzeroBeyondMax) {
            exp = exp.Subtract(1);
            ++decimalPrec;
        }
        if (ctx.getHasExponentRange()) {
            EInteger adjExpUpperBound = exp.Add(decimalPrec).Subtract(1);
            EInteger adjExpLowerBound = exp;
            EInteger eTiny = ctx.getEMin().Subtract(ctx.getPrecision().Subtract(1));
            if (adjExpUpperBound.compareTo(eTiny = eTiny.Subtract(1)) < 0) {
                return EDecimal.SignalUnderflow(ctx, negative, zeroMantissa);
            }
            if (adjExpLowerBound.compareTo(ctx.getEMax()) > 0) {
                return EDecimal.SignalOverflow(ctx, negative, zeroMantissa);
            }
        }
        if (zeroMantissa) {
            EDecimal ef = EDecimal.Create(EInteger.FromInt32(0), exp);
            if (negative) {
                ef = ef.Negate();
            }
            return ef.RoundToPrecision(ctx);
        }
        if (decimalDigitStart != decimalDigitEnd) {
            String tmpstr = str.substring(digitStart, digitStart + (digitEnd - digitStart)) + str.substring(decimalDigitStart, decimalDigitStart + (decimalDigitEnd - decimalDigitStart));
            mant = EInteger.FromString(tmpstr);
        } else {
            mant = EInteger.FromSubstring(str, digitStart, digitEnd);
        }
        if (nonzeroBeyondMax) {
            mant = mant.Multiply(10).Add(1);
        }
        if (negative) {
            mant = mant.Negate();
        }
        return EDecimal.Create(mant, exp).RoundToPrecision(ctx);
    }

    private static EDecimal ParseOrdinaryNumberNoContext(String str, int i, int endStr, boolean negative) {
        FastIntegerFixed fastIntMant;
        FastIntegerFixed fastIntScale;
        char tch;
        int mantInt = 0;
        EInteger mant = null;
        boolean haveDecimalPoint = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        boolean haveDigits = false;
        int digitStart = 0;
        EInteger newScale = null;
        if (endStr - i == 1 && (tch = str.charAt(i)) >= '0' && tch <= '9') {
            int si = tch - 48;
            return negative ? (si == 0 ? NegativeZero : Cache[-si - -24]) : Cache[si - -24];
        }
        digitStart = i;
        int digitEnd = i;
        int decimalDigitStart = i;
        boolean haveNonzeroDigit = false;
        int decimalPrec = 0;
        int firstdigit = -1;
        int decimalDigitEnd = i;
        int lastdigit = -1;
        int realDigitEnd = -1;
        int realDecimalEnd = -1;
        while (i < endStr) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                int thisdigit = ch - 48;
                haveNonzeroDigit |= thisdigit != 0;
                if (firstdigit < 0) {
                    firstdigit = thisdigit;
                }
                haveDigits = true;
                lastdigit = thisdigit;
                if (haveNonzeroDigit) {
                    ++decimalPrec;
                }
                if (haveDecimalPoint) {
                    decimalDigitEnd = i + 1;
                } else {
                    digitEnd = i + 1;
                }
                if (mantInt <= 0xCCCCCCB) {
                    mantInt *= 10;
                    mantInt += thisdigit;
                }
                if (haveDecimalPoint) {
                    if (newScaleInt == Integer.MIN_VALUE || newScaleInt == Integer.MAX_VALUE) {
                        newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                        newScale = newScale.Subtract(1);
                    } else {
                        --newScaleInt;
                    }
                }
            } else if (ch == '.') {
                if (haveDecimalPoint) {
                    throw new NumberFormatException();
                }
                haveDecimalPoint = true;
                realDigitEnd = i;
                decimalDigitStart = i + 1;
                decimalDigitEnd = i + 1;
            } else {
                if (ch == 'E' || ch == 'e') {
                    realDecimalEnd = i++;
                    haveExponent = true;
                    break;
                }
                throw new NumberFormatException();
            }
            ++i;
        }
        if (!haveDigits) {
            throw new NumberFormatException();
        }
        if (realDigitEnd < 0) {
            realDigitEnd = i;
        }
        if (realDecimalEnd < 0) {
            realDecimalEnd = i;
        }
        EDecimal ret = null;
        EInteger exp = null;
        int expInt = 0;
        int expoffset = 1;
        int expDigitStart = -1;
        int expPrec = 0;
        haveNonzeroDigit = false;
        if (haveExponent) {
            haveDigits = false;
            if (i == endStr) {
                throw new NumberFormatException();
            }
            char ch = str.charAt(i);
            if (ch == '+' || ch == '-') {
                if (ch == '-') {
                    expoffset = -1;
                }
                ++i;
            }
            expDigitStart = i;
            while (i < endStr) {
                ch = str.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    haveDigits = true;
                    int thisdigit = ch - 48;
                    if (haveNonzeroDigit |= thisdigit != 0) {
                        ++expPrec;
                    }
                    if (expInt <= 0xCCCCCCB) {
                        expInt *= 10;
                        expInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                throw new NumberFormatException();
            }
        }
        if (i != endStr) {
            throw new NumberFormatException();
        }
        if (haveExponent && expInt <= 0xCCCCCCB) {
            if (expoffset >= 0 && newScaleInt == 0 && newScale == null) {
                newScaleInt = expInt;
            } else if (newScale == null) {
                long tmplong = newScaleInt;
                if (expoffset < 0) {
                    tmplong -= (long)expInt;
                } else if (expInt != 0) {
                    tmplong += (long)expInt;
                }
                if (tmplong >= Integer.MAX_VALUE && tmplong <= Integer.MIN_VALUE) {
                    newScaleInt = (int)tmplong;
                } else {
                    newScale = EInteger.FromInt64(tmplong);
                }
            } else if (expoffset < 0) {
                newScale = newScale.Subtract(expInt);
            } else if (expInt != 0) {
                newScale = newScale.Add(expInt);
            }
        }
        int de = digitEnd;
        int dde = decimalDigitEnd;
        if (!haveExponent && haveDecimalPoint && de - digitStart + (dde - decimalDigitStart) <= 18) {
            long lv = 0L;
            int expo = -(dde - decimalDigitStart);
            if (mantInt <= 0xCCCCCCB) {
                lv = mantInt;
            } else {
                char chvi;
                int vi = 0;
                for (vi = digitStart; vi < de; ++vi) {
                    chvi = str.charAt(vi);
                    lv = lv * 10L + (long)(chvi - 48);
                }
                for (vi = decimalDigitStart; vi < dde; ++vi) {
                    chvi = str.charAt(vi);
                    lv = lv * 10L + (long)(chvi - 48);
                }
            }
            if (negative) {
                lv = -lv;
            }
            if (!negative || lv != 0L) {
                ret = EDecimal.Create(lv, (long)expo);
                return ret;
            }
        }
        if (mantInt > 0xCCCCCCB) {
            if (haveDecimalPoint) {
                if (digitEnd - digitStart == 1 && firstdigit == 0) {
                    mant = EInteger.FromSubstring(str, decimalDigitStart, decimalDigitEnd);
                } else {
                    String decstr = str.substring(digitStart, digitStart + (digitEnd - digitStart)) + str.substring(decimalDigitStart, decimalDigitStart + (decimalDigitEnd - decimalDigitStart));
                    mant = EInteger.FromString(decstr);
                }
            } else {
                mant = EInteger.FromSubstring(str, digitStart, digitEnd);
            }
        }
        if (haveExponent && expInt > 0xCCCCCCB) {
            exp = EInteger.FromSubstring(str, expDigitStart, endStr);
            newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
            newScale = expoffset < 0 ? newScale.Subtract(exp) : newScale.Add(exp);
        }
        FastIntegerFixed fastIntegerFixed = fastIntScale = newScale == null ? FastIntegerFixed.FromInt32(newScaleInt) : FastIntegerFixed.FromBig(newScale);
        if (mant == null) {
            fastIntMant = FastIntegerFixed.FromInt32(mantInt);
        } else if (mant.CanFitInInt32()) {
            mantInt = mant.ToInt32Checked();
            fastIntMant = FastIntegerFixed.FromInt32(mantInt);
        } else {
            fastIntMant = FastIntegerFixed.FromBig(mant);
        }
        ret = new EDecimal(fastIntMant, fastIntScale, (byte)(negative ? 1 : 0));
        return ret;
    }

    private static EDecimal ParseOrdinaryNumber(String str, int i, int endStr, boolean negative, EContext ctx) {
        FastIntegerFixed fastIntMant;
        FastIntegerFixed fastIntScale;
        int precdiff;
        char tch;
        if (ctx == null) {
            return EDecimal.ParseOrdinaryNumberNoContext(str, i, endStr, negative);
        }
        int mantInt = 0;
        EInteger mant = null;
        boolean haveDecimalPoint = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        boolean haveDigits = false;
        int digitStart = 0;
        EInteger newScale = null;
        if (endStr - i == 1 && (tch = str.charAt(i)) >= '0' && tch <= '9') {
            EDecimal cret;
            int si = tch - 48;
            EDecimal eDecimal = negative ? (si == 0 ? NegativeZero : Cache[-si - -24]) : (cret = Cache[si - -24]);
            if (ctx != null) {
                cret = EDecimal.GetMathValue(ctx).RoundAfterConversion(cret, ctx);
            }
            return cret;
        }
        digitStart = i;
        int digitEnd = i;
        int decimalDigitStart = i;
        boolean haveNonzeroDigit = false;
        int decimalPrec = 0;
        int decimalDigitEnd = i;
        boolean roundDown = ctx != null && ctx.getHasMaxPrecision() && !ctx.isPrecisionInBits() && (ctx.getRounding() == ERounding.Down || negative && ctx.getRounding() == ERounding.Ceiling || !negative && ctx.getRounding() == ERounding.Floor) && !ctx.getHasFlagsOrTraps();
        boolean roundHalf = ctx != null && ctx.getHasMaxPrecision() && !ctx.isPrecisionInBits() && (ctx.getRounding() == ERounding.HalfUp || ctx.getRounding() == ERounding.HalfDown || ctx.getRounding() == ERounding.HalfEven) && !ctx.getHasFlagsOrTraps();
        boolean roundUp = ctx != null && ctx.getHasMaxPrecision() && !ctx.isPrecisionInBits() && (ctx.getRounding() == ERounding.Up || !negative && ctx.getRounding() == ERounding.Ceiling || negative && ctx.getRounding() == ERounding.Floor) && !ctx.getHasFlagsOrTraps();
        boolean haveIgnoredDigit = false;
        int lastdigit = -1;
        boolean beyondPrecision = false;
        boolean ignoreNextDigit = false;
        int zerorun = 0;
        int realDigitEnd = -1;
        int realDecimalEnd = -1;
        while (i < endStr) {
            char ch = str.charAt(i);
            if (ch >= '0' && ch <= '9') {
                int thisdigit = ch - 48;
                haveNonzeroDigit |= thisdigit != 0;
                haveDigits = true;
                beyondPrecision |= ctx != null && ctx.getHasMaxPrecision() && !ctx.isPrecisionInBits() && ctx.getPrecision().compareTo(decimalPrec) <= 0;
                if (ctx != null) {
                    if (ignoreNextDigit) {
                        haveIgnoredDigit = true;
                        ignoreNextDigit = false;
                    }
                    if (roundDown && (haveIgnoredDigit || beyondPrecision)) {
                        haveIgnoredDigit = true;
                    } else if (roundUp && beyondPrecision && !haveIgnoredDigit) {
                        if (thisdigit > 0) {
                            ignoreNextDigit = true;
                        } else {
                            roundUp = false;
                        }
                    } else if (roundHalf && beyondPrecision && !haveIgnoredDigit) {
                        if (thisdigit >= 1 && thisdigit < 5) {
                            ignoreNextDigit = true;
                        } else if (thisdigit > 5 || thisdigit == 5 && ctx.getRounding() == ERounding.HalfUp) {
                            roundHalf = false;
                            roundUp = true;
                            ignoreNextDigit = true;
                        } else {
                            roundHalf = false;
                        }
                    }
                }
                if (haveIgnoredDigit) {
                    zerorun = 0;
                    if (newScaleInt == Integer.MIN_VALUE || newScaleInt == Integer.MAX_VALUE) {
                        newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                        newScale = newScale.Add(1);
                    } else {
                        ++newScaleInt;
                    }
                } else {
                    lastdigit = thisdigit;
                    zerorun = beyondPrecision && thisdigit == 0 ? ++zerorun : 0;
                    if (haveNonzeroDigit) {
                        ++decimalPrec;
                    }
                    if (haveDecimalPoint) {
                        decimalDigitEnd = i + 1;
                    } else {
                        digitEnd = i + 1;
                    }
                    if (mantInt <= 0xCCCCCCB) {
                        mantInt *= 10;
                        mantInt += thisdigit;
                    }
                }
                if (haveDecimalPoint) {
                    if (newScaleInt == Integer.MIN_VALUE || newScaleInt == Integer.MAX_VALUE) {
                        newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                        newScale = newScale.Subtract(1);
                    } else {
                        --newScaleInt;
                    }
                }
            } else if (ch == '.') {
                if (haveDecimalPoint) {
                    throw new NumberFormatException();
                }
                haveDecimalPoint = true;
                realDigitEnd = i;
                decimalDigitStart = i + 1;
                decimalDigitEnd = i + 1;
            } else {
                if (ch == 'E' || ch == 'e') {
                    realDecimalEnd = i++;
                    haveExponent = true;
                    break;
                }
                throw new NumberFormatException();
            }
            ++i;
        }
        if (!haveDigits) {
            throw new NumberFormatException();
        }
        if (realDigitEnd < 0) {
            realDigitEnd = i;
        }
        if (realDecimalEnd < 0) {
            realDecimalEnd = i;
        }
        if (!(zerorun <= 0 || lastdigit != 0 || ctx != null && ctx.getHasFlagsOrTraps())) {
            int nondec = 0;
            if (ctx == null || !ctx.getHasMaxPrecision() || (decimalPrec -= zerorun) - ctx.getPrecision().ToInt32Checked() > zerorun) {
                if (haveDecimalPoint) {
                    int decdigits = decimalDigitEnd - decimalDigitStart;
                    nondec = Math.min(decdigits, zerorun);
                    decimalDigitEnd -= nondec;
                    int remain = zerorun - nondec;
                    digitEnd -= remain;
                    nondec = zerorun;
                } else {
                    digitEnd -= zerorun;
                    nondec = zerorun;
                }
                if (newScaleInt > Integer.MIN_VALUE + nondec && newScaleInt < Integer.MAX_VALUE - nondec) {
                    newScaleInt += nondec;
                } else {
                    newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                    newScale = newScale.Add(nondec);
                }
            }
        }
        if (roundUp && ctx != null && ctx.getPrecision().compareTo(decimalPrec) < 0 && (precdiff = decimalPrec - ctx.getPrecision().ToInt32Checked()) > 1) {
            int precchop = precdiff - 1;
            decimalPrec -= precchop;
            int nondec = precchop;
            if (haveDecimalPoint) {
                int decdigits = decimalDigitEnd - decimalDigitStart;
                decimalDigitEnd -= nondec;
                int remain = precchop - nondec;
                digitEnd -= remain;
            } else {
                digitEnd -= precchop;
            }
            if (newScaleInt < Integer.MAX_VALUE - nondec) {
                newScaleInt += nondec;
            } else {
                newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                newScale = newScale.Add(nondec);
            }
        }
        EDecimal ret = null;
        EInteger exp = null;
        int expInt = 0;
        int expoffset = 1;
        int expDigitStart = -1;
        int expPrec = 0;
        haveNonzeroDigit = false;
        if (haveExponent) {
            haveDigits = false;
            if (i == endStr) {
                throw new NumberFormatException();
            }
            if (str.charAt(i) == '+' || str.charAt(i) == '-') {
                if (str.charAt(i) == '-') {
                    expoffset = -1;
                }
                ++i;
            }
            expDigitStart = i;
            while (i < endStr) {
                char ch = str.charAt(i);
                if (ch >= '0' && ch <= '9') {
                    haveDigits = true;
                    int thisdigit = ch - 48;
                    if (haveNonzeroDigit |= thisdigit != 0) {
                        ++expPrec;
                    }
                    if (expInt <= 0xCCCCCCB) {
                        expInt *= 10;
                        expInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                throw new NumberFormatException();
            }
        }
        if (i != endStr) {
            throw new NumberFormatException();
        }
        if (haveExponent && expInt <= 0xCCCCCCB) {
            if (expoffset >= 0 && newScaleInt == 0 && newScale == null) {
                newScaleInt = expInt;
            } else if (newScale == null) {
                long tmplong = newScaleInt;
                if (expoffset < 0) {
                    tmplong -= (long)expInt;
                } else if (expInt != 0) {
                    tmplong += (long)expInt;
                }
                if (tmplong >= Integer.MAX_VALUE && tmplong <= Integer.MIN_VALUE) {
                    newScaleInt = (int)tmplong;
                } else {
                    newScale = EInteger.FromInt64(tmplong);
                }
            } else if (expoffset < 0) {
                newScale = newScale.Subtract(expInt);
            } else if (expInt != 0) {
                newScale = newScale.Add(expInt);
            }
        }
        if (ctx != null && (mantInt > 0xCCCCCCB || haveExponent && expInt > 0xCCCCCCB) && ctx.getHasExponentRange()) {
            EInteger ns;
            if (expInt <= 0xCCCCCCB && ctx != null) {
                ns = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
            } else {
                EInteger trialExponent = EInteger.FromInt32(0xCCCCCCB);
                if (expPrec > 25) {
                    trialExponent = EInteger.FromInt64(Long.MAX_VALUE);
                }
                if (expoffset >= 0 && newScaleInt == 0 && newScale == null) {
                    ns = trialExponent;
                } else {
                    ns = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
                    ns = expoffset < 0 ? ns.Subtract(trialExponent) : ns.Add(trialExponent);
                }
            }
            int expwithin = EDecimal.CheckOverflowUnderflow(ctx, decimalPrec, ns);
            if (mantInt == 0 && (expwithin == 1 || expwithin == 2 || expwithin == 3)) {
                ret = new EDecimal(FastIntegerFixed.FromInt32(0), FastIntegerFixed.FromBig(ns), (byte)(negative ? 1 : 0));
                return EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
            }
            if (expwithin == 1) {
                return EDecimal.GetMathValue(ctx).SignalOverflow(ctx, negative);
            }
            if (expwithin == 2 || expwithin == 3 && mantInt < 0xCCCCCCB) {
                ret = new EDecimal(FastIntegerFixed.FromInt32(expwithin == 3 ? mantInt : 1), FastIntegerFixed.FromBig(ns), (byte)(negative ? 1 : 0));
                return EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
            }
            if (expwithin == 3 && (ctx == null || ctx.getTraps() == 0)) {
                ret = new EDecimal(FastIntegerFixed.FromInt32(1), FastIntegerFixed.FromBig(ns), (byte)(negative ? 1 : 0));
                ret = EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
                ns = ret.getExponent().Subtract(decimalPrec - 1);
                ret = new EDecimal(ret.unsignedMantissa.Copy(), FastIntegerFixed.FromBig(ns), ret.flags);
                return ret;
            }
        }
        int de = digitEnd;
        int dde = decimalDigitEnd;
        if (!haveExponent && haveDecimalPoint && de - digitStart + (dde - decimalDigitStart) <= 18 && newScale == null) {
            long lv = 0L;
            int expo = newScaleInt;
            if (mantInt <= 0xCCCCCCB) {
                lv = mantInt;
            } else {
                int vi = 0;
                for (vi = digitStart; vi < de; ++vi) {
                    lv = lv * 10L + (long)(str.charAt(vi) - 48);
                }
                for (vi = decimalDigitStart; vi < dde; ++vi) {
                    lv = lv * 10L + (long)(str.charAt(vi) - 48);
                }
            }
            if (negative) {
                lv = -lv;
            }
            if (!negative || lv != 0L) {
                ret = EDecimal.Create(lv, (long)expo);
                if (ctx != null) {
                    ret = EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
                }
                return ret;
            }
        }
        if (mantInt > 0xCCCCCCB) {
            if (haveDecimalPoint) {
                if (digitEnd - digitStart == 1 && str.charAt(digitStart) == '0') {
                    mant = EInteger.FromSubstring(str, decimalDigitStart, decimalDigitEnd);
                } else {
                    String decstr = str.substring(digitStart, digitStart + (digitEnd - digitStart)) + str.substring(decimalDigitStart, decimalDigitStart + (decimalDigitEnd - decimalDigitStart));
                    mant = EInteger.FromString(decstr);
                }
            } else {
                mant = EInteger.FromSubstring(str, digitStart, digitEnd);
            }
        }
        if (haveExponent && expInt > 0xCCCCCCB) {
            exp = EInteger.FromSubstring(str, expDigitStart, endStr);
            newScale = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale;
            newScale = expoffset < 0 ? newScale.Subtract(exp) : newScale.Add(exp);
        }
        FastIntegerFixed fastIntegerFixed = fastIntScale = newScale == null ? FastIntegerFixed.FromInt32(newScaleInt) : FastIntegerFixed.FromBig(newScale);
        if (mant == null) {
            fastIntMant = FastIntegerFixed.FromInt32(mantInt);
        } else if (mant.CanFitInInt32()) {
            mantInt = mant.ToInt32Checked();
            fastIntMant = FastIntegerFixed.FromInt32(mantInt);
        } else {
            fastIntMant = FastIntegerFixed.FromBig(mant);
        }
        ret = new EDecimal(fastIntMant, fastIntScale, (byte)(negative ? 1 : 0));
        if (ctx != null) {
            ret = EDecimal.GetMathValue(ctx).RoundAfterConversion(ret, ctx);
        }
        return ret;
    }

    private static int CheckOverflowUnderflow(EContext ec, int precisionInt, EInteger exponent) {
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        if (precisionInt < 0) {
            throw new IllegalArgumentException("doesn't satisfy precision.signum()>= 0");
        }
        if (ec == null || !ec.getHasExponentRange()) {
            return 0;
        }
        if (ec.getAdjustExponent()) {
            if (ec.isPrecisionInBits()) {
                if (exponent.compareTo(ec.getEMax()) > 0) {
                    return 1;
                }
            } else {
                EInteger adjExponent = exponent.Add(precisionInt).Subtract(1);
                if (adjExponent.compareTo(ec.getEMax()) > 0) {
                    return 1;
                }
                if (ec.getHasMaxPrecision()) {
                    EInteger etiny = ec.getEMin().Subtract(ec.getPrecision().Subtract(1));
                    if (adjExponent.compareTo(etiny = etiny.Subtract(1)) < 0) {
                        return 2;
                    }
                } else {
                    EInteger etiny = ec.getEMin().Subtract(precisionInt - 1);
                    if (adjExponent.compareTo(etiny = etiny.Subtract(1)) < 0) {
                        return 3;
                    }
                }
            }
        } else {
            if (exponent.compareTo(ec.getEMax()) > 0) {
                return 1;
            }
            if (!ec.isPrecisionInBits()) {
                EInteger adjExponent = exponent.Add(precisionInt).Subtract(1);
                EInteger etiny = ec.getHasMaxPrecision() ? ec.getEMin().Subtract(ec.getPrecision().Subtract(1)) : ec.getEMin().Subtract(precisionInt - 1);
                if (adjExponent.compareTo(etiny = etiny.Subtract(1)) < 0) {
                    return 2;
                }
            }
        }
        return 0;
    }

    public static EDecimal Max(EDecimal first, EDecimal second, EContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EDecimal.GetMathValue(ctx).Max(first, second, ctx);
    }

    public static EDecimal Max(EDecimal first, EDecimal second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EDecimal.Max(first, second, null);
    }

    public static EDecimal MaxMagnitude(EDecimal first, EDecimal second, EContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EDecimal.GetMathValue(ctx).MaxMagnitude(first, second, ctx);
    }

    public static EDecimal MaxMagnitude(EDecimal first, EDecimal second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EDecimal.MaxMagnitude(first, second, null);
    }

    public static EDecimal Min(EDecimal first, EDecimal second, EContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EDecimal.GetMathValue(ctx).Min(first, second, ctx);
    }

    public static EDecimal Min(EDecimal first, EDecimal second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EDecimal.Min(first, second, null);
    }

    public static EDecimal MinMagnitude(EDecimal first, EDecimal second, EContext ctx) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EDecimal.GetMathValue(ctx).MinMagnitude(first, second, ctx);
    }

    public static EDecimal MinMagnitude(EDecimal first, EDecimal second) {
        if (first == null) {
            throw new NullPointerException("first");
        }
        if (second == null) {
            throw new NullPointerException("second");
        }
        return EDecimal.MinMagnitude(first, second, null);
    }

    public static EDecimal PI(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Pi(ctx);
    }

    public EDecimal Abs() {
        if (this.isNegative()) {
            EDecimal er = new EDecimal(this.unsignedMantissa, this.exponent, (byte)(this.flags & 0xFFFFFFFE));
            return er;
        }
        return this;
    }

    public EDecimal CopySign(EDecimal other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        if (this.isNegative()) {
            return other.isNegative() ? this : this.Negate();
        }
        return other.isNegative() ? this.Negate() : this;
    }

    public EDecimal Abs(EContext context) {
        return (context == null || context == EContext.UnlimitedHalfEven ? ExtendedMathValue : MathValue).Abs(this, context);
    }

    public EDecimal Add(EDecimal otherValue) {
        if (this.isFinite() && otherValue != null && otherValue.isFinite() && ((this.flags | otherValue.flags) & 1) == 0 && this.exponent.compareTo(otherValue.exponent) == 0) {
            FastIntegerFixed result = FastIntegerFixed.Add(this.unsignedMantissa, otherValue.unsignedMantissa);
            return new EDecimal(result, this.exponent, 0);
        }
        return this.Add(otherValue, EContext.UnlimitedHalfEven);
    }

    public EDecimal Add(EDecimal otherValue, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Add(this, otherValue, ctx);
    }

    @Override
    public int compareTo(EDecimal other) {
        return this.CompareToValue(other);
    }

    @Override
    public int compareTo(int intOther) {
        return this.CompareToValue(EDecimal.FromInt32(intOther));
    }

    public int CompareToValue(int intOther) {
        return this.CompareToValue(EDecimal.FromInt32(intOther));
    }

    public int CompareToValue(EDecimal other) {
        return ExtendedMathValue.compareTo(this, other);
    }

    public int CompareToBinary(EFloat other) {
        return EDecimal.CompareEDecimalToEFloat(this, other);
    }

    private static int CompareEDecimalToEFloat(EDecimal ed, EFloat ef) {
        int signB;
        if (ef == null) {
            return 1;
        }
        if (ed.IsNaN()) {
            return ef.IsNaN() ? 0 : 1;
        }
        int signA = ed.signum();
        if (signA != (signB = ef.signum())) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        if (ed.IsInfinity()) {
            if (ef.IsInfinity()) {
                return 0;
            }
            return ed.isNegative() ? -1 : 1;
        }
        if (ef.IsInfinity()) {
            return ef.isNegative() ? 1 : -1;
        }
        if (ef.getExponent().compareTo(EInteger.FromInt64(-1000L)) < 0) {
            if (ef.Abs(null).compareTo(EFloat.One) < 0 && ed.Abs(null).compareTo(One) >= 0) {
                return signA > 0 ? 1 : -1;
            }
            EInteger bitCount = ef.getMantissa().GetUnsignedBitLengthAsEInteger();
            EInteger absexp = ef.getExponent().Abs();
            if (absexp.compareTo(bitCount) > 0) {
                EFloat trial = EFloat.Create(ef.getMantissa(), EInteger.FromInt32(-1000));
                int trialcmp = EDecimal.CompareEDecimalToEFloat(ed, trial);
                if (ef.signum() < 0 && trialcmp < 0) {
                    return -1;
                }
                if (ef.signum() > 0 && trialcmp > 0) {
                    return 1;
                }
            }
            EInteger[] thisAdjExpBounds = EDecimal.GetAdjustedExponentDecimalBounds(ed);
            EInteger otherAdjExp = EDecimal.GetAdjustedExponentBinary(ef);
            if (thisAdjExpBounds[0].signum() < 0 && thisAdjExpBounds[0].compareTo(-1000) >= 0 && otherAdjExp.compareTo(-4000) < 0) {
                return signA > 0 ? 1 : -1;
            }
            if (thisAdjExpBounds[1].signum() < 0 && thisAdjExpBounds[1].compareTo(-1000) < 0 && otherAdjExp.compareTo(-1000) < 0) {
                EInteger divisor1 = thisAdjExpBounds[0].Add(1).Abs();
                EInteger divisor2 = thisAdjExpBounds[1].Add(1).Abs();
                otherAdjExp = otherAdjExp.Add(1).Abs();
                EInteger adjexp = EInteger.Min(divisor1, divisor2);
                EInteger ratio = otherAdjExp.Multiply(1000).Divide(adjexp);
                if (ratio.compareTo(3321) < 0) {
                    return signA > 0 ? -1 : 1;
                }
                adjexp = EInteger.Max(divisor1, divisor2);
                ratio = otherAdjExp.Multiply(1000).Divide(adjexp);
                if (ratio.compareTo(3322) > 0) {
                    return signA > 0 ? 1 : -1;
                }
            }
        }
        if (ef.getExponent().compareTo(1000) > 0) {
            EInteger bignum = EInteger.FromInt32(1).ShiftLeft(999);
            if (ed.Abs(null).CompareToValue(EDecimal.FromEInteger(bignum)) <= 0) {
                return signA > 0 ? -1 : 1;
            }
            EInteger[] thisAdjExpBounds = EDecimal.GetAdjustedExponentDecimalBounds(ed);
            EInteger otherAdjExp = EDecimal.GetAdjustedExponentBinary(ef);
            if (thisAdjExpBounds[0].signum() > 0 && thisAdjExpBounds[0].compareTo(otherAdjExp) >= 0) {
                return signA > 0 ? 1 : -1;
            }
            if (thisAdjExpBounds[1].signum() > 0 && thisAdjExpBounds[1].compareTo(1000) < 0 && otherAdjExp.compareTo(4000) >= 0) {
                return signA > 0 ? -1 : 1;
            }
            if (thisAdjExpBounds[0].signum() > 0 && thisAdjExpBounds[0].compareTo(1000) >= 0 && otherAdjExp.compareTo(1000) >= 0) {
                EInteger divisor1 = thisAdjExpBounds[0].Add(1);
                EInteger divisor2 = thisAdjExpBounds[1].Add(1);
                otherAdjExp = otherAdjExp.Add(1);
                EInteger adjexp = EInteger.Min(divisor1, divisor2);
                EInteger ratio = otherAdjExp.Multiply(1000).Divide(adjexp);
                if (ratio.compareTo(3321) < 0) {
                    return signA > 0 ? 1 : -1;
                }
                adjexp = EInteger.Max(divisor1, divisor2);
                ratio = otherAdjExp.Multiply(1000).Divide(adjexp);
                if (ratio.compareTo(3322) >= 0) {
                    return signA > 0 ? -1 : 1;
                }
            }
        }
        EDecimal otherDec = EDecimal.FromEFloat(ef);
        return ed.compareTo(otherDec);
    }

    public EDecimal CompareToSignal(EDecimal other, EContext ctx) {
        return EDecimal.GetMathValue(ctx).CompareToWithContext(this, other, true, ctx);
    }

    public int CompareToTotalMagnitude(EDecimal other) {
        if (other == null) {
            return 1;
        }
        int valueIThis = 0;
        int valueIOther = 0;
        if (this.IsSignalingNaN()) {
            valueIThis = 2;
        } else if (this.IsNaN()) {
            valueIThis = 3;
        } else if (this.IsInfinity()) {
            valueIThis = 1;
        }
        if (other.IsSignalingNaN()) {
            valueIOther = 2;
        } else if (other.IsNaN()) {
            valueIOther = 3;
        } else if (other.IsInfinity()) {
            valueIOther = 1;
        }
        if (valueIThis > valueIOther) {
            return 1;
        }
        if (valueIThis < valueIOther) {
            return -1;
        }
        if (valueIThis >= 2) {
            int cmp = this.unsignedMantissa.compareTo(other.unsignedMantissa);
            return cmp;
        }
        if (valueIThis == 1) {
            return 0;
        }
        int cmp = this.Abs().compareTo(other.Abs());
        if (cmp == 0) {
            cmp = this.exponent.compareTo(other.exponent);
            return cmp;
        }
        return cmp;
    }

    public int CompareToTotal(EDecimal other, EContext ctx) {
        if (other == null) {
            return 1;
        }
        if (this.IsSignalingNaN() || other.IsSignalingNaN()) {
            return this.CompareToTotal(other);
        }
        if (ctx != null && ctx.isSimplified()) {
            return this.RoundToPrecision(ctx).CompareToTotal(other.RoundToPrecision(ctx));
        }
        return this.CompareToTotal(other);
    }

    public int CompareToTotalMagnitude(EDecimal other, EContext ctx) {
        if (other == null) {
            return 1;
        }
        if (this.IsSignalingNaN() || other.IsSignalingNaN()) {
            return this.CompareToTotalMagnitude(other);
        }
        if (ctx != null && ctx.isSimplified()) {
            return this.RoundToPrecision(ctx).CompareToTotalMagnitude(other.RoundToPrecision(ctx));
        }
        return this.CompareToTotalMagnitude(other);
    }

    public int CompareToTotal(EDecimal other) {
        boolean neg2;
        if (other == null) {
            return -1;
        }
        boolean neg1 = this.isNegative();
        if (neg1 != (neg2 = other.isNegative())) {
            return neg1 ? -1 : 1;
        }
        int valueIThis = 0;
        int valueIOther = 0;
        if (this.IsSignalingNaN()) {
            valueIThis = 2;
        } else if (this.IsNaN()) {
            valueIThis = 3;
        } else if (this.IsInfinity()) {
            valueIThis = 1;
        }
        if (other.IsSignalingNaN()) {
            valueIOther = 2;
        } else if (other.IsNaN()) {
            valueIOther = 3;
        } else if (other.IsInfinity()) {
            valueIOther = 1;
        }
        if (valueIThis > valueIOther) {
            return neg1 ? -1 : 1;
        }
        if (valueIThis < valueIOther) {
            return neg1 ? 1 : -1;
        }
        if (valueIThis >= 2) {
            int cmp = this.unsignedMantissa.compareTo(other.unsignedMantissa);
            return neg1 ? -cmp : cmp;
        }
        if (valueIThis == 1) {
            return 0;
        }
        int cmp = this.compareTo(other);
        if (cmp == 0) {
            cmp = this.exponent.compareTo(other.exponent);
            return neg1 ? -cmp : cmp;
        }
        return cmp;
    }

    public EDecimal CompareToWithContext(EDecimal other, EContext ctx) {
        return EDecimal.GetMathValue(ctx).CompareToWithContext(this, other, false, ctx);
    }

    public EDecimal Divide(EDecimal divisor) {
        return this.Divide(divisor, EContext.ForRounding(ERounding.None));
    }

    public EDecimal Divide(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Divide(this, divisor, ctx);
    }

    @Deprecated
    public EDecimal[] DivideAndRemainderNaturalScale(EDecimal divisor) {
        return this.DivRemNaturalScale(divisor, null);
    }

    @Deprecated
    public EDecimal[] DivideAndRemainderNaturalScale(EDecimal divisor, EContext ctx) {
        return this.DivRemNaturalScale(divisor, ctx);
    }

    public EDecimal[] DivRemNaturalScale(EDecimal divisor) {
        return this.DivRemNaturalScale(divisor, null);
    }

    public EDecimal[] DivRemNaturalScale(EDecimal divisor, EContext ctx) {
        EDecimal[] result;
        result = new EDecimal[]{this.DivideToIntegerNaturalScale(divisor, null), this.Subtract(result[0].Multiply(divisor, null), ctx)};
        result[0] = result[0].RoundToPrecision(ctx);
        return result;
    }

    public EDecimal DivideToExponent(EDecimal divisor, long desiredExponentSmall, EContext ctx) {
        return this.DivideToExponent(divisor, EInteger.FromInt64(desiredExponentSmall), ctx);
    }

    public EDecimal DivideToExponent(EDecimal divisor, int desiredExponentInt, EContext ctx) {
        return this.DivideToExponent(divisor, EInteger.FromInt32(desiredExponentInt), ctx);
    }

    public EDecimal DivideToExponent(EDecimal divisor, long desiredExponentSmall, ERounding rounding) {
        return this.DivideToExponent(divisor, EInteger.FromInt64(desiredExponentSmall), EContext.ForRounding(rounding));
    }

    public EDecimal DivideToExponent(EDecimal divisor, int desiredExponentInt, ERounding rounding) {
        return this.DivideToExponent(divisor, EInteger.FromInt32(desiredExponentInt), EContext.ForRounding(rounding));
    }

    public EDecimal DivideToExponent(EDecimal divisor, EInteger exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).DivideToExponent(this, divisor, exponent, ctx);
    }

    public EDecimal DivideToExponent(EDecimal divisor, EInteger exponent) {
        return this.DivideToExponent(divisor, exponent, ERounding.HalfEven);
    }

    public EDecimal DivideToExponent(EDecimal divisor, long desiredExponentSmall) {
        return this.DivideToExponent(divisor, desiredExponentSmall, ERounding.HalfEven);
    }

    public EDecimal DivideToExponent(EDecimal divisor, int desiredExponentInt) {
        return this.DivideToExponent(divisor, desiredExponentInt, ERounding.HalfEven);
    }

    public EDecimal DivideToExponent(EDecimal divisor, EInteger desiredExponent, ERounding rounding) {
        return this.DivideToExponent(divisor, desiredExponent, EContext.ForRounding(rounding));
    }

    public EDecimal DivideToIntegerNaturalScale(EDecimal divisor) {
        return this.DivideToIntegerNaturalScale(divisor, EContext.ForRounding(ERounding.Down));
    }

    public EDecimal DivideToIntegerNaturalScale(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).DivideToIntegerNaturalScale(this, divisor, ctx);
    }

    public EDecimal DivideToIntegerZeroScale(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).DivideToIntegerZeroScale(this, divisor, ctx);
    }

    public EDecimal DivideToSameExponent(EDecimal divisor, ERounding rounding) {
        return this.DivideToExponent(divisor, this.exponent.ToEInteger(), EContext.ForRounding(rounding));
    }

    public boolean equals(EDecimal other) {
        return this.EqualsInternal(other);
    }

    public boolean equals(Object obj) {
        return this.EqualsInternal(obj instanceof EDecimal ? (EDecimal)obj : null);
    }

    public EDecimal Exp(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Exp(this, ctx);
    }

    public int hashCode() {
        int valueHashCode = 964453631;
        valueHashCode += 964453723 * this.exponent.hashCode();
        valueHashCode += 964453939 * this.unsignedMantissa.hashCode();
        return valueHashCode += 964453967 * this.flags;
    }

    public boolean IsInfinity() {
        return (this.flags & 2) != 0;
    }

    public boolean IsNaN() {
        return (this.flags & 0xC) != 0;
    }

    public boolean IsNegativeInfinity() {
        return (this.flags & 3) == 3;
    }

    public boolean IsPositiveInfinity() {
        return (this.flags & 3) == 2;
    }

    public boolean IsQuietNaN() {
        return (this.flags & 4) != 0;
    }

    public boolean IsSignalingNaN() {
        return (this.flags & 8) != 0;
    }

    public EDecimal Log(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Ln(this, ctx);
    }

    public EDecimal Log10(EContext ctx) {
        return this.LogN(EDecimal.FromInt32(10), ctx);
    }

    public EDecimal LogN(EDecimal baseValue, EContext ctx) {
        EDecimal value = this;
        if (baseValue == null) {
            throw new NullPointerException("baseValue");
        }
        if (value.IsNaN()) {
            return value.Plus(ctx);
        }
        if (baseValue.IsNaN()) {
            return baseValue.Plus(ctx);
        }
        if (ctx == null || !ctx.getHasMaxPrecision() || value.isNegative() && !value.isZero() || baseValue.isNegative() && !baseValue.isZero()) {
            return SignalingNaN.Plus(ctx);
        }
        if (ctx.getTraps() != 0) {
            EContext tctx = ctx.GetNontrapping();
            EDecimal ret = value.LogN(baseValue, tctx);
            return ctx.TriggerTraps(ret, tctx);
        }
        if (ctx.isSimplified()) {
            EContext tmpctx = ctx.WithSimplified(false).WithBlankFlags();
            EDecimal ret = value.PreRound(ctx).LogN(baseValue.PreRound(ctx), tmpctx);
            if (ctx.getHasFlags()) {
                int flags = ctx.getFlags();
                ctx.setFlags(flags | tmpctx.getFlags());
            }
            return ret.RoundToPrecision(ctx);
        }
        if (value.isZero()) {
            return baseValue.compareTo(1) < 0 ? PositiveInfinity : NegativeInfinity;
        }
        if (value.IsPositiveInfinity()) {
            return baseValue.compareTo(1) < 0 ? NegativeInfinity : PositiveInfinity;
        }
        if (baseValue.compareTo(10) == 0) {
            EDecimal ev = value.Reduce(null);
            if (ev.getUnsignedMantissa().compareTo(1) == 0) {
                return EDecimal.FromEInteger(ev.getExponent()).Plus(ctx);
            }
        } else {
            if (value.compareTo(1) == 0) {
                return EDecimal.FromInt32(0).Plus(ctx);
            }
            if (value.compareTo(baseValue) == 0) {
                return EDecimal.FromInt32(1).Plus(ctx);
            }
        }
        int flags = ctx.getFlags();
        EContext tmpctx = ctx.WithBigPrecision(ctx.getPrecision().Add(5)).WithBlankFlags();
        EDecimal ret = value.Log(tmpctx).Divide(baseValue.Log(tmpctx), ctx);
        if (ret.IsInteger() && !ret.isZero()) {
            EDecimal rtmp;
            flags |= 3;
            if (baseValue.Pow(ret).CompareToValue(value) == 0 && !(rtmp = ret.Quantize(EDecimal.FromInt32(1), ctx.WithNoFlags())).IsNaN()) {
                flags &= 0xFFFFFFFC;
                ret = rtmp;
            }
        } else {
            flags |= tmpctx.getFlags();
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(flags |= ctx.getFlags());
        }
        return ret;
    }

    public EDecimal MovePointLeft(int places) {
        return this.MovePointLeft(EInteger.FromInt32(places), null);
    }

    public EDecimal MovePointLeft(int places, EContext ctx) {
        return this.MovePointLeft(EInteger.FromInt32(places), ctx);
    }

    public EDecimal MovePointLeft(EInteger bigPlaces) {
        return this.MovePointLeft(bigPlaces, null);
    }

    public EDecimal MovePointLeft(EInteger bigPlaces, EContext ctx) {
        return !this.isFinite() ? this.RoundToPrecision(ctx) : this.MovePointRight(bigPlaces.Negate(), ctx);
    }

    public EDecimal MovePointRight(int places) {
        return this.MovePointRight(EInteger.FromInt32(places), null);
    }

    public EDecimal MovePointRight(int places, EContext ctx) {
        return this.MovePointRight(EInteger.FromInt32(places), ctx);
    }

    public EDecimal MovePointRight(EInteger bigPlaces) {
        return this.MovePointRight(bigPlaces, null);
    }

    public EDecimal MovePointRight(EInteger bigPlaces, EContext ctx) {
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        EInteger bigExp = this.getExponent();
        if ((bigExp = bigExp.Add(bigPlaces)).signum() > 0) {
            EInteger mant = this.unsignedMantissa.ToEInteger();
            EInteger bigPower = NumberUtility.FindPowerOfTenFromBig(bigExp);
            mant = mant.Multiply(bigPower);
            return EDecimal.CreateWithFlags(mant, EInteger.FromInt32(0), (int)this.flags).RoundToPrecision(ctx);
        }
        return EDecimal.CreateWithFlags(this.unsignedMantissa, FastIntegerFixed.FromBig(bigExp), (int)this.flags).RoundToPrecision(ctx);
    }

    public EDecimal Multiply(EDecimal otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.isFinite() && otherValue.isFinite()) {
            int newflags = otherValue.flags ^ this.flags;
            if (this.unsignedMantissa.CanFitInInt32() && otherValue.unsignedMantissa.CanFitInInt32()) {
                int integerA = this.unsignedMantissa.ToInt32();
                int integerB = otherValue.unsignedMantissa.ToInt32();
                long longA = (long)integerA * (long)integerB;
                FastIntegerFixed exp = FastIntegerFixed.Add(this.exponent, otherValue.exponent);
                if (longA >> 31 == 0L) {
                    return new EDecimal(FastIntegerFixed.FromInt32((int)longA), exp, (byte)newflags);
                }
                return new EDecimal(FastIntegerFixed.FromBig(EInteger.FromInt64(longA)), exp, (byte)newflags);
            }
            EInteger eintA = this.unsignedMantissa.ToEInteger().Multiply(otherValue.unsignedMantissa.ToEInteger());
            return new EDecimal(FastIntegerFixed.FromBig(eintA), FastIntegerFixed.Add(this.exponent, otherValue.exponent), (byte)newflags);
        }
        return this.Multiply(otherValue, EContext.UnlimitedHalfEven);
    }

    public EDecimal Multiply(EDecimal op, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Multiply(this, op, ctx);
    }

    public EDecimal Add(int intValue) {
        return this.Add(EDecimal.FromInt32(intValue));
    }

    public EDecimal Subtract(int intValue) {
        return intValue == Integer.MIN_VALUE ? this.Subtract(EDecimal.FromInt32(intValue)) : this.Add(-intValue);
    }

    public EDecimal Multiply(int intValue) {
        return this.Multiply(EDecimal.FromInt32(intValue));
    }

    public EDecimal Divide(int intValue) {
        return this.Divide(EDecimal.FromInt32(intValue));
    }

    public EDecimal MultiplyAndAdd(EDecimal multiplicand, EDecimal augend) {
        return this.MultiplyAndAdd(multiplicand, augend, null);
    }

    public EDecimal MultiplyAndAdd(EDecimal op, EDecimal augend, EContext ctx) {
        return EDecimal.GetMathValue(ctx).MultiplyAndAdd(this, op, augend, ctx);
    }

    public EDecimal MultiplyAndSubtract(EDecimal op, EDecimal subtrahend, EContext ctx) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (subtrahend == null) {
            throw new NullPointerException("subtrahend");
        }
        EDecimal negated = subtrahend;
        if ((subtrahend.flags & 0xC) == 0) {
            int newflags = subtrahend.flags ^ 1;
            negated = EDecimal.CreateWithFlags(subtrahend.unsignedMantissa, subtrahend.exponent, newflags);
        }
        return EDecimal.GetMathValue(ctx).MultiplyAndAdd(this, op, negated, ctx);
    }

    public EDecimal Negate() {
        return new EDecimal(this.unsignedMantissa, this.exponent, (byte)(this.flags ^ 1));
    }

    public EDecimal Negate(EContext context) {
        return (context == null || context == EContext.UnlimitedHalfEven ? ExtendedMathValue : MathValue).Negate(this, context);
    }

    public EDecimal NextMinus(EContext ctx) {
        return EDecimal.GetMathValue(ctx).NextMinus(this, ctx);
    }

    public EDecimal NextPlus(EContext ctx) {
        return EDecimal.GetMathValue(ctx).NextPlus(this, ctx);
    }

    public EDecimal NextToward(EDecimal otherValue, EContext ctx) {
        return EDecimal.GetMathValue(ctx).NextToward(this, otherValue, ctx);
    }

    public EDecimal Plus(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Plus(this, ctx);
    }

    public EDecimal Pow(EDecimal exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Power(this, exponent, ctx);
    }

    public EDecimal Pow(EDecimal exponent) {
        return this.Pow(exponent, null);
    }

    public EDecimal Pow(int exponentSmall, EContext ctx) {
        return this.Pow(EDecimal.FromInt64(exponentSmall), ctx);
    }

    public EDecimal Pow(int exponentSmall) {
        return this.Pow(EDecimal.FromInt64(exponentSmall), null);
    }

    public EInteger Precision() {
        if (!this.isFinite()) {
            return EInteger.FromInt32(0);
        }
        return this.isZero() ? EInteger.FromInt32(1) : this.unsignedMantissa.ToEInteger().GetDigitCountAsEInteger();
    }

    public EDecimal Quantize(EInteger desiredExponent, EContext ctx) {
        return this.Quantize(EDecimal.Create(EInteger.FromInt32(1), desiredExponent), ctx);
    }

    public EDecimal Quantize(int desiredExponentInt, ERounding rounding) {
        EDecimal ret = this.RoundToExponentFast(desiredExponentInt, rounding);
        if (ret != null) {
            return ret;
        }
        return this.Quantize(EDecimal.Create(EInteger.FromInt32(1), EInteger.FromInt32(desiredExponentInt)), EContext.ForRounding(rounding));
    }

    public EDecimal Quantize(int desiredExponentInt, EContext ctx) {
        EDecimal ret;
        if (!(ctx != null && (ctx.getHasExponentRange() || ctx.getHasFlagsOrTraps() || ctx.getHasMaxPrecision() || ctx.isSimplified()) || (ret = this.RoundToExponentFast(desiredExponentInt, ctx == null ? ERounding.HalfEven : ctx.getRounding())) == null)) {
            return ret;
        }
        return this.Quantize(EDecimal.Create(EInteger.FromInt32(1), EInteger.FromInt32(desiredExponentInt)), ctx);
    }

    public EDecimal Quantize(EDecimal otherValue, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Quantize(this, otherValue, ctx);
    }

    public EDecimal Reduce(EContext ctx) {
        return EDecimal.GetMathValue(ctx).Reduce(this, ctx);
    }

    public EDecimal Remainder(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Remainder(this, divisor, ctx, true);
    }

    public EDecimal RemainderNoRoundAfterDivide(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).Remainder(this, divisor, ctx, false);
    }

    public EDecimal RemainderNaturalScale(EDecimal divisor) {
        return this.RemainderNaturalScale(divisor, null);
    }

    public EDecimal RemainderNaturalScale(EDecimal divisor, EContext ctx) {
        return this.Subtract(this.DivideToIntegerNaturalScale(divisor, null).Multiply(divisor, null), ctx);
    }

    public EDecimal RemainderNear(EDecimal divisor, EContext ctx) {
        return EDecimal.GetMathValue(ctx).RemainderNear(this, divisor, ctx);
    }

    public EDecimal RoundToExponent(EInteger exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentSimple(this, exponent, ctx);
    }

    public EDecimal RoundToExponent(EInteger exponent) {
        return this.RoundToExponent(exponent, EContext.ForRounding(ERounding.HalfEven));
    }

    public EDecimal RoundToExponent(EInteger exponent, ERounding rounding) {
        return this.RoundToExponent(exponent, EContext.ForRounding(rounding));
    }

    public EDecimal RoundToExponent(int exponentSmall) {
        return this.RoundToExponent(exponentSmall, ERounding.HalfEven);
    }

    public EDecimal RoundToExponent(int exponentSmall, EContext ctx) {
        EDecimal ret;
        if (!(ctx != null && (ctx.getHasExponentRange() || ctx.getHasFlagsOrTraps() || ctx.getHasMaxPrecision() || ctx.isSimplified()) || (ret = this.RoundToExponentFast(exponentSmall, ctx == null ? ERounding.HalfEven : ctx.getRounding())) == null)) {
            return ret;
        }
        return this.RoundToExponent(EInteger.FromInt32(exponentSmall), ctx);
    }

    public EDecimal RoundToExponent(int exponentSmall, ERounding rounding) {
        EDecimal ret = this.RoundToExponentFast(exponentSmall, rounding);
        if (ret != null) {
            return ret;
        }
        return this.RoundToExponent(exponentSmall, EContext.ForRounding(rounding));
    }

    public EDecimal RoundToExponentExact(EInteger exponent, EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentExact(this, exponent, ctx);
    }

    public EDecimal RoundToExponentExact(int exponentSmall, EContext ctx) {
        return this.RoundToExponentExact(EInteger.FromInt32(exponentSmall), ctx);
    }

    public EDecimal RoundToExponentExact(int exponentSmall, ERounding rounding) {
        return this.RoundToExponentExact(EInteger.FromInt32(exponentSmall), EContext.Unlimited.WithRounding(rounding));
    }

    public EDecimal RoundToIntegerExact(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentExact(this, EInteger.FromInt32(0), ctx);
    }

    public EDecimal RoundToIntegerNoRoundedFlag(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentNoRoundedFlag(this, EInteger.FromInt32(0), ctx);
    }

    @Deprecated
    public EDecimal RoundToIntegralExact(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentExact(this, EInteger.FromInt32(0), ctx);
    }

    @Deprecated
    public EDecimal RoundToIntegralNoRoundedFlag(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToExponentNoRoundedFlag(this, EInteger.FromInt32(0), ctx);
    }

    public EDecimal RoundToPrecision(EContext ctx) {
        return EDecimal.GetMathValue(ctx).RoundToPrecision(this, ctx);
    }

    public EDecimal PreRound(EContext ctx) {
        return NumberUtility.PreRound(this, ctx, EDecimal.GetMathValue(ctx));
    }

    public EDecimal ScaleByPowerOfTen(int places) {
        return this.ScaleByPowerOfTen(EInteger.FromInt32(places), null);
    }

    public EDecimal ScaleByPowerOfTen(int places, EContext ctx) {
        return this.ScaleByPowerOfTen(EInteger.FromInt32(places), ctx);
    }

    public EDecimal ScaleByPowerOfTen(EInteger bigPlaces) {
        return this.ScaleByPowerOfTen(bigPlaces, null);
    }

    public EDecimal ScaleByPowerOfTen(EInteger bigPlaces, EContext ctx) {
        if (bigPlaces == null) {
            throw new NullPointerException("bigPlaces");
        }
        if (bigPlaces.isZero()) {
            return this.RoundToPrecision(ctx);
        }
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        EInteger bigExp = this.getExponent();
        bigExp = bigExp.Add(bigPlaces);
        return EDecimal.CreateWithFlags(this.unsignedMantissa, FastIntegerFixed.FromBig(bigExp), (int)this.flags).RoundToPrecision(ctx);
    }

    public EDecimal Sqrt(EContext ctx) {
        return EDecimal.GetMathValue(ctx).SquareRoot(this, ctx);
    }

    @Deprecated
    public EDecimal SquareRoot(EContext ctx) {
        return EDecimal.GetMathValue(ctx).SquareRoot(this, ctx);
    }

    public EDecimal Subtract(EDecimal otherValue) {
        return this.Subtract(otherValue, EContext.UnlimitedHalfEven);
    }

    public EDecimal Subtract(EDecimal otherValue, EContext ctx) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        EDecimal negated = otherValue;
        if ((otherValue.flags & 0xC) == 0) {
            int newflags = otherValue.flags ^ 1;
            negated = EDecimal.CreateWithFlags(otherValue.unsignedMantissa, otherValue.exponent, newflags);
        }
        return this.Add(negated, ctx);
    }

    public double ToDouble() {
        if (this.IsPositiveInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.isNegative() && this.isZero()) {
            int highbit = Integer.MIN_VALUE;
            return Extras.IntegersToDouble(new int[]{0, highbit});
        }
        if (this.isZero()) {
            return 0.0;
        }
        if (this.isFinite()) {
            long v;
            if (this.exponent.CompareToInt(0) == 0 && this.unsignedMantissa.CanFitInInt64() && (v = this.unsignedMantissa.ToInt64()) <= 0x20000000000000L) {
                return this.isNegative() ? (double)(-v) : (double)v;
            }
            if (this.exponent.CompareToInt(0) < 0 && this.exponent.CompareToInt(-8) >= 0 && this.unsignedMantissa.CanFitInInt32()) {
                int m = this.unsignedMantissa.ToInt32();
                int iex = -this.exponent.ToInt32();
                int vtp = ValueTenPowers[iex];
                if (m != Integer.MIN_VALUE) {
                    int divsCount;
                    long am;
                    if (m % vtp == 0) {
                        double dn = m / vtp;
                        return this.isNegative() ? -dn : dn;
                    }
                    for (am = (long)Math.abs(m); am < 0x100000L; am <<= 1) {
                    }
                    if (am % (long)vtp == 0L) {
                        double dn = (double)m / (double)vtp;
                        return this.isNegative() ? -dn : dn;
                    }
                    int divdCount = NumberUtility.BitLength(m);
                    int dividendShift = divdCount <= (divsCount = NumberUtility.BitLength(vtp)) ? divsCount - divdCount + 53 + 1 : Math.max(0, 54 - (divdCount - divsCount));
                    long lquo = -1L;
                    long lrem = -1L;
                    if (divsCount + dividendShift > 63) {
                        EInteger eim = EInteger.FromInt32(m).ShiftLeft(dividendShift);
                        EInteger[] divrem3 = eim.DivRem(EInteger.FromInt32(vtp));
                        EInteger equo = divrem3[0];
                        EInteger erem = divrem3[1];
                        if (equo.CanFitInInt64() && erem.CanFitInInt64()) {
                            lquo = equo.ToInt64Checked();
                            lrem = erem.ToInt64Checked();
                        }
                    } else {
                        long ldividend = (long)m << dividendShift;
                        lquo = ldividend / (long)vtp;
                        lrem = ldividend - lquo * (long)vtp;
                    }
                    int nexp = -dividendShift;
                    if (lquo >= 0x20000000000000L) {
                        while (lquo >= 0x40000000000000L) {
                            lrem |= lquo & 1L;
                            lquo >>= 1;
                            ++nexp;
                        }
                        if ((lquo & 3L) == 3L && lrem == 0L) {
                            lquo >>= 1;
                            ++lquo;
                            ++nexp;
                        } else if ((lquo & 1L) != 0L && lrem != 0L) {
                            lquo >>= 1;
                            ++lquo;
                            ++nexp;
                        } else {
                            lquo >>= 1;
                            ++nexp;
                        }
                        while (lquo >= 0x20000000000000L) {
                            lquo >>= 1;
                            ++nexp;
                        }
                        int mb0 = (int)(lquo & 0xFFFFFFFFL);
                        int mb1 = (int)(lquo >> 32 & 0xFFFFFFFFL);
                        mb1 &= 0xFFFFF;
                        mb1 |= nexp + 1075 << 20;
                        if (this.isNegative()) {
                            mb1 |= Integer.MIN_VALUE;
                        }
                        return Extras.IntegersToDouble(mb0, mb1);
                    }
                }
            }
            if (this.exponent.CompareToInt(309) > 0) {
                return this.isNegative() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
        }
        return this.ToEFloat(EContext.Binary64).ToDouble();
    }

    public EInteger ToEInteger() {
        return this.ToEIntegerInternal(false);
    }

    @Deprecated
    public EInteger ToEIntegerExact() {
        return this.ToEIntegerInternal(true);
    }

    public EInteger ToEIntegerIfExact() {
        return this.ToEIntegerInternal(true);
    }

    public String ToEngineeringString() {
        return this.ToStringInternal(1);
    }

    @Deprecated
    public EFloat ToExtendedFloat() {
        return this.ToEFloat(EContext.UnlimitedHalfEven);
    }

    public EFloat ToEFloat() {
        return this.ToEFloat(EContext.UnlimitedHalfEven);
    }

    public String ToPlainString() {
        return this.ToStringInternal(2);
    }

    public float ToSingle() {
        if (this.IsPositiveInfinity()) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.isNegative() && this.isZero()) {
            return Float.intBitsToFloat(Integer.MIN_VALUE);
        }
        if (this.isZero()) {
            return 0.0f;
        }
        if (this.isFinite()) {
            int v;
            if (this.exponent.CompareToInt(0) == 0 && this.unsignedMantissa.CanFitInInt32() && (v = this.unsignedMantissa.ToInt32()) <= 0x1000000) {
                return this.isNegative() ? (float)(-v) : (float)v;
            }
            if (this.exponent.CompareToInt(0) < 0 && this.exponent.CompareToInt(-6) >= 0 && this.unsignedMantissa.CanFitInInt32()) {
                int m = this.unsignedMantissa.ToInt32();
                int iex = -this.exponent.ToInt32();
                int vtp = ValueTenPowers[iex];
                if (m >= -8388608 && m < 0x800000) {
                    int divsCount;
                    long am;
                    if (m % vtp == 0) {
                        float dn = m / vtp;
                        return this.isNegative() ? -dn : dn;
                    }
                    for (am = (long)Math.abs(m); am < 0x800000L; am <<= 1) {
                    }
                    if (am % (long)vtp == 0L) {
                        float dn = (float)m / (float)vtp;
                        return this.isNegative() ? -dn : dn;
                    }
                    int divdCount = NumberUtility.BitLength(m);
                    int dividendShift = divdCount <= (divsCount = NumberUtility.BitLength(vtp)) ? divsCount - divdCount + 24 + 1 : Math.max(0, 25 - (divdCount - divsCount));
                    long lquo = -1L;
                    long lrem = -1L;
                    if (divsCount + dividendShift > 63) {
                        EInteger eim = EInteger.FromInt32(m).ShiftLeft(dividendShift);
                        EInteger[] divrem3 = eim.DivRem(EInteger.FromInt32(vtp));
                        EInteger equo = divrem3[0];
                        EInteger erem = divrem3[1];
                        if (equo.CanFitInInt64() && erem.CanFitInInt64()) {
                            lquo = equo.ToInt64Checked();
                            lrem = erem.ToInt64Checked();
                        }
                    } else {
                        long ldividend = (long)m << dividendShift;
                        lquo = ldividend / (long)vtp;
                        lrem = ldividend - lquo * (long)vtp;
                    }
                    int nexp = -dividendShift;
                    if (lquo >= 0x1000000L) {
                        while (lquo >= 0x2000000L) {
                            lrem |= lquo & 1L;
                            lquo >>= 1;
                            ++nexp;
                        }
                        if ((lquo & 3L) == 3L && lrem == 0L) {
                            lquo >>= 1;
                            ++lquo;
                            ++nexp;
                        } else if ((lquo & 1L) != 0L && lrem != 0L) {
                            lquo >>= 1;
                            ++lquo;
                            ++nexp;
                        } else {
                            lquo >>= 1;
                            ++nexp;
                        }
                        while (lquo >= 0x1000000L) {
                            lquo >>= 1;
                            ++nexp;
                        }
                        int smallmantissa = (int)(lquo & 0x7FFFFFL);
                        smallmantissa |= nexp + 150 << 23;
                        if (this.isNegative()) {
                            smallmantissa |= Integer.MIN_VALUE;
                        }
                        return Float.intBitsToFloat(smallmantissa);
                    }
                }
            }
            if (this.exponent.CompareToInt(39) > 0) {
                return this.isNegative() ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
            }
        }
        return this.ToEFloat(EContext.Binary32).ToSingle();
    }

    public String toString() {
        return this.ToStringInternal(0);
    }

    public EDecimal Ulp() {
        return !this.isFinite() ? One : EDecimal.Create(EInteger.FromInt32(1), this.getExponent());
    }

    static EDecimal CreateWithFlags(FastIntegerFixed mantissa, FastIntegerFixed exponent, int flags) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        return new EDecimal(mantissa, exponent, (byte)flags);
    }

    static EDecimal CreateWithFlags(EInteger mantissa, EInteger exponent, int flags) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        return new EDecimal(FastIntegerFixed.FromBig(mantissa), FastIntegerFixed.FromBig(exponent), (byte)flags);
    }

    private static boolean AppendString(StringBuilder builder, char c, FastInteger count) {
        if (count.CompareToInt(Integer.MAX_VALUE) > 0 || count.signum() < 0) {
            throw new UnsupportedOperationException();
        }
        int icount = count.ToInt32();
        if (icount > 10000) {
            int i;
            StringBuilder sb2 = new StringBuilder(10000);
            for (int i2 = 0; i2 < 10000; ++i2) {
                builder.append(c);
            }
            String sb2str = sb2.toString();
            int count2 = icount / 10000;
            int rem = icount % 10000;
            for (i = 0; i < count2; ++i) {
                builder.append(sb2str);
            }
            for (i = 0; i < rem; ++i) {
                builder.append(c);
            }
        } else {
            for (int i = 0; i < icount; ++i) {
                builder.append(c);
            }
        }
        return true;
    }

    private static IRadixMath<EDecimal> GetMathValue(EContext ctx) {
        if (ctx == null || ctx == EContext.UnlimitedHalfEven) {
            return ExtendedMathValue;
        }
        return !ctx.isSimplified() && ctx.getTraps() == 0 ? ExtendedMathValue : MathValue;
    }

    private boolean EqualsInternal(EDecimal otherValue) {
        return otherValue != null && this.flags == otherValue.flags && this.unsignedMantissa.equals(otherValue.unsignedMantissa) && this.exponent.equals(otherValue.exponent);
    }

    private static EInteger[] GetAdjustedExponentDecimalBounds(EDecimal ed) {
        if (!ed.isFinite()) {
            return new EInteger[]{EInteger.FromInt32(0), EInteger.FromInt32(0)};
        }
        if (ed.isZero()) {
            return new EInteger[]{EInteger.FromInt32(0), EInteger.FromInt32(0)};
        }
        EInteger retEInt = ed.getExponent();
        EInteger[] sigPrecBounds = NumberUtility.DecimalDigitLengthBoundsAsEI(ed.getUnsignedMantissa());
        EInteger eia = retEInt.Add(sigPrecBounds[0].Subtract(1));
        EInteger eib = retEInt.Add(sigPrecBounds[1].Subtract(1));
        return new EInteger[]{EInteger.Min(eia, eib), EInteger.Max(eia, eib)};
    }

    private static EInteger GetAdjustedExponentBinary(EFloat ef) {
        if (!ef.isFinite()) {
            return EInteger.FromInt32(0);
        }
        if (ef.isZero()) {
            return EInteger.FromInt32(0);
        }
        EInteger retEInt = ef.getExponent();
        EInteger valueEiPrecision = ef.getUnsignedMantissa().GetSignedBitLengthAsEInteger();
        retEInt = retEInt.Add(valueEiPrecision.Subtract(1));
        return retEInt;
    }

    private EDecimal RoundToExponentFast(int exponentSmall, ERounding rounding) {
        if (this.isFinite() && this.exponent.CanFitInInt32() && this.unsignedMantissa.CanFitInInt32()) {
            int thisExponentSmall = this.exponent.ToInt32();
            if (thisExponentSmall == exponentSmall) {
                return this;
            }
            if (thisExponentSmall >= -100 && thisExponentSmall <= 100 && exponentSmall >= -100 && exponentSmall <= 100) {
                if (rounding == ERounding.Down) {
                    int diff = exponentSmall - thisExponentSmall;
                    if (diff >= 1 && diff <= 9) {
                        int thisMantissaSmall = this.unsignedMantissa.ToInt32();
                        return new EDecimal(FastIntegerFixed.FromInt32(thisMantissaSmall /= ValueTenPowers[diff]), FastIntegerFixed.FromInt32(exponentSmall), this.flags);
                    }
                } else if (rounding == ERounding.HalfEven) {
                    int diff = exponentSmall - thisExponentSmall;
                    int thisMantissaSmall = this.unsignedMantissa.ToInt32();
                    if (diff >= 1 && diff <= 9 && thisMantissaSmall != Integer.MAX_VALUE) {
                        int div;
                        int pwr = ValueTenPowers[diff - 1];
                        int div2 = (div = thisMantissaSmall / pwr) > 43698 ? div / 10 : div * 26215 >> 18;
                        int rem = div - div2 * 10;
                        if (rem > 5) {
                            ++div2;
                        } else if (rem == 5 && ((div2 & 1) == 1 || thisMantissaSmall - div * pwr != 0)) {
                            ++div2;
                        }
                        return new EDecimal(FastIntegerFixed.FromInt32(div2), FastIntegerFixed.FromInt32(exponentSmall), this.flags);
                    }
                }
            }
        }
        return null;
    }

    private boolean IsIntegerPartZero() {
        if (!this.isFinite()) {
            return false;
        }
        if (this.unsignedMantissa.isValueZero()) {
            return true;
        }
        int sign = this.getExponent().signum();
        if (sign >= 0) {
            return false;
        }
        EInteger umantissa = this.getUnsignedMantissa();
        EInteger[] bounds = NumberUtility.DecimalDigitLengthBoundsAsEI(umantissa);
        EInteger digitCountUpper = bounds[1];
        EInteger digitCountLower = bounds[0];
        EInteger bigexponent = this.getExponent();
        return digitCountUpper.compareTo(bigexponent.Abs()) < 0 ? true : (digitCountLower.compareTo(bigexponent.Abs()) > 0 ? false : this.compareTo(-1) > 0 && this.compareTo(1) < 0);
    }

    private EInteger ToEIntegerInternal(boolean exact) {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        int sign = this.getExponent().signum();
        if (this.isZero()) {
            return EInteger.FromInt32(0);
        }
        if (sign == 0) {
            EInteger bigmantissa = this.getMantissa();
            return bigmantissa;
        }
        if (sign > 0) {
            EInteger exponent = this.getExponent();
            EInteger exponentBitSize = exponent.GetUnsignedBitLengthAsEInteger();
            if (exponentBitSize.compareTo(64) > 0) {
                throw new UnsupportedOperationException("Not enough memory to store as EInteger.");
            }
            EInteger bigmantissa = this.getMantissa();
            EInteger bigexponent = NumberUtility.FindPowerOfTenFromBig(this.getExponent());
            bigmantissa = bigmantissa.Multiply(bigexponent);
            return bigmantissa;
        }
        if (exact && !this.unsignedMantissa.isEvenNumber()) {
            throw new ArithmeticException("Not an exact integer");
        }
        FastInteger bigexponent = this.exponent.ToFastInteger().Negate();
        EInteger bigmantissa = this.unsignedMantissa.ToEInteger();
        DigitShiftAccumulator acc = new DigitShiftAccumulator(bigmantissa, 0, 0);
        if (exact) {
            if (!acc.TruncateRightExact(bigexponent)) {
                throw new ArithmeticException("Not an exact integer");
            }
        } else {
            acc.TruncateRightSimple(bigexponent);
        }
        bigmantissa = acc.getShiftedInt();
        if (this.isNegative()) {
            bigmantissa = bigmantissa.Negate();
        }
        return bigmantissa;
    }

    private static EInteger PowerOfRadixBitsLowerBound(EInteger e) {
        return e.Abs().Multiply(332).Divide(100).Add(1);
    }

    private static EInteger PowerOfRadixBitsUpperBound(EInteger e) {
        return e.Abs().Multiply(333).Divide(100).Add(1);
    }

    public EInteger ToSizedEInteger(int maxBitLength) {
        return this.ToSizedEInteger(maxBitLength, false);
    }

    public EInteger ToSizedEIntegerIfExact(int maxBitLength) {
        return this.ToSizedEInteger(maxBitLength, true);
    }

    private EInteger ToSizedEInteger(int maxBitLength, boolean exact) {
        if (maxBitLength < 0) {
            throw new IllegalArgumentException("maxBitLength (" + maxBitLength + ") is not greater or equal to 0");
        }
        if (!this.isFinite() || this.isZero()) {
            return exact ? this.ToEIntegerIfExact() : this.ToEInteger();
        }
        EInteger mant = this.getMantissa();
        EInteger exp = this.getExponent();
        if (exp.signum() > 0) {
            long imantbits = mant.GetSignedBitLengthAsInt64();
            if (imantbits >= (long)maxBitLength) {
                throw new ArithmeticException("Value out of range");
            }
            if (exp.compareTo(0x100000) < 0 && imantbits < 0x100000L) {
                long expBitsLowerBound = exp.ToInt64Checked() * 332L / 100L + 1L;
                if (imantbits - 1L + expBitsLowerBound > (long)maxBitLength) {
                    throw new ArithmeticException("Value out of range");
                }
            } else {
                if (exp.compareTo(maxBitLength) > 0) {
                    throw new ArithmeticException("Value out of range");
                }
                EInteger mantbits = mant.GetSignedBitLengthAsEInteger();
                if (mantbits.Subtract(1).Add(EDecimal.PowerOfRadixBitsLowerBound(exp)).compareTo(maxBitLength) > 0) {
                    throw new ArithmeticException("Value out of range");
                }
            }
            mant = exact ? this.ToEIntegerIfExact() : this.ToEInteger();
        } else if (exp.signum() < 0) {
            exp = exp.Abs();
            long imantbits = mant.GetSignedBitLengthAsInt64();
            if (exp.compareTo(0x100000) < 0 && imantbits < 0x100000L) {
                long expBitsUpperBound = exp.ToInt64Checked() * 333L / 100L + 1L;
                long expBitsLowerBound = exp.ToInt64Checked() * 332L / 100L + 1L;
                if (imantbits - 1L - expBitsUpperBound > (long)maxBitLength) {
                    throw new ArithmeticException("Value out of range");
                }
                if (imantbits + 1L < expBitsLowerBound) {
                    if (exact) {
                        throw new ArithmeticException("Not an exact integer");
                    }
                    return EInteger.FromInt32(0);
                }
            } else {
                if (imantbits < 0x100000L && exp.compareTo(0x400000) >= 0) {
                    if (exact) {
                        throw new ArithmeticException("Not an exact integer");
                    }
                    return EInteger.FromInt32(0);
                }
                EInteger mantbits = mant.GetSignedBitLengthAsEInteger();
                if (mantbits.Subtract(1).Subtract(EDecimal.PowerOfRadixBitsUpperBound(exp)).compareTo(maxBitLength) > 0) {
                    throw new ArithmeticException("Value out of range");
                }
            }
            EInteger eInteger = mant = exact ? this.ToEIntegerIfExact() : this.ToEInteger();
        }
        if (mant.GetSignedBitLengthAsEInteger().compareTo(maxBitLength) > 0) {
            throw new ArithmeticException("Value out of range");
        }
        return mant;
    }

    private static boolean HasTerminatingBinaryExpansion(EInteger den) {
        if (den.isZero()) {
            return false;
        }
        if (den.GetUnsignedBit(0) && den.compareTo(EInteger.FromInt32(1)) != 0) {
            return false;
        }
        return den.GetUnsignedBitLengthAsEInteger().equals(den.GetLowBitAsEInteger().Add(1));
    }

    private EFloat WithThisSign(EFloat ef) {
        return this.isNegative() ? ef.Negate() : ef;
    }

    public EFloat ToEFloat(EContext ec) {
        EFloat efDen;
        EFloat ret;
        EFloat efNum;
        EInteger bigintExp = this.getExponent();
        EInteger bigUnsignedMantissa = this.getUnsignedMantissa();
        if (this.IsNaN()) {
            return EFloat.CreateNaN(this.getUnsignedMantissa(), this.IsSignalingNaN(), this.isNegative(), ec);
        }
        if (this.IsPositiveInfinity()) {
            return EFloat.PositiveInfinity.RoundToPrecision(ec);
        }
        if (this.IsNegativeInfinity()) {
            return EFloat.NegativeInfinity.RoundToPrecision(ec);
        }
        if (bigUnsignedMantissa.isZero()) {
            return this.isNegative() ? EFloat.NegativeZero.RoundToPrecision(ec) : EFloat.Zero.RoundToPrecision(ec);
        }
        if (bigintExp.isZero()) {
            return this.WithThisSign(EFloat.FromEInteger(bigUnsignedMantissa)).RoundToPrecision(ec);
        }
        EContext b64 = EContext.Binary64;
        if (ec != null && ec.getHasMaxPrecision() && ec.getHasExponentRange() && !ec.isSimplified() && ec.getEMax().compareTo(b64.getEMax()) <= 0 && ec.getEMin().compareTo(b64.getEMin()) >= 0 && ec.getPrecision().compareTo(b64.getPrecision()) <= 0) {
            EInteger[] bounds = NumberUtility.DecimalDigitLengthBoundsAsEI(bigUnsignedMantissa);
            EInteger digitCountUpper = bounds[1];
            EInteger adjexpLowerBound = bigintExp;
            EInteger adjexpUpperBound = bigintExp.Add(digitCountUpper.Subtract(1));
            if (adjexpUpperBound.compareTo(-326) < 0) {
                EInteger eTiny = ec.getEMin().Subtract(ec.getPrecision().Subtract(1));
                eTiny = eTiny.Subtract(2);
                EFloat ret2 = EFloat.Create(EInteger.FromInt32(this.isNegative() ? -1 : 1), eTiny);
                return ret2.RoundToPrecision(ec);
            }
            if (adjexpLowerBound.compareTo(309) > 0) {
                return EFloat.GetMathValue().SignalOverflow(ec, this.isNegative());
            }
            EInteger digitCountLower = bounds[0];
            if (bigintExp.signum() >= 0 && digitCountLower.Subtract(2).compareTo(309) > 0) {
                return EFloat.GetMathValue().SignalOverflow(ec, this.isNegative());
            }
            if (digitCountLower.Add(bigintExp).Subtract(2).compareTo(309) > 0) {
                return EFloat.GetMathValue().SignalOverflow(ec, this.isNegative());
            }
        }
        if (bigintExp.signum() > 0) {
            if (ec == EContext.Binary32 ? bigintExp.compareTo(39) > 0 : ec == EContext.Binary64 && bigintExp.compareTo(309) > 0) {
                return this.isNegative() ? EFloat.NegativeInfinity : EFloat.PositiveInfinity;
            }
            EInteger bigmantissa = bigUnsignedMantissa;
            bigintExp = NumberUtility.FindPowerOfTenFromBig(bigintExp);
            bigmantissa = bigmantissa.Multiply(bigintExp);
            return this.WithThisSign(EFloat.FromEInteger(bigmantissa)).RoundToPrecision(ec);
        }
        EInteger scale = bigintExp;
        EInteger bigmantissa = bigUnsignedMantissa;
        EInteger negscale = scale.Negate();
        EInteger divisor = NumberUtility.FindPowerOfTenFromBig(negscale);
        EContext eContext = ec = ec == null ? EContext.UnlimitedHalfEven : ec;
        if (ec.getHasMaxPrecision()) {
            efNum = EFloat.FromEInteger(bigmantissa);
            if (this.signum() < 0) {
                efNum = efNum.Negate();
            }
            EFloat efDen2 = EFloat.FromEInteger(divisor);
            return efNum.Divide(efDen2, ec);
        }
        if (!ec.getHasFlagsOrTraps()) {
            EFloat efDen3;
            EFloat ret3;
            efNum = EFloat.FromEInteger(bigmantissa);
            if (this.signum() < 0) {
                efNum = efNum.Negate();
            }
            if (!(ret3 = efNum.Divide(efDen3 = EFloat.FromEInteger(divisor), ec)).IsNaN()) {
                return ret3;
            }
            EInteger bitprec = bigmantissa.GetUnsignedBitLengthAsEInteger();
            bitprec = EInteger.Max(bitprec, EInteger.FromInt32(53));
            return efNum.Divide(efDen3, ec.WithBigPrecision(bitprec));
        }
        if (ec.getTraps() != 0) {
            EContext tctx = ec.GetNontrapping();
            EFloat ret4 = this.ToEFloat(tctx);
            return ec.TriggerTraps(ret4, tctx);
        }
        EContext tmpctx = ec.WithBlankFlags();
        EFloat efNum2 = EFloat.FromEInteger(bigmantissa);
        if (this.signum() < 0) {
            efNum2 = efNum2.Negate();
        }
        if (!(ret = efNum2.Divide(efDen = EFloat.FromEInteger(divisor), tmpctx)).IsNaN()) {
            ec.setFlags(ec.getFlags() | tmpctx.getFlags());
            return ret;
        }
        EInteger bitprec = bigmantissa.GetUnsignedBitLengthAsEInteger();
        bitprec = EInteger.Max(bitprec, EInteger.FromInt32(53));
        tmpctx = ec.WithBigPrecision(bitprec).WithBlankFlags();
        ret = efNum2.Divide(efDen, tmpctx);
        ec.setFlags(ec.getFlags() | tmpctx.getFlags());
        return ret;
    }

    private String ToStringInternal(int mode) {
        int tmpInt;
        int cmp;
        int intExp;
        int scaleSign;
        boolean negative;
        boolean bl = negative = (this.flags & 1) != 0;
        if (!this.isFinite()) {
            if ((this.flags & 2) != 0) {
                return negative ? "-Infinity" : "Infinity";
            }
            if ((this.flags & 8) != 0) {
                return this.unsignedMantissa.isValueZero() ? (negative ? "-sNaN" : "sNaN") : (negative ? "-sNaN" + this.unsignedMantissa : "sNaN" + this.unsignedMantissa);
            }
            if ((this.flags & 4) != 0) {
                return this.unsignedMantissa.isValueZero() ? (negative ? "-NaN" : "NaN") : (negative ? "-NaN" + this.unsignedMantissa : "NaN" + this.unsignedMantissa);
            }
        }
        if ((scaleSign = -this.exponent.signum()) == 0) {
            String mantissaString = this.unsignedMantissa.toString();
            return negative ? "-" + mantissaString : mantissaString;
        }
        boolean iszero = this.unsignedMantissa.isValueZero();
        if (mode == 2 && iszero && scaleSign < 0) {
            String mantissaString = this.unsignedMantissa.toString();
            return negative ? "-" + mantissaString : mantissaString;
        }
        if (mode == 0 && this.unsignedMantissa.CanFitInInt32() && this.exponent.CanFitInInt32()) {
            intExp = this.exponent.ToInt32();
            int intMant = this.unsignedMantissa.ToInt32();
            if (intMant < 1000 && intExp == -2) {
                int i = 0;
                int a = intMant % 10;
                int b = (intMant /= 10) % 10;
                int c = intMant /= 10;
                int clength = (negative ? 1 : 0) + 4;
                char[] chars = new char[clength];
                if (negative) {
                    chars[i++] = 45;
                }
                chars[i++] = (char)(48 + c);
                chars[i++] = 46;
                chars[i++] = (char)(48 + b);
                chars[i++] = (char)(48 + a);
                return new String(chars, 0, clength);
            }
            if (intMant < 100 && intExp == -1) {
                int i = 0;
                int a = intMant % 10;
                int b = intMant /= 10;
                int clength = (negative ? 1 : 0) + 3;
                char[] chars = new char[clength];
                if (negative) {
                    chars[i++] = 45;
                }
                chars[i++] = (char)(48 + b);
                chars[i++] = 46;
                chars[i++] = (char)(48 + a);
                return new String(chars, 0, clength);
            }
        }
        String mantissaString = this.unsignedMantissa.toString();
        if (mode == 0 && mantissaString.length() < 100 && this.exponent.CanFitInInt32() && (intExp = this.exponent.ToInt32()) > -100 && intExp < 100) {
            int adj = intExp + mantissaString.length() - 1;
            if (scaleSign >= 0 && adj >= -6 && scaleSign > 0) {
                int ms = mantissaString.length();
                int dp = intExp + ms;
                if (dp < 0) {
                    int j;
                    dp = -dp;
                    int clength = 2 + dp + (negative ? 1 : 0) + ms;
                    char[] chars = new char[clength];
                    int i = 0;
                    if (negative) {
                        chars[i++] = 45;
                    }
                    chars[i++] = 48;
                    chars[i++] = 46;
                    for (j = 0; j < dp; ++j) {
                        chars[i++] = 48;
                    }
                    for (j = 0; j < ms; ++j) {
                        chars[i++] = mantissaString.charAt(j);
                    }
                    return new String(chars, 0, clength);
                }
                if (dp == 0) {
                    int clength = 2 + (negative ? 1 : 0) + ms;
                    char[] chars = new char[clength];
                    int i = 0;
                    if (negative) {
                        chars[i++] = 45;
                    }
                    chars[i++] = 48;
                    chars[i++] = 46;
                    for (int j = 0; j < ms; ++j) {
                        chars[i++] = mantissaString.charAt(j);
                    }
                    return new String(chars, 0, clength);
                }
                if (dp > 0 && dp <= ms) {
                    int clength = 1 + (negative ? 1 : 0) + ms;
                    char[] chars = new char[clength];
                    int i = 0;
                    int j = 0;
                    if (negative) {
                        chars[i++] = 45;
                    }
                    for (j = 0; j < dp; ++j) {
                        chars[i++] = mantissaString.charAt(j);
                    }
                    chars[i++] = 46;
                    for (j = dp; j < ms; ++j) {
                        chars[i++] = mantissaString.charAt(j);
                    }
                    return new String(chars, 0, clength);
                }
            }
        }
        StringBuilder builder = null;
        FastInteger adjustedExponent = FastInteger.FromBig(this.getExponent());
        FastInteger builderLength = new FastInteger(mantissaString.length());
        FastInteger thisExponent = adjustedExponent.Copy();
        adjustedExponent.Add(builderLength).Decrement();
        FastInteger decimalPointAdjust = new FastInteger(1);
        FastInteger threshold = new FastInteger(-6);
        if (mode == 1) {
            FastInteger newExponent = adjustedExponent.Copy();
            boolean adjExponentNegative = adjustedExponent.signum() < 0;
            int intphase = adjustedExponent.Copy().Abs().Remainder(3).ToInt32();
            if (iszero && (adjustedExponent.compareTo(threshold) < 0 || scaleSign < 0)) {
                if (intphase == 1) {
                    if (adjExponentNegative) {
                        decimalPointAdjust.Increment();
                        newExponent.Increment();
                    } else {
                        decimalPointAdjust.AddInt(2);
                        newExponent.AddInt(2);
                    }
                } else if (intphase == 2) {
                    if (!adjExponentNegative) {
                        decimalPointAdjust.Increment();
                        newExponent.Increment();
                    } else {
                        decimalPointAdjust.AddInt(2);
                        newExponent.AddInt(2);
                    }
                }
                threshold.Increment();
            } else if (intphase == 1) {
                if (!adjExponentNegative) {
                    decimalPointAdjust.Increment();
                    newExponent.Decrement();
                } else {
                    decimalPointAdjust.AddInt(2);
                    newExponent.AddInt(-2);
                }
            } else if (intphase == 2) {
                if (adjExponentNegative) {
                    decimalPointAdjust.Increment();
                    newExponent.Decrement();
                } else {
                    decimalPointAdjust.AddInt(2);
                    newExponent.AddInt(-2);
                }
            }
            adjustedExponent = newExponent;
        }
        if (mode == 2 || adjustedExponent.compareTo(threshold) >= 0 && scaleSign >= 0) {
            if (scaleSign > 0) {
                FastInteger decimalPoint = thisExponent.Copy().Add(builderLength);
                cmp = decimalPoint.CompareToInt(0);
                builder = null;
                if (cmp < 0) {
                    FastInteger tmpFast = new FastInteger(mantissaString.length()).AddInt(6);
                    builder = new StringBuilder(tmpFast.CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.ToInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append("0.");
                    EDecimal.AppendString(builder, '0', decimalPoint.Copy().Negate());
                    builder.append(mantissaString);
                } else if (cmp == 0) {
                    FastInteger tmpFast = new FastInteger(mantissaString.length()).AddInt(6);
                    builder = new StringBuilder(tmpFast.CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.ToInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append("0.");
                    builder.append(mantissaString);
                } else if (decimalPoint.CompareToInt(mantissaString.length()) > 0) {
                    FastInteger tmpFast;
                    FastInteger insertionPoint = builderLength;
                    if (!insertionPoint.CanFitInInt32()) {
                        throw new UnsupportedOperationException();
                    }
                    int tmpInt2 = insertionPoint.ToInt32();
                    if (tmpInt2 < 0) {
                        tmpInt2 = 0;
                    }
                    builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.ToInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, tmpInt2);
                    EDecimal.AppendString(builder, '0', decimalPoint.Copy().SubtractInt(builder.length()));
                    builder.append('.');
                    builder.append(mantissaString, tmpInt2, tmpInt2 + (mantissaString.length() - tmpInt2));
                } else {
                    FastInteger tmpFast;
                    if (!decimalPoint.CanFitInInt32()) {
                        throw new UnsupportedOperationException();
                    }
                    tmpInt = decimalPoint.ToInt32();
                    if (tmpInt < 0) {
                        tmpInt = 0;
                    }
                    builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.ToInt32());
                    if (negative) {
                        builder.append('-');
                    }
                    builder.append(mantissaString, 0, tmpInt);
                    builder.append('.');
                    builder.append(mantissaString, tmpInt, tmpInt + (mantissaString.length() - tmpInt));
                }
                return builder.toString();
            }
            if (mode == 2 && scaleSign < 0) {
                FastInteger negscale = thisExponent.Copy();
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
                EDecimal.AppendString(builder, '0', negscale);
                return builder.toString();
            }
            return !negative ? mantissaString : "-" + mantissaString;
        }
        if (mode == 1 && iszero && decimalPointAdjust.CompareToInt(1) > 0) {
            builder = new StringBuilder();
            if (negative) {
                builder.append('-');
            }
            builder.append(mantissaString);
            builder.append('.');
            EDecimal.AppendString(builder, '0', decimalPointAdjust.Copy().Decrement());
        } else {
            FastInteger tmp = decimalPointAdjust.Copy();
            cmp = tmp.CompareToInt(mantissaString.length());
            if (cmp > 0) {
                tmp.SubtractInt(mantissaString.length());
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
                EDecimal.AppendString(builder, '0', tmp);
            } else if (cmp < 0) {
                FastInteger tmpFast;
                if (!tmp.CanFitInInt32()) {
                    throw new UnsupportedOperationException();
                }
                tmpInt = tmp.ToInt32();
                if (tmp.signum() < 0) {
                    tmpInt = 0;
                }
                builder = new StringBuilder((tmpFast = new FastInteger(mantissaString.length()).AddInt(6)).CompareToInt(Integer.MAX_VALUE) > 0 ? Integer.MAX_VALUE : tmpFast.ToInt32());
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString, 0, tmpInt);
                builder.append('.');
                builder.append(mantissaString, tmpInt, tmpInt + (mantissaString.length() - tmpInt));
            } else {
                if (adjustedExponent.signum() == 0 && !negative) {
                    return mantissaString;
                }
                if (adjustedExponent.signum() == 0 && negative) {
                    return "-" + mantissaString;
                }
                builder = new StringBuilder();
                if (negative) {
                    builder.append('-');
                }
                builder.append(mantissaString);
            }
        }
        if (adjustedExponent.signum() != 0) {
            builder.append(adjustedExponent.signum() < 0 ? "E-" : "E+");
            adjustedExponent.Abs();
            builder.append(adjustedExponent.toString());
        }
        return builder.toString();
    }

    public EDecimal Increment() {
        return this.Add(1);
    }

    public EDecimal Decrement() {
        return this.Subtract(1);
    }

    private void CheckTrivialOverflow(int maxDigits) {
        if (this.isZero()) {
            return;
        }
        if (this.exponent.signum() < 0) {
            EInteger bigexponent = this.getExponent();
            EInteger bigmantissa = this.getUnsignedMantissa();
            bigexponent = bigexponent.Abs();
            EInteger lowerBound = NumberUtility.DecimalDigitLengthBoundsAsEI(bigmantissa = bigmantissa.Abs())[0];
            if (lowerBound.Subtract(bigexponent).compareTo(maxDigits) > 0) {
                throw new ArithmeticException("Value out of range");
            }
        } else if (this.exponent.CompareToInt(maxDigits) >= 0) {
            throw new ArithmeticException("Value out of range");
        }
    }

    public byte ToByteChecked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        this.CheckTrivialOverflow(3);
        if (this.IsIntegerPartZero()) {
            return 0;
        }
        if (this.isNegative()) {
            throw new ArithmeticException("Value out of range");
        }
        return this.ToEInteger().ToByteChecked();
    }

    public byte ToByteUnchecked() {
        if (this.isFinite()) {
            if (this.IsIntegerPartZero()) {
                return 0;
            }
            if (this.exponent.CompareToInt(8) >= 0) {
                return 0;
            }
            return this.ToEInteger().ToByteUnchecked();
        }
        return 0;
    }

    public byte ToByteIfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.isNegative() && !this.isZero()) {
            throw new ArithmeticException("Value out of range");
        }
        this.CheckTrivialOverflow(3);
        return this.ToEIntegerIfExact().ToByteChecked();
    }

    public static EDecimal FromByte(byte inputByte) {
        int val = inputByte & 0xFF;
        return EDecimal.FromInt32(val);
    }

    public short ToInt16Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        this.CheckTrivialOverflow(5);
        return this.IsIntegerPartZero() ? (short)0 : this.ToEInteger().ToInt16Checked();
    }

    public short ToInt16Unchecked() {
        if (this.isFinite()) {
            if (this.IsIntegerPartZero()) {
                return 0;
            }
            if (this.exponent.CompareToInt(16) >= 0) {
                return 0;
            }
            return this.ToEInteger().ToInt16Unchecked();
        }
        return 0;
    }

    public short ToInt16IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        this.CheckTrivialOverflow(5);
        return this.ToEIntegerIfExact().ToInt16Checked();
    }

    public static EDecimal FromInt16(short inputInt16) {
        short val = inputInt16;
        return EDecimal.FromInt32(val);
    }

    public int ToInt32Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        this.CheckTrivialOverflow(10);
        return this.IsIntegerPartZero() ? 0 : this.ToEInteger().ToInt32Checked();
    }

    public int ToInt32Unchecked() {
        if (this.isFinite()) {
            if (this.IsIntegerPartZero()) {
                return 0;
            }
            if (this.exponent.CompareToInt(32) >= 0) {
                return 0;
            }
            return this.ToEInteger().ToInt32Unchecked();
        }
        return 0;
    }

    public int ToInt32IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.isZero()) {
            return 0;
        }
        this.CheckTrivialOverflow(10);
        return this.ToEIntegerIfExact().ToInt32Checked();
    }

    public long ToInt64Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        this.CheckTrivialOverflow(19);
        return this.IsIntegerPartZero() ? 0L : this.ToEInteger().ToInt64Checked();
    }

    public long ToInt64Unchecked() {
        if (this.isFinite()) {
            if (this.IsIntegerPartZero()) {
                return 0L;
            }
            if (this.exponent.CompareToInt(64) >= 0) {
                return 0L;
            }
            return this.ToEInteger().ToInt64Unchecked();
        }
        return 0L;
    }

    public long ToInt64IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.isZero()) {
            return 0L;
        }
        this.CheckTrivialOverflow(19);
        return this.ToEIntegerIfExact().ToInt64Checked();
    }

    private static final class DecimalMathHelper
    implements IRadixMathHelper<EDecimal> {
        private DecimalMathHelper() {
        }

        @Override
        public int GetRadix() {
            return 10;
        }

        @Override
        public int GetSign(EDecimal value) {
            return value.signum();
        }

        @Override
        public EInteger GetMantissa(EDecimal value) {
            return value.unsignedMantissa.ToEInteger();
        }

        @Override
        public EInteger GetExponent(EDecimal value) {
            return value.exponent.ToEInteger();
        }

        @Override
        public FastIntegerFixed GetMantissaFastInt(EDecimal value) {
            return value.unsignedMantissa;
        }

        @Override
        public FastIntegerFixed GetExponentFastInt(EDecimal value) {
            return value.exponent;
        }

        @Override
        public FastInteger GetDigitLength(EInteger ei) {
            long i64 = ei.GetDigitCountAsInt64();
            if (i64 != Long.MAX_VALUE) {
                return FastInteger.FromInt64(i64);
            }
            return FastInteger.FromBig(ei.GetDigitCountAsEInteger());
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigits(EInteger bigint, int lastDigit, int olderDigits) {
            return new DigitShiftAccumulator(bigint, lastDigit, olderDigits);
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigitsFastInt(FastIntegerFixed fastInt, int lastDigit, int olderDigits) {
            if (fastInt.CanFitInInt32()) {
                return new DigitShiftAccumulator(fastInt.ToInt32(), lastDigit, olderDigits);
            }
            return new DigitShiftAccumulator(fastInt.ToEInteger(), lastDigit, olderDigits);
        }

        @Override
        public FastInteger DivisionShift(EInteger num, EInteger den) {
            if (den.isZero()) {
                return null;
            }
            EInteger gcd = den.Gcd(EInteger.FromInt32(10));
            if (gcd.compareTo(EInteger.FromInt32(1)) == 0) {
                return null;
            }
            if (den.isZero()) {
                return null;
            }
            EInteger elowbit = den.GetLowBitAsEInteger();
            den = den.ShiftRight(elowbit);
            FastInteger fiveShift = new FastInteger(0);
            while (true) {
                EInteger[] divrem = den.DivRem(EInteger.FromInt64(5L));
                EInteger bigquo = divrem[0];
                EInteger bigrem = divrem[1];
                if (!bigrem.isZero()) break;
                fiveShift.Increment();
                den = bigquo;
            }
            if (den.compareTo(EInteger.FromInt32(1)) != 0) {
                return null;
            }
            FastInteger fastlowbit = FastInteger.FromBig(elowbit);
            if (fiveShift.compareTo(fastlowbit) > 0) {
                return fiveShift;
            }
            return fastlowbit;
        }

        @Override
        public FastIntegerFixed MultiplyByRadixPowerFastInt(FastIntegerFixed fbigint, FastIntegerFixed fpower) {
            int powerInt;
            if (fbigint.isValueZero()) {
                return fbigint;
            }
            boolean fitsInInt32 = fpower.CanFitInInt32();
            int n = powerInt = fitsInInt32 ? fpower.ToInt32() : 0;
            if (fitsInInt32 && powerInt == 0) {
                return fbigint;
            }
            EInteger bigint = fbigint.ToEInteger();
            EInteger ret = null;
            if (bigint.compareTo(1) != 0) {
                if (fitsInInt32) {
                    ret = NumberUtility.MultiplyByPowerOfTen(bigint, powerInt);
                } else {
                    EInteger eipower = fpower.ToEInteger();
                    ret = NumberUtility.MultiplyByPowerOfTen(bigint, eipower);
                }
            } else {
                ret = fitsInInt32 ? NumberUtility.FindPowerOfTen(powerInt) : NumberUtility.FindPowerOfTenFromBig(fpower.ToEInteger());
            }
            return FastIntegerFixed.FromBig(ret);
        }

        @Override
        public EInteger MultiplyByRadixPower(EInteger bigint, FastInteger power) {
            int powerInt;
            if (bigint.isZero()) {
                return bigint;
            }
            boolean fitsInInt32 = power.CanFitInInt32();
            int n = powerInt = fitsInInt32 ? power.ToInt32() : 0;
            if (fitsInInt32 && powerInt == 0) {
                return bigint;
            }
            if (bigint.compareTo(1) != 0) {
                if (fitsInInt32) {
                    return NumberUtility.MultiplyByPowerOfTen(bigint, powerInt);
                }
                EInteger eipower = power.ToEInteger();
                return NumberUtility.MultiplyByPowerOfTen(bigint, eipower);
            }
            return fitsInInt32 ? NumberUtility.FindPowerOfTen(powerInt) : NumberUtility.FindPowerOfTenFromBig(power.ToEInteger());
        }

        @Override
        public int GetFlags(EDecimal value) {
            return value.flags & 0xFF;
        }

        @Override
        public EDecimal CreateNewWithFlags(EInteger mantissa, EInteger exponent, int flags) {
            return EDecimal.CreateWithFlags(FastIntegerFixed.FromBig(mantissa), FastIntegerFixed.FromBig(exponent), flags);
        }

        @Override
        public EDecimal CreateNewWithFlagsFastInt(FastIntegerFixed fmantissa, FastIntegerFixed fexponent, int flags) {
            return EDecimal.CreateWithFlags(fmantissa, fexponent, flags);
        }

        @Override
        public int GetArithmeticSupport() {
            return 1;
        }

        @Override
        public EDecimal ValueOf(int val) {
            return val == 0 ? Zero : (val == 1 ? One : EDecimal.FromInt64(val));
        }
    }
}

