/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.util;

public final class URIUtility {
    private static final String HexChars = "0123456789ABCDEF";
    private static final String ValueDotSlash = "./";
    private static final String ValueSlashDot = "/.";

    private URIUtility() {
    }

    private static void AppendAuthority(StringBuilder builder, String refValue, int[] segments) {
        if (segments[2] >= 0) {
            builder.append("//");
            builder.append(refValue.substring(segments[2], segments[2] + (segments[3] - segments[2])));
        }
    }

    private static void AppendFragment(StringBuilder builder, String refValue, int[] segments) {
        if (segments[8] >= 0) {
            builder.append('#');
            builder.append(refValue.substring(segments[8], segments[8] + (segments[9] - segments[8])));
        }
    }

    private static void AppendNormalizedPath(StringBuilder builder, String refValue, int[] segments) {
        builder.append(URIUtility.NormalizePath(refValue.substring(segments[4], segments[4] + (segments[5] - segments[4]))));
    }

    private static void AppendPath(StringBuilder builder, String refValue, int[] segments) {
        builder.append(refValue.substring(segments[4], segments[4] + (segments[5] - segments[4])));
    }

    private static void AppendQuery(StringBuilder builder, String refValue, int[] segments) {
        if (segments[6] >= 0) {
            builder.append('?');
            builder.append(refValue.substring(segments[6], segments[6] + (segments[7] - segments[6])));
        }
    }

    private static void AppendScheme(StringBuilder builder, String refValue, int[] segments) {
        if (segments[0] >= 0) {
            builder.append(refValue.substring(segments[0], segments[0] + (segments[1] - segments[0])));
            builder.append(':');
        }
    }

    public static String EscapeURI(String s, int mode) {
        if (s == null) {
            return null;
        }
        int[] components = null;
        if (mode == 1) {
            int[] nArray = components = s == null ? null : URIUtility.SplitIRI(s, 0, s.length(), ParseMode.IRIStrict);
            if (components == null) {
                return null;
            }
        } else {
            components = s == null ? null : URIUtility.SplitIRI(s, 0, s.length(), ParseMode.IRISurrogateLenient);
        }
        int index = 0;
        int valueSLength = s.length();
        StringBuilder builder = new StringBuilder();
        while (index < valueSLength) {
            int c = s.charAt(index);
            if ((c & 0xFC00) == 55296 && index + 1 < valueSLength && (s.charAt(index + 1) & 0xFC00) == 56320) {
                c = 65536 + ((c & 0x3FF) << 10) + (s.charAt(index + 1) & 0x3FF);
                ++index;
            } else if ((c & 0xF800) == 55296) {
                c = 65533;
            }
            if (mode == 0 || mode == 3) {
                if (c == 37 && mode == 3) {
                    if (index + 2 >= valueSLength || !URIUtility.IsHexChar(s.charAt(index + 1)) || !URIUtility.IsHexChar(s.charAt(index + 2))) {
                        URIUtility.PercentEncodeUtf8(builder, c);
                    } else if (c <= 65535) {
                        builder.append((char)c);
                    } else if (c <= 0x10FFFF) {
                        builder.append((char)(c - 65536 >> 10 & 0x3FF | 0xD800));
                        builder.append((char)(c - 65536 & 0x3FF | 0xDC00));
                    }
                    ++index;
                    continue;
                }
                if (c >= 127 || c <= 32 || (c & 0x7F) == c && "{}|^\\`<>\"".indexOf((char)c) >= 0) {
                    URIUtility.PercentEncodeUtf8(builder, c);
                } else if (c == 91 || c == 93) {
                    if (components != null && index >= components[2] && index < components[3]) {
                        builder.append((char)c);
                    } else {
                        URIUtility.PercentEncodeUtf8(builder, c);
                    }
                } else if (c <= 65535) {
                    builder.append((char)c);
                } else if (c <= 0x10FFFF) {
                    builder.append((char)(c - 65536 >> 10 & 0x3FF | 0xD800));
                    builder.append((char)(c - 65536 & 0x3FF | 0xDC00));
                }
            } else if (mode == 1 || mode == 2) {
                if (c >= 128) {
                    URIUtility.PercentEncodeUtf8(builder, c);
                } else if (c == 91 || c == 93) {
                    if (components != null && index >= components[2] && index < components[3]) {
                        builder.append((char)c);
                    } else {
                        URIUtility.PercentEncodeUtf8(builder, c);
                    }
                } else if (c <= 65535) {
                    builder.append((char)c);
                } else if (c <= 0x10FFFF) {
                    builder.append((char)(c - 65536 >> 10 & 0x3FF | 0xD800));
                    builder.append((char)(c - 65536 & 0x3FF | 0xDC00));
                }
            }
            ++index;
        }
        return builder.toString();
    }

    public static boolean HasScheme(String refValue) {
        int[] segments = refValue == null ? null : URIUtility.SplitIRI(refValue, 0, refValue.length(), ParseMode.IRIStrict);
        return segments != null && segments[0] >= 0;
    }

    public static boolean HasSchemeForURI(String refValue) {
        int[] segments = refValue == null ? null : URIUtility.SplitIRI(refValue, 0, refValue.length(), ParseMode.URIStrict);
        return segments != null && segments[0] >= 0;
    }

    private static boolean IsHexChar(char c) {
        return c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    private static int ToHex(char b1) {
        if (b1 >= '0' && b1 <= '9') {
            return b1 - 48;
        }
        if (b1 >= 'A' && b1 <= 'F') {
            return b1 + 10 - 65;
        }
        return b1 >= 'a' && b1 <= 'f' ? b1 + 10 - 97 : 1;
    }

    public static String PercentDecode(String str) {
        return str == null ? null : URIUtility.PercentDecode(str, 0, str.length());
    }

    public static String PercentDecode(String str, int index, int endIndex) {
        int i;
        if (str == null) {
            return null;
        }
        boolean quickCheck = true;
        int lastIndex = 0;
        for (i = index; i < endIndex; ++i) {
            if (str.charAt(i) < '\ud800' && str.charAt(i) != '%') continue;
            quickCheck = false;
            lastIndex = i;
            break;
        }
        if (quickCheck) {
            return str.substring(index, index + (endIndex - index));
        }
        StringBuilder retString = new StringBuilder();
        retString.append(str, index, index + lastIndex);
        int cp = 0;
        int bytesSeen = 0;
        int bytesNeeded = 0;
        int lower = 128;
        int upper = 191;
        int markedPos = -1;
        for (i = lastIndex; i < endIndex; ++i) {
            int c = str.charAt(i);
            if ((c & 0xFC00) == 55296 && i + 1 < endIndex && (str.charAt(i + 1) & 0xFC00) == 56320) {
                c = 65536 + ((c & 0x3FF) << 10) + (str.charAt(i + 1) & 0x3FF);
                ++i;
            } else if ((c & 0xF800) == 55296) {
                c = 65533;
            }
            if (c == 37 && i + 2 < endIndex) {
                int a = URIUtility.ToHex(str.charAt(i + 1));
                int b = URIUtility.ToHex(str.charAt(i + 2));
                if (a >= 0 && b >= 0) {
                    b = a * 16 + b;
                    i += 2;
                    if (bytesNeeded == 0) {
                        if (b < 128) {
                            retString.append((char)b);
                            continue;
                        }
                        if (b >= 194 && b <= 223) {
                            markedPos = i;
                            bytesNeeded = 1;
                            cp = b - 192;
                        } else if (b >= 224 && b <= 239) {
                            markedPos = i;
                            lower = b == 224 ? 160 : 128;
                            upper = b == 237 ? 159 : 191;
                            bytesNeeded = 2;
                            cp = b - 224;
                        } else if (b >= 240 && b <= 244) {
                            markedPos = i;
                            lower = b == 240 ? 144 : 128;
                            upper = b == 244 ? 143 : 191;
                            bytesNeeded = 3;
                            cp = b - 240;
                        } else {
                            retString.append('\ufffd');
                            continue;
                        }
                        cp <<= 6 * bytesNeeded;
                        continue;
                    }
                    if (b < lower || b > upper) {
                        bytesSeen = 0;
                        bytesNeeded = 0;
                        cp = 0;
                        lower = 128;
                        upper = 191;
                        i = markedPos;
                        retString.append('\ufffd');
                        continue;
                    }
                    lower = 128;
                    upper = 191;
                    cp += b - 128 << 6 * (bytesNeeded - ++bytesSeen);
                    markedPos = i;
                    if (bytesSeen != bytesNeeded) continue;
                    int ret = cp;
                    cp = 0;
                    bytesSeen = 0;
                    bytesNeeded = 0;
                    if (ret <= 65535) {
                        retString.append((char)ret);
                        continue;
                    }
                    retString.append((char)(ret - 65536 >> 10 & 0x3FF | 0xD800));
                    retString.append((char)(ret - 65536 & 0x3FF | 0xDC00));
                    continue;
                }
            }
            if (bytesNeeded > 0) {
                bytesNeeded = 0;
                retString.append('\ufffd');
            }
            if (c <= 65535) {
                retString.append((char)c);
                continue;
            }
            if (c > 0x10FFFF) continue;
            retString.append((char)(c - 65536 >> 10 & 0x3FF | 0xD800));
            retString.append((char)(c - 65536 & 0x3FF | 0xDC00));
        }
        if (bytesNeeded > 0) {
            bytesNeeded = 0;
            retString.append('\ufffd');
        }
        return retString.toString();
    }

    public static String EncodeStringForURI(String s) {
        if (s == null) {
            throw new NullPointerException("s");
        }
        int index = 0;
        StringBuilder builder = new StringBuilder();
        while (index < s.length()) {
            int c = s.charAt(index);
            if ((c & 0xFC00) == 55296 && index + 1 < s.length() && (s.charAt(index + 1) & 0xFC00) == 56320) {
                c = 65536 + ((c & 0x3FF) << 10) + (s.charAt(index + 1) & 0x3FF);
            } else if ((c & 0xF800) == 55296) {
                c = 65533;
            }
            if (c >= 65536) {
                ++index;
            }
            if ((c & 0x7F) == c && (c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || "-_.~".indexOf((char)c) >= 0)) {
                builder.append((char)c);
                ++index;
                continue;
            }
            URIUtility.PercentEncodeUtf8(builder, c);
            ++index;
        }
        return builder.toString();
    }

    private static boolean IsIfragmentChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || (c & 0x7F) == c && "/?-._~:@!$&'()*+,;=".indexOf((char)c) >= 0 || c >= 160 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 921600 && c <= 983037 || c >= 65536 && c <= 917501 && (c & 0xFFFE) != 65534;
    }

    private static boolean IsIpchar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || (c & 0x7F) == c && "/-._~:@!$&'()*+,;=".indexOf((char)c) >= 0 || c >= 160 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 921600 && c <= 983037 || c >= 65536 && c <= 917501 && (c & 0xFFFE) != 65534;
    }

    private static boolean IsIqueryChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || (c & 0x7F) == c && "/?-._~:@!$&'()*+,;=".indexOf((char)c) >= 0 || c >= 160 && c <= 55295 || c >= 57344 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 65536 && c <= 1114109 && (c & 0xFFFE) != 65534 && (c < 917504 || c > 921599);
    }

    private static boolean IsIRegNameChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || (c & 0x7F) == c && "-._~!$&'()*+,;=".indexOf((char)c) >= 0 || c >= 160 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 921600 && c <= 983037 || c >= 65536 && c <= 917501 && (c & 0xFFFE) != 65534;
    }

    private static boolean IsIUserInfoChar(int c) {
        return c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || (c & 0x7F) == c && "-._~:!$&'()*+,;=".indexOf((char)c) >= 0 || c >= 160 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65519 || c >= 921600 && c <= 983037 || c >= 65536 && c <= 917501 && (c & 0xFFFE) != 65534;
    }

    public static boolean IsValidCurieReference(String s, int offset, int length) {
        if (s == null) {
            return false;
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset (" + offset + ") is less than 0 ");
        }
        if (offset > s.length()) {
            throw new IllegalArgumentException("offset (" + offset + ") is more than " + s.length());
        }
        if (length < 0) {
            throw new IllegalArgumentException("length (" + length + ") is less than 0 ");
        }
        if (length > s.length()) {
            throw new IllegalArgumentException("length (" + length + ") is more than " + s.length());
        }
        if (s.length() - offset < length) {
            throw new IllegalArgumentException("s's length minus " + offset + " (" + (s.length() - offset) + ") is less than " + length);
        }
        if (length == 0) {
            return true;
        }
        int index = offset;
        int valueSLength = offset + length;
        int state = 0;
        if (index + 2 <= valueSLength && s.charAt(index) == '/' && s.charAt(index + 1) == '/') {
            return false;
        }
        state = 0;
        while (index < valueSLength) {
            int c = s.charAt(index);
            if ((c & 0xFC00) == 55296 && index + 1 < valueSLength && (s.charAt(index + 1) & 0xFC00) == 56320) {
                c = 65536 + ((c & 0x3FF) << 10) + (s.charAt(index + 1) & 0x3FF);
                ++index;
            } else if ((c & 0xF800) == 55296) {
                return false;
            }
            if (c == 37) {
                if (index + 2 < valueSLength && URIUtility.IsHexChar(s.charAt(index + 1)) && URIUtility.IsHexChar(s.charAt(index + 2))) {
                    index += 3;
                    continue;
                }
                return false;
            }
            if (state == 0) {
                if (c == 63) {
                    state = 1;
                } else if (c == 35) {
                    state = 2;
                } else if (!URIUtility.IsIpchar(c)) {
                    return false;
                }
                ++index;
                continue;
            }
            if (state == 1) {
                if (c == 35) {
                    state = 2;
                } else if (!URIUtility.IsIqueryChar(c)) {
                    return false;
                }
                ++index;
                continue;
            }
            if (state != 2) continue;
            if (!URIUtility.IsIfragmentChar(c)) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static String BuildIRI(String schemeAndAuthority, String path, String query, String fragment) {
        int[] irisplit;
        StringBuilder builder = new StringBuilder();
        if (schemeAndAuthority != null && schemeAndAuthority.length() != 0 && ((irisplit = URIUtility.SplitIRI(schemeAndAuthority)) == null || irisplit[0] < 0 && irisplit[2] < 0 || irisplit[4] != irisplit[5] || irisplit[6] >= 0 || irisplit[8] >= 0)) {
            throw new IllegalArgumentException("invalid schemeAndAuthority");
        }
        if (path == null || path.length() == 0) {
            path = "";
        }
        for (int phase = 0; phase < 3; ++phase) {
            String s = path;
            if (phase == 1) {
                s = query;
                if (query == null) continue;
                builder.append('?');
            } else if (phase == 2) {
                s = fragment;
                if (fragment == null) continue;
                builder.append('#');
            }
            int index = 0;
            if (query == null || fragment == null) continue;
            while (index < s.length()) {
                int c = s.charAt(index);
                if ((c & 0xFC00) == 55296 && index + 1 < s.length() && (s.charAt(index + 1) & 0xFC00) == 56320) {
                    c = 65536 + ((c & 0x3FF) << 10) + (s.charAt(index + 1) & 0x3FF);
                } else if ((c & 0xF800) == 55296) {
                    c = 65533;
                }
                if (c >= 65536) {
                    ++index;
                }
                if (c == 37) {
                    if (index + 2 < s.length() && URIUtility.IsHexChar(s.charAt(index + 1)) && URIUtility.IsHexChar(s.charAt(index + 2))) {
                        builder.append('%');
                        builder.append(s.charAt(index + 1));
                        builder.append(s.charAt(index + 2));
                        index += 3;
                        continue;
                    }
                    builder.append("%25");
                    ++index;
                    continue;
                }
                if ((c & 0x7F) == c && (c >= 65 && c <= 90 || c >= 97 && c <= 122 || c >= 48 && c <= 57 || "-_.~/(=):!$&'*+,;@".indexOf((char)c) >= 0)) {
                    builder.append((char)c);
                    ++index;
                    continue;
                }
                URIUtility.PercentEncodeUtf8(builder, c);
                ++index;
            }
        }
        String ret = builder.toString();
        if (URIUtility.SplitIRI(ret) == null) {
            throw new IllegalArgumentException("The arguments result in an invalid IRI.");
        }
        return ret;
    }

    public static boolean IsValidIRI(String s) {
        return (s == null ? null : URIUtility.SplitIRI(s, 0, s.length(), ParseMode.IRIStrict)) != null;
    }

    public static boolean IsValidIRI(String s, ParseMode mode) {
        return (s == null ? null : URIUtility.SplitIRI(s, 0, s.length(), mode)) != null;
    }

    private static String NormalizePath(String path) {
        int len = path.length();
        if (len == 0 || path.equals("..") || path.equals(".")) {
            return "";
        }
        if (path.indexOf(ValueSlashDot) < 0 && path.indexOf(ValueDotSlash) < 0) {
            return path;
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while (index < len) {
            int index2;
            String builderString;
            char c = path.charAt(index);
            if (index + 3 <= len && c == '/' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '/' || index + 2 == len && c == '.' && path.charAt(index + 1) == '.') {
                index += 2;
                continue;
            }
            if (index + 3 <= len && c == '.' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '/') {
                index += 3;
                continue;
            }
            if (index + 2 <= len && c == '.' && path.charAt(index + 1) == '/' || index + 1 == len && c == '.') {
                ++index;
                continue;
            }
            if (index + 2 == len && c == '/' && path.charAt(index + 1) == '.') {
                builder.append('/');
                break;
            }
            if (index + 3 == len && c == '/' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '.') {
                builderString = builder.toString();
                for (index2 = builder.length() - 1; index2 >= 0 && builderString.charAt(index2) != '/'; --index2) {
                }
                if (index2 < 0) {
                    index2 = 0;
                }
                builder.setLength(index2);
                builder.append('/');
                break;
            }
            if (index + 4 <= len && c == '/' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '.' && path.charAt(index + 3) == '/') {
                builderString = builder.toString();
                for (index2 = builder.length() - 1; index2 >= 0 && builderString.charAt(index2) != '/'; --index2) {
                }
                if (index2 < 0) {
                    index2 = 0;
                }
                builder.setLength(index2);
                index += 3;
                continue;
            }
            builder.append(c);
            ++index;
            while (index < len && (c = path.charAt(index)) != '/') {
                builder.append(c);
                ++index;
            }
        }
        return builder.toString();
    }

    private static int ParseIPLiteral(String s, int offset, int endOffset) {
        int index;
        if (offset == endOffset) {
            return -1;
        }
        if (s.charAt(index) == 'v') {
            char c;
            ++index;
            boolean hex = false;
            while (index < endOffset && URIUtility.IsHexChar(c = s.charAt(index))) {
                hex = true;
                ++index;
            }
            if (!hex) {
                return -1;
            }
            if (index >= endOffset || s.charAt(index) != '.') {
                return -1;
            }
            ++index;
            hex = false;
            while (index < endOffset && ((c = s.charAt(index)) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || (c & 0x7F) == c && ":-._~!$&'()*+,;=".indexOf(c) >= 0)) {
                hex = true;
                ++index;
            }
            if (!hex) {
                return -1;
            }
            if (index >= endOffset || s.charAt(index) != ']') {
                return -1;
            }
            return ++index;
        }
        if (s.charAt(index) == ':' || URIUtility.IsHexChar(s.charAt(index))) {
            int startIndex = index;
            for (index = offset; index < endOffset && (s.charAt(index) >= 'A' && s.charAt(index) <= 'F' || s.charAt(index) >= 'a' && s.charAt(index) <= 'f' || s.charAt(index) >= '0' && s.charAt(index) <= ':' || s.charAt(index) == '.'); ++index) {
            }
            if (index >= endOffset || s.charAt(index) != ']' && s.charAt(index) != '%') {
                return -1;
            }
            int[] addressParts = new int[8];
            int ipEndIndex = index;
            boolean doubleColon = false;
            int doubleColonPos = 0;
            int totalParts = 0;
            boolean ipv4part = false;
            index = startIndex;
            for (int part = 0; part < 8; ++part) {
                if (!doubleColon && ipEndIndex - index > 1 && s.charAt(index) == ':' && s.charAt(index + 1) == ':') {
                    doubleColon = true;
                    doubleColonPos = part;
                    if ((index += 2) == ipEndIndex) break;
                }
                int hex = 0;
                boolean haveHex = false;
                int curindex = index;
                for (int i = 0; i < 4 && URIUtility.IsHexChar(s.charAt(index)); ++i) {
                    hex = hex << 4 | URIUtility.ToHex(s.charAt(index));
                    haveHex = true;
                    ++index;
                }
                if (!haveHex) {
                    return -1;
                }
                if (index < ipEndIndex && s.charAt(index) == '.' && part < 7) {
                    ipv4part = true;
                    index = curindex;
                    break;
                }
                addressParts[part] = hex;
                ++totalParts;
                if (index < ipEndIndex && s.charAt(index) != ':') {
                    return -1;
                }
                if (index == ipEndIndex && doubleColon) break;
                if (index >= ipEndIndex || index + 1 < ipEndIndex && s.charAt(index + 1) == ':') continue;
                ++index;
            }
            if (index != ipEndIndex && !ipv4part) {
                return -1;
            }
            if (doubleColon || ipv4part) {
                if (ipv4part) {
                    int[] ipparts = new int[4];
                    for (int part = 0; part < 4; ++part) {
                        if (part > 0) {
                            if (index < ipEndIndex && s.charAt(index) == '.') {
                                ++index;
                            } else {
                                return -1;
                            }
                        }
                        if (index + 1 < ipEndIndex && s.charAt(index) == '0' && s.charAt(index + 1) >= '0' && s.charAt(index + 1) <= '9') {
                            return -1;
                        }
                        int dec = 0;
                        boolean haveDec = false;
                        int curindex = index;
                        for (int i = 0; i < 4 && s.charAt(index) >= '0' && s.charAt(index) <= '9'; ++i) {
                            dec = dec * 10 + (s.charAt(index) - 48);
                            haveDec = true;
                            ++index;
                        }
                        if (!haveDec || dec > 255) {
                            return -1;
                        }
                        ipparts[part] = dec;
                    }
                    if (index != ipEndIndex) {
                        return -1;
                    }
                    addressParts[totalParts] = ipparts[0] << 8 | ipparts[1];
                    addressParts[totalParts + 1] = ipparts[2] << 8 | ipparts[3];
                    if (!doubleColon && (totalParts += 2) != 8) {
                        return -1;
                    }
                }
                if (doubleColon) {
                    int resid = 8 - totalParts;
                    if (resid == 0) {
                        return -1;
                    }
                    int[] newAddressParts = new int[8];
                    System.arraycopy(addressParts, 0, newAddressParts, 0, doubleColonPos);
                    System.arraycopy(addressParts, doubleColonPos, newAddressParts, doubleColonPos + resid, totalParts - doubleColonPos);
                    System.arraycopy(newAddressParts, 0, addressParts, 0, 8);
                }
            } else if (totalParts != 8) {
                return -1;
            }
            if (s.charAt(index) == '%') {
                if (index + 2 < endOffset && s.charAt(index + 1) == '2' && s.charAt(index + 2) == '5' && (addressParts[0] & 0xFFC0) == 65152) {
                    index += 3;
                    boolean haveChar = false;
                    while (index < endOffset) {
                        char c = s.charAt(index);
                        if (c == ']') {
                            return haveChar ? index + 1 : -1;
                        }
                        if (c == '%') {
                            if (index + 2 < endOffset && URIUtility.IsHexChar(s.charAt(index + 1)) && URIUtility.IsHexChar(s.charAt(index + 2))) {
                                index += 3;
                                haveChar = true;
                                continue;
                            }
                            return -1;
                        }
                        if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == '_' || c == '-' || c == '~') {
                            ++index;
                            haveChar = true;
                            continue;
                        }
                        return -1;
                    }
                    return -1;
                }
                return -1;
            }
            return ++index;
        }
        return -1;
    }

    private static String PathParent(String refValue, int startIndex, int endIndex) {
        if (startIndex > endIndex) {
            return "";
        }
        --endIndex;
        while (endIndex >= startIndex) {
            if (refValue.charAt(endIndex) == '/') {
                return refValue.substring(startIndex, startIndex + (endIndex + 1 - startIndex));
            }
            --endIndex;
        }
        return "";
    }

    private static void PercentEncode(StringBuilder buffer, int b) {
        buffer.append('%');
        buffer.append(HexChars.charAt(b >> 4 & 0xF));
        buffer.append(HexChars.charAt(b & 0xF));
    }

    private static void PercentEncodeUtf8(StringBuilder buffer, int cp) {
        if (cp <= 127) {
            buffer.append('%');
            buffer.append(HexChars.charAt(cp >> 4 & 0xF));
            buffer.append(HexChars.charAt(cp & 0xF));
        } else if (cp <= 2047) {
            URIUtility.PercentEncode(buffer, 0xC0 | cp >> 6 & 0x1F);
            URIUtility.PercentEncode(buffer, 0x80 | cp & 0x3F);
        } else if (cp <= 65535) {
            URIUtility.PercentEncode(buffer, 0xE0 | cp >> 12 & 0xF);
            URIUtility.PercentEncode(buffer, 0x80 | cp >> 6 & 0x3F);
            URIUtility.PercentEncode(buffer, 0x80 | cp & 0x3F);
        } else {
            URIUtility.PercentEncode(buffer, 0xF0 | cp >> 18 & 7);
            URIUtility.PercentEncode(buffer, 0x80 | cp >> 12 & 0x3F);
            URIUtility.PercentEncode(buffer, 0x80 | cp >> 6 & 0x3F);
            URIUtility.PercentEncode(buffer, 0x80 | cp & 0x3F);
        }
    }

    public static String RelativeResolve(String refValue, String absoluteBase) {
        return URIUtility.RelativeResolve(refValue, absoluteBase, ParseMode.IRIStrict);
    }

    public static String RelativeResolve(String refValue, String absoluteBase, ParseMode parseMode) {
        int[] segmentsBase;
        int[] segments;
        int[] nArray = segments = refValue == null ? null : URIUtility.SplitIRI(refValue, 0, refValue.length(), parseMode);
        if (segments == null) {
            return null;
        }
        int[] nArray2 = segmentsBase = absoluteBase == null ? null : URIUtility.SplitIRI(absoluteBase, 0, absoluteBase.length(), parseMode);
        if (segmentsBase == null) {
            return refValue;
        }
        StringBuilder builder = new StringBuilder();
        if (segments[0] >= 0) {
            if (refValue == null) {
                throw new IllegalStateException();
            }
            URIUtility.AppendScheme(builder, refValue, segments);
            URIUtility.AppendAuthority(builder, refValue, segments);
            URIUtility.AppendNormalizedPath(builder, refValue, segments);
            URIUtility.AppendQuery(builder, refValue, segments);
            URIUtility.AppendFragment(builder, refValue, segments);
        } else if (segments[2] >= 0) {
            if (absoluteBase == null) {
                throw new IllegalStateException();
            }
            URIUtility.AppendScheme(builder, absoluteBase, segmentsBase);
            if (refValue == null) {
                throw new NullPointerException("refValue");
            }
            URIUtility.AppendAuthority(builder, refValue, segments);
            URIUtility.AppendNormalizedPath(builder, refValue, segments);
            URIUtility.AppendQuery(builder, refValue, segments);
            URIUtility.AppendFragment(builder, refValue, segments);
        } else if (segments[4] == segments[5]) {
            if (absoluteBase == null) {
                throw new NullPointerException("absoluteBase");
            }
            URIUtility.AppendScheme(builder, absoluteBase, segmentsBase);
            URIUtility.AppendAuthority(builder, absoluteBase, segmentsBase);
            URIUtility.AppendPath(builder, absoluteBase, segmentsBase);
            if (segments[6] >= 0) {
                if (refValue == null) {
                    throw new NullPointerException("refValue");
                }
                URIUtility.AppendQuery(builder, refValue, segments);
            } else {
                URIUtility.AppendQuery(builder, absoluteBase, segmentsBase);
            }
            if (refValue == null) {
                throw new NullPointerException("refValue");
            }
            URIUtility.AppendFragment(builder, refValue, segments);
        } else {
            if (absoluteBase == null) {
                throw new IllegalStateException();
            }
            URIUtility.AppendScheme(builder, absoluteBase, segmentsBase);
            URIUtility.AppendAuthority(builder, absoluteBase, segmentsBase);
            if (refValue == null) {
                throw new IllegalStateException();
            }
            if (segments[4] < segments[5] && refValue.charAt(segments[4]) == '/') {
                URIUtility.AppendNormalizedPath(builder, refValue, segments);
            } else {
                StringBuilder merged = new StringBuilder();
                if (segmentsBase[2] >= 0 && segmentsBase[4] == segmentsBase[5]) {
                    merged.append('/');
                    if (absoluteBase == null) {
                        throw new IllegalStateException();
                    }
                    URIUtility.AppendPath(merged, refValue, segments);
                    builder.append(URIUtility.NormalizePath(merged.toString()));
                } else {
                    merged.append(URIUtility.PathParent(absoluteBase, segmentsBase[4], segmentsBase[5]));
                    URIUtility.AppendPath(merged, refValue, segments);
                    builder.append(URIUtility.NormalizePath(merged.toString()));
                }
            }
            URIUtility.AppendQuery(builder, refValue, segments);
            URIUtility.AppendFragment(builder, refValue, segments);
        }
        return builder.toString();
    }

    private static String ToLowerCaseAscii(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        char c = '\u0000';
        boolean hasUpperCase = false;
        for (int i = 0; i < len; ++i) {
            c = str.charAt(i);
            if (c < 'A' || c > 'Z') continue;
            hasUpperCase = true;
            break;
        }
        if (!hasUpperCase) {
            return str;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            c = str.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                builder.append((char)(c + 32));
                continue;
            }
            builder.append(c);
        }
        return builder.toString();
    }

    public static String[] SplitIRIToStrings(String s) {
        int[] indexes = URIUtility.SplitIRI(s);
        if (indexes == null) {
            return null;
        }
        if (s == null) {
            throw new IllegalStateException();
        }
        String s1 = indexes[0] < 0 ? null : s.substring(indexes[0], indexes[0] + (indexes[1] - indexes[0]));
        String s2 = indexes[2] < 0 ? null : s.substring(indexes[2], indexes[2] + (indexes[3] - indexes[2]));
        String s3 = indexes[4] < 0 ? null : s.substring(indexes[4], indexes[4] + (indexes[5] - indexes[4]));
        String s4 = indexes[6] < 0 ? null : s.substring(indexes[6], indexes[6] + (indexes[7] - indexes[6]));
        String s5 = indexes[8] < 0 ? null : s.substring(indexes[8], indexes[8] + (indexes[9] - indexes[8]));
        return new String[]{s1 == null ? null : URIUtility.ToLowerCaseAscii(s1), s2, s3, s4, s5};
    }

    public static int[] SplitIRI(String s) {
        return s == null ? null : URIUtility.SplitIRI(s, 0, s.length(), ParseMode.IRIStrict);
    }

    public static int[] SplitIRI(String s, int offset, int length, ParseMode parseMode) {
        int index;
        if (s == null) {
            return null;
        }
        if (offset < 0) {
            throw new IllegalArgumentException("offset (" + offset + ") is less than 0");
        }
        if (offset > s.length()) {
            throw new IllegalArgumentException("offset (" + offset + ") is more than " + s.length());
        }
        if (length < 0) {
            throw new IllegalArgumentException("length (" + length + ") is less than 0");
        }
        if (length > s.length()) {
            throw new IllegalArgumentException("length (" + length + ") is more than " + s.length());
        }
        if (s.length() - offset < length) {
            throw new IllegalArgumentException("s's length minus " + offset + " (" + (s.length() - offset) + ") is less than " + length);
        }
        int[] retval = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        if (length == 0) {
            retval[4] = 0;
            retval[5] = 0;
            return retval;
        }
        boolean asciiOnly = parseMode == ParseMode.URILenient || parseMode == ParseMode.URIStrict;
        boolean strict = parseMode == ParseMode.URIStrict || parseMode == ParseMode.IRIStrict;
        int valueSLength = offset + length;
        boolean scheme = false;
        for (index = offset; index < valueSLength; ++index) {
            char c = s.charAt(index);
            if (index > offset && c == ':') {
                scheme = true;
                retval[0] = offset;
                retval[1] = index++;
                break;
            }
            if (!((!strict || index != offset || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') && (!strict || index <= offset || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '+' || c == '-' || c == '.') && (strict || c != '#' && c != ':' && c != '?' && c != '/'))) break;
        }
        if (!scheme) {
            index = offset;
        }
        int state = 0;
        if (index + 2 <= valueSLength && s.charAt(index) == '/' && s.charAt(index + 1) == '/') {
            int authorityStart;
            retval[2] = authorityStart = (index += 2);
            retval[3] = valueSLength;
            state = 0;
            while (index < valueSLength) {
                int c = s.charAt(index);
                if (asciiOnly && c >= 128) {
                    return null;
                }
                if ((c & 0xFC00) == 55296 && index + 1 < valueSLength && (s.charAt(index + 1) & 0xFC00) == 56320) {
                    c = 65536 + ((c & 0x3FF) << 10) + (s.charAt(index + 1) & 0x3FF);
                    ++index;
                } else if ((c & 0xF800) == 55296) {
                    if (parseMode == ParseMode.IRISurrogateLenient) {
                        c = 65533;
                    } else {
                        return null;
                    }
                }
                if (c == 37 && (state == 0 || state == 1) && strict) {
                    if (index + 2 < valueSLength && URIUtility.IsHexChar(s.charAt(index + 1)) && URIUtility.IsHexChar(s.charAt(index + 2))) {
                        index += 3;
                        continue;
                    }
                    return null;
                }
                if (state == 0) {
                    if (c == 47 || c == 63 || c == 35) {
                        state = 1;
                        index = authorityStart;
                        continue;
                    }
                    if (strict && c == 64) {
                        ++index;
                        state = 1;
                        continue;
                    }
                    if (strict && URIUtility.IsIUserInfoChar(c)) {
                        if (++index != valueSLength) continue;
                        state = 1;
                        index = authorityStart;
                        continue;
                    }
                    state = 1;
                    index = authorityStart;
                    continue;
                }
                if (state == 1) {
                    if (c == 47 || c == 63 || c == 35) {
                        retval[3] = index;
                        break;
                    }
                    if (!strict) {
                        ++index;
                        continue;
                    }
                    if (c == 91) {
                        ++index;
                        if ((index = URIUtility.ParseIPLiteral(s, index, valueSLength)) >= 0) continue;
                        return null;
                    }
                    if (c == 58) {
                        state = 2;
                        ++index;
                        continue;
                    }
                    if (URIUtility.IsIRegNameChar(c)) {
                        ++index;
                        continue;
                    }
                    return null;
                }
                if (state != 2) continue;
                if (c == 47 || c == 63 || c == 35) {
                    retval[3] = index;
                    break;
                }
                if (c >= 48 && c <= 57) {
                    ++index;
                    continue;
                }
                return null;
            }
        }
        boolean colon = false;
        boolean segment = false;
        boolean fullyRelative = index == offset;
        retval[4] = index;
        retval[5] = valueSLength;
        state = 0;
        while (index < valueSLength) {
            int c = s.charAt(index);
            if (asciiOnly && c >= 128) {
                return null;
            }
            if ((c & 0xFC00) == 55296 && index + 1 < valueSLength && (s.charAt(index + 1) & 0xFC00) == 56320) {
                c = 65536 + ((c & 0x3FF) << 10) + (s.charAt(index + 1) & 0x3FF);
                ++index;
            } else if ((c & 0xF800) == 55296) {
                return null;
            }
            if (c == 37 && strict) {
                if (index + 2 < valueSLength && URIUtility.IsHexChar(s.charAt(index + 1)) && URIUtility.IsHexChar(s.charAt(index + 2))) {
                    index += 3;
                    continue;
                }
                return null;
            }
            if (state == 0) {
                if (c == 58 && fullyRelative) {
                    colon = true;
                } else if (c == 47 && fullyRelative && !segment) {
                    if (strict && colon) {
                        return null;
                    }
                    segment = true;
                }
                if (c == 63) {
                    retval[5] = index;
                    retval[6] = index + 1;
                    retval[7] = valueSLength;
                    state = 1;
                } else if (c == 35) {
                    retval[5] = index;
                    retval[8] = index + 1;
                    retval[9] = valueSLength;
                    state = 2;
                } else if (strict && !URIUtility.IsIpchar(c)) {
                    return null;
                }
                ++index;
                continue;
            }
            if (state == 1) {
                if (c == 35) {
                    retval[7] = index;
                    retval[8] = index + 1;
                    retval[9] = valueSLength;
                    state = 2;
                } else if (strict && !URIUtility.IsIqueryChar(c)) {
                    return null;
                }
                ++index;
                continue;
            }
            if (state != 2) continue;
            if (strict && !URIUtility.IsIfragmentChar(c)) {
                return null;
            }
            ++index;
        }
        if (strict && fullyRelative && colon && !segment) {
            return null;
        }
        return retval;
    }

    public static int[] SplitIRI(String s, ParseMode parseMode) {
        return s == null ? null : URIUtility.SplitIRI(s, 0, s.length(), parseMode);
    }

    private static boolean PathHasDotComponent(String path) {
        if (path == null || path.length() == 0) {
            return false;
        }
        if ((path = URIUtility.PercentDecode(path)).equals("..")) {
            return true;
        }
        if (path.equals(".")) {
            return true;
        }
        if (path.indexOf(ValueSlashDot) < 0 && path.indexOf(ValueDotSlash) < 0) {
            return false;
        }
        int index = 0;
        int len = path.length();
        while (index < len) {
            char c = path.charAt(index);
            if (index + 3 <= len && c == '/' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '/' || index + 2 == len && c == '.' && path.charAt(index + 1) == '.') {
                return true;
            }
            if (index + 3 <= len && c == '.' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '/') {
                return true;
            }
            if (index + 2 <= len && c == '.' && path.charAt(index + 1) == '/' || index + 1 == len && c == '.') {
                return true;
            }
            if (index + 2 == len && c == '/' && path.charAt(index + 1) == '.') {
                return true;
            }
            if (index + 3 == len && c == '/' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '.') {
                return true;
            }
            if (index + 4 <= len && c == '/' && path.charAt(index + 1) == '.' && path.charAt(index + 2) == '.' && path.charAt(index + 3) == '/') {
                return true;
            }
            ++index;
            while (index < len && (c = path.charAt(index)) != '/') {
                ++index;
            }
        }
        return false;
    }

    private static String UriPath(String uri, ParseMode parseMode) {
        int[] indexes = URIUtility.SplitIRI(uri, parseMode);
        return indexes == null ? null : uri.substring(indexes[4], indexes[4] + (indexes[5] - indexes[4]));
    }

    public static String DirectoryPath(String uref) {
        return URIUtility.DirectoryPath(uref, ParseMode.IRIStrict);
    }

    public static String DirectoryPath(String uref, ParseMode parseMode) {
        int[] indexes = URIUtility.SplitIRI(uref, parseMode);
        if (indexes == null) {
            return null;
        }
        if (uref == null) {
            throw new IllegalStateException();
        }
        String schemeAndAuthority = uref.substring(0, indexes[4]);
        String path = uref.substring(indexes[4], indexes[4] + (indexes[5] - indexes[4]));
        if (path.length() > 0) {
            for (int i = path.length() - 1; i >= 0; --i) {
                if (path.charAt(i) != '/') continue;
                return schemeAndAuthority + path.substring(0, i + 1);
            }
            return schemeAndAuthority + path;
        }
        return schemeAndAuthority;
    }

    public static String RelativeResolveWithinBaseURI(String refValue, String absoluteBase) {
        if (absoluteBase != null && absoluteBase.length() != 0 && URIUtility.SplitIRI(absoluteBase, ParseMode.IRIStrict) == null) {
            return null;
        }
        String rel = URIUtility.RelativeResolve(refValue, absoluteBase);
        if (rel == null) {
            return null;
        }
        if (refValue == null) {
            throw new IllegalStateException();
        }
        String relpath = URIUtility.UriPath(refValue, ParseMode.IRIStrict);
        if (URIUtility.PathHasDotComponent(relpath)) {
            return null;
        }
        String absuri = URIUtility.DirectoryPath(absoluteBase);
        String reluri = URIUtility.DirectoryPath(rel);
        return absuri == null || reluri == null || !absuri.equals(reluri) ? null : rel;
    }

    public static enum ParseMode {
        IRIStrict,
        URIStrict,
        IRILenient,
        URILenient,
        IRISurrogateLenient;

    }
}

