/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.impl.BackPressureListener;
import com.github.phantomthief.collection.impl.RejectHandler;
import java.util.concurrent.locks.Condition;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackPressureHandler<T>
implements RejectHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(BackPressureHandler.class);
    @Nullable
    private final BackPressureListener<T> listener;

    BackPressureHandler(BackPressureListener<T> listener) {
        this.listener = listener;
    }

    @Override
    public boolean onReject(T element, @Nullable Condition condition) {
        if (this.listener != null) {
            try {
                this.listener.onHandle(element);
            }
            catch (Throwable e) {
                logger.error("", e);
            }
        }
        assert (condition != null);
        condition.awaitUninterruptibly();
        return true;
    }
}

