/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.BufferTrigger;
import com.github.phantomthief.collection.impl.BackPressureListener;
import com.github.phantomthief.collection.impl.SimpleBufferTrigger;
import com.github.phantomthief.collection.impl.SimpleBufferTriggerBuilder;
import com.github.phantomthief.util.MoreSuppliers;
import com.github.phantomthief.util.ThrowableConsumer;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class GenericSimpleBufferTriggerBuilder<E, C> {
    private final SimpleBufferTriggerBuilder<Object, Object> builder;

    public GenericSimpleBufferTriggerBuilder(SimpleBufferTriggerBuilder<Object, Object> builder) {
        this.builder = builder;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> setContainer(Supplier<? extends C> factory, BiPredicate<? super C, ? super E> queueAdder) {
        this.builder.setContainer(factory, queueAdder);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> setContainerEx(Supplier<? extends C> factory, ToIntBiFunction<? super C, ? super E> queueAdder) {
        this.builder.setContainerEx(factory, queueAdder);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> setScheduleExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.builder.setScheduleExecutorService(scheduledExecutorService);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> setExceptionHandler(BiConsumer<? super Throwable, ? super C> exceptionHandler) {
        this.builder.setExceptionHandler(exceptionHandler);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> triggerStrategy(SimpleBufferTrigger.TriggerStrategy triggerStrategy) {
        this.builder.triggerStrategy(triggerStrategy);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> intervalAtFixedRate(final long interval, final TimeUnit unit) {
        this.builder.triggerStrategy(new SimpleBufferTrigger.TriggerStrategy(){
            private final Supplier<Long> time = MoreSuppliers.lazy(System::currentTimeMillis);

            @Override
            public SimpleBufferTrigger.TriggerResult canTrigger(long last, long change) {
                long alignTime = this.time.get();
                long intervalInMs = unit.toMillis(interval);
                long result = intervalInMs - (System.currentTimeMillis() - alignTime) % intervalInMs;
                return SimpleBufferTrigger.TriggerResult.trig(change > 0L, result);
            }
        });
        return this;
    }

    @Deprecated
    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> on(long interval, TimeUnit unit, long count) {
        this.builder.on(interval, unit, count);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> interval(long interval, TimeUnit unit) {
        this.builder.interval(interval, unit);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> interval(LongSupplier interval, TimeUnit unit) {
        this.builder.interval(interval, unit);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> consumer(ThrowableConsumer<? super C, Throwable> consumer) {
        this.builder.consumer(consumer);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> maxBufferCount(long count) {
        this.builder.maxBufferCount(count);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> maxBufferCount(@Nonnull LongSupplier count) {
        this.builder.maxBufferCount(count);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> disableSwitchLock() {
        this.builder.disableSwitchLock();
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> maxBufferCount(long count, Consumer<? super E> rejectHandler) {
        this.builder.maxBufferCount(count, rejectHandler);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> rejectHandler(Consumer<? super E> rejectHandler) {
        this.builder.rejectHandler(rejectHandler);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> enableBackPressure() {
        this.builder.enableBackPressure();
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> enableBackPressure(BackPressureListener<E> listener) {
        this.builder.enableBackPressure(listener);
        return this;
    }

    @CheckReturnValue
    public GenericSimpleBufferTriggerBuilder<E, C> name(String name) {
        this.builder.name(name);
        return this;
    }

    public BufferTrigger<E> build() {
        return this.builder.build();
    }
}

