/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.BufferTrigger;
import com.github.phantomthief.collection.impl.BackPressureHandler;
import com.github.phantomthief.collection.impl.BackPressureListener;
import com.github.phantomthief.collection.impl.LazyBufferTrigger;
import com.github.phantomthief.collection.impl.MultiIntervalTriggerStrategy;
import com.github.phantomthief.collection.impl.RejectHandler;
import com.github.phantomthief.collection.impl.SimpleBufferTrigger;
import com.github.phantomthief.util.ThrowableConsumer;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBufferTriggerBuilder<E, C> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleBufferTriggerBuilder.class);
    private boolean maxBufferCountWasSet = false;
    SimpleBufferTrigger.TriggerStrategy triggerStrategy;
    ScheduledExecutorService scheduledExecutorService;
    boolean usingInnerExecutor;
    Supplier<C> bufferFactory;
    ToIntBiFunction<C, E> queueAdder;
    ThrowableConsumer<C, Throwable> consumer;
    BiConsumer<Throwable, C> exceptionHandler;
    LongSupplier maxBufferCount = () -> -1L;
    RejectHandler<E> rejectHandler;
    String name;
    boolean disableSwitchLock;

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> setContainer(Supplier<? extends C1> factory, BiPredicate<? super C1, ? super E1> queueAdder) {
        Preconditions.checkNotNull(factory);
        Preconditions.checkNotNull(queueAdder);
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.bufferFactory = factory;
        thisBuilder.queueAdder = (c, e) -> queueAdder.test((Object)c, (Object)e) ? 1 : 0;
        return thisBuilder;
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> setContainerEx(Supplier<? extends C1> factory, ToIntBiFunction<? super C1, ? super E1> queueAdder) {
        Preconditions.checkNotNull(factory);
        Preconditions.checkNotNull(queueAdder);
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.bufferFactory = factory;
        thisBuilder.queueAdder = queueAdder;
        return thisBuilder;
    }

    public SimpleBufferTriggerBuilder<E, C> setScheduleExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> setExceptionHandler(BiConsumer<? super Throwable, ? super C1> exceptionHandler) {
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.exceptionHandler = exceptionHandler;
        return thisBuilder;
    }

    public SimpleBufferTriggerBuilder<E, C> disableSwitchLock() {
        this.disableSwitchLock = true;
        return this;
    }

    public SimpleBufferTriggerBuilder<E, C> triggerStrategy(SimpleBufferTrigger.TriggerStrategy triggerStrategy) {
        this.triggerStrategy = triggerStrategy;
        return this;
    }

    @Deprecated
    public SimpleBufferTriggerBuilder<E, C> on(long interval, TimeUnit unit, long count) {
        if (this.triggerStrategy == null) {
            this.triggerStrategy = new MultiIntervalTriggerStrategy();
        }
        if (this.triggerStrategy instanceof MultiIntervalTriggerStrategy) {
            ((MultiIntervalTriggerStrategy)this.triggerStrategy).on(interval, unit, count);
        } else {
            logger.warn("exists non multi interval trigger strategy found. ignore setting:{},{}->{}", new Object[]{interval, unit, count});
        }
        return this;
    }

    public SimpleBufferTriggerBuilder<E, C> interval(long interval, TimeUnit unit) {
        return this.interval(() -> interval, unit);
    }

    public SimpleBufferTriggerBuilder<E, C> interval(LongSupplier interval, TimeUnit unit) {
        this.triggerStrategy = (last, change) -> {
            long intervalInMs = unit.toMillis(interval.getAsLong());
            return SimpleBufferTrigger.TriggerResult.trig(change > 0L && System.currentTimeMillis() - last >= intervalInMs, intervalInMs);
        };
        return this;
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> consumer(ThrowableConsumer<? super C1, Throwable> consumer) {
        Preconditions.checkNotNull(consumer);
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.consumer = consumer;
        return thisBuilder;
    }

    public SimpleBufferTriggerBuilder<E, C> maxBufferCount(long count) {
        Preconditions.checkArgument((count > 0L ? 1 : 0) != 0);
        return this.maxBufferCount(() -> count);
    }

    public SimpleBufferTriggerBuilder<E, C> maxBufferCount(@Nonnull LongSupplier count) {
        this.maxBufferCount = (LongSupplier)Preconditions.checkNotNull((Object)count);
        this.maxBufferCountWasSet = true;
        return this;
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> maxBufferCount(long count, Consumer<? super E1> rejectHandler) {
        return this.maxBufferCount(count).rejectHandler(rejectHandler);
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> rejectHandler(Consumer<? super E1> rejectHandler) {
        Preconditions.checkNotNull(rejectHandler);
        return this.rejectHandlerEx((e, h) -> {
            rejectHandler.accept((Object)e);
            return false;
        });
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> enableBackPressure() {
        return this.enableBackPressure(null);
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> enableBackPressure(BackPressureListener<E1> listener) {
        if (this.rejectHandler != null) {
            throw new IllegalStateException("cannot enable back-pressure while reject handler was set.");
        }
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.rejectHandler = new BackPressureHandler<E1>(listener);
        return thisBuilder;
    }

    private <E1, C1> SimpleBufferTriggerBuilder<E1, C1> rejectHandlerEx(RejectHandler<? super E1> rejectHandler) {
        Preconditions.checkNotNull(rejectHandler);
        if (this.rejectHandler instanceof BackPressureHandler) {
            throw new IllegalStateException("cannot set reject handler while enable back-pressure.");
        }
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.rejectHandler = rejectHandler;
        return thisBuilder;
    }

    public SimpleBufferTriggerBuilder<E, C> name(String name) {
        this.name = name;
        return this;
    }

    public <E1> BufferTrigger<E1> build() {
        this.check();
        return new LazyBufferTrigger(() -> {
            this.ensure();
            SimpleBufferTriggerBuilder builder = this;
            return new SimpleBufferTrigger(builder);
        });
    }

    private void check() {
        Preconditions.checkNotNull(this.consumer);
        if (this.rejectHandler instanceof BackPressureHandler) {
            if (this.disableSwitchLock) {
                throw new IllegalStateException("back-pressure cannot work together with switch lock disabled.");
            }
            if (!this.maxBufferCountWasSet) {
                throw new IllegalStateException("back-pressure need to set maxBufferCount.");
            }
        }
    }

    private void ensure() {
        if (this.triggerStrategy == null) {
            logger.warn("no trigger strategy found. using NO-OP trigger");
            this.triggerStrategy = (t, n) -> SimpleBufferTrigger.TriggerResult.empty();
        }
        if (this.bufferFactory == null && this.queueAdder == null) {
            logger.warn("no container found. use default thread-safe HashSet as container.");
            this.bufferFactory = () -> Collections.newSetFromMap(new ConcurrentHashMap());
            this.queueAdder = (c, e) -> ((Set)c).add(e) ? 1 : 0;
        }
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.makeScheduleExecutor();
            this.usingInnerExecutor = true;
        }
    }

    private ScheduledExecutorService makeScheduleExecutor() {
        String threadPattern = this.name == null ? "pool-simple-buffer-trigger-thread-%d" : "pool-simple-buffer-trigger-thread-[" + this.name + "]";
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat(threadPattern).setDaemon(true).build());
    }
}

