/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.impl.BackPressureListener;
import com.github.phantomthief.collection.impl.GlobalBackPressureListener;
import com.github.phantomthief.collection.impl.RejectHandler;
import java.util.concurrent.locks.Condition;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BackPressureHandler<T>
implements RejectHandler<T> {
    private static final Logger logger = LoggerFactory.getLogger(BackPressureHandler.class);
    private static GlobalBackPressureListener globalBackPressureListener = null;
    @Nullable
    private final BackPressureListener<T> listener;
    private String name;

    BackPressureHandler(BackPressureListener<T> listener) {
        this.listener = listener;
    }

    void setName(String name) {
        this.name = name;
    }

    @Override
    public boolean onReject(T element, @Nullable Condition condition) {
        if (this.listener != null) {
            try {
                this.listener.onHandle(element);
            }
            catch (Throwable e) {
                logger.error("", e);
            }
        }
        if (globalBackPressureListener != null) {
            try {
                globalBackPressureListener.onHandle(this.name, element);
            }
            catch (Throwable e) {
                logger.error("", e);
            }
        }
        assert (condition != null);
        long startNano = System.nanoTime();
        condition.awaitUninterruptibly();
        long blockInNano = System.nanoTime() - startNano;
        if (globalBackPressureListener != null) {
            try {
                globalBackPressureListener.postHandle(this.name, element, blockInNano);
            }
            catch (Throwable e) {
                logger.error("", e);
            }
        }
        return true;
    }

    static void setupGlobalBackPressureListener(GlobalBackPressureListener listener) {
        globalBackPressureListener = listener;
    }
}

