/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.impl.SimpleBufferTrigger;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class MultiIntervalTriggerStrategy
implements SimpleBufferTrigger.TriggerStrategy {
    private long minTriggerPeriod = Long.MAX_VALUE;
    private final SortedMap<Long, Long> triggerMap = new TreeMap<Long, Long>();

    public MultiIntervalTriggerStrategy on(long interval, TimeUnit unit, long count) {
        long intervalInMs = unit.toMillis(interval);
        this.triggerMap.put(intervalInMs, count);
        this.minTriggerPeriod = this.checkAndCalcMinPeriod();
        return this;
    }

    long minTriggerPeriod() {
        return this.minTriggerPeriod;
    }

    private long checkAndCalcMinPeriod() {
        long minPeriod = Long.MAX_VALUE;
        Long maxTrigChangeCount = null;
        long lastPeriod = 0L;
        for (Map.Entry<Long, Long> entry : this.triggerMap.entrySet()) {
            long period = entry.getKey();
            minPeriod = Math.min(minPeriod, period);
            if (lastPeriod > 0L) {
                minPeriod = Math.min(minPeriod, Math.abs(lastPeriod - period));
            }
            long trigChangedCount = entry.getValue();
            if (maxTrigChangeCount == null) {
                maxTrigChangeCount = trigChangedCount;
            } else if (maxTrigChangeCount <= trigChangedCount) {
                throw new IllegalArgumentException("found invalid trigger setting:" + this.triggerMap);
            }
            lastPeriod = period;
        }
        return minPeriod;
    }

    @Override
    public SimpleBufferTrigger.TriggerResult canTrigger(long lastConsumeTimestamp, long changedCount) {
        Preconditions.checkArgument((!this.triggerMap.isEmpty() ? 1 : 0) != 0);
        boolean doConsumer = false;
        long now = System.currentTimeMillis();
        for (Map.Entry<Long, Long> entry : this.triggerMap.entrySet()) {
            if (now - lastConsumeTimestamp < entry.getKey() || changedCount < entry.getValue()) continue;
            doConsumer = true;
            break;
        }
        return SimpleBufferTrigger.TriggerResult.trig(doConsumer, this.minTriggerPeriod);
    }
}

