/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.BufferTrigger;
import com.github.phantomthief.collection.impl.BatchConsumeBlockingQueueTrigger;
import com.github.phantomthief.collection.impl.LazyBufferTrigger;
import com.github.phantomthief.util.ThrowableConsumer;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public final class BatchConsumerTriggerBuilder<E> {
    private static final long DEFAULT_LINGER_MS = TimeUnit.SECONDS.toMillis(1L);
    private ScheduledExecutorService scheduledExecutorService;
    private long lingerMs;
    private int batchSize;
    private int bufferSize;
    private ThrowableConsumer<List<E>, Exception> consumer;
    private BiConsumer<Throwable, List<E>> exceptionHandler;

    public BatchConsumerTriggerBuilder<E> setScheduleExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    @Deprecated
    public BatchConsumerTriggerBuilder<E> forceConsumeEveryTick() {
        return this;
    }

    @Deprecated
    public BatchConsumerTriggerBuilder<E> tickTime(long time, TimeUnit unit) {
        return this.linger(time, unit);
    }

    public BatchConsumerTriggerBuilder<E> linger(long time, TimeUnit unit) {
        this.lingerMs = unit.toMillis(time);
        return this;
    }

    public BatchConsumerTriggerBuilder<E> linger(Duration duration) {
        this.lingerMs = duration.toMillis();
        return this;
    }

    @Deprecated
    public BatchConsumerTriggerBuilder<E> batchConsumerSize(int size) {
        this.batchSize = size;
        return this;
    }

    public BatchConsumerTriggerBuilder<E> batchSize(int size) {
        this.batchSize = size;
        return this;
    }

    @Deprecated
    public <E1> BatchConsumerTriggerBuilder<E1> setQueue(BlockingQueue<? extends E> queue) {
        return this;
    }

    @Deprecated
    public <E1> BatchConsumerTriggerBuilder<E1> setConsumer(Consumer<? super List<E1>> consumer) {
        BatchConsumerTriggerBuilder thisBuilder = this;
        thisBuilder.consumer = consumer::accept;
        return thisBuilder;
    }

    public <E1> BatchConsumerTriggerBuilder<E1> setConsumerEx(ThrowableConsumer<? super List<E1>, Exception> consumer) {
        BatchConsumerTriggerBuilder thisBuilder = this;
        thisBuilder.consumer = arg_0 -> consumer.accept(arg_0);
        return thisBuilder;
    }

    public <E1> BatchConsumerTriggerBuilder<E1> setExceptionHandler(BiConsumer<? super Throwable, ? super List<E1>> exceptionHandler) {
        BatchConsumerTriggerBuilder thisBuilder = this;
        thisBuilder.exceptionHandler = exceptionHandler;
        return thisBuilder;
    }

    @Deprecated
    public BatchConsumerTriggerBuilder<E> queueCapacity(int capacity) {
        return this.bufferSize(capacity);
    }

    public BatchConsumerTriggerBuilder<E> bufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
        return this;
    }

    public <E1> BufferTrigger<E1> build() {
        return new LazyBufferTrigger(() -> {
            this.ensure();
            return new BatchConsumeBlockingQueueTrigger<E>(this.lingerMs, this.batchSize, this.bufferSize, this.exceptionHandler, this.consumer, this.scheduledExecutorService);
        });
    }

    private void ensure() {
        Preconditions.checkNotNull(this.consumer);
        if (this.lingerMs <= 0L) {
            this.lingerMs = DEFAULT_LINGER_MS;
        }
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.makeScheduleExecutor();
        }
    }

    private ScheduledExecutorService makeScheduleExecutor() {
        return Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("pool-batch-consume-blocking-queue-thread-%d").setDaemon(true).build());
    }
}

