/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.BufferTrigger;
import com.github.phantomthief.collection.impl.GenericSimpleBufferTriggerBuilder;
import com.github.phantomthief.collection.impl.SimpleBufferTriggerBuilder;
import com.github.phantomthief.util.ThrowableConsumer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBufferTrigger<E>
implements BufferTrigger<E> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleBufferTrigger.class);
    private static final long DEFAULT_NEXT_TRIGGER_PERIOD = TimeUnit.SECONDS.toMillis(1L);
    private final AtomicLong counter = new AtomicLong();
    private final ThrowableConsumer<Object, Throwable> consumer;
    private final ToIntBiFunction<Object, E> queueAdder;
    private final Supplier<Object> bufferFactory;
    private final BiConsumer<Throwable, Object> exceptionHandler;
    private final AtomicReference<Object> buffer = new AtomicReference();
    private final long maxBufferCount;
    private final Consumer<E> rejectHandler;
    private final ReentrantReadWriteLock.ReadLock readLock;
    private final ReentrantReadWriteLock.WriteLock writeLock;
    private volatile long lastConsumeTimestamp = System.currentTimeMillis();

    SimpleBufferTrigger(Supplier<Object> bufferFactory, ToIntBiFunction<Object, E> queueAdder, ScheduledExecutorService scheduledExecutorService, ThrowableConsumer<Object, Throwable> consumer, TriggerStrategy triggerStrategy, BiConsumer<Throwable, Object> exceptionHandler, long maxBufferCount, Consumer<E> rejectHandler) {
        this.queueAdder = queueAdder;
        this.bufferFactory = bufferFactory;
        this.consumer = consumer;
        this.exceptionHandler = exceptionHandler;
        this.maxBufferCount = maxBufferCount;
        this.rejectHandler = rejectHandler;
        this.buffer.set(this.bufferFactory.get());
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
        scheduledExecutorService.schedule(new TriggerRunnable(scheduledExecutorService, triggerStrategy), DEFAULT_NEXT_TRIGGER_PERIOD, TimeUnit.MILLISECONDS);
    }

    @Deprecated
    public static SimpleBufferTriggerBuilder<Object, Object> newBuilder() {
        return new SimpleBufferTriggerBuilder<Object, Object>();
    }

    @Deprecated
    public static <E, C> GenericSimpleBufferTriggerBuilder<E, C> newGenericBuilder() {
        return new GenericSimpleBufferTriggerBuilder(SimpleBufferTrigger.newBuilder());
    }

    public static SimpleBufferTriggerBuilder<Object, Map<Object, Integer>> newCounterBuilder() {
        return new SimpleBufferTriggerBuilder().setContainer(ConcurrentHashMap::new, (map, element) -> {
            map.merge(element, 1, Math::addExact);
            return true;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueue(E element) {
        long currentCount = this.counter.get();
        if (this.maxBufferCount > 0L && currentCount >= this.maxBufferCount) {
            if (this.rejectHandler != null) {
                this.rejectHandler.accept(element);
            }
            return;
        }
        boolean locked = false;
        try {
            this.readLock.lock();
            locked = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            Object thisBuffer = this.buffer.get();
            int changedCount = this.queueAdder.applyAsInt(thisBuffer, element);
            if (changedCount > 0) {
                this.counter.addAndGet(changedCount);
            }
        }
        finally {
            if (locked) {
                this.readLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void manuallyDoTrigger() {
        SimpleBufferTrigger simpleBufferTrigger = this;
        synchronized (simpleBufferTrigger) {
            this.doConsume();
        }
    }

    private void doConsume() {
        Object old = null;
        try {
            this.writeLock.lock();
            try {
                old = this.buffer.getAndSet(this.bufferFactory.get());
            }
            finally {
                this.counter.set(0L);
                this.writeLock.unlock();
            }
            if (old != null) {
                this.consumer.accept(old);
            }
        }
        catch (Throwable e) {
            if (this.exceptionHandler != null) {
                try {
                    this.exceptionHandler.accept(e, old);
                }
                catch (Throwable idontcare) {
                    e.printStackTrace();
                    idontcare.printStackTrace();
                }
            }
            logger.error("Ops.", e);
        }
    }

    @Override
    public long getPendingChanges() {
        return this.counter.get();
    }

    private class TriggerRunnable
    implements Runnable {
        private final ScheduledExecutorService scheduledExecutorService;
        private final TriggerStrategy triggerStrategy;

        TriggerRunnable(ScheduledExecutorService scheduledExecutorService, TriggerStrategy triggerStrategy) {
            this.scheduledExecutorService = scheduledExecutorService;
            this.triggerStrategy = triggerStrategy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SimpleBufferTrigger simpleBufferTrigger = SimpleBufferTrigger.this;
            synchronized (simpleBufferTrigger) {
                long nextTrigPeriod = DEFAULT_NEXT_TRIGGER_PERIOD;
                try {
                    TriggerResult triggerResult = this.triggerStrategy.canTrigger(SimpleBufferTrigger.this.lastConsumeTimestamp, SimpleBufferTrigger.this.counter.get());
                    nextTrigPeriod = triggerResult.nextPeriod;
                    long beforeConsume = System.currentTimeMillis();
                    if (triggerResult.doConsumer) {
                        SimpleBufferTrigger.this.lastConsumeTimestamp = beforeConsume;
                        SimpleBufferTrigger.this.doConsume();
                    }
                    nextTrigPeriod -= System.currentTimeMillis() - beforeConsume;
                }
                catch (Throwable e) {
                    logger.error("", e);
                }
                nextTrigPeriod = Math.max(0L, nextTrigPeriod);
                this.scheduledExecutorService.schedule(this, nextTrigPeriod, TimeUnit.MILLISECONDS);
            }
        }
    }

    public static class TriggerResult {
        private static final TriggerResult EMPTY = new TriggerResult(false, TimeUnit.DAYS.toMillis(1L));
        private final boolean doConsumer;
        private final long nextPeriod;

        private TriggerResult(boolean doConsumer, long nextPeriod) {
            this.doConsumer = doConsumer;
            this.nextPeriod = nextPeriod;
        }

        public static TriggerResult trig(boolean doConsumer, long nextPeriod) {
            return new TriggerResult(doConsumer, nextPeriod);
        }

        public static TriggerResult empty() {
            return EMPTY;
        }
    }

    public static interface TriggerStrategy {
        public TriggerResult canTrigger(long var1, long var3);
    }
}

