/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.collection.impl;

import com.github.phantomthief.collection.BufferTrigger;
import com.github.phantomthief.collection.impl.LazyBufferTrigger;
import com.github.phantomthief.collection.impl.MultiIntervalTriggerStrategy;
import com.github.phantomthief.collection.impl.SimpleBufferTrigger;
import com.github.phantomthief.util.ThrowableConsumer;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.function.ToIntBiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleBufferTriggerBuilder<E, C> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleBufferTriggerBuilder.class);
    private SimpleBufferTrigger.TriggerStrategy triggerStrategy;
    private ScheduledExecutorService scheduledExecutorService;
    private Supplier<C> bufferFactory;
    private ToIntBiFunction<C, E> queueAdder;
    private ThrowableConsumer<C, Throwable> consumer;
    private BiConsumer<Throwable, C> exceptionHandler;
    private long maxBufferCount = -1L;
    private Consumer<E> rejectHandler;

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> setContainer(Supplier<? extends C1> factory, BiPredicate<? super C1, ? super E1> queueAdder) {
        Preconditions.checkNotNull(factory);
        Preconditions.checkNotNull(queueAdder);
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.bufferFactory = factory;
        thisBuilder.queueAdder = (c, e) -> queueAdder.test((Object)c, (Object)e) ? 1 : 0;
        return thisBuilder;
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> setContainerEx(Supplier<? extends C1> factory, ToIntBiFunction<? super C1, ? super E1> queueAdder) {
        Preconditions.checkNotNull(factory);
        Preconditions.checkNotNull(queueAdder);
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.bufferFactory = factory;
        thisBuilder.queueAdder = queueAdder;
        return thisBuilder;
    }

    public SimpleBufferTriggerBuilder<E, C> setScheduleExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
        return this;
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> setExceptionHandler(BiConsumer<? super Throwable, ? super C1> exceptionHandler) {
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.exceptionHandler = exceptionHandler;
        return thisBuilder;
    }

    public SimpleBufferTriggerBuilder<E, C> triggerStrategy(SimpleBufferTrigger.TriggerStrategy triggerStrategy) {
        this.triggerStrategy = triggerStrategy;
        return this;
    }

    @Deprecated
    public SimpleBufferTriggerBuilder<E, C> on(long interval, TimeUnit unit, long count) {
        if (this.triggerStrategy == null) {
            this.triggerStrategy = new MultiIntervalTriggerStrategy();
        }
        if (this.triggerStrategy instanceof MultiIntervalTriggerStrategy) {
            ((MultiIntervalTriggerStrategy)this.triggerStrategy).on(interval, unit, count);
        } else {
            logger.warn("exists non multi interval trigger strategy found. ignore setting:{},{}->{}", new Object[]{interval, unit, count});
        }
        return this;
    }

    public SimpleBufferTriggerBuilder<E, C> interval(long interval, TimeUnit unit) {
        return this.interval(() -> interval, unit);
    }

    public SimpleBufferTriggerBuilder<E, C> interval(LongSupplier interval, TimeUnit unit) {
        this.triggerStrategy = (last, change) -> {
            long intervalInMs = unit.toMillis(interval.getAsLong());
            return SimpleBufferTrigger.TriggerResult.trig(change > 0L && System.currentTimeMillis() - last >= intervalInMs, intervalInMs);
        };
        return this;
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> consumer(ThrowableConsumer<? super C1, Throwable> consumer) {
        Preconditions.checkNotNull(consumer);
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.consumer = consumer;
        return thisBuilder;
    }

    public SimpleBufferTriggerBuilder<E, C> maxBufferCount(long count) {
        Preconditions.checkArgument((count > 0L ? 1 : 0) != 0);
        this.maxBufferCount = count;
        return this;
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> maxBufferCount(long count, Consumer<? super E1> rejectHandler) {
        return this.maxBufferCount(count).rejectHandler(rejectHandler);
    }

    public <E1, C1> SimpleBufferTriggerBuilder<E1, C1> rejectHandler(Consumer<? super E1> rejectHandler) {
        Preconditions.checkNotNull(rejectHandler);
        SimpleBufferTriggerBuilder thisBuilder = this;
        thisBuilder.rejectHandler = rejectHandler;
        return thisBuilder;
    }

    public <E1> BufferTrigger<E1> build() {
        return new LazyBufferTrigger(() -> {
            this.ensure();
            return new SimpleBufferTrigger<E>(this.bufferFactory, this.queueAdder, this.scheduledExecutorService, this.consumer, this.triggerStrategy, this.exceptionHandler, this.maxBufferCount, this.rejectHandler);
        });
    }

    private void ensure() {
        Preconditions.checkNotNull(this.consumer);
        if (this.triggerStrategy == null) {
            logger.warn("no trigger strategy found. using NO-OP trigger");
            this.triggerStrategy = (t, n) -> SimpleBufferTrigger.TriggerResult.empty();
        }
        if (this.bufferFactory == null && this.queueAdder == null) {
            this.bufferFactory = () -> Collections.newSetFromMap(new ConcurrentHashMap());
            this.queueAdder = (c, e) -> ((Set)c).add(e) ? 1 : 0;
        }
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.makeScheduleExecutor();
        }
    }

    private ScheduledExecutorService makeScheduleExecutor() {
        return Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("pool-simple-buffer-trigger-thread-%d").setDaemon(true).build());
    }
}

