/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.jedis;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueConsumer<T> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Supplier<T> queuePoper;
    private final Consumer<T> queueConsumer;
    private volatile boolean stopped = false;

    public QueueConsumer(Supplier<T> queuePoper, Consumer<T> queueConsumer) {
        this.queuePoper = queuePoper;
        this.queueConsumer = queueConsumer;
    }

    public void startConsume() {
        while (!this.stopped) {
            try {
                T object = this.queuePoper.get();
                if (object == null) continue;
                this.queueConsumer.accept(object);
            }
            catch (Throwable e) {
                this.logger.error("fail to consumer:{}, {}, exception:{}", new Object[]{this.queuePoper, this.queueConsumer, e.getMessage()});
            }
        }
    }

    public void stop() {
        this.stopped = true;
    }
}

