/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.jedis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public final class QueueHelper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Supplier<ShardedJedisPool> jedisFactory;

    public QueueHelper(Supplier<ShardedJedisPool> jedisFactory) {
        this.jedisFactory = jedisFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enqueue(String key, String data) {
        ShardedJedisPool pool = this.jedisFactory.get();
        Throwable throwable = null;
        try (ShardedJedis resource = pool.getResource();){
            ArrayList allShards = new ArrayList(resource.getAllShards());
            Collections.shuffle(allShards);
            for (Jedis jedis : allShards) {
                try {
                    jedis.lpush(key, new String[]{data});
                    return;
                }
                catch (Throwable e) {
                    try {
                        this.logger.error("fail to enqueue [{}:{}], {}->{}, exception:{}", new Object[]{jedis.getClient().getHost(), jedis.getClient().getPort(), key, data, e.getMessage()});
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        throw new RuntimeException("fail to enqueue:" + key + ", " + data);
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void enqueue(byte[] key, byte[] data) {
        ShardedJedisPool pool = this.jedisFactory.get();
        Throwable throwable = null;
        try (ShardedJedis resource = pool.getResource();){
            ArrayList allShards = new ArrayList(resource.getAllShards());
            Collections.shuffle(allShards);
            for (Jedis jedis : allShards) {
                try {
                    jedis.lpush(key, (byte[][])new byte[][]{data});
                    return;
                }
                catch (Throwable e) {
                    try {
                        this.logger.error("fail to enqueue [{}:{}], {}->{}, exception:{}", new Object[]{jedis.getClient().getHost(), jedis.getClient().getPort(), new String(key), data, e.getMessage()});
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        throw throwable3;
                        throw new RuntimeException("fail to enqueue:" + new String(key) + ", " + Arrays.toString(data));
                    }
                }
            }
        }
    }
}

