/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.jedis.poper;

import com.github.phantomthief.jedis.util.WeightTreeInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.ShardedJedis;
import redis.clients.jedis.ShardedJedisPool;

public abstract class AbsJedisQueuePoper<K, E, R>
implements Supplier<E> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final long DEFAULT_WAIT_ON_EMPTY = TimeUnit.SECONDS.toMillis(30L);
    private final K queueKey;
    private final Supplier<ShardedJedisPool> jedisFactory;
    private final BiFunction<Jedis, K, List<R>> poper;
    private final Function<R, E> decoder;

    protected AbsJedisQueuePoper(K queueKey, Supplier<ShardedJedisPool> jedisFactory, BiFunction<Jedis, K, List<R>> poper, Function<R, E> decoder) {
        this.queueKey = queueKey;
        this.jedisFactory = jedisFactory;
        this.poper = poper;
        this.decoder = decoder;
    }

    @Override
    public E get() {
        ShardedJedisPool pool = this.jedisFactory.get();
        try (ShardedJedis resource = pool.getResource();){
            ArrayList allShards = new ArrayList(resource.getAllShards());
            WeightTreeInfo<Jedis> sorted = new WeightTreeInfo<Jedis>();
            for (Jedis j : allShards) {
                long length = 0L;
                try {
                    if (this.queueKey instanceof byte[]) {
                        length = j.llen((byte[])this.queueKey);
                    } else if (this.queueKey instanceof String) {
                        length = j.llen((String)this.queueKey);
                    }
                }
                catch (Throwable e) {
                    this.logger.warn("queue length fail:{},{}", this.queueKey, (Object)e.getMessage());
                }
                if (length <= 0L) continue;
                sorted.putNode(j, length);
            }
            if (allShards.isEmpty()) {
                try {
                    Thread.sleep(DEFAULT_WAIT_ON_EMPTY);
                }
                catch (InterruptedException e) {
                    this.logger.error("Ops.", (Throwable)e);
                }
                E e = null;
                return e;
            }
            Jedis j = sorted.isEmpty() ? (Jedis)allShards.get(RandomUtils.nextInt((int)0, (int)allShards.size())) : (Jedis)sorted.getNode();
            List<R> brpop = this.poper.apply(j, this.queueKey);
            if (brpop == null) {
                E e = null;
                return e;
            }
            for (R bs : brpop) {
                if (bs instanceof byte[] ? Arrays.equals((byte[])bs, (byte[])this.queueKey) : Objects.equals(bs, this.queueKey)) continue;
                E e = this.decoder.apply(bs);
                return e;
            }
            Iterator<R> iterator = null;
            return (E)iterator;
        }
    }

    public String toString() {
        return "AbsJedisQueuePoper [queueKey=" + this.queueKey + ", poper=" + this.poper + ", decoder=" + this.decoder + "]";
    }
}

