/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.jedis.util;

import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import org.apache.commons.lang3.RandomUtils;

public class WeightTreeInfo<T> {
    private static final int DEFAULT_WEIGHT = 100;
    private final RangeMap<Long, T> nodes = TreeRangeMap.create();
    private long maxWeight = 0L;

    public void putNode(T node, long weight) {
        this.nodes.put(Range.closedOpen((Comparable)Long.valueOf(this.maxWeight), (Comparable)Long.valueOf(this.maxWeight + weight)), node);
        this.maxWeight += weight;
    }

    public T getNode() {
        if (this.isEmpty()) {
            return null;
        }
        long resultIndex = RandomUtils.nextLong((long)0L, (long)this.maxWeight);
        return (T)this.nodes.get((Comparable)Long.valueOf(resultIndex));
    }

    public static <T> WeightTreeInfo<T> buildSingleOne(T one) {
        WeightTreeInfo<T> result = new WeightTreeInfo<T>();
        result.putNode(one, 100L);
        return result;
    }

    public String toString() {
        return this.nodes.toString();
    }

    public boolean isEmpty() {
        return this.maxWeight == 0L;
    }
}

