/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.concurrent;

import com.github.phantomthief.util.ThrowableRunnable;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutListenableFuture<V>
extends ForwardingListenableFuture<V> {
    private static final Logger logger = LoggerFactory.getLogger(TimeoutListenableFuture.class);
    private final ListenableFuture<V> delegate;
    private final List<ThrowableRunnable<Exception>> timeoutListeners = new ArrayList<ThrowableRunnable<Exception>>();

    public TimeoutListenableFuture(ListenableFuture<V> delegate) {
        this.delegate = delegate;
    }

    protected ListenableFuture<V> delegate() {
        return this.delegate;
    }

    public TimeoutListenableFuture<V> addTimeoutListener(ThrowableRunnable<Exception> consumer) {
        this.timeoutListeners.add(consumer);
        return this;
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (V)this.delegate().get(timeout, unit);
        }
        catch (TimeoutException e) {
            for (ThrowableRunnable<Exception> timeoutListener : this.timeoutListeners) {
                try {
                    timeoutListener.run();
                }
                catch (Exception e1) {
                    logger.error("", (Throwable)e1);
                }
            }
            throw e;
        }
    }
}

