/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.util.ThrowableConsumer;
import com.github.phantomthief.util.ThrowableFunction;
import com.github.phantomthief.util.ThrowableRunnable;
import com.google.common.base.Throwables;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MoreFunctions {
    private static final Logger logger = LoggerFactory.getLogger(MoreFunctions.class);

    public static <R> Optional<R> catchingOptional(Callable<R> callable) {
        return Optional.ofNullable(MoreFunctions.catching(callable));
    }

    public static <R> R catching(Callable<R> callable) {
        return MoreFunctions.catching(callable, e -> logger.error("", e));
    }

    public static <X extends Exception> void runCatching(ThrowableRunnable<X> callable) {
        MoreFunctions.catching(() -> {
            callable.run();
            return null;
        }, e -> logger.error("", e));
    }

    public static <R> R throwing(Callable<R> callable) {
        return MoreFunctions.catching(callable, Throwables::propagate);
    }

    public static <X extends Exception> void runThrowing(ThrowableRunnable<X> callable) {
        MoreFunctions.catching(() -> {
            callable.run();
            return null;
        }, Throwables::propagate);
    }

    public static <R, X extends Throwable> R catching(Callable<R> callable, ThrowableConsumer<Throwable, X> exceptionHandler) throws X {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
            return null;
        }
    }

    public static <T, R> R catching(ThrowableFunction<T, R, Exception> function, T t) {
        return MoreFunctions.catching(function, t, e -> logger.error("", e));
    }

    public static <T, R> R throwing(ThrowableFunction<T, R, Exception> function, T t) {
        return MoreFunctions.catching(function, t, Throwables::propagate);
    }

    public static <T, R, X extends Throwable> R catching(ThrowableFunction<T, R, Exception> function, T t, ThrowableConsumer<Throwable, X> exceptionHandler) throws X {
        try {
            return function.apply(t);
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
            return null;
        }
    }
}

