/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class MoreStreams {
    private MoreStreams() {
        throw new UnsupportedOperationException();
    }

    public static LongStream longRangeClosed(long from, long to) {
        if (from <= to) {
            return LongStream.rangeClosed(from, to);
        }
        return LongStream.rangeClosed(to, from).map(i -> to - i + from);
    }

    public static IntStream intRangeClosed(int from, int to) {
        if (from <= to) {
            return IntStream.rangeClosed(from, to);
        }
        return IntStream.rangeClosed(to, from).map(i -> to - i + from);
    }

    public static <T> Stream<T> toStream(Iterator<T> iterator) {
        Preconditions.checkNotNull(iterator);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterator, 1296), false);
    }

    public static <T> Stream<T> toStream(Iterable<T> iterable) {
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof Collection) {
            try {
                Collection collection = (Collection)iterable;
                return StreamSupport.stream(Spliterators.spliterator(collection, 0), false);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iterable.iterator(), 1296), false);
    }

    public static <T> Stream<List<T>> partition(Stream<T> stream, int size) {
        Iterable iterable = () -> Iterators.partition(stream.iterator(), (int)size);
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

