/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.concurrent;

import com.github.phantomthief.concurrent.TryWaitFutureUncheckedException;
import com.github.phantomthief.concurrent.TryWaitResult;
import com.github.phantomthief.concurrent.TryWaitUncheckedException;
import com.github.phantomthief.util.ThrowableFunction;
import com.github.phantomthief.util.ThrowableRunnable;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ExecutionError;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import com.google.common.util.concurrent.Uninterruptibles;
import java.time.Duration;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreFutures {
    private static final Logger logger = LoggerFactory.getLogger(MoreFutures.class);

    public static <T> T getUnchecked(@Nonnull Future<? extends T> future, @Nonnull Duration duration) {
        Preconditions.checkNotNull((Object)duration);
        return MoreFutures.getUnchecked(future, duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public static <T> T getUnchecked(@Nonnull Future<? extends T> future, @Nonnegative long timeout, @Nonnull TimeUnit unit) {
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull(future);
        try {
            return (T)Uninterruptibles.getUninterruptibly(future, (long)timeout, (TimeUnit)unit);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw new ExecutionError((Error)cause);
            }
            throw new UncheckedExecutionException(cause);
        }
        catch (TimeoutException e) {
            throw new UncheckedTimeoutException((Throwable)e);
        }
    }

    @Nonnull
    public static <F extends Future<V>, V> Map<F, V> tryWait(@Nonnull Iterable<F> futures, @Nonnull Duration duration) throws TryWaitFutureUncheckedException {
        Preconditions.checkNotNull(futures);
        Preconditions.checkNotNull((Object)duration);
        return MoreFutures.tryWait(futures, duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    @Nonnull
    public static <F extends Future<V>, V> Map<F, V> tryWait(@Nonnull Iterable<F> futures, @Nonnegative long timeout, @Nonnull TimeUnit unit) throws TryWaitFutureUncheckedException {
        Preconditions.checkNotNull(futures);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)unit));
        return MoreFutures.tryWait(futures, timeout, unit, it -> it, TryWaitFutureUncheckedException::new);
    }

    @Nonnull
    public static <K, V, X extends Throwable> Map<K, V> tryWait(@Nonnull Iterable<K> keys, @Nonnull Duration duration, @Nonnull ThrowableFunction<K, Future<V>, X> asyncFunc) throws X, TryWaitUncheckedException {
        Preconditions.checkNotNull(keys);
        Preconditions.checkNotNull((Object)duration);
        Preconditions.checkNotNull(asyncFunc);
        return MoreFutures.tryWait(keys, duration.toNanos(), TimeUnit.NANOSECONDS, asyncFunc);
    }

    @Nonnull
    public static <K, V, X extends Throwable> Map<K, V> tryWait(@Nonnull Iterable<K> keys, @Nonnegative long timeout, @Nonnull TimeUnit unit, @Nonnull ThrowableFunction<K, Future<V>, X> asyncFunc) throws X, TryWaitUncheckedException {
        return MoreFutures.tryWait(keys, timeout, unit, asyncFunc, TryWaitUncheckedException::new);
    }

    @Nonnull
    private static <K, V, X extends Throwable> Map<K, V> tryWait(@Nonnull Iterable<K> keys, @Nonnegative long timeout, @Nonnull TimeUnit unit, @Nonnull ThrowableFunction<K, Future<V>, X> asyncFunc, @Nonnull Function<TryWaitResult, RuntimeException> throwing) throws X {
        Preconditions.checkNotNull(keys);
        Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)((Object)unit));
        Preconditions.checkNotNull(asyncFunc);
        LinkedHashMap successMap = new LinkedHashMap();
        LinkedHashMap failMap = new LinkedHashMap();
        LinkedHashMap timeoutMap = new LinkedHashMap();
        LinkedHashMap cancelMap = new LinkedHashMap();
        long remainingNanos = unit.toNanos(timeout);
        long end = System.nanoTime() + remainingNanos;
        IdentityHashMap<Future<V>, K> futureKeyMap = new IdentityHashMap<Future<V>, K>();
        for (K key : keys) {
            Preconditions.checkNotNull(key);
            Future<V> future = asyncFunc.apply(key);
            Preconditions.checkNotNull(future);
            futureKeyMap.put(future, key);
            if (remainingNanos <= 0L) {
                MoreFutures.waitAndCollect(successMap, failMap, timeoutMap, cancelMap, future, 1L);
                continue;
            }
            MoreFutures.waitAndCollect(successMap, failMap, timeoutMap, cancelMap, future, remainingNanos);
            remainingNanos = end - System.nanoTime();
        }
        TryWaitResult result = new TryWaitResult(successMap, failMap, timeoutMap, cancelMap, futureKeyMap);
        if (failMap.isEmpty() && timeoutMap.isEmpty() && cancelMap.isEmpty()) {
            return result.getSuccess();
        }
        throw throwing.apply(result);
    }

    private static <T> void waitAndCollect(Map<Future<? extends T>, T> successMap, Map<Future<? extends T>, Throwable> failMap, Map<Future<? extends T>, TimeoutException> timeoutMap, Map<Future<? extends T>, CancellationException> cancelMap, Future<? extends T> future, long thisWait) {
        try {
            Object t = Uninterruptibles.getUninterruptibly(future, (long)thisWait, (TimeUnit)TimeUnit.NANOSECONDS);
            successMap.put(future, t);
        }
        catch (CancellationException e) {
            cancelMap.put(future, e);
        }
        catch (TimeoutException e) {
            timeoutMap.put(future, e);
        }
        catch (ExecutionException e) {
            failMap.put(future, e.getCause());
        }
        catch (Throwable e) {
            failMap.put(future, e);
        }
    }

    public static Future<?> scheduleWithDynamicDelay(@Nonnull ScheduledExecutorService executor, @Nullable Duration initDelay, @Nonnull Scheduled task) {
        Preconditions.checkNotNull((Object)executor);
        Preconditions.checkNotNull((Object)task);
        final AtomicBoolean canceled = new AtomicBoolean(false);
        AbstractFuture<Object> future = new AbstractFuture<Object>(){

            public boolean cancel(boolean mayInterruptIfRunning) {
                canceled.set(true);
                return super.cancel(mayInterruptIfRunning);
            }
        };
        executor.schedule(new ScheduledTaskImpl(executor, task, canceled), initDelay == null ? 0L : initDelay.toMillis(), TimeUnit.MILLISECONDS);
        return future;
    }

    public static Future<?> scheduleWithDynamicDelay(@Nonnull ScheduledExecutorService executor, @Nonnull Supplier<Duration> delay, @Nonnull ThrowableRunnable<Throwable> task) {
        Preconditions.checkNotNull(delay);
        return MoreFutures.scheduleWithDynamicDelay(executor, delay.get(), () -> {
            try {
                task.run();
            }
            catch (Throwable e) {
                logger.error("", e);
            }
            return (Duration)delay.get();
        });
    }

    private static class ScheduledTaskImpl
    implements Runnable {
        private final ScheduledExecutorService executorService;
        private final Scheduled scheduled;
        private final AtomicBoolean canceled;

        private ScheduledTaskImpl(ScheduledExecutorService executorService, Scheduled scheduled, AtomicBoolean canceled) {
            this.executorService = executorService;
            this.scheduled = scheduled;
            this.canceled = canceled;
        }

        @Override
        public void run() {
            if (this.canceled.get()) {
                return;
            }
            try {
                Duration delay = this.scheduled.run();
                if (!this.canceled.get() && delay != null) {
                    this.executorService.schedule(this, delay.toMillis(), TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable e) {
                logger.error("", e);
            }
        }
    }

    public static interface Scheduled {
        @Nullable
        public Duration run();
    }
}

