/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.util.ThrowableConsumer;
import com.github.phantomthief.util.ThrowableFunction;
import com.github.phantomthief.util.ThrowableRunnable;
import com.github.phantomthief.util.ThrowableSupplier;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MoreFunctions {
    private static final Logger logger = LoggerFactory.getLogger(MoreFunctions.class);

    public static <R> Optional<R> catchingOptional(Callable<R> callable) {
        return Optional.ofNullable(MoreFunctions.catching(callable));
    }

    public static <R> R catching(Callable<R> callable) {
        return MoreFunctions.catching(callable, e -> logger.error("", e));
    }

    public static <X extends Exception> void runCatching(ThrowableRunnable<X> callable) {
        MoreFunctions.catching(() -> {
            callable.run();
            return null;
        }, e -> logger.error("", e));
    }

    public static <R> R throwing(Callable<R> callable) {
        return MoreFunctions.catching(callable, throwable -> {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException((Throwable)throwable);
        });
    }

    public static <X extends Exception> void runThrowing(ThrowableRunnable<X> callable) {
        MoreFunctions.catching(() -> {
            callable.run();
            return null;
        }, throwable -> {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException((Throwable)throwable);
        });
    }

    public static <R, X extends Throwable> R catching(Callable<R> callable, ThrowableConsumer<Throwable, X> exceptionHandler) throws X {
        try {
            return callable.call();
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
            return null;
        }
    }

    public static <T, R> R catching(ThrowableFunction<T, R, Exception> function, T t) {
        return MoreFunctions.catching(function, t, e -> logger.error("", e));
    }

    public static <T, R> R throwing(ThrowableFunction<T, R, Exception> function, T t) {
        return MoreFunctions.catching(function, t, throwable -> {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException((Throwable)throwable);
        });
    }

    public static <T, R, X extends Throwable> R catching(ThrowableFunction<T, R, Exception> function, T t, ThrowableConsumer<Throwable, X> exceptionHandler) throws X {
        try {
            return function.apply(t);
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
            return null;
        }
    }

    public static <X extends Throwable> void runParallel(ForkJoinPool pool, ThrowableRunnable<X> func) throws X {
        MoreFunctions.supplyParallel(pool, () -> {
            func.run();
            return null;
        });
    }

    public static <R, X extends Throwable> R supplyParallel(ForkJoinPool pool, ThrowableSupplier<R, X> func) throws X {
        Object r;
        Preconditions.checkNotNull((Object)pool);
        Throwable[] throwable = new Throwable[]{null};
        Future task = pool.submit(() -> {
            try {
                return func.get();
            }
            catch (Throwable e) {
                throwable[0] = e;
                return null;
            }
        });
        try {
            r = ((ForkJoinTask)task).get();
        }
        catch (InterruptedException | ExecutionException impossible) {
            throw new AssertionError((Object)impossible);
        }
        if (throwable[0] != null) {
            throw throwable[0];
        }
        return (R)r;
    }

    public static <X extends Throwable> void runWithThreadName(@Nonnull Function<String, String> name, @Nonnull ThrowableRunnable<X> func) throws X {
        MoreFunctions.supplyWithThreadName(name, () -> {
            func.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <X extends Throwable, T> T supplyWithThreadName(@Nonnull Function<String, String> name, @Nonnull ThrowableSupplier<T, X> func) throws X {
        Thread currentThread = Thread.currentThread();
        String originalThreadName = currentThread.getName();
        String newName = name.apply(originalThreadName);
        if (newName != null) {
            currentThread.setName(newName);
        }
        try {
            T t = func.get();
            return t;
        }
        finally {
            currentThread.setName(originalThreadName);
        }
    }

    public static <K, V, T> Function<Map.Entry<K, V>, T> mapKv(BiFunction<K, V, T> func) {
        return entry -> func.apply(entry.getKey(), entry.getValue());
    }

    public static <K, V> Predicate<Map.Entry<K, V>> filterKv(BiPredicate<K, V> func) {
        return entry -> func.test(entry.getKey(), entry.getValue());
    }

    public static <K, V> Consumer<Map.Entry<K, V>> consumerKv(BiConsumer<K, V> func) {
        return entry -> func.accept(entry.getKey(), entry.getValue());
    }
}

