/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreReflection {
    private static final Logger logger = LoggerFactory.getLogger(MoreReflection.class);
    private static final RateLimiter RATE_LIMITER = RateLimiter.create((double)1.0);

    public static void logDeprecated(@Nonnull String message) {
        if (RATE_LIMITER.tryAcquire()) {
            Preconditions.checkNotNull((Object)message);
            StackTraceElement stack = MoreReflection.getCallerPlace();
            if (stack != null) {
                logger.info(message, (Object)(stack.getFileName() + ":" + stack.getLineNumber()));
            }
        }
    }

    @Nullable
    public static StackTraceElement getCallerPlace() {
        ArrayList stackTrace = Lists.newArrayList((Object[])Thread.currentThread().getStackTrace());
        boolean afterSelf = false;
        boolean afterDeprecated = false;
        String deprecatedClass = null;
        for (StackTraceElement stack : stackTrace) {
            if (stack.getClassName().equals(MoreReflection.class.getName())) {
                afterSelf = true;
                continue;
            }
            if (afterSelf && deprecatedClass == null && !stack.getClassName().equals(MoreReflection.class.getName())) {
                deprecatedClass = stack.getClassName();
            }
            if (stack.getClassName().equals(deprecatedClass)) {
                afterDeprecated = true;
                continue;
            }
            if (!afterDeprecated) continue;
            return stack;
        }
        return null;
    }
}

