/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.util.ThrowableConsumer;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public final class MoreSuppliers {
    public static <T> CloseableSupplier<T> lazy(Supplier<T> delegate) {
        return MoreSuppliers.lazy(delegate, true);
    }

    public static <T> CloseableSupplier<T> lazy(Supplier<T> delegate, boolean resetAfterClose) {
        if (delegate instanceof CloseableSupplier) {
            return (CloseableSupplier)delegate;
        }
        return new CloseableSupplier((Supplier)Preconditions.checkNotNull(delegate), resetAfterClose);
    }

    public static <T> Supplier<T> asyncLazy(Supplier<T> delegate, Supplier<T> pendingSupplier, String threadName) {
        return new AsyncSupplier<T>(delegate, pendingSupplier, threadName);
    }

    public static <T> Supplier<T> asyncLazy(Supplier<T> delegate, String threadName) {
        return MoreSuppliers.asyncLazy(delegate, () -> null, threadName);
    }

    public static <T> Supplier<T> asyncLazy(Supplier<T> delegate) {
        return MoreSuppliers.asyncLazy(delegate, null);
    }

    public static final class AsyncSupplier<T>
    implements Supplier<T> {
        private final String initThreadName;
        private final Supplier<T> innerSupplier;
        private final Supplier<T> pendingSupplier;
        private volatile T value;
        private volatile boolean inited;
        private volatile boolean initing;

        AsyncSupplier(Supplier<T> innerSupplier, Supplier<T> pendingSupplier, String initThreadName) {
            this.initThreadName = initThreadName;
            this.innerSupplier = (Supplier)Preconditions.checkNotNull(innerSupplier);
            this.pendingSupplier = (Supplier)Preconditions.checkNotNull(pendingSupplier);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (this.inited) {
                return this.value;
            }
            if (this.initing) {
                return this.pendingSupplier.get();
            }
            AsyncSupplier asyncSupplier = this;
            synchronized (asyncSupplier) {
                if (this.inited) {
                    return this.value;
                }
                if (this.initing) {
                    return this.pendingSupplier.get();
                }
                this.initing = true;
                Runnable initWithTry = () -> {
                    try {
                        this.value = this.innerSupplier.get();
                        this.inited = true;
                        this.initing = false;
                    }
                    catch (Throwable e) {
                        this.initing = false;
                        throw e;
                    }
                };
                if (this.initThreadName == null) {
                    new Thread(initWithTry).start();
                } else {
                    new Thread(initWithTry, this.initThreadName).start();
                }
            }
            if (this.inited) {
                return this.value;
            }
            return this.pendingSupplier.get();
        }
    }

    public static class CloseableSupplier<T>
    implements Supplier<T>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final Supplier<T> delegate;
        private final boolean resetAfterClose;
        private volatile transient boolean initialized;
        private transient T value;

        private CloseableSupplier(Supplier<T> delegate, boolean resetAfterClose) {
            this.delegate = delegate;
            this.resetAfterClose = resetAfterClose;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                CloseableSupplier closeableSupplier = this;
                synchronized (closeableSupplier) {
                    if (!this.initialized) {
                        T t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return t;
                    }
                }
            }
            return this.value;
        }

        public boolean isInitialized() {
            return this.initialized;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <X extends Throwable> void ifPresent(ThrowableConsumer<T, X> consumer) throws X {
            CloseableSupplier closeableSupplier = this;
            synchronized (closeableSupplier) {
                if (this.initialized && this.value != null) {
                    consumer.accept(this.value);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
            Preconditions.checkNotNull(mapper);
            CloseableSupplier closeableSupplier = this;
            synchronized (closeableSupplier) {
                if (this.initialized && this.value != null) {
                    return Optional.ofNullable(mapper.apply(this.value));
                }
                return Optional.empty();
            }
        }

        public void tryClose() {
            this.tryClose(i -> {});
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <X extends Throwable> void tryClose(ThrowableConsumer<T, X> close) throws X {
            CloseableSupplier closeableSupplier = this;
            synchronized (closeableSupplier) {
                if (this.initialized) {
                    close.accept(this.value);
                    if (this.resetAfterClose) {
                        this.value = null;
                        this.initialized = false;
                    }
                }
            }
        }

        public String toString() {
            if (this.initialized) {
                return "MoreSuppliers.lazy(" + this.get() + ")";
            }
            return "MoreSuppliers.lazy(" + this.delegate + ")";
        }
    }
}

