/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.concurrent;

import com.github.phantomthief.util.ThrowableConsumer;
import com.github.phantomthief.util.ThrowableRunnable;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ForwardingListenableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeoutListenableFuture<V>
extends ForwardingListenableFuture<V> {
    private static final Logger logger = LoggerFactory.getLogger(TimeoutListenableFuture.class);
    private final ListenableFuture<V> delegate;
    private final List<ThrowableConsumer<TimeoutException, Exception>> timeoutListeners = new ArrayList<ThrowableConsumer<TimeoutException, Exception>>();

    public TimeoutListenableFuture(ListenableFuture<V> delegate) {
        this.delegate = delegate;
    }

    public static <V> TimeoutListenableFuture<V> timeoutListenableFuture(ListenableFuture<V> delegate) {
        if (delegate instanceof TimeoutListenableFuture) {
            return (TimeoutListenableFuture)delegate;
        }
        return new TimeoutListenableFuture<V>(delegate);
    }

    protected ListenableFuture<V> delegate() {
        return this.delegate;
    }

    public TimeoutListenableFuture<V> addTimeoutListener(@Nonnull ThrowableRunnable<Exception> listener) {
        Preconditions.checkNotNull(listener);
        return this.addTimeoutListener((TimeoutException e) -> listener.run());
    }

    public TimeoutListenableFuture<V> addTimeoutListener(@Nonnull ThrowableConsumer<TimeoutException, Exception> listener) {
        this.timeoutListeners.add((ThrowableConsumer)Preconditions.checkNotNull(listener));
        return this;
    }

    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            return (V)this.delegate().get(timeout, unit);
        }
        catch (TimeoutException e) {
            for (ThrowableConsumer<TimeoutException, Exception> listener : this.timeoutListeners) {
                try {
                    listener.accept(e);
                }
                catch (Exception e1) {
                    logger.error("", (Throwable)e1);
                }
            }
            throw e;
        }
    }

    public List<ThrowableConsumer<TimeoutException, Exception>> getTimeoutListeners() {
        return Collections.unmodifiableList(this.timeoutListeners);
    }
}

