/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.concurrent;

import com.github.phantomthief.util.MoreSuppliers;
import com.google.common.base.MoreObjects;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

class TryWaitResult<K, V> {
    private final Map<Future<? extends V>, V> success;
    private final Map<Future<? extends V>, Throwable> failed;
    private final Map<Future<? extends V>, TimeoutException> timeout;
    private final Map<Future<? extends V>, CancellationException> cancel;
    private final Map<Future<? extends V>, K> futureMap;
    private final Supplier<Map<K, V>> successMap;
    private final Supplier<Map<K, Throwable>> failedMap;
    private final Supplier<Map<K, TimeoutException>> timeoutMap;
    private final Supplier<Map<K, CancellationException>> cancelMap;

    TryWaitResult(Map<Future<? extends V>, V> success, Map<Future<? extends V>, Throwable> failed, Map<Future<? extends V>, TimeoutException> timeout, Map<Future<? extends V>, CancellationException> cancel, Map<Future<? extends V>, K> futureMap) {
        this.success = success;
        this.failed = failed;
        this.timeout = timeout;
        this.cancel = cancel;
        this.futureMap = futureMap;
        this.successMap = MoreSuppliers.lazy(() -> this.transfer(this.success, this.futureMap));
        this.failedMap = MoreSuppliers.lazy(() -> this.transfer(this.failed, this.futureMap));
        this.timeoutMap = MoreSuppliers.lazy(() -> this.transfer(this.timeout, this.futureMap));
        this.cancelMap = MoreSuppliers.lazy(() -> this.transfer(this.cancel, this.futureMap));
    }

    private <T2> Map<K, T2> transfer(Map<Future<? extends V>, T2> sourceMap, Map<Future<? extends V>, K> transferMap) {
        HashMap map = new HashMap();
        sourceMap.forEach((k, v) -> map.put(transferMap.get(k), v));
        return map;
    }

    @Nonnull
    public Map<K, V> getSuccess() {
        return this.successMap.get();
    }

    @Nonnull
    public Map<K, Throwable> getFailed() {
        return this.failedMap.get();
    }

    @Nonnull
    public Map<K, TimeoutException> getTimeout() {
        return this.timeoutMap.get();
    }

    @Nonnull
    public Map<K, CancellationException> getCancel() {
        return this.cancelMap.get();
    }

    @Nonnull
    public Map<K, Boolean> cancelAllTimeout(boolean mayInterruptIfRunning) {
        return this.timeout.entrySet().stream().collect(Collectors.toMap(entry -> this.futureMap.get(entry.getKey()), it -> ((Future)it.getKey()).cancel(mayInterruptIfRunning)));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("success", this.success.size()).add("failed", this.failed.size()).add("timeout", this.timeout.size()).add("cancel", this.cancel.size()).toString();
    }

    public String getCombinedExceptionMessage() {
        return Stream.of(this.getFailed(), this.getTimeout(), this.getCancel()).map(map -> map.entrySet().stream()).flatMap(Function.identity()).map(this::exceptionEntryToString).collect(Collectors.joining("\n"));
    }

    private String exceptionEntryToString(Map.Entry<?, ? extends Throwable> entry) {
        return String.format("key:%s, exception:%s, message:%s", entry.getKey(), entry.getValue().getClass(), entry.getValue().getMessage());
    }
}

