/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.tuple.Tuple;
import com.github.phantomthief.tuple.TwoTuple;
import com.github.phantomthief.util.MoreSuppliers;
import com.github.phantomthief.util.ThrowableRunnable;
import com.github.phantomthief.util.ThrowableSupplier;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeadlineChecker
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(DeadlineChecker.class);
    private final Map<Thread, List<DeadlineInfo>> running = new ConcurrentHashMap<Thread, List<DeadlineInfo>>();
    private final MoreSuppliers.CloseableSupplier<TwoTuple<ExecutorService, ScheduledFuture<?>>> scheduler = MoreSuppliers.lazy(() -> {
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("deadline-helper-%d").build());
        return Tuple.tuple(executor, executor.scheduleAtFixedRate(this::checkDeadline, ticker, ticker, TimeUnit.NANOSECONDS));
    });

    private DeadlineChecker(long ticker) {
    }

    public static DeadlineChecker deadlineWithMinTicker(Duration minTicker) {
        long ticker = minTicker.toNanos();
        Preconditions.checkArgument((ticker > 0L ? 1 : 0) != 0, (Object)"invalid min ticker, it must be larger than 1ns.");
        return new DeadlineChecker(ticker);
    }

    public <X extends Throwable> void runWithDeadline(ThrowableRunnable<X> runnable, Duration deadline, Consumer<Thread> deadlineExceeded) throws X {
        this.supplyWithDeadline(() -> {
            runnable.run();
            return null;
        }, deadline, deadlineExceeded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, X extends Throwable> T supplyWithDeadline(ThrowableSupplier<T, X> supplier, Duration deadline, Consumer<Thread> deadlineExceeded) throws X {
        this.scheduler.get();
        Thread thread = Thread.currentThread();
        DeadlineInfo deadlineInfo = new DeadlineInfo(deadline.toMillis(), thread, deadlineExceeded);
        this.running.compute(thread, (t, deadlines) -> {
            if (deadlines == null) {
                deadlines = new CopyOnWriteArrayList<DeadlineInfo>();
            }
            deadlines.add(deadlineInfo);
            return deadlines;
        });
        try {
            T t2 = supplier.get();
            return t2;
        }
        finally {
            this.running.compute(thread, (t, deadlines) -> {
                if (deadlines == null) {
                    return null;
                }
                deadlines.remove(deadlineInfo);
                if (deadlines.isEmpty()) {
                    return null;
                }
                return deadlines;
            });
        }
    }

    private void checkDeadline() {
        HashSet changedThreads = new HashSet();
        this.running.forEach((thread, deadlines) -> {
            for (DeadlineInfo deadline : deadlines) {
                if (!deadline.tryCheckDeadlineExceeded()) continue;
                deadlines.remove(deadline);
                changedThreads.add(thread);
            }
        });
        changedThreads.forEach(thread -> this.running.compute((Thread)thread, (t, deadlines) -> {
            if (deadlines == null) {
                return null;
            }
            if (deadlines.isEmpty()) {
                return null;
            }
            return deadlines;
        }));
    }

    @Override
    public void close() {
        this.scheduler.tryClose(tuple -> {
            ((ScheduledFuture)tuple.getSecond()).cancel(true);
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)((ExecutorService)tuple.getFirst()), (long)1L, (TimeUnit)TimeUnit.MINUTES);
            this.running.clear();
        });
    }

    Map<Thread, List<DeadlineInfo>> getRunning() {
        return this.running;
    }

    private static class DeadlineInfo {
        private final long startTime = System.currentTimeMillis();
        private final long deadline;
        private final Thread thread;
        private final Consumer<Thread> deadlineExceeded;

        DeadlineInfo(long deadline, Thread thread, Consumer<Thread> deadlineExceeded) {
            this.deadline = deadline;
            this.thread = thread;
            this.deadlineExceeded = (Consumer)Preconditions.checkNotNull(deadlineExceeded);
        }

        boolean tryCheckDeadlineExceeded() {
            if (System.currentTimeMillis() - this.startTime >= this.deadline) {
                try {
                    this.deadlineExceeded.accept(this.thread);
                }
                catch (Throwable e) {
                    logger.error("", e);
                }
                return true;
            }
            return false;
        }
    }
}

