/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.IntContainer;
import com.carrotsearch.hppc.IntHashSet;
import com.carrotsearch.hppc.IntObjectAssociativeContainer;
import com.carrotsearch.hppc.IntObjectHashMap;
import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongContainer;
import com.carrotsearch.hppc.LongHashSet;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class MoreCollectors {
    public static final Set<Collector.Characteristics> CH_ID = Collections.unmodifiableSet(EnumSet.of(Collector.Characteristics.IDENTITY_FINISH));
    public static final Set<Collector.Characteristics> CH_NOID = Collections.emptySet();

    private MoreCollectors() {
        throw new UnsupportedOperationException();
    }

    public static Collector<Integer, ?, IntArrayList> toIntList() {
        return new CollectorImpl(IntArrayList::new, IntArrayList::add, (left, right) -> {
            left.addAll((IntContainer)right);
            return left;
        }, CH_ID);
    }

    public static Collector<Long, ?, LongArrayList> toLongList() {
        return new CollectorImpl(LongArrayList::new, LongArrayList::add, (left, right) -> {
            left.addAll((LongContainer)right);
            return left;
        }, CH_ID);
    }

    public static Collector<Integer, ?, IntHashSet> toIntSet() {
        return new CollectorImpl(IntHashSet::new, IntHashSet::add, (left, right) -> {
            left.addAll((IntContainer)right);
            return left;
        }, CH_ID);
    }

    public static Collector<Long, ?, LongHashSet> toLongSet() {
        return new CollectorImpl(LongHashSet::new, LongHashSet::add, (left, right) -> {
            left.addAll((LongContainer)right);
            return left;
        }, CH_ID);
    }

    public static <T, K, U> Collector<T, IntObjectHashMap<U>, IntObjectHashMap<U>> toIntMap(ToIntFunction<? super T> keyMapper, Function<? super T, ? extends U> valueMapper) {
        BiConsumer<IntObjectHashMap, Object> accumulator = (map, element) -> map.put(keyMapper.applyAsInt(element), valueMapper.apply(element));
        return new CollectorImpl(IntObjectHashMap::new, accumulator, (m1, m2) -> {
            m1.putAll((IntObjectAssociativeContainer)m2);
            return m1;
        }, CH_ID);
    }

    public static <K, V> Collector<Map.Entry<K, V>, ?, Map<K, V>> toMap() {
        return Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue);
    }

    @Deprecated
    public static <T, K> Collector<T, ?, HashMultiset<K>> toMultiset(Function<? super T, ? extends K> elementMapper, ToIntFunction<? super T> countMapper) {
        BiConsumer<HashMultiset, Object> accumulator = (set, element) -> set.add(elementMapper.apply(element), countMapper.applyAsInt(element));
        BinaryOperator finisher = (m1, m2) -> {
            m1.addAll((Collection)m2);
            return m1;
        };
        return new CollectorImpl(HashMultiset::create, accumulator, finisher, CH_ID);
    }

    @Deprecated
    public static <T, K, U, M extends Multimap<K, U>> Collector<T, ?, M> toMultimap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Supplier<M> supplier) {
        BiConsumer<Multimap, Object> accumulator = (multimap, element) -> multimap.put(keyMapper.apply(element), valueMapper.apply(element));
        BinaryOperator finisher = (m1, m2) -> {
            m1.putAll(m2);
            return m1;
        };
        return new CollectorImpl(supplier, accumulator, finisher, CH_ID);
    }

    public static <T, K, U, R extends Map<K, U>> Collector<T, ?, R> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, Supplier<R> supplier) {
        return MoreCollectors.toMap(keyMapper, valueMapper, MoreCollectors.throwingMerger(), supplier);
    }

    private static <T, K, U, M extends Map<K, U>> Collector<T, ?, M> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        BiConsumer<Map, Object> accumulator = (map, element) -> map.merge(keyMapper.apply(element), valueMapper.apply(element), mergeFunction);
        return new CollectorImpl(mapSupplier, accumulator, MoreCollectors.mapMerger(mergeFunction), CH_ID);
    }

    public static <T, K> Collector<T, ?, Map<K, List<T>>> groupingByAllowNullKey(Function<? super T, ? extends K> classifier) {
        return MoreCollectors.groupingByAllowNullKey(classifier, Collectors.toList());
    }

    public static <T, K, A, D> Collector<T, ?, Map<K, D>> groupingByAllowNullKey(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return MoreCollectors.groupingByAllowNullKey(classifier, HashMap::new, downstream);
    }

    public static <T, K, D, A, M extends Map<K, D>> Collector<T, ?, M> groupingByAllowNullKey(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        Supplier downstreamSupplier = downstream.supplier();
        BiConsumer downstreamAccumulator = downstream.accumulator();
        BiConsumer<Map, Object> accumulator = (m, t) -> {
            Object key = classifier.apply(t);
            Object container = m.computeIfAbsent(key, arg_0 -> MoreCollectors.lambda$groupingByAllowNullKey$11((Supplier)downstreamSupplier, arg_0));
            downstreamAccumulator.accept(container, t);
        };
        BinaryOperator<M> merger = MoreCollectors.mapMerger(downstream.combiner());
        Supplier<M> mangledFactory = mapFactory;
        if (downstream.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
            return new CollectorImpl(mangledFactory, accumulator, merger, CH_ID);
        }
        Function downstreamFinisher = downstream.finisher();
        Function<Map, Map> finisher = intermediate -> {
            intermediate.replaceAll((k, v) -> downstreamFinisher.apply(v));
            Map castResult = intermediate;
            return castResult;
        };
        return new CollectorImpl<Object, Map, Map>(mangledFactory, accumulator, merger, finisher, CH_NOID);
    }

    private static <I, R> Function<I, R> castingIdentity() {
        return i -> i;
    }

    public static <T> BinaryOperator<T> throwingMerger() {
        return (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        };
    }

    private static <K, V, M extends Map<K, V>> BinaryOperator<M> mapMerger(BinaryOperator<V> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    private static <T, A, R, S> Collector<T, ?, S> combine(Collector<T, A, R> collector, Function<? super R, ? extends S> function) {
        return Collector.of(collector.supplier(), collector.accumulator(), collector.combiner(), collector.finisher().andThen(function), new Collector.Characteristics[0]);
    }

    public static <T> Collector<T, ?, Stream<T>> concat(Stream<? extends T> other) {
        return MoreCollectors.combine(Collectors.toList(), list -> Stream.concat(list.stream(), other));
    }

    public static <T> Collector<T, ?, Stream<T>> concat(T element) {
        return MoreCollectors.concat(Stream.of(element));
    }

    private static /* synthetic */ Object lambda$groupingByAllowNullKey$11(Supplier downstreamSupplier, Object k) {
        return downstreamSupplier.get();
    }

    public static class CollectorImpl<T, A, R>
    implements Collector<T, A, R> {
        private final Supplier<A> supplier;
        private final BiConsumer<A, T> accumulator;
        private final BinaryOperator<A> combiner;
        private final Function<A, R> finisher;
        private final Set<Collector.Characteristics> characteristics;

        public CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Function<A, R> finisher, Set<Collector.Characteristics> characteristics) {
            this.supplier = supplier;
            this.accumulator = accumulator;
            this.combiner = combiner;
            this.finisher = finisher;
            this.characteristics = characteristics;
        }

        public CollectorImpl(Supplier<A> supplier, BiConsumer<A, T> accumulator, BinaryOperator<A> combiner, Set<Collector.Characteristics> characteristics) {
            this(supplier, accumulator, combiner, MoreCollectors.castingIdentity(), characteristics);
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return this.accumulator;
        }

        @Override
        public Supplier<A> supplier() {
            return this.supplier;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return this.combiner;
        }

        @Override
        public Function<A, R> finisher() {
            return this.finisher;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return this.characteristics;
        }
    }
}

