/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.util;

import com.github.phantomthief.util.StackTraceProvider;
import com.github.phantomthief.util.StackTraceProviderJdk8;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.RateLimiter;
import java.util.Iterator;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreReflection {
    private static final Logger logger = LoggerFactory.getLogger(MoreReflection.class);
    private static final RateLimiter RATE_LIMITER = RateLimiter.create((double)1.0);
    private static final StackTraceProvider STACK_TRACE_PROVIDER;

    public static void logDeprecated(@Nonnull String message) {
        if (RATE_LIMITER.tryAcquire()) {
            Preconditions.checkNotNull((Object)message);
            StackTraceElement stack = MoreReflection.getCallerPlace();
            if (stack != null) {
                logger.info(message, (Object)(stack.getFileName() + ":" + stack.getLineNumber()));
            }
        }
    }

    @Nullable
    public static StackTraceElement getCallerPlace() {
        return MoreReflection.getCallerPlace(MoreReflection.class);
    }

    @Nullable
    public static StackTraceElement getCallerPlace(Class<?> locationAwareClass) {
        return STACK_TRACE_PROVIDER.getCallerPlace(locationAwareClass);
    }

    static StackTraceProvider getStackTraceProvider() {
        return STACK_TRACE_PROVIDER;
    }

    static {
        StackTraceProvider temp = null;
        try {
            ServiceLoader<StackTraceProvider> loader = ServiceLoader.load(StackTraceProvider.class);
            Iterator<StackTraceProvider> iterator = loader.iterator();
            if (iterator.hasNext()) {
                temp = iterator.next();
            }
        }
        catch (UnsupportedClassVersionError e) {
            logger.info("failed to use jdk9's [JEP 259: Stack-Walking API] as caller tracker.");
        }
        catch (Throwable e) {
            logger.warn("failed to use jdk9's [JEP 259: Stack-Walking API] as caller tracker.", e);
        }
        if (temp == null) {
            temp = new StackTraceProviderJdk8();
        }
        STACK_TRACE_PROVIDER = temp;
        logger.info("using [{}] as caller tracker implementation.", (Object)STACK_TRACE_PROVIDER.getClass().getName());
    }
}

