/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.scope;

import com.github.phantomthief.scope.JdkThreadLocal;
import com.github.phantomthief.scope.MyThreadLocal;
import com.github.phantomthief.scope.NettyFastThreadLocal;
import com.github.phantomthief.scope.SubstituteThreadLocal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MyThreadLocalFactory {
    private static final Logger logger = LoggerFactory.getLogger(MyThreadLocalFactory.class);
    static final String USE_FAST_THREAD_LOCAL = "USE_FAST_THREAD_LOCAL";

    MyThreadLocalFactory() {
    }

    static <T> SubstituteThreadLocal<T> create() {
        MyThreadLocal real = null;
        if (Boolean.getBoolean(USE_FAST_THREAD_LOCAL)) {
            try {
                NettyFastThreadLocal nettyFastThreadLocal = new NettyFastThreadLocal();
                logger.info("using fast thread local as scope implements.");
                real = nettyFastThreadLocal;
            }
            catch (Error e) {
                logger.warn("cannot use fast thread local as scope implements.");
            }
        }
        if (real == null) {
            real = new JdkThreadLocal();
        }
        return new SubstituteThreadLocal(real);
    }
}

