/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.scope;

import com.github.phantomthief.scope.JdkThreadLocal;
import com.github.phantomthief.scope.MyThreadLocalFactory;
import com.github.phantomthief.scope.NettyFastThreadLocal;
import com.github.phantomthief.scope.ScopeKey;
import com.github.phantomthief.scope.SubstituteThreadLocal;
import com.github.phantomthief.util.ThrowableRunnable;
import com.github.phantomthief.util.ThrowableSupplier;
import com.google.common.annotations.Beta;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scope {
    private static final Logger logger = LoggerFactory.getLogger(Scope.class);
    private static final SubstituteThreadLocal<Scope> SCOPE_THREAD_LOCAL = MyThreadLocalFactory.create();
    private final ConcurrentMap<ScopeKey<?>, Object> values = new ConcurrentHashMap();

    @Beta
    public static boolean fastThreadLocalEnabled() {
        try {
            return SCOPE_THREAD_LOCAL.getRealThreadLocal() instanceof NettyFastThreadLocal;
        }
        catch (Error e) {
            return false;
        }
    }

    @Beta
    public static boolean tryEnableFastThreadLocal() {
        return Scope.setFastThreadLocal(true);
    }

    static boolean setFastThreadLocal(boolean usingFastThreadLocal) {
        if (usingFastThreadLocal) {
            try {
                if (!(SCOPE_THREAD_LOCAL.getRealThreadLocal() instanceof NettyFastThreadLocal)) {
                    SCOPE_THREAD_LOCAL.setRealThreadLocal(new NettyFastThreadLocal());
                    logger.info("change current scope's implements to fast thread local.");
                }
            }
            catch (Error e) {
                logger.warn("fail to change scope's implements to fast thread local.");
                return false;
            }
            return true;
        }
        if (!(SCOPE_THREAD_LOCAL.getRealThreadLocal() instanceof JdkThreadLocal)) {
            SCOPE_THREAD_LOCAL.setRealThreadLocal(new JdkThreadLocal());
            logger.info("change current scope's implements to jdk thread local.");
        }
        return true;
    }

    public static <X extends Throwable> void runWithExistScope(@Nullable Scope scope, ThrowableRunnable<X> runnable) throws X {
        Scope.supplyWithExistScope(scope, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, X extends Throwable> T supplyWithExistScope(@Nullable Scope scope, ThrowableSupplier<T, X> supplier) throws X {
        Scope oldScope = SCOPE_THREAD_LOCAL.get();
        SCOPE_THREAD_LOCAL.set(scope);
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            if (oldScope != null) {
                SCOPE_THREAD_LOCAL.set(oldScope);
            } else {
                SCOPE_THREAD_LOCAL.remove();
            }
        }
    }

    public static <X extends Throwable> void runWithNewScope(@Nonnull ThrowableRunnable<X> runnable) throws X {
        Scope.supplyWithNewScope(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T, X extends Throwable> T supplyWithNewScope(@Nonnull ThrowableSupplier<T, X> supplier) throws X {
        Scope.beginScope();
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            Scope.endScope();
        }
    }

    @Nonnull
    public static Scope beginScope() {
        Scope scope = SCOPE_THREAD_LOCAL.get();
        if (scope != null) {
            throw new IllegalStateException("start a scope in an exist scope.");
        }
        scope = new Scope();
        SCOPE_THREAD_LOCAL.set(scope);
        return scope;
    }

    public static void endScope() {
        SCOPE_THREAD_LOCAL.remove();
    }

    @Nullable
    public static Scope getCurrentScope() {
        return SCOPE_THREAD_LOCAL.get();
    }

    public <T> void set(@Nonnull ScopeKey<T> key, T value) {
        if (value != null) {
            this.values.put(key, value);
        } else {
            this.values.remove(key);
        }
    }

    public <T> T get(@Nonnull ScopeKey<T> key) {
        Object value = this.values.get(key);
        if (value == null && key.initializer() != null && (value = key.initializer().get()) != null) {
            this.values.put(key, value);
        }
        return (T)(value == null ? key.defaultValue() : value);
    }
}

