/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.scope;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnegative;

public interface RetryPolicy {
    public static final long NO_RETRY = -1L;

    public static RetryPolicy noRetry() {
        return RetryPolicy.retryNTimes(0);
    }

    public static RetryPolicy retryNTimes(int times) {
        return RetryPolicy.retryNTimes(times, 0L);
    }

    public static RetryPolicy retryNTimes(int times, @Nonnegative long delayInMs) {
        return RetryPolicy.retryNTimes(times, delayInMs, true);
    }

    public static RetryPolicy retryNTimes(final int times, final @Nonnegative long delayInMs, final boolean hedge) {
        Preconditions.checkArgument((delayInMs >= 0L ? 1 : 0) != 0, (Object)"delayInMs must be non-negative.");
        return new RetryPolicy(){

            @Override
            public long retry(int retryCount) {
                return retryCount <= times ? delayInMs : -1L;
            }

            @Override
            public boolean hedge() {
                return hedge;
            }
        };
    }

    public long retry(int var1);

    default public boolean hedge() {
        return true;
    }

    default public boolean triggerGetOnTimeout() {
        return true;
    }

    default public boolean abortRetry(Throwable t) {
        return false;
    }
}

