/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.scope;

import com.github.phantomthief.scope.JdkThreadLocal;
import com.github.phantomthief.scope.MyThreadLocalFactory;
import com.github.phantomthief.scope.NettyFastThreadLocal;
import com.github.phantomthief.scope.ScopeKey;
import com.github.phantomthief.scope.SubstituteThreadLocal;
import com.github.phantomthief.util.ThrowableRunnable;
import com.github.phantomthief.util.ThrowableSupplier;
import com.google.common.annotations.Beta;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Scope {
    private static final Logger logger = LoggerFactory.getLogger(Scope.class);
    private static final SubstituteThreadLocal<Scope> SCOPE_THREAD_LOCAL = MyThreadLocalFactory.create();
    private final ConcurrentMap<ScopeKey<?>, Holder<?>> values = new ConcurrentHashMap();
    private final ConcurrentMap<ScopeKey<?>, Boolean> enableNullProtections = new ConcurrentHashMap();

    @Beta
    public static boolean fastThreadLocalEnabled() {
        try {
            return SCOPE_THREAD_LOCAL.getRealThreadLocal() instanceof NettyFastThreadLocal;
        }
        catch (Error e) {
            return false;
        }
    }

    @Beta
    public static boolean tryEnableFastThreadLocal() {
        return Scope.setFastThreadLocal(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean setFastThreadLocal(boolean usingFastThreadLocal) {
        if (usingFastThreadLocal) {
            try {
                if (SCOPE_THREAD_LOCAL.getRealThreadLocal() instanceof NettyFastThreadLocal) return true;
                SCOPE_THREAD_LOCAL.setRealThreadLocal(new NettyFastThreadLocal());
                logger.info("change current scope's implements to fast thread local.");
                return true;
            }
            catch (Error e) {
                logger.warn("fail to change scope's implements to fast thread local.");
                return false;
            }
        } else {
            if (SCOPE_THREAD_LOCAL.getRealThreadLocal() instanceof JdkThreadLocal) return true;
            SCOPE_THREAD_LOCAL.setRealThreadLocal(new JdkThreadLocal());
            logger.info("change current scope's implements to jdk thread local.");
        }
        return true;
    }

    public static <X extends Throwable> void runWithExistScope(@Nullable Scope scope, ThrowableRunnable<X> runnable) throws X {
        Scope.supplyWithExistScope(scope, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, X extends Throwable> T supplyWithExistScope(@Nullable Scope scope, ThrowableSupplier<T, X> supplier) throws X {
        Scope oldScope = SCOPE_THREAD_LOCAL.get();
        SCOPE_THREAD_LOCAL.set(scope);
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            if (oldScope != null) {
                SCOPE_THREAD_LOCAL.set(oldScope);
            } else {
                SCOPE_THREAD_LOCAL.remove();
            }
        }
    }

    public static <X extends Throwable> void runWithNewScope(@Nonnull ThrowableRunnable<X> runnable) throws X {
        Scope.supplyWithNewScope(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T, X extends Throwable> T supplyWithNewScope(@Nonnull ThrowableSupplier<T, X> supplier) throws X {
        Scope.beginScope();
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            Scope.endScope();
        }
    }

    @Nonnull
    public static Scope beginScope() {
        Scope scope = SCOPE_THREAD_LOCAL.get();
        if (scope != null) {
            throw new IllegalStateException("start a scope in an exist scope.");
        }
        scope = new Scope();
        SCOPE_THREAD_LOCAL.set(scope);
        return scope;
    }

    public static void endScope() {
        SCOPE_THREAD_LOCAL.remove();
    }

    @Nullable
    public static Scope getCurrentScope() {
        return SCOPE_THREAD_LOCAL.get();
    }

    public <T> void set(@Nonnull ScopeKey<T> key, T value) {
        if (value != null) {
            this.values.put(key, new Holder<T>(value));
        } else {
            this.values.remove(key);
        }
    }

    public <T> T get(@Nonnull ScopeKey<T> key) {
        Holder holder = (Holder)this.values.get(key);
        if (holder == null) {
            holder = this.values.computeIfAbsent(key, k -> new Holder());
        }
        return holder.getOrCreate(key, this.enableNullProtections);
    }

    private static class Holder<T> {
        private T value;

        public Holder() {
        }

        public Holder(T value) {
            this.value = value;
        }

        public T getOrCreate(ScopeKey<T> key, ConcurrentMap<ScopeKey<?>, Boolean> enableNullProtections) {
            if (this.value != null) {
                return this.value;
            }
            if (key.initializer() == null) {
                return key.defaultValue();
            }
            return this.create(key, enableNullProtections);
        }

        private synchronized T create(ScopeKey<T> key, ConcurrentMap<ScopeKey<?>, Boolean> enableNullProtections) {
            if (this.value != null) {
                return this.value;
            }
            Supplier<T> initializer = key.initializer();
            if (initializer == null) {
                return key.defaultValue();
            }
            if (enableNullProtections.containsKey(key)) {
                return null;
            }
            T v = initializer.get();
            if (v != null) {
                this.value = v;
                return v;
            }
            if (key.enableNullProtection()) {
                enableNullProtections.put(key, true);
            }
            return key.defaultValue();
        }
    }
}

