/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.scope;

import com.github.phantomthief.scope.RetryPolicy;
import com.github.phantomthief.scope.Scope;
import com.github.phantomthief.util.ThrowableSupplier;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ScopeAsyncRetry {
    private final ListeningScheduledExecutorService scheduler;
    private final Executor callbackExecutor;

    @Deprecated
    public static ScopeAsyncRetry createScopeAsyncRetry(@Nonnegative ScheduledExecutorService executor) {
        return new ScopeAsyncRetry(executor);
    }

    public static ScopeAsyncRetry createScopeAsyncRetry(@Nonnegative ScheduledExecutorService executor, Executor callbackExecutor) {
        return new ScopeAsyncRetry(executor, callbackExecutor);
    }

    public static ScopeAsyncRetry shared() {
        return LazyHolder.INSTANCE;
    }

    @Deprecated
    ScopeAsyncRetry(ScheduledExecutorService scheduler) {
        this(scheduler, MoreExecutors.directExecutor());
    }

    ScopeAsyncRetry(ScheduledExecutorService scheduler, Executor callbackExecutor) {
        this.scheduler = MoreExecutors.listeningDecorator((ScheduledExecutorService)scheduler);
        this.callbackExecutor = callbackExecutor;
    }

    private static <T> FutureCallback<T> setAllResultToOtherSettableFuture(final SettableFuture<T> target) {
        return new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                target.set(result);
            }

            public void onFailure(Throwable t) {
                target.setException(t);
            }
        };
    }

    private static <T> FutureCallback<T> cancelOtherFuture(final Future<T> target, final boolean mayInterruptIfRunning) {
        return new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                target.cancel(mayInterruptIfRunning);
            }

            public void onFailure(Throwable t) {
                target.cancel(mayInterruptIfRunning);
            }
        };
    }

    private static <T> FutureCallback<T> setSuccessResultToOtherSettableFuture(final SettableFuture<T> target) {
        return new FutureCallback<T>(){

            public void onSuccess(@Nullable T result) {
                target.set(result);
            }

            public void onFailure(Throwable t) {
            }
        };
    }

    private static <T> void addCallbackWithDirectExecutor(ListenableFuture<T> future, FutureCallback<? super T> callback) {
        Futures.addCallback(future, callback, (Executor)MoreExecutors.directExecutor());
    }

    private <T> void addCallbackWithCallbackExecutor(ListenableFuture<T> future, FutureCallback<? super T> callback) {
        Futures.addCallback(future, callback, (Executor)this.callbackExecutor);
    }

    @Nonnull
    public <T, X extends Throwable> ListenableFuture<T> callWithRetry(long singleCallTimeoutMs, RetryPolicy retryPolicy, @Nonnull ThrowableSupplier<ListenableFuture<T>, X> func) {
        return this.callWithRetry(singleCallTimeoutMs, retryPolicy, func, null);
    }

    @Nonnull
    public <T, X extends Throwable> ListenableFuture<T> callWithRetry(long singleCallTimeoutMs, RetryPolicy retryPolicy, @Nonnull ThrowableSupplier<ListenableFuture<T>, X> func, @Nullable FutureCallback<T> eachRetryCallback) {
        Preconditions.checkNotNull((Object)retryPolicy);
        Preconditions.checkNotNull(func);
        Preconditions.checkArgument((singleCallTimeoutMs > 0L ? 1 : 0) != 0);
        SettableFuture resultFuture = SettableFuture.create();
        AtomicInteger retryTime = new AtomicInteger(0);
        Supplier<RetryConfig> retryConfigSupplier = () -> new RetryConfig(retryPolicy.retry(retryTime.incrementAndGet()), retryPolicy.hedge(), retryPolicy.triggerGetOnTimeout(), retryPolicy::abortRetry);
        Scope scope = Scope.getCurrentScope();
        ThrowableSupplier scopeWrappedFunc = () -> (ListenableFuture)Scope.supplyWithExistScope(scope, func);
        return this.callWithRetry(scopeWrappedFunc, singleCallTimeoutMs, retryConfigSupplier, resultFuture, eachRetryCallback);
    }

    private <T, X extends Throwable> SettableFuture<T> callWithRetry(final @Nonnull ThrowableSupplier<ListenableFuture<T>, X> func, final long singleCallTimeoutMs, final Supplier<RetryConfig> retryConfigSupplier, final SettableFuture<T> resultFuture, final FutureCallback<T> eachRetryCallback) {
        if (resultFuture.isDone()) {
            return resultFuture;
        }
        final RetryConfig retryConfig = retryConfigSupplier.get();
        final SettableFuture currentTry = SettableFuture.create();
        if (eachRetryCallback != null) {
            Futures.addCallback((ListenableFuture)currentTry, eachRetryCallback, (Executor)this.callbackExecutor);
        }
        final AtomicBoolean currentTrySetted = new AtomicBoolean(false);
        RefHolder<ListenableFuture> callingFuture = new RefHolder<ListenableFuture>();
        try {
            callingFuture.set((ListenableFuture)func.get());
            ScopeAsyncRetry.addCallbackWithDirectExecutor((ListenableFuture)callingFuture.get(), new FutureCallback<T>(){
                final /* synthetic */ ScopeAsyncRetry this$0;
                {
                    this.this$0 = this$0;
                }

                public void onSuccess(@Nullable T result) {
                    if (currentTrySetted.compareAndSet(false, true)) {
                        currentTry.set(result);
                    }
                }

                public void onFailure(Throwable t) {
                    if (currentTrySetted.compareAndSet(false, true)) {
                        currentTry.setException(t);
                    }
                }
            });
        }
        catch (Throwable t) {
            currentTry.setException(t);
        }
        if (callingFuture.get() != null) {
            this.scheduler.schedule(() -> {
                if (retryConfig.triggerGetOnTimeout) {
                    if (currentTrySetted.compareAndSet(false, true)) {
                        try {
                            Object result = ((ListenableFuture)callingFuture.get()).get(0L, TimeUnit.NANOSECONDS);
                            currentTry.set(result);
                        }
                        catch (Throwable t) {
                            currentTry.setException(t);
                        }
                    }
                } else {
                    currentTry.setException((Throwable)new TimeoutException());
                }
                if (!retryConfig.hedge) {
                    ((ListenableFuture)callingFuture.get()).cancel(false);
                } else {
                    ScopeAsyncRetry.addCallbackWithDirectExecutor(resultFuture, ScopeAsyncRetry.cancelOtherFuture((Future)callingFuture.get(), false));
                }
            }, singleCallTimeoutMs, TimeUnit.MILLISECONDS);
        }
        if (retryConfig.hedge && callingFuture.get() != null) {
            ScopeAsyncRetry.addCallbackWithDirectExecutor((ListenableFuture)callingFuture.get(), ScopeAsyncRetry.setSuccessResultToOtherSettableFuture(resultFuture));
        }
        if (retryConfig.retryInterval < 0L) {
            this.addCallbackWithCallbackExecutor((ListenableFuture<T>)currentTry, (FutureCallback<? super T>)ScopeAsyncRetry.setAllResultToOtherSettableFuture(resultFuture));
        } else {
            this.addCallbackWithCallbackExecutor((ListenableFuture<T>)currentTry, (FutureCallback<? super T>)ScopeAsyncRetry.setSuccessResultToOtherSettableFuture(resultFuture));
        }
        if (!resultFuture.isDone() && retryConfig.retryInterval >= 0L) {
            this.addCallbackWithCallbackExecutor((ListenableFuture<T>)currentTry, (FutureCallback<? super T>)new FutureCallback<T>(){
                final /* synthetic */ ScopeAsyncRetry this$0;
                {
                    this.this$0 = this$0;
                }

                public void onSuccess(@Nullable T result) {
                }

                public void onFailure(Throwable t) {
                    if (retryConfig.abortRetry.test(t)) {
                        resultFuture.setException(t);
                    } else if (retryConfig.retryInterval > 0L) {
                        this.this$0.scheduler.schedule(() -> this.lambda$onFailure$0(func, singleCallTimeoutMs, (Supplier)retryConfigSupplier, resultFuture, eachRetryCallback), retryConfig.retryInterval, TimeUnit.MILLISECONDS);
                    } else {
                        this.this$0.callWithRetry(func, singleCallTimeoutMs, retryConfigSupplier, resultFuture, eachRetryCallback);
                    }
                }

                private /* synthetic */ void lambda$onFailure$0(ThrowableSupplier func2, long singleCallTimeoutMs2, Supplier retryConfigSupplier2, SettableFuture resultFuture2, FutureCallback eachRetryCallback2) {
                    this.this$0.callWithRetry(func2, singleCallTimeoutMs2, retryConfigSupplier2, resultFuture2, eachRetryCallback2);
                }
            });
        }
        return resultFuture;
    }

    private static final class LazyHolder {
        private static final ScopeAsyncRetry INSTANCE = ScopeAsyncRetry.createScopeAsyncRetry(Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setPriority(10).setNameFormat("default-retrier-%d").build()), Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, new ThreadFactoryBuilder().setPriority(10).setNameFormat("default-callback-%d").build()));

        private LazyHolder() {
        }
    }

    private static class RetryConfig {
        private final long retryInterval;
        private final boolean hedge;
        private final boolean triggerGetOnTimeout;
        private final Predicate<Throwable> abortRetry;

        private RetryConfig(long retryInterval, boolean hedge, boolean triggerGetOnTimeout, Predicate<Throwable> abortRetry) {
            this.retryInterval = retryInterval;
            this.hedge = hedge;
            this.triggerGetOnTimeout = triggerGetOnTimeout;
            this.abortRetry = abortRetry;
        }
    }

    private static class RefHolder<R> {
        private R r;

        private RefHolder() {
        }

        public void set(R ref) {
            this.r = ref;
        }

        public R get() {
            return this.r;
        }
    }
}

