/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.scope;

import com.github.phantomthief.scope.LongCostTrack;
import com.github.phantomthief.scope.Scope;
import com.github.phantomthief.util.MoreSuppliers;
import com.google.common.base.Preconditions;
import com.google.common.collect.MapMaker;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScopeUtils {
    private static final Logger logger = LoggerFactory.getLogger(ScopeUtils.class);
    private static final ConcurrentMap<LongCostTrackImpl, Boolean> MAP = new MapMaker().weakKeys().concurrencyLevel(64).makeMap();
    private static final int CHECK_PERIOD = 1;
    private static final Supplier<ScheduledFuture<?>> SCHEDULER = MoreSuppliers.lazy(() -> Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("long-cost-track").setPriority(1).build()).scheduleWithFixedDelay(ScopeUtils::doReport, 1L, 1L, TimeUnit.SECONDS));

    private ScopeUtils() {
    }

    private static Runnable wrapRunnableExistScope(@Nullable Scope scope, @Nonnull Runnable runnable) {
        return () -> Scope.runWithExistScope(scope, runnable::run);
    }

    private static <T> Supplier<T> wrapSupplierExistScope(@Nullable Scope scope, @Nonnull Supplier<T> supplier) {
        return () -> Scope.supplyWithExistScope(scope, ((Supplier)supplier)::get);
    }

    public static void runAsyncWithCurrentScope(@Nonnull Runnable runnable, @Nonnull Executor executor) {
        executor.execute(ScopeUtils.wrapRunnableExistScope(Scope.getCurrentScope(), runnable));
    }

    @Nonnull
    public static ListenableFuture<?> runAsyncWithCurrentScope(@Nonnull Runnable runnable, @Nonnull ListeningExecutorService executor) {
        return executor.submit(ScopeUtils.wrapRunnableExistScope(Scope.getCurrentScope(), runnable));
    }

    @Nonnull
    public static <U> Future<U> supplyAsyncWithCurrentScope(@Nonnull Supplier<U> supplier, @Nonnull ExecutorService executor) {
        return executor.submit(() -> ScopeUtils.wrapSupplierExistScope(Scope.getCurrentScope(), supplier).get());
    }

    @Nonnull
    public static <U> ListenableFuture<U> supplyAsyncWithCurrentScope(@Nonnull Supplier<U> supplier, @Nonnull ListeningExecutorService executor) {
        return executor.submit(() -> ScopeUtils.wrapSupplierExistScope(Scope.getCurrentScope(), supplier).get());
    }

    public static LongCostTrack trackLongCost(Duration timeoutForReport, Consumer<Duration> onTimeoutReportRunnable) {
        SCHEDULER.get();
        Scope scope = Scope.getCurrentScope();
        long nano = System.nanoTime();
        LongCostTrackImpl context = new LongCostTrackImpl(onTimeoutReportRunnable, nano, nano + timeoutForReport.toNanos(), scope);
        MAP.put(context, Boolean.TRUE);
        return context;
    }

    private static void doReport() {
        Iterator iterator = MAP.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LongCostTrackImpl key = (LongCostTrackImpl)entry.getKey();
            if (key.closed) {
                iterator.remove();
                continue;
            }
            long now = System.nanoTime();
            long currentCost = now - key.deadline;
            if (currentCost <= 0L) continue;
            Scope.runWithExistScope(key.scope, () -> {
                try {
                    key.runnable.accept(Duration.ofNanos(now - key.start));
                }
                catch (Throwable e) {
                    logger.error("", e);
                }
                finally {
                    iterator.remove();
                }
            });
        }
    }

    @Nonnull
    public static <U> FutureCallback<U> wrapWithScope(final @Nonnull FutureCallback<U> futureCallback) {
        Preconditions.checkNotNull(futureCallback);
        final Scope currentScope = Scope.getCurrentScope();
        return new FutureCallback<U>(){

            public void onSuccess(@Nullable U u) {
                Scope.runWithExistScope(currentScope, () -> futureCallback.onSuccess(u));
            }

            public void onFailure(Throwable throwable) {
                Scope.runWithExistScope(currentScope, () -> futureCallback.onFailure(throwable));
            }
        };
    }

    private static class LongCostTrackImpl
    implements LongCostTrack {
        private final Consumer<Duration> runnable;
        private final long start;
        private final long deadline;
        private final Scope scope;
        private volatile boolean closed;

        private LongCostTrackImpl(Consumer<Duration> runnable, long start, long deadline, Scope scope) {
            this.runnable = runnable;
            this.start = start;
            this.deadline = deadline;
            this.scope = scope;
        }

        @Override
        public void close() {
            this.closed = true;
            MAP.remove(this);
        }
    }
}

