/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.scope;

import com.github.phantomthief.scope.ScopeKey;
import com.github.phantomthief.util.ThrowableRunnable;
import com.github.phantomthief.util.ThrowableSupplier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class Scope {
    private static final ThreadLocal<Scope> SCOPE_THREAD_LOCAL = new ThreadLocal();
    private final ConcurrentMap<ScopeKey<?>, Object> values = new ConcurrentHashMap();

    public static <X extends Throwable> void runWithExistScope(@Nullable Scope scope, ThrowableRunnable<X> runnable) throws X {
        Scope.supplyWithExistScope(scope, () -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, X extends Throwable> T supplyWithExistScope(@Nullable Scope scope, ThrowableSupplier<T, X> supplier) throws X {
        Scope oldScope = SCOPE_THREAD_LOCAL.get();
        SCOPE_THREAD_LOCAL.set(scope);
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            if (oldScope != null) {
                SCOPE_THREAD_LOCAL.set(oldScope);
            } else {
                SCOPE_THREAD_LOCAL.remove();
            }
        }
    }

    public static <X extends Throwable> void runWithNewScope(@Nonnull ThrowableRunnable<X> runnable) throws X {
        Scope.supplyWithNewScope(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T, X extends Throwable> T supplyWithNewScope(@Nonnull ThrowableSupplier<T, X> supplier) throws X {
        Scope.beginScope();
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            Scope.endScope();
        }
    }

    @Nonnull
    public static Scope beginScope() {
        Scope scope = SCOPE_THREAD_LOCAL.get();
        if (scope != null) {
            throw new IllegalStateException("start a scope in an exist scope.");
        }
        scope = new Scope();
        SCOPE_THREAD_LOCAL.set(scope);
        return scope;
    }

    public static void endScope() {
        SCOPE_THREAD_LOCAL.remove();
    }

    @Nullable
    public static Scope getCurrentScope() {
        return SCOPE_THREAD_LOCAL.get();
    }

    public <T> void set(@Nonnull ScopeKey<T> key, T value) {
        if (value != null) {
            this.values.put(key, value);
        } else {
            this.values.remove(key);
        }
    }

    public <T> T get(@Nonnull ScopeKey<T> key) {
        Object value = this.values.get(key);
        if (value == null && key.initializer() != null && (value = key.initializer().get()) != null) {
            this.values.put(key, value);
        }
        return (T)(value == null ? key.defaultValue() : value);
    }
}

