/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.scope;

import com.github.phantomthief.scope.Scope;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScopeKey<T> {
    private static final Logger logger = LoggerFactory.getLogger(ScopeKey.class);
    private final T defaultValue;
    private final Supplier<T> initializer;

    private ScopeKey(T defaultValue, Supplier<T> initializer) {
        this.defaultValue = defaultValue;
        this.initializer = initializer;
    }

    @Nonnull
    public static <T> ScopeKey<T> allocate() {
        return ScopeKey.withDefaultValue(null);
    }

    @Nonnull
    @Deprecated
    public static <T> ScopeKey<T> withDefaultValue(T defaultValue) {
        ScopeKey.outputDeprecatedLog();
        return new ScopeKey<T>(defaultValue, null);
    }

    @Nonnull
    public static ScopeKey<Boolean> withDefaultValue(boolean defaultValue) {
        return ScopeKey.withDefaultValue(Boolean.valueOf(defaultValue));
    }

    @Nonnull
    public static ScopeKey<Integer> withDefaultValue(int defaultValue) {
        return ScopeKey.withDefaultValue(Integer.valueOf(defaultValue));
    }

    @Nonnull
    public static ScopeKey<Long> withDefaultValue(long defaultValue) {
        return ScopeKey.withDefaultValue(Long.valueOf(defaultValue));
    }

    @Nonnull
    public static ScopeKey<String> withDefaultValue(String defaultValue) {
        return ScopeKey.withDefaultValue(defaultValue);
    }

    @Nonnull
    public static <T extends Enum<T>> ScopeKey<T> withDefaultValue(T defaultValue) {
        return ScopeKey.withDefaultValue(defaultValue);
    }

    @Nonnull
    public static <T> ScopeKey<T> withInitializer(Supplier<T> initializer) {
        return new ScopeKey<Object>(null, initializer);
    }

    public T get() {
        Scope currentScope = Scope.getCurrentScope();
        if (currentScope == null) {
            return this.defaultValue();
        }
        return currentScope.get(this);
    }

    Supplier<T> initializer() {
        return this.initializer;
    }

    T defaultValue() {
        return this.defaultValue;
    }

    public boolean set(T value) {
        Scope currentScope = Scope.getCurrentScope();
        if (currentScope != null) {
            currentScope.set(this, value);
            return true;
        }
        return false;
    }

    private static void outputDeprecatedLog() {
        ArrayList stackTrace = Lists.newArrayList((Object[])Thread.currentThread().getStackTrace());
        boolean[] after = new boolean[]{false};
        int[] count = new int[]{0};
        String location = stackTrace.stream().filter(stack -> {
            if (stack.getClassName().equals(ScopeKey.class.getName())) {
                count[0] = count[0] + 1;
                after[0] = true;
                return false;
            }
            return after[0];
        }).map(stack -> stack.getFileName() + ":" + stack.getLineNumber()).findFirst().orElse(null);
        if (count[0] == 2) {
            logger.warn("found deprecated call ScopeKey.withDefaultValue at location:({})", (Object)location);
        }
    }
}

