/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.scope;

import com.github.phantomthief.scope.Scope;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScopeKey<T> {
    private static final Logger logger = LoggerFactory.getLogger(ScopeKey.class);
    private final T defaultValue;
    private final Supplier<T> initializer;

    private ScopeKey(T defaultValue, Supplier<T> initializer) {
        this.defaultValue = defaultValue;
        this.initializer = initializer;
    }

    @Nonnull
    public static <T> ScopeKey<T> allocate() {
        return ScopeKey.withDefaultValue0(null);
    }

    @Nonnull
    private static <T> ScopeKey<T> withDefaultValue0(T defaultValue) {
        return new ScopeKey<T>(defaultValue, null);
    }

    @Nonnull
    public static ScopeKey<Boolean> withDefaultValue(boolean defaultValue) {
        return ScopeKey.withDefaultValue0(defaultValue);
    }

    @Nonnull
    public static ScopeKey<Integer> withDefaultValue(int defaultValue) {
        return ScopeKey.withDefaultValue0(defaultValue);
    }

    @Nonnull
    public static ScopeKey<Long> withDefaultValue(long defaultValue) {
        return ScopeKey.withDefaultValue0(defaultValue);
    }

    @Nonnull
    public static ScopeKey<Double> withDefaultValue(double defaultValue) {
        return ScopeKey.withDefaultValue0(defaultValue);
    }

    @Nonnull
    public static ScopeKey<String> withDefaultValue(String defaultValue) {
        return ScopeKey.withDefaultValue0(defaultValue);
    }

    @Nonnull
    public static <T extends Enum<T>> ScopeKey<T> withDefaultValue(T defaultValue) {
        return ScopeKey.withDefaultValue0(defaultValue);
    }

    @Nonnull
    public static <T> ScopeKey<T> withInitializer(Supplier<T> initializer) {
        return new ScopeKey<Object>(null, initializer);
    }

    public T get() {
        Scope currentScope = Scope.getCurrentScope();
        if (currentScope == null) {
            return this.defaultValue();
        }
        return currentScope.get(this);
    }

    Supplier<T> initializer() {
        return this.initializer;
    }

    T defaultValue() {
        return this.defaultValue;
    }

    public boolean set(T value) {
        Scope currentScope = Scope.getCurrentScope();
        if (currentScope != null) {
            currentScope.set(this, value);
            return true;
        }
        return false;
    }
}

