/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.scope;

import com.github.phantomthief.scope.Scope;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ScopeUtils {
    private ScopeUtils() {
    }

    private static Runnable wrapRunnableExistScope(@Nullable Scope scope, @Nonnull Runnable runnable) {
        return () -> Scope.runWithExistScope(scope, runnable::run);
    }

    private static <T> Supplier<T> wrapSupplierExistScope(@Nullable Scope scope, @Nonnull Supplier<T> supplier) {
        return () -> Scope.supplyWithExistScope(scope, ((Supplier)supplier)::get);
    }

    public static void runAsyncWithCurrentScope(@Nonnull Runnable runnable, @Nonnull Executor executor) {
        executor.execute(ScopeUtils.wrapRunnableExistScope(Scope.getCurrentScope(), runnable));
    }

    @Nonnull
    public static ListenableFuture<?> runAsyncWithCurrentScope(@Nonnull Runnable runnable, @Nonnull ListeningExecutorService executor) {
        return executor.submit(ScopeUtils.wrapRunnableExistScope(Scope.getCurrentScope(), runnable));
    }

    @Nonnull
    public static <U> Future<U> supplyAsyncWithCurrentScope(@Nonnull Supplier<U> supplier, @Nonnull ExecutorService executor) {
        return executor.submit(() -> ScopeUtils.wrapSupplierExistScope(Scope.getCurrentScope(), supplier).get());
    }

    @Nonnull
    public static <U> ListenableFuture<U> supplyAsyncWithCurrentScope(@Nonnull Supplier<U> supplier, @Nonnull ListeningExecutorService executor) {
        return executor.submit(() -> ScopeUtils.wrapSupplierExistScope(Scope.getCurrentScope(), supplier).get());
    }
}

