/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.zookeeper;

import com.github.phantomthief.util.ThrowableBiConsumer;
import com.github.phantomthief.util.ThrowableBiFunction;
import com.github.phantomthief.util.ThrowableConsumer;
import com.github.phantomthief.util.ThrowableFunction;
import com.github.phantomthief.zookeeper.ZkBasedNodeResource;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.zookeeper.data.Stat;

public class GenericZkBasedNodeBuilder<T> {
    private final ZkBasedNodeResource.Builder<Object> builder;

    GenericZkBasedNodeBuilder(ZkBasedNodeResource.Builder<Object> builder) {
        this.builder = builder;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> addFactoryFailedListener(@Nonnull ThrowableConsumer<Throwable, Throwable> listener) {
        this.builder.addFactoryFailedListener(listener);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> addFactoryFailedListener(@Nonnull ThrowableBiConsumer<ChildData, Throwable, Throwable> listener) {
        this.builder.addFactoryFailedListener(listener);
        return this;
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withFactory(BiFunction<byte[], Stat, ? extends T> factory) {
        return this.withFactoryEx(factory::apply);
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withFactoryEx(ThrowableBiFunction<byte[], Stat, ? extends T, Exception> factory) {
        this.builder.withFactoryEx(factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> asyncRefresh(@Nonnull ListeningExecutorService executor) {
        this.builder.asyncRefresh(executor);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> onResourceChange(BiConsumer<? super T, ? super T> callback) {
        this.builder.onResourceChange(callback);
        return this;
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withFactory(Function<byte[], ? extends T> factory) {
        return this.withFactoryEx(factory::apply);
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withFactoryEx(ThrowableFunction<byte[], ? extends T, Exception> factory) {
        return this.withFactoryEx((b, s) -> factory.apply(b));
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withStringFactory(BiFunction<String, Stat, ? extends T> factory) {
        return this.withStringFactoryEx(factory::apply);
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withStringFactoryEx(ThrowableBiFunction<String, Stat, ? extends T, Exception> factory) {
        return this.withFactoryEx((b, s) -> factory.apply((Object)(b == null ? null : new String((byte[])b)), s));
    }

    @Deprecated
    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withStringFactory(Function<String, ? extends T> factory) {
        return this.withStringFactoryEx(factory::apply);
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withStringFactoryEx(ThrowableFunction<String, ? extends T, Exception> factory) {
        return this.withStringFactoryEx((b, s) -> factory.apply(b));
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withCacheFactory(Supplier<NodeCache> cacheFactory) {
        this.builder.withCacheFactory(cacheFactory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withCacheFactory(String path, CuratorFramework curator) {
        this.builder.withCacheFactory(path, curator);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withCacheFactory(String path, Supplier<CuratorFramework> curatorFactory) {
        this.builder.withCacheFactory(path, curatorFactory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withCleanupConsumer(ThrowableConsumer<? super T, Throwable> cleanup) {
        this.builder.withCleanupConsumer(cleanup);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withCleanupPredicate(Predicate<? super T> cleanup) {
        this.builder.withCleanupPredicate(cleanup);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withWaitStopPeriod(long waitStopPeriod) {
        this.builder.withWaitStopPeriod(waitStopPeriod);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withEmptyObject(T emptyObject) {
        this.builder.withEmptyObject(emptyObject);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withRefreshFactory(@Nonnull ThrowableBiFunction<byte[], Stat, ? extends T, Exception> factory) {
        this.builder.withRefreshFactory(factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withRefreshFactory(@Nullable ListeningExecutorService executor, @Nonnull ThrowableBiFunction<byte[], Stat, ? extends T, Exception> factory) {
        this.builder.withRefreshFactory(executor, factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withAsyncRefreshFactory(@Nonnull ThrowableBiFunction<byte[], Stat, ListenableFuture<T>, Exception> factory) {
        this.builder.withAsyncRefreshFactory(factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withRefreshFactory(@Nonnull ThrowableFunction<byte[], ? extends T, Exception> factory) {
        this.builder.withRefreshFactory(factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withRefreshFactory(@Nullable ListeningExecutorService executor, @Nonnull ThrowableFunction<byte[], ? extends T, Exception> factory) {
        this.builder.withRefreshFactory(executor, factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withAsyncRefreshFactory(ThrowableFunction<byte[], ListenableFuture<T>, Exception> factory) {
        this.builder.withAsyncRefreshFactory(factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withRefreshStringFactory(@Nonnull ThrowableBiFunction<String, Stat, ? extends T, Exception> factory) {
        this.builder.withRefreshStringFactory(factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withRefreshStringFactory(@Nullable ListeningExecutorService executor, @Nonnull ThrowableBiFunction<String, Stat, ? extends T, Exception> factory) {
        this.builder.withRefreshStringFactory(executor, factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withAsyncRefreshStringFactory(@Nonnull ThrowableBiFunction<String, Stat, ListenableFuture<T>, Exception> factory) {
        this.builder.withAsyncRefreshStringFactory(factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withRefreshStringFactory(@Nonnull ThrowableFunction<String, ? extends T, Exception> factory) {
        this.builder.withRefreshStringFactory(factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withRefreshStringFactory(@Nullable ListeningExecutorService executor, @Nonnull ThrowableFunction<String, ? extends T, Exception> factory) {
        this.builder.withRefreshStringFactory(executor, factory);
        return this;
    }

    @CheckReturnValue
    @Nonnull
    public GenericZkBasedNodeBuilder<T> withAsyncRefreshStringFactory(ThrowableFunction<String, ListenableFuture<T>, Exception> factory) {
        this.builder.withAsyncRefreshStringFactory(factory);
        return this;
    }

    @Nonnull
    public ZkBasedNodeResource<T> build() {
        return this.builder.build();
    }
}

