/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.zookeeper;

import com.github.phantomthief.util.MoreSuppliers;
import com.github.phantomthief.util.ThrowableBiConsumer;
import com.github.phantomthief.util.ThrowableBiFunction;
import com.github.phantomthief.util.ThrowableConsumer;
import com.github.phantomthief.util.ThrowableFunction;
import com.github.phantomthief.zookeeper.GenericZkBasedNodeBuilder;
import com.github.phantomthief.zookeeper.ZkNode;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.curator.framework.recipes.cache.NodeCacheListener;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZkBasedNodeResource<T>
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ZkBasedNodeResource.class);
    private static final int UNKNOWN = 0;
    private static final int EXISTS = 1;
    private static final int NOT_EXISTS = 2;
    private final Object lock = new Object();
    private final ThrowableBiFunction<byte[], Stat, T, Exception> factory;
    private final ThrowableBiFunction<byte[], Stat, ListenableFuture<T>, Exception> refreshFactory;
    private final Predicate<T> cleanup;
    private final long waitStopPeriod;
    private final T emptyObject;
    private final BiConsumer<T, T> onResourceChange;
    private final Supplier<NodeCache> nodeCache;
    private final Runnable nodeCacheShutdown;
    private final BiConsumer<ChildData, Throwable> factoryFailedListener;
    @GuardedBy(value="lock")
    private volatile T resource;
    @GuardedBy(value="lock")
    private volatile boolean emptyLogged = false;
    @GuardedBy(value="lock")
    private volatile boolean closed = false;
    private volatile int zkNodeExists = 0;
    private volatile boolean hasAddListener = false;
    private volatile Runnable nodeCacheRemoveListener;

    private ZkBasedNodeResource(Builder<T> builder) {
        this.factory = builder.factory;
        this.refreshFactory = builder.refreshFactory;
        this.cleanup = builder.cleanup;
        this.waitStopPeriod = builder.waitStopPeriod;
        this.emptyObject = builder.emptyObject;
        this.onResourceChange = builder.onResourceChange;
        this.nodeCacheShutdown = builder.nodeCacheShutdown;
        this.nodeCache = MoreSuppliers.lazy((Supplier)builder.cacheFactory);
        this.factoryFailedListener = (d, t) -> {
            for (ThrowableBiConsumer failedListener : builder.factoryFailedListeners) {
                try {
                    failedListener.accept(d, t);
                }
                catch (Throwable e) {
                    logger.error("", e);
                }
            }
        };
    }

    @Deprecated
    @Nonnull
    public static Builder<Object> newBuilder() {
        return new Builder<Object>();
    }

    @CheckReturnValue
    @Nonnull
    public static <T> GenericZkBasedNodeBuilder<T> newGenericBuilder() {
        return new GenericZkBasedNodeBuilder(ZkBasedNodeResource.newBuilder());
    }

    private static String path(NodeCache nodeCache) {
        try {
            if (nodeCache == null) {
                return "n/a";
            }
            Field f = NodeCache.class.getDeclaredField("path");
            f.setAccessible(true);
            return (String)f.get(nodeCache);
        }
        catch (Throwable e) {
            logger.error("Ops.fail to get path from node:{}, exception:{}", (Object)nodeCache, (Object)e.toString());
            return null;
        }
    }

    private static String zkConn(CuratorFramework zk) {
        String result = zk.getZookeeperClient().getCurrentConnectionString();
        if (StringUtils.isNotBlank((CharSequence)zk.getNamespace())) {
            result = result + "[" + zk.getNamespace() + "]";
        }
        return result;
    }

    public ZkNode<T> zkNode() {
        T t = this.get();
        return new ZkNode<T>(t, this.zkNodeExists == 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        this.checkClosed();
        if (this.resource == null) {
            if (this.zkNodeExists == 2) {
                return this.emptyObject;
            }
            Object object = this.lock;
            synchronized (object) {
                this.checkClosed();
                if (this.resource == null) {
                    NodeCache cache = this.nodeCache.get();
                    this.tryAddListener(cache);
                    ChildData currentData = cache.getCurrentData();
                    if (currentData == null || currentData.getData() == null) {
                        this.zkNodeExists = 2;
                        if (!this.emptyLogged) {
                            logger.info("found no zk path for:{}:{}, using empty data:{}", new Object[]{ZkBasedNodeResource.zkConn(cache.getClient()), ZkBasedNodeResource.path(cache), this.emptyObject});
                            this.emptyLogged = true;
                        }
                        return this.emptyObject;
                    }
                    this.zkNodeExists = 1;
                    try {
                        this.resource = this.factory.apply((Object)currentData.getData(), (Object)currentData.getStat());
                        if (this.onResourceChange != null) {
                            this.onResourceChange.accept(this.resource, this.emptyObject);
                        }
                    }
                    catch (Exception e) {
                        this.factoryFailedListener.accept(currentData, e);
                        Throwables.throwIfUnchecked((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.resource;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("zkNode has been closed.");
        }
    }

    private void tryAddListener(final NodeCache cache) {
        if (!this.hasAddListener) {
            NodeCacheListener nodeCacheListener = () -> {
                Object object = this.lock;
                synchronized (object) {
                    final ChildData data = cache.getCurrentData();
                    final T oldResource = this.resource;
                    if (data != null && data.getData() != null) {
                        this.zkNodeExists = 1;
                        ListenableFuture future = (ListenableFuture)this.refreshFactory.apply((Object)data.getData(), (Object)data.getStat());
                        Futures.addCallback((ListenableFuture)future, (FutureCallback)new FutureCallback<T>(){

                            public void onSuccess(@Nullable T result) {
                                ZkBasedNodeResource.this.resource = result;
                                ZkBasedNodeResource.this.cleanup(ZkBasedNodeResource.this.resource, oldResource, cache);
                            }

                            public void onFailure(Throwable t) {
                                ZkBasedNodeResource.this.factoryFailedListener.accept(data, t);
                                logger.error("", t);
                            }
                        }, (Executor)MoreExecutors.directExecutor());
                    } else {
                        this.zkNodeExists = 2;
                        this.resource = null;
                        this.emptyLogged = false;
                        this.cleanup(this.resource, oldResource, cache);
                    }
                }
            };
            cache.getListenable().addListener((Object)nodeCacheListener);
            this.nodeCacheRemoveListener = () -> cache.getListenable().removeListener((Object)nodeCacheListener);
            this.hasAddListener = true;
        }
    }

    private void cleanup(T currentResource, T oldResource, NodeCache nodeCache) {
        if (oldResource != null && oldResource != this.emptyObject) {
            if (currentResource == oldResource) {
                logger.warn("[BUG!!!!] should NOT occurred, old resource is same as current, path:{}, {}", (Object)ZkBasedNodeResource.path(nodeCache), oldResource);
            } else {
                new ThreadFactoryBuilder().setNameFormat("old [" + oldResource.getClass().getSimpleName() + "] cleanup thread-[%d]").setUncaughtExceptionHandler((t, e) -> logger.error("fail to cleanup resource, path:{}, {}", new Object[]{ZkBasedNodeResource.path(nodeCache), oldResource.getClass().getSimpleName(), e})).setPriority(1).setDaemon(true).build().newThread(() -> {
                    do {
                        if (this.waitStopPeriod <= 0L) continue;
                        Uninterruptibles.sleepUninterruptibly((long)this.waitStopPeriod, (TimeUnit)TimeUnit.MILLISECONDS);
                    } while (!this.cleanup.test(oldResource));
                    if (this.onResourceChange != null) {
                        this.onResourceChange.accept(currentResource, oldResource);
                    }
                }).start();
                return;
            }
        }
        if (this.onResourceChange != null) {
            this.onResourceChange.accept(currentResource, oldResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.nodeCacheShutdown != null) {
                this.nodeCacheShutdown.run();
            }
            if (this.nodeCacheRemoveListener != null) {
                this.nodeCacheRemoveListener.run();
            }
            if (this.resource != null && this.resource != this.emptyObject && this.cleanup != null) {
                this.cleanup.test(this.resource);
            }
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Deprecated
    public static final class Builder<E> {
        private ThrowableBiFunction<byte[], Stat, E, Exception> factory;
        private ThrowableBiFunction<byte[], Stat, ListenableFuture<E>, Exception> refreshFactory;
        private Supplier<NodeCache> cacheFactory;
        private Predicate<E> cleanup;
        private long waitStopPeriod;
        private E emptyObject;
        private BiConsumer<E, E> onResourceChange;
        private Runnable nodeCacheShutdown;
        private ListeningExecutorService refreshExecutor;
        private List<ThrowableBiConsumer<ChildData, Throwable, Throwable>> factoryFailedListeners = new ArrayList<ThrowableBiConsumer<ChildData, Throwable, Throwable>>();

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> addFactoryFailedListener(@Nonnull ThrowableConsumer<Throwable, Throwable> listener) {
            Preconditions.checkNotNull(listener);
            return this.addFactoryFailedListener((ThrowableBiConsumer<ChildData, Throwable, Throwable>)((ThrowableBiConsumer)(d, t) -> listener.accept(t)));
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> addFactoryFailedListener(@Nonnull ThrowableBiConsumer<ChildData, Throwable, Throwable> listener) {
            this.factoryFailedListeners.add((ThrowableBiConsumer<ChildData, Throwable, Throwable>)Preconditions.checkNotNull(listener));
            return this;
        }

        @Deprecated
        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withFactory(@Nonnull BiFunction<byte[], Stat, ? extends E1> factory) {
            return this.withFactoryEx(factory::apply);
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withFactoryEx(@Nonnull ThrowableBiFunction<byte[], Stat, ? extends E1, Exception> factory) {
            Builder thisBuilder = this;
            thisBuilder.factory = factory;
            return thisBuilder;
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withRefreshStringFactory(@Nonnull ThrowableBiFunction<String, Stat, ? extends E1, Exception> factory) {
            return this.withRefreshStringFactory(null, factory);
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withRefreshStringFactory(@Nullable ListeningExecutorService executor, @Nonnull ThrowableBiFunction<String, Stat, ? extends E1, Exception> factory) {
            return this.withRefreshFactory(executor, (b, s) -> factory.apply((Object)(b == null ? null : new String((byte[])b)), s));
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withRefreshFactory(@Nonnull ThrowableBiFunction<byte[], Stat, ? extends E1, Exception> factory) {
            return this.withRefreshFactory(null, factory);
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withRefreshFactory(@Nullable ListeningExecutorService executor, @Nonnull ThrowableBiFunction<byte[], Stat, ? extends E1, Exception> factory) {
            Builder thisBuilder = this;
            thisBuilder.refreshFactory = executor == null ? (b, s) -> {
                try {
                    return Futures.immediateFuture((Object)factory.apply(b, s));
                }
                catch (Throwable t) {
                    return Futures.immediateFailedFuture((Throwable)t);
                }
            } : (b, s) -> executor.submit(() -> factory.apply(b, s));
            return thisBuilder;
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withAsyncRefreshStringFactory(@Nonnull ThrowableBiFunction<String, Stat, ListenableFuture<E1>, Exception> factory) {
            return this.withAsyncRefreshFactory((b, s) -> (ListenableFuture)factory.apply((Object)(b == null ? null : new String((byte[])b)), s));
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withAsyncRefreshFactory(@Nonnull ThrowableBiFunction<byte[], Stat, ListenableFuture<E1>, Exception> factory) {
            Builder thisBuilder = this;
            thisBuilder.refreshFactory = factory;
            return thisBuilder;
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> onResourceChange(BiConsumer<? super E1, ? super E1> callback) {
            Builder thisBuilder = this;
            thisBuilder.onResourceChange = callback;
            return thisBuilder;
        }

        @Deprecated
        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withFactory(@Nonnull Function<byte[], ? extends E1> factory) {
            return this.withFactoryEx(factory::apply);
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withFactoryEx(@Nonnull ThrowableFunction<byte[], ? extends E1, Exception> factory) {
            return this.withFactoryEx((b, s) -> factory.apply(b));
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withRefreshStringFactory(@Nonnull ThrowableFunction<String, ? extends E1, Exception> factory) {
            return this.withRefreshStringFactory(null, factory);
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withRefreshStringFactory(@Nullable ListeningExecutorService executor, @Nonnull ThrowableFunction<String, ? extends E1, Exception> factory) {
            return this.withRefreshStringFactory(executor, (b, s) -> factory.apply(b));
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withRefreshFactory(@Nonnull ThrowableFunction<byte[], ? extends E1, Exception> factory) {
            return this.withRefreshFactory(null, factory);
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withRefreshFactory(@Nullable ListeningExecutorService executor, @Nonnull ThrowableFunction<byte[], ? extends E1, Exception> factory) {
            return this.withRefreshFactory(executor, (b, s) -> factory.apply(b));
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withAsyncRefreshStringFactory(ThrowableFunction<String, ListenableFuture<E1>, Exception> factory) {
            return this.withAsyncRefreshStringFactory((b, s) -> (ListenableFuture)factory.apply(b));
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withAsyncRefreshFactory(ThrowableFunction<byte[], ListenableFuture<E1>, Exception> factory) {
            return this.withAsyncRefreshFactory((b, s) -> (ListenableFuture)factory.apply(b));
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> asyncRefresh(@Nonnull ListeningExecutorService executor) {
            Builder thisBuilder = this;
            thisBuilder.refreshExecutor = (ListeningExecutorService)Preconditions.checkNotNull((Object)executor);
            return thisBuilder;
        }

        @Deprecated
        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withStringFactory(BiFunction<String, Stat, ? extends E1> factory) {
            return this.withStringFactoryEx(factory::apply);
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withStringFactoryEx(ThrowableBiFunction<String, Stat, ? extends E1, Exception> factory) {
            return this.withFactoryEx((b, s) -> factory.apply((Object)(b == null ? null : new String((byte[])b)), s));
        }

        @Deprecated
        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withStringFactory(Function<String, ? extends E1> factory) {
            return this.withStringFactoryEx(factory::apply);
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withStringFactoryEx(ThrowableFunction<String, ? extends E1, Exception> factory) {
            return this.withStringFactoryEx((b, s) -> factory.apply(b));
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> withCacheFactory(Supplier<NodeCache> cacheFactory) {
            this.cacheFactory = cacheFactory;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> withCacheFactory(String path, CuratorFramework curator) {
            return this.withCacheFactory(path, () -> curator);
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> withCacheFactory(String path, Supplier<CuratorFramework> curatorFactory) {
            this.cacheFactory = () -> {
                CuratorFramework thisClient = (CuratorFramework)curatorFactory.get();
                if (thisClient.getState() != CuratorFrameworkState.STARTED) {
                    thisClient.start();
                }
                NodeCache buildingCache = new NodeCache(thisClient, path);
                try {
                    buildingCache.start();
                    if (Thread.currentThread().isInterrupted()) {
                        Thread.interrupted();
                    }
                    buildingCache.rebuild();
                    this.nodeCacheShutdown = () -> {
                        try {
                            buildingCache.close();
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    };
                    return buildingCache;
                }
                catch (Throwable e) {
                    Throwables.throwIfUnchecked((Throwable)e);
                    throw new RuntimeException(e);
                }
            };
            return this;
        }

        @Deprecated
        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withCleanup(ThrowableConsumer<? super E1, Throwable> cleanup) {
            return this.withCleanupConsumer(cleanup);
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withCleanupConsumer(ThrowableConsumer<? super E1, Throwable> cleanup) {
            Builder thisBuilder = this;
            thisBuilder.cleanup = t -> {
                try {
                    cleanup.accept(t);
                    return true;
                }
                catch (Throwable e) {
                    logger.error("Ops. fail to close, path:{}", t, (Object)e);
                    return false;
                }
            };
            return thisBuilder;
        }

        @Deprecated
        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withCleanup(Predicate<? super E1> cleanup) {
            return this.withCleanupPredicate(cleanup);
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withCleanupPredicate(Predicate<? super E1> cleanup) {
            Builder thisBuilder = this;
            thisBuilder.cleanup = cleanup;
            return thisBuilder;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> withWaitStopPeriod(long waitStopPeriod) {
            this.waitStopPeriod = waitStopPeriod;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public <E1> Builder<E1> withEmptyObject(E1 emptyObject) {
            Builder thisBuilder = this;
            thisBuilder.emptyObject = emptyObject;
            return thisBuilder;
        }

        @Nonnull
        public <E1> ZkBasedNodeResource<E1> build() {
            this.ensure();
            return new ZkBasedNodeResource(this);
        }

        private void ensure() {
            Preconditions.checkNotNull(this.factory);
            Preconditions.checkNotNull(this.cacheFactory);
            if (this.refreshFactory == null) {
                this.refreshFactory = this.refreshExecutor != null ? (bs, stat) -> this.refreshExecutor.submit(() -> this.factory.apply(bs, stat)) : (bs, stat) -> {
                    try {
                        return Futures.immediateFuture((Object)this.factory.apply(bs, stat));
                    }
                    catch (Throwable t) {
                        return Futures.immediateFailedFuture((Throwable)t);
                    }
                };
            }
            if (this.onResourceChange != null) {
                BiConsumer temp = this.onResourceChange;
                this.onResourceChange = (t, u) -> {
                    try {
                        temp.accept(t, u);
                    }
                    catch (Throwable e) {
                        logger.error("Ops.", e);
                    }
                };
            }
            if (this.cleanup == null) {
                this.withCleanup(t -> {
                    if (t instanceof Closeable) {
                        try {
                            ((Closeable)t).close();
                        }
                        catch (Throwable e) {
                            throw Throwables.propagate((Throwable)e);
                        }
                    }
                });
            }
        }
    }
}

