/*
 * Decompiled with CFR 0.152.
 */
package com.github.phantomthief.zookeeper;

import com.github.phantomthief.util.ThrowableConsumer;
import com.github.phantomthief.util.ThrowableFunction;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.Closeable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZkBasedTreeNodeResource<T>
implements Closeable {
    private static Logger logger = LoggerFactory.getLogger(ZkBasedTreeNodeResource.class);
    private final Object lock = new Object();
    private final ThrowableFunction<Map<String, ChildData>, T, Exception> factory;
    private final Predicate<T> cleanup;
    private final long waitStopPeriod;
    private final BiConsumer<T, T> onResourceChange;
    private final Supplier<CuratorFramework> curatorFrameworkFactory;
    private final String path;
    @GuardedBy(value="lock")
    private volatile TreeCache treeCache;
    @GuardedBy(value="lock")
    private volatile T resource;
    @GuardedBy(value="lock")
    private volatile boolean closed;

    private ZkBasedTreeNodeResource(Builder<T> builder) {
        this.factory = ((Builder)builder).factory;
        this.cleanup = ((Builder)builder).cleanup;
        this.path = ((Builder)builder).path;
        this.waitStopPeriod = ((Builder)builder).waitStopPeriod;
        this.curatorFrameworkFactory = ((Builder)builder).curatorFrameworkFactory;
        this.onResourceChange = ((Builder)builder).onResourceChange;
    }

    public static <T> Builder<T> newBuilder() {
        return new Builder();
    }

    private void ensureTreeCacheReady() {
        assert (Thread.holdsLock(this.lock));
        if (this.treeCache == null) {
            try {
                CountDownLatch countDownLatch = new CountDownLatch(1);
                TreeCache building = TreeCache.newBuilder((CuratorFramework)this.curatorFrameworkFactory.get(), (String)this.path).setCacheData(true).setExecutor(Executors.newSingleThreadExecutor(ThreadUtils.newThreadFactory((String)("TreeCache-[" + this.path + "]")))).build();
                building.getListenable().addListener((c, event) -> {
                    if (event.getType() == TreeCacheEvent.Type.INITIALIZED) {
                        countDownLatch.countDown();
                        return;
                    }
                    if (countDownLatch.getCount() > 0L) {
                        logger.debug("ignore event before initialized:{}=>{}", (Object)event.getType(), (Object)this.path);
                        return;
                    }
                    if (event.getType() == TreeCacheEvent.Type.CONNECTION_SUSPENDED || event.getType() == TreeCacheEvent.Type.CONNECTION_LOST) {
                        logger.info("ignore event:{} for tree node:{}", (Object)event.getType(), (Object)this.path);
                        return;
                    }
                    Object object = this.lock;
                    synchronized (object) {
                        T oldResource = this.resource;
                        this.resource = this.doFactory();
                        this.cleanup(this.resource, oldResource);
                    }
                });
                building.start();
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)countDownLatch);
                this.treeCache = building;
            }
            catch (Throwable e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        this.checkClosed();
        if (this.resource == null) {
            Object object = this.lock;
            synchronized (object) {
                this.checkClosed();
                if (this.resource == null) {
                    this.ensureTreeCacheReady();
                    try {
                        this.resource = this.doFactory();
                        if (this.onResourceChange != null) {
                            this.onResourceChange.accept(this.resource, null);
                        }
                    }
                    catch (Exception e) {
                        Throwables.throwIfUnchecked((Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.resource;
    }

    private void checkClosed() {
        if (this.closed) {
            throw new IllegalStateException("zkNode has been closed.");
        }
    }

    private void cleanup(T currentResource, T oldResource) {
        if (oldResource != null) {
            if (currentResource == oldResource) {
                logger.warn("[BUG!!!!] should NOT occured, old resource is same as current, path:{}, {}", (Object)this.path, oldResource);
            } else {
                new ThreadFactoryBuilder().setNameFormat("old [" + oldResource.getClass().getSimpleName() + "] cleanup thread-[%d]").setUncaughtExceptionHandler((t, e) -> logger.error("fail to cleanup resource, path:{}, {}", new Object[]{this.path, oldResource.getClass().getSimpleName(), e})).setPriority(1).setDaemon(true).build().newThread(() -> {
                    do {
                        if (this.waitStopPeriod <= 0L) continue;
                        Uninterruptibles.sleepUninterruptibly((long)this.waitStopPeriod, (TimeUnit)TimeUnit.MILLISECONDS);
                    } while (!this.cleanup.test(oldResource));
                    if (this.onResourceChange != null) {
                        this.onResourceChange.accept(currentResource, oldResource);
                    }
                }).start();
                return;
            }
        }
        if (this.onResourceChange != null) {
            this.onResourceChange.accept(currentResource, oldResource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            if (this.resource != null && this.cleanup != null) {
                this.cleanup.test(this.resource);
            }
            if (this.treeCache != null) {
                this.treeCache.close();
            }
            this.closed = true;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    private T doFactory() throws Exception {
        HashMap<String, ChildData> map = new HashMap<String, ChildData>();
        this.generateFullTree(map, this.treeCache, this.path);
        return (T)this.factory.apply(map);
    }

    private void generateFullTree(Map<String, ChildData> map, TreeCache cache, String rootPath) {
        Map thisMap = cache.getCurrentChildren(rootPath);
        if (thisMap != null) {
            thisMap.values().forEach(c -> map.put(StringUtils.removeStart((String)c.getPath(), (String)this.path), (ChildData)c));
            thisMap.values().forEach(c -> this.generateFullTree(map, cache, c.getPath()));
        }
    }

    public static final class Builder<E> {
        private ThrowableFunction<Map<String, ChildData>, E, Exception> factory;
        private String path;
        private Supplier<CuratorFramework> curatorFrameworkFactory;
        private Predicate<E> cleanup;
        private long waitStopPeriod;
        private BiConsumer<E, E> onResourceChange;

        @CheckReturnValue
        @Nonnull
        public Builder<E> path(String path) {
            this.path = path;
            return this;
        }

        @Deprecated
        @CheckReturnValue
        @Nonnull
        public Builder<E> factory(Function<Map<String, ChildData>, E> factory) {
            return this.factoryEx(factory::apply);
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> factoryEx(ThrowableFunction<Map<String, ChildData>, E, Exception> factory) {
            this.factory = factory;
            return this;
        }

        @CheckReturnValue
        @Deprecated
        @Nonnull
        public Builder<E> childDataFactory(Function<Collection<ChildData>, E> factory) {
            return this.childDataFactoryEx(factory::apply);
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> childDataFactoryEx(ThrowableFunction<Collection<ChildData>, E, Exception> factory) {
            Preconditions.checkNotNull(factory);
            return this.factoryEx(map -> factory.apply(map.values()));
        }

        @Deprecated
        @CheckReturnValue
        @Nonnull
        public Builder<E> keysFactory(Function<Collection<String>, E> factory) {
            return this.keysFactoryEx(factory::apply);
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> keysFactoryEx(ThrowableFunction<Collection<String>, E, Exception> factory) {
            Preconditions.checkNotNull(factory);
            return this.factoryEx(map -> factory.apply(map.keySet()));
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> onResourceChange(BiConsumer<E, E> callback) {
            this.onResourceChange = callback;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> curator(Supplier<CuratorFramework> curatorFactory) {
            this.curatorFrameworkFactory = curatorFactory;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> curator(CuratorFramework curator) {
            this.curatorFrameworkFactory = () -> curator;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> cleanup(ThrowableConsumer<E, Throwable> cleanup) {
            this.cleanup = t -> {
                try {
                    cleanup.accept(t);
                    return true;
                }
                catch (Throwable e) {
                    logger.error("Ops. fail to close, path:{}", t, (Object)e);
                    return false;
                }
            };
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> cleanup(Predicate<E> cleanup) {
            this.cleanup = cleanup;
            return this;
        }

        @CheckReturnValue
        @Nonnull
        public Builder<E> withWaitStopPeriod(long waitStopPeriod) {
            this.waitStopPeriod = waitStopPeriod;
            return this;
        }

        @Nonnull
        public ZkBasedTreeNodeResource<E> build() {
            this.ensure();
            return new ZkBasedTreeNodeResource(this);
        }

        private void ensure() {
            Preconditions.checkNotNull(this.factory);
            Preconditions.checkNotNull(this.curatorFrameworkFactory);
            if (this.onResourceChange != null) {
                BiConsumer temp = this.onResourceChange;
                this.onResourceChange = (t, u) -> {
                    try {
                        temp.accept(t, u);
                    }
                    catch (Throwable e) {
                        logger.error("Ops.", e);
                    }
                };
            }
            if (this.cleanup == null) {
                this.cleanup(t -> {
                    if (t instanceof Closeable) {
                        try {
                            ((Closeable)t).close();
                        }
                        catch (Throwable e) {
                            Throwables.throwIfUnchecked((Throwable)e);
                            throw new RuntimeException(e);
                        }
                    }
                });
            }
        }
    }
}

